/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Paginated representation of a workflow history for a workflow execution. This is the up to date, complete and
 * authoritative record of the events related to all tasks and events in the life of the workflow execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetWorkflowExecutionHistoryResponse extends SwfResponse implements
        ToCopyableBuilder<GetWorkflowExecutionHistoryResponse.Builder, GetWorkflowExecutionHistoryResponse> {
    private static final SdkField<List<HistoryEvent>> EVENTS_FIELD = SdkField
            .<List<HistoryEvent>> builder(MarshallingType.LIST)
            .getter(getter(GetWorkflowExecutionHistoryResponse::events))
            .setter(setter(Builder::events))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("events").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HistoryEvent> builder(MarshallingType.SDK_POJO)
                                            .constructor(HistoryEvent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetWorkflowExecutionHistoryResponse::nextPageToken)).setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENTS_FIELD,
            NEXT_PAGE_TOKEN_FIELD));

    private final List<HistoryEvent> events;

    private final String nextPageToken;

    private GetWorkflowExecutionHistoryResponse(BuilderImpl builder) {
        super(builder);
        this.events = builder.events;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * <p>
     * The list of history events.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of history events.
     */
    public List<HistoryEvent> events() {
        return events;
    }

    /**
     * <p>
     * If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To retrieve
     * the next page of results, make the call again using the returned token in <code>nextPageToken</code>. Keep all
     * other arguments unchanged.
     * </p>
     * <p>
     * The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.
     * </p>
     * 
     * @return If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To
     *         retrieve the next page of results, make the call again using the returned token in
     *         <code>nextPageToken</code>. Keep all other arguments unchanged.</p>
     *         <p>
     *         The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.
     */
    public String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(events());
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWorkflowExecutionHistoryResponse)) {
            return false;
        }
        GetWorkflowExecutionHistoryResponse other = (GetWorkflowExecutionHistoryResponse) obj;
        return Objects.equals(events(), other.events()) && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    @Override
    public String toString() {
        return ToString.builder("GetWorkflowExecutionHistoryResponse").add("Events", events())
                .add("NextPageToken", nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "events":
            return Optional.ofNullable(clazz.cast(events()));
        case "nextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetWorkflowExecutionHistoryResponse, T> g) {
        return obj -> g.apply((GetWorkflowExecutionHistoryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SwfResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetWorkflowExecutionHistoryResponse> {
        /**
         * <p>
         * The list of history events.
         * </p>
         * 
         * @param events
         *        The list of history events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(Collection<HistoryEvent> events);

        /**
         * <p>
         * The list of history events.
         * </p>
         * 
         * @param events
         *        The list of history events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(HistoryEvent... events);

        /**
         * <p>
         * The list of history events.
         * </p>
         * This is a convenience that creates an instance of the {@link List<HistoryEvent>.Builder} avoiding the need to
         * create one manually via {@link List<HistoryEvent>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<HistoryEvent>.Builder#build()} is called immediately and its
         * result is passed to {@link #events(List<HistoryEvent>)}.
         * 
         * @param events
         *        a consumer that will call methods on {@link List<HistoryEvent>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #events(List<HistoryEvent>)
         */
        Builder events(Consumer<HistoryEvent.Builder>... events);

        /**
         * <p>
         * If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To
         * retrieve the next page of results, make the call again using the returned token in <code>nextPageToken</code>
         * . Keep all other arguments unchanged.
         * </p>
         * <p>
         * The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.
         * </p>
         * 
         * @param nextPageToken
         *        If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To
         *        retrieve the next page of results, make the call again using the returned token in
         *        <code>nextPageToken</code>. Keep all other arguments unchanged.</p>
         *        <p>
         *        The configured <code>maximumPageSize</code> determines how many results can be returned in a single
         *        call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl extends SwfResponse.BuilderImpl implements Builder {
        private List<HistoryEvent> events = DefaultSdkAutoConstructList.getInstance();

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWorkflowExecutionHistoryResponse model) {
            super(model);
            events(model.events);
            nextPageToken(model.nextPageToken);
        }

        public final Collection<HistoryEvent.Builder> getEvents() {
            return events != null ? events.stream().map(HistoryEvent::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder events(Collection<HistoryEvent> events) {
            this.events = HistoryEventListCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(HistoryEvent... events) {
            events(Arrays.asList(events));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(Consumer<HistoryEvent.Builder>... events) {
            events(Stream.of(events).map(c -> HistoryEvent.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEvents(Collection<HistoryEvent.BuilderImpl> events) {
            this.events = HistoryEventListCopier.copyFromBuilder(events);
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public GetWorkflowExecutionHistoryResponse build() {
            return new GetWorkflowExecutionHistoryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
