/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a paginated list of information structures about workflow types.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListWorkflowTypesResponse extends SwfResponse implements
        ToCopyableBuilder<ListWorkflowTypesResponse.Builder, ListWorkflowTypesResponse> {
    private static final SdkField<List<WorkflowTypeInfo>> TYPE_INFOS_FIELD = SdkField
            .<List<WorkflowTypeInfo>> builder(MarshallingType.LIST)
            .getter(getter(ListWorkflowTypesResponse::typeInfos))
            .setter(setter(Builder::typeInfos))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeInfos").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WorkflowTypeInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(WorkflowTypeInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListWorkflowTypesResponse::nextPageToken)).setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_INFOS_FIELD,
            NEXT_PAGE_TOKEN_FIELD));

    private final List<WorkflowTypeInfo> typeInfos;

    private final String nextPageToken;

    private ListWorkflowTypesResponse(BuilderImpl builder) {
        super(builder);
        this.typeInfos = builder.typeInfos;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * <p>
     * The list of workflow type information.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of workflow type information.
     */
    public List<WorkflowTypeInfo> typeInfos() {
        return typeInfos;
    }

    /**
     * <p>
     * If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To retrieve
     * the next page of results, make the call again using the returned token in <code>nextPageToken</code>. Keep all
     * other arguments unchanged.
     * </p>
     * <p>
     * The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.
     * </p>
     * 
     * @return If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To
     *         retrieve the next page of results, make the call again using the returned token in
     *         <code>nextPageToken</code>. Keep all other arguments unchanged.</p>
     *         <p>
     *         The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.
     */
    public String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeInfos());
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkflowTypesResponse)) {
            return false;
        }
        ListWorkflowTypesResponse other = (ListWorkflowTypesResponse) obj;
        return Objects.equals(typeInfos(), other.typeInfos()) && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListWorkflowTypesResponse").add("TypeInfos", typeInfos()).add("NextPageToken", nextPageToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "typeInfos":
            return Optional.ofNullable(clazz.cast(typeInfos()));
        case "nextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListWorkflowTypesResponse, T> g) {
        return obj -> g.apply((ListWorkflowTypesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SwfResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListWorkflowTypesResponse> {
        /**
         * <p>
         * The list of workflow type information.
         * </p>
         * 
         * @param typeInfos
         *        The list of workflow type information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeInfos(Collection<WorkflowTypeInfo> typeInfos);

        /**
         * <p>
         * The list of workflow type information.
         * </p>
         * 
         * @param typeInfos
         *        The list of workflow type information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeInfos(WorkflowTypeInfo... typeInfos);

        /**
         * <p>
         * The list of workflow type information.
         * </p>
         * This is a convenience that creates an instance of the {@link List<WorkflowTypeInfo>.Builder} avoiding the
         * need to create one manually via {@link List<WorkflowTypeInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<WorkflowTypeInfo>.Builder#build()} is called immediately and
         * its result is passed to {@link #typeInfos(List<WorkflowTypeInfo>)}.
         * 
         * @param typeInfos
         *        a consumer that will call methods on {@link List<WorkflowTypeInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #typeInfos(List<WorkflowTypeInfo>)
         */
        Builder typeInfos(Consumer<WorkflowTypeInfo.Builder>... typeInfos);

        /**
         * <p>
         * If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To
         * retrieve the next page of results, make the call again using the returned token in <code>nextPageToken</code>
         * . Keep all other arguments unchanged.
         * </p>
         * <p>
         * The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.
         * </p>
         * 
         * @param nextPageToken
         *        If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To
         *        retrieve the next page of results, make the call again using the returned token in
         *        <code>nextPageToken</code>. Keep all other arguments unchanged.</p>
         *        <p>
         *        The configured <code>maximumPageSize</code> determines how many results can be returned in a single
         *        call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl extends SwfResponse.BuilderImpl implements Builder {
        private List<WorkflowTypeInfo> typeInfos = DefaultSdkAutoConstructList.getInstance();

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkflowTypesResponse model) {
            super(model);
            typeInfos(model.typeInfos);
            nextPageToken(model.nextPageToken);
        }

        public final Collection<WorkflowTypeInfo.Builder> getTypeInfos() {
            return typeInfos != null ? typeInfos.stream().map(WorkflowTypeInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder typeInfos(Collection<WorkflowTypeInfo> typeInfos) {
            this.typeInfos = WorkflowTypeInfoListCopier.copy(typeInfos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder typeInfos(WorkflowTypeInfo... typeInfos) {
            typeInfos(Arrays.asList(typeInfos));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder typeInfos(Consumer<WorkflowTypeInfo.Builder>... typeInfos) {
            typeInfos(Stream.of(typeInfos).map(c -> WorkflowTypeInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTypeInfos(Collection<WorkflowTypeInfo.BuilderImpl> typeInfos) {
            this.typeInfos = WorkflowTypeInfoListCopier.copyFromBuilder(typeInfos);
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public ListWorkflowTypesResponse build() {
            return new ListWorkflowTypesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
