/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PollForDecisionTaskRequest extends SwfRequest implements
        ToCopyableBuilder<PollForDecisionTaskRequest.Builder, PollForDecisionTaskRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PollForDecisionTaskRequest::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domain").build()).build();

    private static final SdkField<TaskList> TASK_LIST_FIELD = SdkField.<TaskList> builder(MarshallingType.SDK_POJO)
            .getter(getter(PollForDecisionTaskRequest::taskList)).setter(setter(Builder::taskList))
            .constructor(TaskList::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskList").build()).build();

    private static final SdkField<String> IDENTITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PollForDecisionTaskRequest::identity)).setter(setter(Builder::identity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identity").build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PollForDecisionTaskRequest::nextPageToken)).setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageToken").build()).build();

    private static final SdkField<Integer> MAXIMUM_PAGE_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(PollForDecisionTaskRequest::maximumPageSize)).setter(setter(Builder::maximumPageSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumPageSize").build()).build();

    private static final SdkField<Boolean> REVERSE_ORDER_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(PollForDecisionTaskRequest::reverseOrder)).setter(setter(Builder::reverseOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reverseOrder").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD, TASK_LIST_FIELD,
            IDENTITY_FIELD, NEXT_PAGE_TOKEN_FIELD, MAXIMUM_PAGE_SIZE_FIELD, REVERSE_ORDER_FIELD));

    private final String domain;

    private final TaskList taskList;

    private final String identity;

    private final String nextPageToken;

    private final Integer maximumPageSize;

    private final Boolean reverseOrder;

    private PollForDecisionTaskRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.taskList = builder.taskList;
        this.identity = builder.identity;
        this.nextPageToken = builder.nextPageToken;
        this.maximumPageSize = builder.maximumPageSize;
        this.reverseOrder = builder.reverseOrder;
    }

    /**
     * <p>
     * The name of the domain containing the task lists to poll.
     * </p>
     * 
     * @return The name of the domain containing the task lists to poll.
     */
    public String domain() {
        return domain;
    }

    /**
     * <p>
     * Specifies the task list to poll for decision tasks.
     * </p>
     * <p>
     * The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
     * <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code> |
     * <code>\u007f-\u009f</code>). Also, it must not contain the literal string <code>arn</code>.
     * </p>
     * 
     * @return Specifies the task list to poll for decision tasks.</p>
     *         <p>
     *         The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
     *         <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (
     *         <code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not contain the literal string
     *         <code>arn</code>.
     */
    public TaskList taskList() {
        return taskList;
    }

    /**
     * <p>
     * Identity of the decider making the request, which is recorded in the DecisionTaskStarted event in the workflow
     * history. This enables diagnostic tracing when problems arise. The form of this identity is user defined.
     * </p>
     * 
     * @return Identity of the decider making the request, which is recorded in the DecisionTaskStarted event in the
     *         workflow history. This enables diagnostic tracing when problems arise. The form of this identity is user
     *         defined.
     */
    public String identity() {
        return identity;
    }

    /**
     * <p>
     * If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To retrieve
     * the next page of results, make the call again using the returned token in <code>nextPageToken</code>. Keep all
     * other arguments unchanged.
     * </p>
     * <p>
     * The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.
     * </p>
     * <note>
     * <p>
     * The <code>nextPageToken</code> returned by this action cannot be used with <a>GetWorkflowExecutionHistory</a> to
     * get the next page. You must call <a>PollForDecisionTask</a> again (with the <code>nextPageToken</code>) to
     * retrieve the next page of history records. Calling <a>PollForDecisionTask</a> with a <code>nextPageToken</code>
     * doesn't return a new decision task.
     * </p>
     * </note>
     * 
     * @return If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To
     *         retrieve the next page of results, make the call again using the returned token in
     *         <code>nextPageToken</code>. Keep all other arguments unchanged.</p>
     *         <p>
     *         The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.
     *         </p>
     *         <note>
     *         <p>
     *         The <code>nextPageToken</code> returned by this action cannot be used with
     *         <a>GetWorkflowExecutionHistory</a> to get the next page. You must call <a>PollForDecisionTask</a> again
     *         (with the <code>nextPageToken</code>) to retrieve the next page of history records. Calling
     *         <a>PollForDecisionTask</a> with a <code>nextPageToken</code> doesn't return a new decision task.
     *         </p>
     */
    public String nextPageToken() {
        return nextPageToken;
    }

    /**
     * <p>
     * The maximum number of results that are returned per call. <code>nextPageToken</code> can be used to obtain futher
     * pages of results. The default is 1000, which is the maximum allowed page size. You can, however, specify a page
     * size <i>smaller</i> than the maximum.
     * </p>
     * <p>
     * This is an upper limit only; the actual number of results returned per call may be fewer than the specified
     * maximum.
     * </p>
     * 
     * @return The maximum number of results that are returned per call. <code>nextPageToken</code> can be used to
     *         obtain futher pages of results. The default is 1000, which is the maximum allowed page size. You can,
     *         however, specify a page size <i>smaller</i> than the maximum.</p>
     *         <p>
     *         This is an upper limit only; the actual number of results returned per call may be fewer than the
     *         specified maximum.
     */
    public Integer maximumPageSize() {
        return maximumPageSize;
    }

    /**
     * <p>
     * When set to <code>true</code>, returns the events in reverse order. By default the results are returned in
     * ascending order of the <code>eventTimestamp</code> of the events.
     * </p>
     * 
     * @return When set to <code>true</code>, returns the events in reverse order. By default the results are returned
     *         in ascending order of the <code>eventTimestamp</code> of the events.
     */
    public Boolean reverseOrder() {
        return reverseOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(taskList());
        hashCode = 31 * hashCode + Objects.hashCode(identity());
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        hashCode = 31 * hashCode + Objects.hashCode(maximumPageSize());
        hashCode = 31 * hashCode + Objects.hashCode(reverseOrder());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PollForDecisionTaskRequest)) {
            return false;
        }
        PollForDecisionTaskRequest other = (PollForDecisionTaskRequest) obj;
        return Objects.equals(domain(), other.domain()) && Objects.equals(taskList(), other.taskList())
                && Objects.equals(identity(), other.identity()) && Objects.equals(nextPageToken(), other.nextPageToken())
                && Objects.equals(maximumPageSize(), other.maximumPageSize())
                && Objects.equals(reverseOrder(), other.reverseOrder());
    }

    @Override
    public String toString() {
        return ToString.builder("PollForDecisionTaskRequest").add("Domain", domain()).add("TaskList", taskList())
                .add("Identity", identity()).add("NextPageToken", nextPageToken()).add("MaximumPageSize", maximumPageSize())
                .add("ReverseOrder", reverseOrder()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "taskList":
            return Optional.ofNullable(clazz.cast(taskList()));
        case "identity":
            return Optional.ofNullable(clazz.cast(identity()));
        case "nextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        case "maximumPageSize":
            return Optional.ofNullable(clazz.cast(maximumPageSize()));
        case "reverseOrder":
            return Optional.ofNullable(clazz.cast(reverseOrder()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PollForDecisionTaskRequest, T> g) {
        return obj -> g.apply((PollForDecisionTaskRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SwfRequest.Builder, SdkPojo, CopyableBuilder<Builder, PollForDecisionTaskRequest> {
        /**
         * <p>
         * The name of the domain containing the task lists to poll.
         * </p>
         * 
         * @param domain
         *        The name of the domain containing the task lists to poll.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * Specifies the task list to poll for decision tasks.
         * </p>
         * <p>
         * The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
         * <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code>
         * | <code>\u007f-\u009f</code>). Also, it must not contain the literal string <code>arn</code>.
         * </p>
         * 
         * @param taskList
         *        Specifies the task list to poll for decision tasks.</p>
         *        <p>
         *        The specified string must not start or end with whitespace. It must not contain a <code>:</code>
         *        (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (
         *        <code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not contain the literal string
         *        <code>arn</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskList(TaskList taskList);

        /**
         * <p>
         * Specifies the task list to poll for decision tasks.
         * </p>
         * <p>
         * The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
         * <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code>
         * | <code>\u007f-\u009f</code>). Also, it must not contain the literal string <code>arn</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link TaskList.Builder} avoiding the need to create
         * one manually via {@link TaskList#builder()}.
         *
         * When the {@link Consumer} completes, {@link TaskList.Builder#build()} is called immediately and its result is
         * passed to {@link #taskList(TaskList)}.
         * 
         * @param taskList
         *        a consumer that will call methods on {@link TaskList.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taskList(TaskList)
         */
        default Builder taskList(Consumer<TaskList.Builder> taskList) {
            return taskList(TaskList.builder().applyMutation(taskList).build());
        }

        /**
         * <p>
         * Identity of the decider making the request, which is recorded in the DecisionTaskStarted event in the
         * workflow history. This enables diagnostic tracing when problems arise. The form of this identity is user
         * defined.
         * </p>
         * 
         * @param identity
         *        Identity of the decider making the request, which is recorded in the DecisionTaskStarted event in the
         *        workflow history. This enables diagnostic tracing when problems arise. The form of this identity is
         *        user defined.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identity(String identity);

        /**
         * <p>
         * If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To
         * retrieve the next page of results, make the call again using the returned token in <code>nextPageToken</code>
         * . Keep all other arguments unchanged.
         * </p>
         * <p>
         * The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.
         * </p>
         * <note>
         * <p>
         * The <code>nextPageToken</code> returned by this action cannot be used with <a>GetWorkflowExecutionHistory</a>
         * to get the next page. You must call <a>PollForDecisionTask</a> again (with the <code>nextPageToken</code>) to
         * retrieve the next page of history records. Calling <a>PollForDecisionTask</a> with a
         * <code>nextPageToken</code> doesn't return a new decision task.
         * </p>
         * </note>
         * 
         * @param nextPageToken
         *        If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To
         *        retrieve the next page of results, make the call again using the returned token in
         *        <code>nextPageToken</code>. Keep all other arguments unchanged.</p>
         *        <p>
         *        The configured <code>maximumPageSize</code> determines how many results can be returned in a single
         *        call.
         *        </p>
         *        <note>
         *        <p>
         *        The <code>nextPageToken</code> returned by this action cannot be used with
         *        <a>GetWorkflowExecutionHistory</a> to get the next page. You must call <a>PollForDecisionTask</a>
         *        again (with the <code>nextPageToken</code>) to retrieve the next page of history records. Calling
         *        <a>PollForDecisionTask</a> with a <code>nextPageToken</code> doesn't return a new decision task.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);

        /**
         * <p>
         * The maximum number of results that are returned per call. <code>nextPageToken</code> can be used to obtain
         * futher pages of results. The default is 1000, which is the maximum allowed page size. You can, however,
         * specify a page size <i>smaller</i> than the maximum.
         * </p>
         * <p>
         * This is an upper limit only; the actual number of results returned per call may be fewer than the specified
         * maximum.
         * </p>
         * 
         * @param maximumPageSize
         *        The maximum number of results that are returned per call. <code>nextPageToken</code> can be used to
         *        obtain futher pages of results. The default is 1000, which is the maximum allowed page size. You can,
         *        however, specify a page size <i>smaller</i> than the maximum.</p>
         *        <p>
         *        This is an upper limit only; the actual number of results returned per call may be fewer than the
         *        specified maximum.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumPageSize(Integer maximumPageSize);

        /**
         * <p>
         * When set to <code>true</code>, returns the events in reverse order. By default the results are returned in
         * ascending order of the <code>eventTimestamp</code> of the events.
         * </p>
         * 
         * @param reverseOrder
         *        When set to <code>true</code>, returns the events in reverse order. By default the results are
         *        returned in ascending order of the <code>eventTimestamp</code> of the events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reverseOrder(Boolean reverseOrder);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SwfRequest.BuilderImpl implements Builder {
        private String domain;

        private TaskList taskList;

        private String identity;

        private String nextPageToken;

        private Integer maximumPageSize;

        private Boolean reverseOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(PollForDecisionTaskRequest model) {
            super(model);
            domain(model.domain);
            taskList(model.taskList);
            identity(model.identity);
            nextPageToken(model.nextPageToken);
            maximumPageSize(model.maximumPageSize);
            reverseOrder(model.reverseOrder);
        }

        public final String getDomain() {
            return domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final TaskList.Builder getTaskList() {
            return taskList != null ? taskList.toBuilder() : null;
        }

        @Override
        public final Builder taskList(TaskList taskList) {
            this.taskList = taskList;
            return this;
        }

        public final void setTaskList(TaskList.BuilderImpl taskList) {
            this.taskList = taskList != null ? taskList.build() : null;
        }

        public final String getIdentity() {
            return identity;
        }

        @Override
        public final Builder identity(String identity) {
            this.identity = identity;
            return this;
        }

        public final void setIdentity(String identity) {
            this.identity = identity;
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        public final Integer getMaximumPageSize() {
            return maximumPageSize;
        }

        @Override
        public final Builder maximumPageSize(Integer maximumPageSize) {
            this.maximumPageSize = maximumPageSize;
            return this;
        }

        public final void setMaximumPageSize(Integer maximumPageSize) {
            this.maximumPageSize = maximumPageSize;
        }

        public final Boolean getReverseOrder() {
            return reverseOrder;
        }

        @Override
        public final Builder reverseOrder(Boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
            return this;
        }

        public final void setReverseOrder(Boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PollForDecisionTaskRequest build() {
            return new PollForDecisionTaskRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
