/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.swf.model.RegistrationStatus;
import software.amazon.awssdk.services.swf.model.SwfRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDomainsRequest
extends SwfRequest
implements ToCopyableBuilder<Builder, ListDomainsRequest> {
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListDomainsRequest.getter(ListDomainsRequest::nextPageToken)).setter(ListDomainsRequest.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageToken").build()}).build();
    private static final SdkField<String> REGISTRATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListDomainsRequest.getter(ListDomainsRequest::registrationStatusAsString)).setter(ListDomainsRequest.setter(Builder::registrationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registrationStatus").build()}).build();
    private static final SdkField<Integer> MAXIMUM_PAGE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ListDomainsRequest.getter(ListDomainsRequest::maximumPageSize)).setter(ListDomainsRequest.setter(Builder::maximumPageSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumPageSize").build()}).build();
    private static final SdkField<Boolean> REVERSE_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ListDomainsRequest.getter(ListDomainsRequest::reverseOrder)).setter(ListDomainsRequest.setter(Builder::reverseOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reverseOrder").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_PAGE_TOKEN_FIELD, REGISTRATION_STATUS_FIELD, MAXIMUM_PAGE_SIZE_FIELD, REVERSE_ORDER_FIELD));
    private final String nextPageToken;
    private final String registrationStatus;
    private final Integer maximumPageSize;
    private final Boolean reverseOrder;

    private ListDomainsRequest(BuilderImpl builder) {
        super(builder);
        this.nextPageToken = builder.nextPageToken;
        this.registrationStatus = builder.registrationStatus;
        this.maximumPageSize = builder.maximumPageSize;
        this.reverseOrder = builder.reverseOrder;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public RegistrationStatus registrationStatus() {
        return RegistrationStatus.fromValue(this.registrationStatus);
    }

    public String registrationStatusAsString() {
        return this.registrationStatus;
    }

    public Integer maximumPageSize() {
        return this.maximumPageSize;
    }

    public Boolean reverseOrder() {
        return this.reverseOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumPageSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.reverseOrder());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDomainsRequest)) {
            return false;
        }
        ListDomainsRequest other = (ListDomainsRequest)((Object)obj);
        return Objects.equals(this.nextPageToken(), other.nextPageToken()) && Objects.equals(this.registrationStatusAsString(), other.registrationStatusAsString()) && Objects.equals(this.maximumPageSize(), other.maximumPageSize()) && Objects.equals(this.reverseOrder(), other.reverseOrder());
    }

    public String toString() {
        return ToString.builder((String)"ListDomainsRequest").add("NextPageToken", (Object)this.nextPageToken()).add("RegistrationStatus", (Object)this.registrationStatusAsString()).add("MaximumPageSize", (Object)this.maximumPageSize()).add("ReverseOrder", (Object)this.reverseOrder()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
            case "registrationStatus": {
                return Optional.ofNullable(clazz.cast(this.registrationStatusAsString()));
            }
            case "maximumPageSize": {
                return Optional.ofNullable(clazz.cast(this.maximumPageSize()));
            }
            case "reverseOrder": {
                return Optional.ofNullable(clazz.cast(this.reverseOrder()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDomainsRequest, T> g) {
        return obj -> g.apply((ListDomainsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SwfRequest.BuilderImpl
    implements Builder {
        private String nextPageToken;
        private String registrationStatus;
        private Integer maximumPageSize;
        private Boolean reverseOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDomainsRequest model) {
            super(model);
            this.nextPageToken(model.nextPageToken);
            this.registrationStatus(model.registrationStatus);
            this.maximumPageSize(model.maximumPageSize);
            this.reverseOrder(model.reverseOrder);
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        public final String getRegistrationStatus() {
            return this.registrationStatus;
        }

        @Override
        public final Builder registrationStatus(String registrationStatus) {
            this.registrationStatus = registrationStatus;
            return this;
        }

        @Override
        public final Builder registrationStatus(RegistrationStatus registrationStatus) {
            this.registrationStatus(registrationStatus.toString());
            return this;
        }

        public final void setRegistrationStatus(String registrationStatus) {
            this.registrationStatus = registrationStatus;
        }

        public final Integer getMaximumPageSize() {
            return this.maximumPageSize;
        }

        @Override
        public final Builder maximumPageSize(Integer maximumPageSize) {
            this.maximumPageSize = maximumPageSize;
            return this;
        }

        public final void setMaximumPageSize(Integer maximumPageSize) {
            this.maximumPageSize = maximumPageSize;
        }

        public final Boolean getReverseOrder() {
            return this.reverseOrder;
        }

        @Override
        public final Builder reverseOrder(Boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
            return this;
        }

        public final void setReverseOrder(Boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDomainsRequest build() {
            return new ListDomainsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SwfRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDomainsRequest> {
        public Builder nextPageToken(String var1);

        public Builder registrationStatus(String var1);

        public Builder registrationStatus(RegistrationStatus var1);

        public Builder maximumPageSize(Integer var1);

        public Builder reverseOrder(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

