/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.swf.model.RegistrationStatus;
import software.amazon.awssdk.services.swf.model.WorkflowType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkflowTypeInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkflowTypeInfo> {
    private static final SdkField<WorkflowType> WORKFLOW_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(WorkflowTypeInfo.getter(WorkflowTypeInfo::workflowType)).setter(WorkflowTypeInfo.setter(Builder::workflowType)).constructor(WorkflowType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowType").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WorkflowTypeInfo.getter(WorkflowTypeInfo::statusAsString)).setter(WorkflowTypeInfo.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WorkflowTypeInfo.getter(WorkflowTypeInfo::description)).setter(WorkflowTypeInfo.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(WorkflowTypeInfo.getter(WorkflowTypeInfo::creationDate)).setter(WorkflowTypeInfo.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()}).build();
    private static final SdkField<Instant> DEPRECATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(WorkflowTypeInfo.getter(WorkflowTypeInfo::deprecationDate)).setter(WorkflowTypeInfo.setter(Builder::deprecationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deprecationDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_TYPE_FIELD, STATUS_FIELD, DESCRIPTION_FIELD, CREATION_DATE_FIELD, DEPRECATION_DATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final WorkflowType workflowType;
    private final String status;
    private final String description;
    private final Instant creationDate;
    private final Instant deprecationDate;

    private WorkflowTypeInfo(BuilderImpl builder) {
        this.workflowType = builder.workflowType;
        this.status = builder.status;
        this.description = builder.description;
        this.creationDate = builder.creationDate;
        this.deprecationDate = builder.deprecationDate;
    }

    public WorkflowType workflowType() {
        return this.workflowType;
    }

    public RegistrationStatus status() {
        return RegistrationStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String description() {
        return this.description;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public Instant deprecationDate() {
        return this.deprecationDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowType());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.deprecationDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowTypeInfo)) {
            return false;
        }
        WorkflowTypeInfo other = (WorkflowTypeInfo)obj;
        return Objects.equals(this.workflowType(), other.workflowType()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.deprecationDate(), other.deprecationDate());
    }

    public String toString() {
        return ToString.builder((String)"WorkflowTypeInfo").add("WorkflowType", (Object)this.workflowType()).add("Status", (Object)this.statusAsString()).add("Description", (Object)this.description()).add("CreationDate", (Object)this.creationDate()).add("DeprecationDate", (Object)this.deprecationDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workflowType": {
                return Optional.ofNullable(clazz.cast(this.workflowType()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "creationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "deprecationDate": {
                return Optional.ofNullable(clazz.cast(this.deprecationDate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkflowTypeInfo, T> g) {
        return obj -> g.apply((WorkflowTypeInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private WorkflowType workflowType;
        private String status;
        private String description;
        private Instant creationDate;
        private Instant deprecationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowTypeInfo model) {
            this.workflowType(model.workflowType);
            this.status(model.status);
            this.description(model.description);
            this.creationDate(model.creationDate);
            this.deprecationDate(model.deprecationDate);
        }

        public final WorkflowType.Builder getWorkflowType() {
            return this.workflowType != null ? this.workflowType.toBuilder() : null;
        }

        @Override
        public final Builder workflowType(WorkflowType workflowType) {
            this.workflowType = workflowType;
            return this;
        }

        public final void setWorkflowType(WorkflowType.BuilderImpl workflowType) {
            this.workflowType = workflowType != null ? workflowType.build() : null;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RegistrationStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Instant getDeprecationDate() {
            return this.deprecationDate;
        }

        @Override
        public final Builder deprecationDate(Instant deprecationDate) {
            this.deprecationDate = deprecationDate;
            return this;
        }

        public final void setDeprecationDate(Instant deprecationDate) {
            this.deprecationDate = deprecationDate;
        }

        public WorkflowTypeInfo build() {
            return new WorkflowTypeInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkflowTypeInfo> {
        public Builder workflowType(WorkflowType var1);

        default public Builder workflowType(Consumer<WorkflowType.Builder> workflowType) {
            return this.workflowType((WorkflowType)((WorkflowType.Builder)WorkflowType.builder().applyMutation(workflowType)).build());
        }

        public Builder status(String var1);

        public Builder status(RegistrationStatus var1);

        public Builder description(String var1);

        public Builder creationDate(Instant var1);

        public Builder deprecationDate(Instant var1);
    }
}

