/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the details of the <code>ActivityTaskCompleted</code> event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActivityTaskCompletedEventAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<ActivityTaskCompletedEventAttributes.Builder, ActivityTaskCompletedEventAttributes> {
    private static final SdkField<String> RESULT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ActivityTaskCompletedEventAttributes::result)).setter(setter(Builder::result))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("result").build()).build();

    private static final SdkField<Long> SCHEDULED_EVENT_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(ActivityTaskCompletedEventAttributes::scheduledEventId)).setter(setter(Builder::scheduledEventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduledEventId").build()).build();

    private static final SdkField<Long> STARTED_EVENT_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(ActivityTaskCompletedEventAttributes::startedEventId)).setter(setter(Builder::startedEventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedEventId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULT_FIELD,
            SCHEDULED_EVENT_ID_FIELD, STARTED_EVENT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String result;

    private final Long scheduledEventId;

    private final Long startedEventId;

    private ActivityTaskCompletedEventAttributes(BuilderImpl builder) {
        this.result = builder.result;
        this.scheduledEventId = builder.scheduledEventId;
        this.startedEventId = builder.startedEventId;
    }

    /**
     * <p>
     * The results of the activity task.
     * </p>
     * 
     * @return The results of the activity task.
     */
    public String result() {
        return result;
    }

    /**
     * <p>
     * The ID of the <code>ActivityTaskScheduled</code> event that was recorded when this activity task was scheduled.
     * This information can be useful for diagnosing problems by tracing back the chain of events leading up to this
     * event.
     * </p>
     * 
     * @return The ID of the <code>ActivityTaskScheduled</code> event that was recorded when this activity task was
     *         scheduled. This information can be useful for diagnosing problems by tracing back the chain of events
     *         leading up to this event.
     */
    public Long scheduledEventId() {
        return scheduledEventId;
    }

    /**
     * <p>
     * The ID of the <code>ActivityTaskStarted</code> event recorded when this activity task was started. This
     * information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.
     * </p>
     * 
     * @return The ID of the <code>ActivityTaskStarted</code> event recorded when this activity task was started. This
     *         information can be useful for diagnosing problems by tracing back the chain of events leading up to this
     *         event.
     */
    public Long startedEventId() {
        return startedEventId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(result());
        hashCode = 31 * hashCode + Objects.hashCode(scheduledEventId());
        hashCode = 31 * hashCode + Objects.hashCode(startedEventId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActivityTaskCompletedEventAttributes)) {
            return false;
        }
        ActivityTaskCompletedEventAttributes other = (ActivityTaskCompletedEventAttributes) obj;
        return Objects.equals(result(), other.result()) && Objects.equals(scheduledEventId(), other.scheduledEventId())
                && Objects.equals(startedEventId(), other.startedEventId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ActivityTaskCompletedEventAttributes").add("Result", result())
                .add("ScheduledEventId", scheduledEventId()).add("StartedEventId", startedEventId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "result":
            return Optional.ofNullable(clazz.cast(result()));
        case "scheduledEventId":
            return Optional.ofNullable(clazz.cast(scheduledEventId()));
        case "startedEventId":
            return Optional.ofNullable(clazz.cast(startedEventId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActivityTaskCompletedEventAttributes, T> g) {
        return obj -> g.apply((ActivityTaskCompletedEventAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActivityTaskCompletedEventAttributes> {
        /**
         * <p>
         * The results of the activity task.
         * </p>
         * 
         * @param result
         *        The results of the activity task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder result(String result);

        /**
         * <p>
         * The ID of the <code>ActivityTaskScheduled</code> event that was recorded when this activity task was
         * scheduled. This information can be useful for diagnosing problems by tracing back the chain of events leading
         * up to this event.
         * </p>
         * 
         * @param scheduledEventId
         *        The ID of the <code>ActivityTaskScheduled</code> event that was recorded when this activity task was
         *        scheduled. This information can be useful for diagnosing problems by tracing back the chain of events
         *        leading up to this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledEventId(Long scheduledEventId);

        /**
         * <p>
         * The ID of the <code>ActivityTaskStarted</code> event recorded when this activity task was started. This
         * information can be useful for diagnosing problems by tracing back the chain of events leading up to this
         * event.
         * </p>
         * 
         * @param startedEventId
         *        The ID of the <code>ActivityTaskStarted</code> event recorded when this activity task was started.
         *        This information can be useful for diagnosing problems by tracing back the chain of events leading up
         *        to this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedEventId(Long startedEventId);
    }

    static final class BuilderImpl implements Builder {
        private String result;

        private Long scheduledEventId;

        private Long startedEventId;

        private BuilderImpl() {
        }

        private BuilderImpl(ActivityTaskCompletedEventAttributes model) {
            result(model.result);
            scheduledEventId(model.scheduledEventId);
            startedEventId(model.startedEventId);
        }

        public final String getResult() {
            return result;
        }

        @Override
        public final Builder result(String result) {
            this.result = result;
            return this;
        }

        public final void setResult(String result) {
            this.result = result;
        }

        public final Long getScheduledEventId() {
            return scheduledEventId;
        }

        @Override
        public final Builder scheduledEventId(Long scheduledEventId) {
            this.scheduledEventId = scheduledEventId;
            return this;
        }

        public final void setScheduledEventId(Long scheduledEventId) {
            this.scheduledEventId = scheduledEventId;
        }

        public final Long getStartedEventId() {
            return startedEventId;
        }

        @Override
        public final Builder startedEventId(Long startedEventId) {
            this.startedEventId = startedEventId;
            return this;
        }

        public final void setStartedEventId(Long startedEventId) {
            this.startedEventId = startedEventId;
        }

        @Override
        public ActivityTaskCompletedEventAttributes build() {
            return new ActivityTaskCompletedEventAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
