/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.swf.SwfClient;
import software.amazon.awssdk.services.swf.model.CountClosedWorkflowExecutionsRequest;
import software.amazon.awssdk.services.swf.model.CountClosedWorkflowExecutionsResponse;
import software.amazon.awssdk.services.swf.model.CountOpenWorkflowExecutionsRequest;
import software.amazon.awssdk.services.swf.model.CountOpenWorkflowExecutionsResponse;
import software.amazon.awssdk.services.swf.model.CountPendingActivityTasksRequest;
import software.amazon.awssdk.services.swf.model.CountPendingActivityTasksResponse;
import software.amazon.awssdk.services.swf.model.CountPendingDecisionTasksRequest;
import software.amazon.awssdk.services.swf.model.CountPendingDecisionTasksResponse;
import software.amazon.awssdk.services.swf.model.DefaultUndefinedException;
import software.amazon.awssdk.services.swf.model.DeprecateActivityTypeRequest;
import software.amazon.awssdk.services.swf.model.DeprecateActivityTypeResponse;
import software.amazon.awssdk.services.swf.model.DeprecateDomainRequest;
import software.amazon.awssdk.services.swf.model.DeprecateDomainResponse;
import software.amazon.awssdk.services.swf.model.DeprecateWorkflowTypeRequest;
import software.amazon.awssdk.services.swf.model.DeprecateWorkflowTypeResponse;
import software.amazon.awssdk.services.swf.model.DescribeActivityTypeRequest;
import software.amazon.awssdk.services.swf.model.DescribeActivityTypeResponse;
import software.amazon.awssdk.services.swf.model.DescribeDomainRequest;
import software.amazon.awssdk.services.swf.model.DescribeDomainResponse;
import software.amazon.awssdk.services.swf.model.DescribeWorkflowExecutionRequest;
import software.amazon.awssdk.services.swf.model.DescribeWorkflowExecutionResponse;
import software.amazon.awssdk.services.swf.model.DescribeWorkflowTypeRequest;
import software.amazon.awssdk.services.swf.model.DescribeWorkflowTypeResponse;
import software.amazon.awssdk.services.swf.model.DomainAlreadyExistsException;
import software.amazon.awssdk.services.swf.model.DomainDeprecatedException;
import software.amazon.awssdk.services.swf.model.GetWorkflowExecutionHistoryRequest;
import software.amazon.awssdk.services.swf.model.GetWorkflowExecutionHistoryResponse;
import software.amazon.awssdk.services.swf.model.LimitExceededException;
import software.amazon.awssdk.services.swf.model.ListActivityTypesRequest;
import software.amazon.awssdk.services.swf.model.ListActivityTypesResponse;
import software.amazon.awssdk.services.swf.model.ListClosedWorkflowExecutionsRequest;
import software.amazon.awssdk.services.swf.model.ListClosedWorkflowExecutionsResponse;
import software.amazon.awssdk.services.swf.model.ListDomainsRequest;
import software.amazon.awssdk.services.swf.model.ListDomainsResponse;
import software.amazon.awssdk.services.swf.model.ListOpenWorkflowExecutionsRequest;
import software.amazon.awssdk.services.swf.model.ListOpenWorkflowExecutionsResponse;
import software.amazon.awssdk.services.swf.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.swf.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.swf.model.ListWorkflowTypesRequest;
import software.amazon.awssdk.services.swf.model.ListWorkflowTypesResponse;
import software.amazon.awssdk.services.swf.model.OperationNotPermittedException;
import software.amazon.awssdk.services.swf.model.PollForActivityTaskRequest;
import software.amazon.awssdk.services.swf.model.PollForActivityTaskResponse;
import software.amazon.awssdk.services.swf.model.PollForDecisionTaskRequest;
import software.amazon.awssdk.services.swf.model.PollForDecisionTaskResponse;
import software.amazon.awssdk.services.swf.model.RecordActivityTaskHeartbeatRequest;
import software.amazon.awssdk.services.swf.model.RecordActivityTaskHeartbeatResponse;
import software.amazon.awssdk.services.swf.model.RegisterActivityTypeRequest;
import software.amazon.awssdk.services.swf.model.RegisterActivityTypeResponse;
import software.amazon.awssdk.services.swf.model.RegisterDomainRequest;
import software.amazon.awssdk.services.swf.model.RegisterDomainResponse;
import software.amazon.awssdk.services.swf.model.RegisterWorkflowTypeRequest;
import software.amazon.awssdk.services.swf.model.RegisterWorkflowTypeResponse;
import software.amazon.awssdk.services.swf.model.RequestCancelWorkflowExecutionRequest;
import software.amazon.awssdk.services.swf.model.RequestCancelWorkflowExecutionResponse;
import software.amazon.awssdk.services.swf.model.RespondActivityTaskCanceledRequest;
import software.amazon.awssdk.services.swf.model.RespondActivityTaskCanceledResponse;
import software.amazon.awssdk.services.swf.model.RespondActivityTaskCompletedRequest;
import software.amazon.awssdk.services.swf.model.RespondActivityTaskCompletedResponse;
import software.amazon.awssdk.services.swf.model.RespondActivityTaskFailedRequest;
import software.amazon.awssdk.services.swf.model.RespondActivityTaskFailedResponse;
import software.amazon.awssdk.services.swf.model.RespondDecisionTaskCompletedRequest;
import software.amazon.awssdk.services.swf.model.RespondDecisionTaskCompletedResponse;
import software.amazon.awssdk.services.swf.model.SignalWorkflowExecutionRequest;
import software.amazon.awssdk.services.swf.model.SignalWorkflowExecutionResponse;
import software.amazon.awssdk.services.swf.model.StartWorkflowExecutionRequest;
import software.amazon.awssdk.services.swf.model.StartWorkflowExecutionResponse;
import software.amazon.awssdk.services.swf.model.SwfException;
import software.amazon.awssdk.services.swf.model.SwfRequest;
import software.amazon.awssdk.services.swf.model.TagResourceRequest;
import software.amazon.awssdk.services.swf.model.TagResourceResponse;
import software.amazon.awssdk.services.swf.model.TerminateWorkflowExecutionRequest;
import software.amazon.awssdk.services.swf.model.TerminateWorkflowExecutionResponse;
import software.amazon.awssdk.services.swf.model.TooManyTagsException;
import software.amazon.awssdk.services.swf.model.TypeAlreadyExistsException;
import software.amazon.awssdk.services.swf.model.TypeDeprecatedException;
import software.amazon.awssdk.services.swf.model.UndeprecateActivityTypeRequest;
import software.amazon.awssdk.services.swf.model.UndeprecateActivityTypeResponse;
import software.amazon.awssdk.services.swf.model.UndeprecateDomainRequest;
import software.amazon.awssdk.services.swf.model.UndeprecateDomainResponse;
import software.amazon.awssdk.services.swf.model.UndeprecateWorkflowTypeRequest;
import software.amazon.awssdk.services.swf.model.UndeprecateWorkflowTypeResponse;
import software.amazon.awssdk.services.swf.model.UnknownResourceException;
import software.amazon.awssdk.services.swf.model.UntagResourceRequest;
import software.amazon.awssdk.services.swf.model.UntagResourceResponse;
import software.amazon.awssdk.services.swf.model.WorkflowExecutionAlreadyStartedException;
import software.amazon.awssdk.services.swf.paginators.GetWorkflowExecutionHistoryIterable;
import software.amazon.awssdk.services.swf.paginators.ListActivityTypesIterable;
import software.amazon.awssdk.services.swf.paginators.ListClosedWorkflowExecutionsIterable;
import software.amazon.awssdk.services.swf.paginators.ListDomainsIterable;
import software.amazon.awssdk.services.swf.paginators.ListOpenWorkflowExecutionsIterable;
import software.amazon.awssdk.services.swf.paginators.ListWorkflowTypesIterable;
import software.amazon.awssdk.services.swf.paginators.PollForDecisionTaskIterable;
import software.amazon.awssdk.services.swf.transform.CountClosedWorkflowExecutionsRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.CountOpenWorkflowExecutionsRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.CountPendingActivityTasksRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.CountPendingDecisionTasksRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.DeprecateActivityTypeRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.DeprecateDomainRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.DeprecateWorkflowTypeRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.DescribeActivityTypeRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.DescribeDomainRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.DescribeWorkflowExecutionRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.DescribeWorkflowTypeRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.GetWorkflowExecutionHistoryRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.ListActivityTypesRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.ListClosedWorkflowExecutionsRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.ListDomainsRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.ListOpenWorkflowExecutionsRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.ListWorkflowTypesRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.PollForActivityTaskRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.PollForDecisionTaskRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.RecordActivityTaskHeartbeatRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.RegisterActivityTypeRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.RegisterDomainRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.RegisterWorkflowTypeRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.RequestCancelWorkflowExecutionRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.RespondActivityTaskCanceledRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.RespondActivityTaskCompletedRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.RespondActivityTaskFailedRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.RespondDecisionTaskCompletedRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.SignalWorkflowExecutionRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.StartWorkflowExecutionRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.TerminateWorkflowExecutionRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.UndeprecateActivityTypeRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.UndeprecateDomainRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.UndeprecateWorkflowTypeRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.UntagResourceRequestMarshaller;

@SdkInternalApi
final class DefaultSwfClient
implements SwfClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultSwfClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "swf";
    }

    @Override
    public CountClosedWorkflowExecutionsResponse countClosedWorkflowExecutions(CountClosedWorkflowExecutionsRequest countClosedWorkflowExecutionsRequest) throws UnknownResourceException, OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CountClosedWorkflowExecutionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CountClosedWorkflowExecutionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CountClosedWorkflowExecutions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)countClosedWorkflowExecutionsRequest).withMarshaller((Marshaller)new CountClosedWorkflowExecutionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CountOpenWorkflowExecutionsResponse countOpenWorkflowExecutions(CountOpenWorkflowExecutionsRequest countOpenWorkflowExecutionsRequest) throws UnknownResourceException, OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CountOpenWorkflowExecutionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CountOpenWorkflowExecutionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CountOpenWorkflowExecutions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)countOpenWorkflowExecutionsRequest).withMarshaller((Marshaller)new CountOpenWorkflowExecutionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CountPendingActivityTasksResponse countPendingActivityTasks(CountPendingActivityTasksRequest countPendingActivityTasksRequest) throws UnknownResourceException, OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CountPendingActivityTasksResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CountPendingActivityTasksResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CountPendingActivityTasks").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)countPendingActivityTasksRequest).withMarshaller((Marshaller)new CountPendingActivityTasksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CountPendingDecisionTasksResponse countPendingDecisionTasks(CountPendingDecisionTasksRequest countPendingDecisionTasksRequest) throws UnknownResourceException, OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CountPendingDecisionTasksResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CountPendingDecisionTasksResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CountPendingDecisionTasks").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)countPendingDecisionTasksRequest).withMarshaller((Marshaller)new CountPendingDecisionTasksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeprecateActivityTypeResponse deprecateActivityType(DeprecateActivityTypeRequest deprecateActivityTypeRequest) throws UnknownResourceException, TypeDeprecatedException, OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeprecateActivityTypeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeprecateActivityTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeprecateActivityType").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deprecateActivityTypeRequest).withMarshaller((Marshaller)new DeprecateActivityTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeprecateDomainResponse deprecateDomain(DeprecateDomainRequest deprecateDomainRequest) throws UnknownResourceException, DomainDeprecatedException, OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeprecateDomainResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeprecateDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeprecateDomain").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deprecateDomainRequest).withMarshaller((Marshaller)new DeprecateDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeprecateWorkflowTypeResponse deprecateWorkflowType(DeprecateWorkflowTypeRequest deprecateWorkflowTypeRequest) throws UnknownResourceException, TypeDeprecatedException, OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeprecateWorkflowTypeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeprecateWorkflowTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeprecateWorkflowType").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deprecateWorkflowTypeRequest).withMarshaller((Marshaller)new DeprecateWorkflowTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeActivityTypeResponse describeActivityType(DescribeActivityTypeRequest describeActivityTypeRequest) throws UnknownResourceException, OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeActivityTypeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeActivityTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeActivityType").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeActivityTypeRequest).withMarshaller((Marshaller)new DescribeActivityTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeDomainResponse describeDomain(DescribeDomainRequest describeDomainRequest) throws UnknownResourceException, OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDomainResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDomain").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDomainRequest).withMarshaller((Marshaller)new DescribeDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeWorkflowExecutionResponse describeWorkflowExecution(DescribeWorkflowExecutionRequest describeWorkflowExecutionRequest) throws UnknownResourceException, OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeWorkflowExecutionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeWorkflowExecutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeWorkflowExecution").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeWorkflowExecutionRequest).withMarshaller((Marshaller)new DescribeWorkflowExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeWorkflowTypeResponse describeWorkflowType(DescribeWorkflowTypeRequest describeWorkflowTypeRequest) throws UnknownResourceException, OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeWorkflowTypeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeWorkflowTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeWorkflowType").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeWorkflowTypeRequest).withMarshaller((Marshaller)new DescribeWorkflowTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetWorkflowExecutionHistoryResponse getWorkflowExecutionHistory(GetWorkflowExecutionHistoryRequest getWorkflowExecutionHistoryRequest) throws UnknownResourceException, OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetWorkflowExecutionHistoryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetWorkflowExecutionHistoryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetWorkflowExecutionHistory").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getWorkflowExecutionHistoryRequest).withMarshaller((Marshaller)new GetWorkflowExecutionHistoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetWorkflowExecutionHistoryIterable getWorkflowExecutionHistoryPaginator(GetWorkflowExecutionHistoryRequest getWorkflowExecutionHistoryRequest) throws UnknownResourceException, OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        return new GetWorkflowExecutionHistoryIterable(this, this.applyPaginatorUserAgent(getWorkflowExecutionHistoryRequest));
    }

    @Override
    public ListActivityTypesResponse listActivityTypes(ListActivityTypesRequest listActivityTypesRequest) throws OperationNotPermittedException, UnknownResourceException, AwsServiceException, SdkClientException, SwfException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListActivityTypesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListActivityTypesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListActivityTypes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listActivityTypesRequest).withMarshaller((Marshaller)new ListActivityTypesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListActivityTypesIterable listActivityTypesPaginator(ListActivityTypesRequest listActivityTypesRequest) throws OperationNotPermittedException, UnknownResourceException, AwsServiceException, SdkClientException, SwfException {
        return new ListActivityTypesIterable(this, this.applyPaginatorUserAgent(listActivityTypesRequest));
    }

    @Override
    public ListClosedWorkflowExecutionsResponse listClosedWorkflowExecutions(ListClosedWorkflowExecutionsRequest listClosedWorkflowExecutionsRequest) throws UnknownResourceException, OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListClosedWorkflowExecutionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListClosedWorkflowExecutionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListClosedWorkflowExecutions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listClosedWorkflowExecutionsRequest).withMarshaller((Marshaller)new ListClosedWorkflowExecutionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListClosedWorkflowExecutionsIterable listClosedWorkflowExecutionsPaginator(ListClosedWorkflowExecutionsRequest listClosedWorkflowExecutionsRequest) throws UnknownResourceException, OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        return new ListClosedWorkflowExecutionsIterable(this, this.applyPaginatorUserAgent(listClosedWorkflowExecutionsRequest));
    }

    @Override
    public ListDomainsResponse listDomains(ListDomainsRequest listDomainsRequest) throws OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDomainsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListDomainsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDomains").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDomainsRequest).withMarshaller((Marshaller)new ListDomainsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListDomainsIterable listDomainsPaginator(ListDomainsRequest listDomainsRequest) throws OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        return new ListDomainsIterable(this, this.applyPaginatorUserAgent(listDomainsRequest));
    }

    @Override
    public ListOpenWorkflowExecutionsResponse listOpenWorkflowExecutions(ListOpenWorkflowExecutionsRequest listOpenWorkflowExecutionsRequest) throws UnknownResourceException, OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListOpenWorkflowExecutionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListOpenWorkflowExecutionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListOpenWorkflowExecutions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listOpenWorkflowExecutionsRequest).withMarshaller((Marshaller)new ListOpenWorkflowExecutionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListOpenWorkflowExecutionsIterable listOpenWorkflowExecutionsPaginator(ListOpenWorkflowExecutionsRequest listOpenWorkflowExecutionsRequest) throws UnknownResourceException, OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        return new ListOpenWorkflowExecutionsIterable(this, this.applyPaginatorUserAgent(listOpenWorkflowExecutionsRequest));
    }

    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws UnknownResourceException, LimitExceededException, OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListWorkflowTypesResponse listWorkflowTypes(ListWorkflowTypesRequest listWorkflowTypesRequest) throws OperationNotPermittedException, UnknownResourceException, AwsServiceException, SdkClientException, SwfException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListWorkflowTypesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListWorkflowTypesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListWorkflowTypes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listWorkflowTypesRequest).withMarshaller((Marshaller)new ListWorkflowTypesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListWorkflowTypesIterable listWorkflowTypesPaginator(ListWorkflowTypesRequest listWorkflowTypesRequest) throws OperationNotPermittedException, UnknownResourceException, AwsServiceException, SdkClientException, SwfException {
        return new ListWorkflowTypesIterable(this, this.applyPaginatorUserAgent(listWorkflowTypesRequest));
    }

    @Override
    public PollForActivityTaskResponse pollForActivityTask(PollForActivityTaskRequest pollForActivityTaskRequest) throws UnknownResourceException, OperationNotPermittedException, LimitExceededException, AwsServiceException, SdkClientException, SwfException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PollForActivityTaskResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PollForActivityTaskResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PollForActivityTask").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)pollForActivityTaskRequest).withMarshaller((Marshaller)new PollForActivityTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PollForDecisionTaskResponse pollForDecisionTask(PollForDecisionTaskRequest pollForDecisionTaskRequest) throws UnknownResourceException, OperationNotPermittedException, LimitExceededException, AwsServiceException, SdkClientException, SwfException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PollForDecisionTaskResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PollForDecisionTaskResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PollForDecisionTask").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)pollForDecisionTaskRequest).withMarshaller((Marshaller)new PollForDecisionTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PollForDecisionTaskIterable pollForDecisionTaskPaginator(PollForDecisionTaskRequest pollForDecisionTaskRequest) throws UnknownResourceException, OperationNotPermittedException, LimitExceededException, AwsServiceException, SdkClientException, SwfException {
        return new PollForDecisionTaskIterable(this, this.applyPaginatorUserAgent(pollForDecisionTaskRequest));
    }

    @Override
    public RecordActivityTaskHeartbeatResponse recordActivityTaskHeartbeat(RecordActivityTaskHeartbeatRequest recordActivityTaskHeartbeatRequest) throws UnknownResourceException, OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RecordActivityTaskHeartbeatResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (RecordActivityTaskHeartbeatResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RecordActivityTaskHeartbeat").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)recordActivityTaskHeartbeatRequest).withMarshaller((Marshaller)new RecordActivityTaskHeartbeatRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public RegisterActivityTypeResponse registerActivityType(RegisterActivityTypeRequest registerActivityTypeRequest) throws TypeAlreadyExistsException, LimitExceededException, UnknownResourceException, OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterActivityTypeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (RegisterActivityTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterActivityType").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)registerActivityTypeRequest).withMarshaller((Marshaller)new RegisterActivityTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public RegisterDomainResponse registerDomain(RegisterDomainRequest registerDomainRequest) throws DomainAlreadyExistsException, LimitExceededException, OperationNotPermittedException, TooManyTagsException, AwsServiceException, SdkClientException, SwfException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterDomainResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (RegisterDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterDomain").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)registerDomainRequest).withMarshaller((Marshaller)new RegisterDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public RegisterWorkflowTypeResponse registerWorkflowType(RegisterWorkflowTypeRequest registerWorkflowTypeRequest) throws TypeAlreadyExistsException, LimitExceededException, UnknownResourceException, OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterWorkflowTypeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (RegisterWorkflowTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterWorkflowType").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)registerWorkflowTypeRequest).withMarshaller((Marshaller)new RegisterWorkflowTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public RequestCancelWorkflowExecutionResponse requestCancelWorkflowExecution(RequestCancelWorkflowExecutionRequest requestCancelWorkflowExecutionRequest) throws UnknownResourceException, OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RequestCancelWorkflowExecutionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (RequestCancelWorkflowExecutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RequestCancelWorkflowExecution").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)requestCancelWorkflowExecutionRequest).withMarshaller((Marshaller)new RequestCancelWorkflowExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public RespondActivityTaskCanceledResponse respondActivityTaskCanceled(RespondActivityTaskCanceledRequest respondActivityTaskCanceledRequest) throws UnknownResourceException, OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RespondActivityTaskCanceledResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (RespondActivityTaskCanceledResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RespondActivityTaskCanceled").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)respondActivityTaskCanceledRequest).withMarshaller((Marshaller)new RespondActivityTaskCanceledRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public RespondActivityTaskCompletedResponse respondActivityTaskCompleted(RespondActivityTaskCompletedRequest respondActivityTaskCompletedRequest) throws UnknownResourceException, OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RespondActivityTaskCompletedResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (RespondActivityTaskCompletedResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RespondActivityTaskCompleted").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)respondActivityTaskCompletedRequest).withMarshaller((Marshaller)new RespondActivityTaskCompletedRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public RespondActivityTaskFailedResponse respondActivityTaskFailed(RespondActivityTaskFailedRequest respondActivityTaskFailedRequest) throws UnknownResourceException, OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RespondActivityTaskFailedResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (RespondActivityTaskFailedResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RespondActivityTaskFailed").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)respondActivityTaskFailedRequest).withMarshaller((Marshaller)new RespondActivityTaskFailedRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public RespondDecisionTaskCompletedResponse respondDecisionTaskCompleted(RespondDecisionTaskCompletedRequest respondDecisionTaskCompletedRequest) throws UnknownResourceException, OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RespondDecisionTaskCompletedResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (RespondDecisionTaskCompletedResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RespondDecisionTaskCompleted").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)respondDecisionTaskCompletedRequest).withMarshaller((Marshaller)new RespondDecisionTaskCompletedRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public SignalWorkflowExecutionResponse signalWorkflowExecution(SignalWorkflowExecutionRequest signalWorkflowExecutionRequest) throws UnknownResourceException, OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SignalWorkflowExecutionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (SignalWorkflowExecutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SignalWorkflowExecution").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)signalWorkflowExecutionRequest).withMarshaller((Marshaller)new SignalWorkflowExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public StartWorkflowExecutionResponse startWorkflowExecution(StartWorkflowExecutionRequest startWorkflowExecutionRequest) throws UnknownResourceException, TypeDeprecatedException, WorkflowExecutionAlreadyStartedException, LimitExceededException, OperationNotPermittedException, DefaultUndefinedException, AwsServiceException, SdkClientException, SwfException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartWorkflowExecutionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (StartWorkflowExecutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartWorkflowExecution").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startWorkflowExecutionRequest).withMarshaller((Marshaller)new StartWorkflowExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws UnknownResourceException, TooManyTagsException, LimitExceededException, OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public TerminateWorkflowExecutionResponse terminateWorkflowExecution(TerminateWorkflowExecutionRequest terminateWorkflowExecutionRequest) throws UnknownResourceException, OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TerminateWorkflowExecutionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (TerminateWorkflowExecutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TerminateWorkflowExecution").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)terminateWorkflowExecutionRequest).withMarshaller((Marshaller)new TerminateWorkflowExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UndeprecateActivityTypeResponse undeprecateActivityType(UndeprecateActivityTypeRequest undeprecateActivityTypeRequest) throws UnknownResourceException, TypeAlreadyExistsException, OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UndeprecateActivityTypeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UndeprecateActivityTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UndeprecateActivityType").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)undeprecateActivityTypeRequest).withMarshaller((Marshaller)new UndeprecateActivityTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UndeprecateDomainResponse undeprecateDomain(UndeprecateDomainRequest undeprecateDomainRequest) throws UnknownResourceException, DomainAlreadyExistsException, OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UndeprecateDomainResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UndeprecateDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UndeprecateDomain").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)undeprecateDomainRequest).withMarshaller((Marshaller)new UndeprecateDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UndeprecateWorkflowTypeResponse undeprecateWorkflowType(UndeprecateWorkflowTypeRequest undeprecateWorkflowTypeRequest) throws UnknownResourceException, TypeAlreadyExistsException, OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UndeprecateWorkflowTypeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UndeprecateWorkflowTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UndeprecateWorkflowType").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)undeprecateWorkflowTypeRequest).withMarshaller((Marshaller)new UndeprecateWorkflowTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws UnknownResourceException, LimitExceededException, OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(SwfException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.0").registerModeledException(ExceptionMetadata.builder().errorCode("TypeAlreadyExistsFault").exceptionBuilderSupplier(TypeAlreadyExistsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TypeDeprecatedFault").exceptionBuilderSupplier(TypeDeprecatedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededFault").exceptionBuilderSupplier(LimitExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DomainDeprecatedFault").exceptionBuilderSupplier(DomainDeprecatedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DefaultUndefinedFault").exceptionBuilderSupplier(DefaultUndefinedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DomainAlreadyExistsFault").exceptionBuilderSupplier(DomainAlreadyExistsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OperationNotPermittedFault").exceptionBuilderSupplier(OperationNotPermittedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("WorkflowExecutionAlreadyStartedFault").exceptionBuilderSupplier(WorkflowExecutionAlreadyStartedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyTagsFault").exceptionBuilderSupplier(TooManyTagsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnknownResourceFault").exceptionBuilderSupplier(UnknownResourceException::builder).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends SwfRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.10.21").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((SwfRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

