/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.swf.model.ActivityTypeConfiguration;
import software.amazon.awssdk.services.swf.model.ActivityTypeInfo;
import software.amazon.awssdk.services.swf.model.SwfResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeActivityTypeResponse
extends SwfResponse
implements ToCopyableBuilder<Builder, DescribeActivityTypeResponse> {
    private static final SdkField<ActivityTypeInfo> TYPE_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeActivityTypeResponse.getter(DescribeActivityTypeResponse::typeInfo)).setter(DescribeActivityTypeResponse.setter(Builder::typeInfo)).constructor(ActivityTypeInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeInfo").build()}).build();
    private static final SdkField<ActivityTypeConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeActivityTypeResponse.getter(DescribeActivityTypeResponse::configuration)).setter(DescribeActivityTypeResponse.setter(Builder::configuration)).constructor(ActivityTypeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_INFO_FIELD, CONFIGURATION_FIELD));
    private final ActivityTypeInfo typeInfo;
    private final ActivityTypeConfiguration configuration;

    private DescribeActivityTypeResponse(BuilderImpl builder) {
        super(builder);
        this.typeInfo = builder.typeInfo;
        this.configuration = builder.configuration;
    }

    public ActivityTypeInfo typeInfo() {
        return this.typeInfo;
    }

    public ActivityTypeConfiguration configuration() {
        return this.configuration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.typeInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeActivityTypeResponse)) {
            return false;
        }
        DescribeActivityTypeResponse other = (DescribeActivityTypeResponse)((Object)obj);
        return Objects.equals(this.typeInfo(), other.typeInfo()) && Objects.equals(this.configuration(), other.configuration());
    }

    public String toString() {
        return ToString.builder((String)"DescribeActivityTypeResponse").add("TypeInfo", (Object)this.typeInfo()).add("Configuration", (Object)this.configuration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "typeInfo": {
                return Optional.ofNullable(clazz.cast(this.typeInfo()));
            }
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeActivityTypeResponse, T> g) {
        return obj -> g.apply((DescribeActivityTypeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SwfResponse.BuilderImpl
    implements Builder {
        private ActivityTypeInfo typeInfo;
        private ActivityTypeConfiguration configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeActivityTypeResponse model) {
            super(model);
            this.typeInfo(model.typeInfo);
            this.configuration(model.configuration);
        }

        public final ActivityTypeInfo.Builder getTypeInfo() {
            return this.typeInfo != null ? this.typeInfo.toBuilder() : null;
        }

        @Override
        public final Builder typeInfo(ActivityTypeInfo typeInfo) {
            this.typeInfo = typeInfo;
            return this;
        }

        public final void setTypeInfo(ActivityTypeInfo.BuilderImpl typeInfo) {
            this.typeInfo = typeInfo != null ? typeInfo.build() : null;
        }

        public final ActivityTypeConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        @Override
        public final Builder configuration(ActivityTypeConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final void setConfiguration(ActivityTypeConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public DescribeActivityTypeResponse build() {
            return new DescribeActivityTypeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SwfResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeActivityTypeResponse> {
        public Builder typeInfo(ActivityTypeInfo var1);

        default public Builder typeInfo(Consumer<ActivityTypeInfo.Builder> typeInfo) {
            return this.typeInfo((ActivityTypeInfo)((ActivityTypeInfo.Builder)ActivityTypeInfo.builder().applyMutation(typeInfo)).build());
        }

        public Builder configuration(ActivityTypeConfiguration var1);

        default public Builder configuration(Consumer<ActivityTypeConfiguration.Builder> configuration) {
            return this.configuration((ActivityTypeConfiguration)((ActivityTypeConfiguration.Builder)ActivityTypeConfiguration.builder().applyMutation(configuration)).build());
        }
    }
}

