/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a paginated collection of DomainInfo structures.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDomainsResponse extends SwfResponse implements
        ToCopyableBuilder<ListDomainsResponse.Builder, ListDomainsResponse> {
    private static final SdkField<List<DomainInfo>> DOMAIN_INFOS_FIELD = SdkField
            .<List<DomainInfo>> builder(MarshallingType.LIST)
            .getter(getter(ListDomainsResponse::domainInfos))
            .setter(setter(Builder::domainInfos))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainInfos").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DomainInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(DomainInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListDomainsResponse::nextPageToken)).setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_INFOS_FIELD,
            NEXT_PAGE_TOKEN_FIELD));

    private final List<DomainInfo> domainInfos;

    private final String nextPageToken;

    private ListDomainsResponse(BuilderImpl builder) {
        super(builder);
        this.domainInfos = builder.domainInfos;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * <p>
     * A list of DomainInfo structures.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of DomainInfo structures.
     */
    public List<DomainInfo> domainInfos() {
        return domainInfos;
    }

    /**
     * <p>
     * If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To retrieve
     * the next page of results, make the call again using the returned token in <code>nextPageToken</code>. Keep all
     * other arguments unchanged.
     * </p>
     * <p>
     * The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.
     * </p>
     * 
     * @return If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To
     *         retrieve the next page of results, make the call again using the returned token in
     *         <code>nextPageToken</code>. Keep all other arguments unchanged.</p>
     *         <p>
     *         The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.
     */
    public String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainInfos());
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDomainsResponse)) {
            return false;
        }
        ListDomainsResponse other = (ListDomainsResponse) obj;
        return Objects.equals(domainInfos(), other.domainInfos()) && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListDomainsResponse").add("DomainInfos", domainInfos()).add("NextPageToken", nextPageToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainInfos":
            return Optional.ofNullable(clazz.cast(domainInfos()));
        case "nextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDomainsResponse, T> g) {
        return obj -> g.apply((ListDomainsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SwfResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListDomainsResponse> {
        /**
         * <p>
         * A list of DomainInfo structures.
         * </p>
         * 
         * @param domainInfos
         *        A list of DomainInfo structures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainInfos(Collection<DomainInfo> domainInfos);

        /**
         * <p>
         * A list of DomainInfo structures.
         * </p>
         * 
         * @param domainInfos
         *        A list of DomainInfo structures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainInfos(DomainInfo... domainInfos);

        /**
         * <p>
         * A list of DomainInfo structures.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DomainInfo>.Builder} avoiding the need to
         * create one manually via {@link List<DomainInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DomainInfo>.Builder#build()} is called immediately and its
         * result is passed to {@link #domainInfos(List<DomainInfo>)}.
         * 
         * @param domainInfos
         *        a consumer that will call methods on {@link List<DomainInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainInfos(List<DomainInfo>)
         */
        Builder domainInfos(Consumer<DomainInfo.Builder>... domainInfos);

        /**
         * <p>
         * If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To
         * retrieve the next page of results, make the call again using the returned token in <code>nextPageToken</code>
         * . Keep all other arguments unchanged.
         * </p>
         * <p>
         * The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.
         * </p>
         * 
         * @param nextPageToken
         *        If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To
         *        retrieve the next page of results, make the call again using the returned token in
         *        <code>nextPageToken</code>. Keep all other arguments unchanged.</p>
         *        <p>
         *        The configured <code>maximumPageSize</code> determines how many results can be returned in a single
         *        call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl extends SwfResponse.BuilderImpl implements Builder {
        private List<DomainInfo> domainInfos = DefaultSdkAutoConstructList.getInstance();

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDomainsResponse model) {
            super(model);
            domainInfos(model.domainInfos);
            nextPageToken(model.nextPageToken);
        }

        public final Collection<DomainInfo.Builder> getDomainInfos() {
            return domainInfos != null ? domainInfos.stream().map(DomainInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder domainInfos(Collection<DomainInfo> domainInfos) {
            this.domainInfos = DomainInfoListCopier.copy(domainInfos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainInfos(DomainInfo... domainInfos) {
            domainInfos(Arrays.asList(domainInfos));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainInfos(Consumer<DomainInfo.Builder>... domainInfos) {
            domainInfos(Stream.of(domainInfos).map(c -> DomainInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDomainInfos(Collection<DomainInfo.BuilderImpl> domainInfos) {
            this.domainInfos = DomainInfoListCopier.copyFromBuilder(domainInfos);
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public ListDomainsResponse build() {
            return new ListDomainsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
