/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.swf.model.ChildPolicy;
import software.amazon.awssdk.services.swf.model.TagListCopier;
import software.amazon.awssdk.services.swf.model.TaskList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContinueAsNewWorkflowExecutionDecisionAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContinueAsNewWorkflowExecutionDecisionAttributes> {
    private static final SdkField<String> INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ContinueAsNewWorkflowExecutionDecisionAttributes.getter(ContinueAsNewWorkflowExecutionDecisionAttributes::input)).setter(ContinueAsNewWorkflowExecutionDecisionAttributes.setter(Builder::input)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()}).build();
    private static final SdkField<String> EXECUTION_START_TO_CLOSE_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ContinueAsNewWorkflowExecutionDecisionAttributes.getter(ContinueAsNewWorkflowExecutionDecisionAttributes::executionStartToCloseTimeout)).setter(ContinueAsNewWorkflowExecutionDecisionAttributes.setter(Builder::executionStartToCloseTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionStartToCloseTimeout").build()}).build();
    private static final SdkField<TaskList> TASK_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ContinueAsNewWorkflowExecutionDecisionAttributes.getter(ContinueAsNewWorkflowExecutionDecisionAttributes::taskList)).setter(ContinueAsNewWorkflowExecutionDecisionAttributes.setter(Builder::taskList)).constructor(TaskList::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskList").build()}).build();
    private static final SdkField<String> TASK_PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ContinueAsNewWorkflowExecutionDecisionAttributes.getter(ContinueAsNewWorkflowExecutionDecisionAttributes::taskPriority)).setter(ContinueAsNewWorkflowExecutionDecisionAttributes.setter(Builder::taskPriority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskPriority").build()}).build();
    private static final SdkField<String> TASK_START_TO_CLOSE_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ContinueAsNewWorkflowExecutionDecisionAttributes.getter(ContinueAsNewWorkflowExecutionDecisionAttributes::taskStartToCloseTimeout)).setter(ContinueAsNewWorkflowExecutionDecisionAttributes.setter(Builder::taskStartToCloseTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskStartToCloseTimeout").build()}).build();
    private static final SdkField<String> CHILD_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ContinueAsNewWorkflowExecutionDecisionAttributes.getter(ContinueAsNewWorkflowExecutionDecisionAttributes::childPolicyAsString)).setter(ContinueAsNewWorkflowExecutionDecisionAttributes.setter(Builder::childPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("childPolicy").build()}).build();
    private static final SdkField<List<String>> TAG_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ContinueAsNewWorkflowExecutionDecisionAttributes.getter(ContinueAsNewWorkflowExecutionDecisionAttributes::tagList)).setter(ContinueAsNewWorkflowExecutionDecisionAttributes.setter(Builder::tagList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> WORKFLOW_TYPE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ContinueAsNewWorkflowExecutionDecisionAttributes.getter(ContinueAsNewWorkflowExecutionDecisionAttributes::workflowTypeVersion)).setter(ContinueAsNewWorkflowExecutionDecisionAttributes.setter(Builder::workflowTypeVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowTypeVersion").build()}).build();
    private static final SdkField<String> LAMBDA_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ContinueAsNewWorkflowExecutionDecisionAttributes.getter(ContinueAsNewWorkflowExecutionDecisionAttributes::lambdaRole)).setter(ContinueAsNewWorkflowExecutionDecisionAttributes.setter(Builder::lambdaRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaRole").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_FIELD, EXECUTION_START_TO_CLOSE_TIMEOUT_FIELD, TASK_LIST_FIELD, TASK_PRIORITY_FIELD, TASK_START_TO_CLOSE_TIMEOUT_FIELD, CHILD_POLICY_FIELD, TAG_LIST_FIELD, WORKFLOW_TYPE_VERSION_FIELD, LAMBDA_ROLE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String input;
    private final String executionStartToCloseTimeout;
    private final TaskList taskList;
    private final String taskPriority;
    private final String taskStartToCloseTimeout;
    private final String childPolicy;
    private final List<String> tagList;
    private final String workflowTypeVersion;
    private final String lambdaRole;

    private ContinueAsNewWorkflowExecutionDecisionAttributes(BuilderImpl builder) {
        this.input = builder.input;
        this.executionStartToCloseTimeout = builder.executionStartToCloseTimeout;
        this.taskList = builder.taskList;
        this.taskPriority = builder.taskPriority;
        this.taskStartToCloseTimeout = builder.taskStartToCloseTimeout;
        this.childPolicy = builder.childPolicy;
        this.tagList = builder.tagList;
        this.workflowTypeVersion = builder.workflowTypeVersion;
        this.lambdaRole = builder.lambdaRole;
    }

    public String input() {
        return this.input;
    }

    public String executionStartToCloseTimeout() {
        return this.executionStartToCloseTimeout;
    }

    public TaskList taskList() {
        return this.taskList;
    }

    public String taskPriority() {
        return this.taskPriority;
    }

    public String taskStartToCloseTimeout() {
        return this.taskStartToCloseTimeout;
    }

    public ChildPolicy childPolicy() {
        return ChildPolicy.fromValue(this.childPolicy);
    }

    public String childPolicyAsString() {
        return this.childPolicy;
    }

    public List<String> tagList() {
        return this.tagList;
    }

    public String workflowTypeVersion() {
        return this.workflowTypeVersion;
    }

    public String lambdaRole() {
        return this.lambdaRole;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.input());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionStartToCloseTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskList());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskPriority());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskStartToCloseTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.childPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagList());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowTypeVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaRole());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContinueAsNewWorkflowExecutionDecisionAttributes)) {
            return false;
        }
        ContinueAsNewWorkflowExecutionDecisionAttributes other = (ContinueAsNewWorkflowExecutionDecisionAttributes)obj;
        return Objects.equals(this.input(), other.input()) && Objects.equals(this.executionStartToCloseTimeout(), other.executionStartToCloseTimeout()) && Objects.equals(this.taskList(), other.taskList()) && Objects.equals(this.taskPriority(), other.taskPriority()) && Objects.equals(this.taskStartToCloseTimeout(), other.taskStartToCloseTimeout()) && Objects.equals(this.childPolicyAsString(), other.childPolicyAsString()) && Objects.equals(this.tagList(), other.tagList()) && Objects.equals(this.workflowTypeVersion(), other.workflowTypeVersion()) && Objects.equals(this.lambdaRole(), other.lambdaRole());
    }

    public String toString() {
        return ToString.builder((String)"ContinueAsNewWorkflowExecutionDecisionAttributes").add("Input", (Object)this.input()).add("ExecutionStartToCloseTimeout", (Object)this.executionStartToCloseTimeout()).add("TaskList", (Object)this.taskList()).add("TaskPriority", (Object)this.taskPriority()).add("TaskStartToCloseTimeout", (Object)this.taskStartToCloseTimeout()).add("ChildPolicy", (Object)this.childPolicyAsString()).add("TagList", this.tagList()).add("WorkflowTypeVersion", (Object)this.workflowTypeVersion()).add("LambdaRole", (Object)this.lambdaRole()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "input": {
                return Optional.ofNullable(clazz.cast(this.input()));
            }
            case "executionStartToCloseTimeout": {
                return Optional.ofNullable(clazz.cast(this.executionStartToCloseTimeout()));
            }
            case "taskList": {
                return Optional.ofNullable(clazz.cast(this.taskList()));
            }
            case "taskPriority": {
                return Optional.ofNullable(clazz.cast(this.taskPriority()));
            }
            case "taskStartToCloseTimeout": {
                return Optional.ofNullable(clazz.cast(this.taskStartToCloseTimeout()));
            }
            case "childPolicy": {
                return Optional.ofNullable(clazz.cast(this.childPolicyAsString()));
            }
            case "tagList": {
                return Optional.ofNullable(clazz.cast(this.tagList()));
            }
            case "workflowTypeVersion": {
                return Optional.ofNullable(clazz.cast(this.workflowTypeVersion()));
            }
            case "lambdaRole": {
                return Optional.ofNullable(clazz.cast(this.lambdaRole()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContinueAsNewWorkflowExecutionDecisionAttributes, T> g) {
        return obj -> g.apply((ContinueAsNewWorkflowExecutionDecisionAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String input;
        private String executionStartToCloseTimeout;
        private TaskList taskList;
        private String taskPriority;
        private String taskStartToCloseTimeout;
        private String childPolicy;
        private List<String> tagList = DefaultSdkAutoConstructList.getInstance();
        private String workflowTypeVersion;
        private String lambdaRole;

        private BuilderImpl() {
        }

        private BuilderImpl(ContinueAsNewWorkflowExecutionDecisionAttributes model) {
            this.input(model.input);
            this.executionStartToCloseTimeout(model.executionStartToCloseTimeout);
            this.taskList(model.taskList);
            this.taskPriority(model.taskPriority);
            this.taskStartToCloseTimeout(model.taskStartToCloseTimeout);
            this.childPolicy(model.childPolicy);
            this.tagList(model.tagList);
            this.workflowTypeVersion(model.workflowTypeVersion);
            this.lambdaRole(model.lambdaRole);
        }

        public final String getInput() {
            return this.input;
        }

        @Override
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        public final String getExecutionStartToCloseTimeout() {
            return this.executionStartToCloseTimeout;
        }

        @Override
        public final Builder executionStartToCloseTimeout(String executionStartToCloseTimeout) {
            this.executionStartToCloseTimeout = executionStartToCloseTimeout;
            return this;
        }

        public final void setExecutionStartToCloseTimeout(String executionStartToCloseTimeout) {
            this.executionStartToCloseTimeout = executionStartToCloseTimeout;
        }

        public final TaskList.Builder getTaskList() {
            return this.taskList != null ? this.taskList.toBuilder() : null;
        }

        @Override
        public final Builder taskList(TaskList taskList) {
            this.taskList = taskList;
            return this;
        }

        public final void setTaskList(TaskList.BuilderImpl taskList) {
            this.taskList = taskList != null ? taskList.build() : null;
        }

        public final String getTaskPriority() {
            return this.taskPriority;
        }

        @Override
        public final Builder taskPriority(String taskPriority) {
            this.taskPriority = taskPriority;
            return this;
        }

        public final void setTaskPriority(String taskPriority) {
            this.taskPriority = taskPriority;
        }

        public final String getTaskStartToCloseTimeout() {
            return this.taskStartToCloseTimeout;
        }

        @Override
        public final Builder taskStartToCloseTimeout(String taskStartToCloseTimeout) {
            this.taskStartToCloseTimeout = taskStartToCloseTimeout;
            return this;
        }

        public final void setTaskStartToCloseTimeout(String taskStartToCloseTimeout) {
            this.taskStartToCloseTimeout = taskStartToCloseTimeout;
        }

        public final String getChildPolicyAsString() {
            return this.childPolicy;
        }

        @Override
        public final Builder childPolicy(String childPolicy) {
            this.childPolicy = childPolicy;
            return this;
        }

        @Override
        public final Builder childPolicy(ChildPolicy childPolicy) {
            this.childPolicy(childPolicy == null ? null : childPolicy.toString());
            return this;
        }

        public final void setChildPolicy(String childPolicy) {
            this.childPolicy = childPolicy;
        }

        public final Collection<String> getTagList() {
            return this.tagList;
        }

        @Override
        public final Builder tagList(Collection<String> tagList) {
            this.tagList = TagListCopier.copy(tagList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(String ... tagList) {
            this.tagList(Arrays.asList(tagList));
            return this;
        }

        public final void setTagList(Collection<String> tagList) {
            this.tagList = TagListCopier.copy(tagList);
        }

        public final String getWorkflowTypeVersion() {
            return this.workflowTypeVersion;
        }

        @Override
        public final Builder workflowTypeVersion(String workflowTypeVersion) {
            this.workflowTypeVersion = workflowTypeVersion;
            return this;
        }

        public final void setWorkflowTypeVersion(String workflowTypeVersion) {
            this.workflowTypeVersion = workflowTypeVersion;
        }

        public final String getLambdaRole() {
            return this.lambdaRole;
        }

        @Override
        public final Builder lambdaRole(String lambdaRole) {
            this.lambdaRole = lambdaRole;
            return this;
        }

        public final void setLambdaRole(String lambdaRole) {
            this.lambdaRole = lambdaRole;
        }

        public ContinueAsNewWorkflowExecutionDecisionAttributes build() {
            return new ContinueAsNewWorkflowExecutionDecisionAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContinueAsNewWorkflowExecutionDecisionAttributes> {
        public Builder input(String var1);

        public Builder executionStartToCloseTimeout(String var1);

        public Builder taskList(TaskList var1);

        default public Builder taskList(Consumer<TaskList.Builder> taskList) {
            return this.taskList((TaskList)((TaskList.Builder)TaskList.builder().applyMutation(taskList)).build());
        }

        public Builder taskPriority(String var1);

        public Builder taskStartToCloseTimeout(String var1);

        public Builder childPolicy(String var1);

        public Builder childPolicy(ChildPolicy var1);

        public Builder tagList(Collection<String> var1);

        public Builder tagList(String ... var1);

        public Builder workflowTypeVersion(String var1);

        public Builder lambdaRole(String var1);
    }
}

