/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a paginated list of information about workflow executions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListClosedWorkflowExecutionsResponse extends SwfResponse implements
        ToCopyableBuilder<ListClosedWorkflowExecutionsResponse.Builder, ListClosedWorkflowExecutionsResponse> {
    private static final SdkField<List<WorkflowExecutionInfo>> EXECUTION_INFOS_FIELD = SdkField
            .<List<WorkflowExecutionInfo>> builder(MarshallingType.LIST)
            .getter(getter(ListClosedWorkflowExecutionsResponse::executionInfos))
            .setter(setter(Builder::executionInfos))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionInfos").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WorkflowExecutionInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(WorkflowExecutionInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListClosedWorkflowExecutionsResponse::nextPageToken)).setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_INFOS_FIELD,
            NEXT_PAGE_TOKEN_FIELD));

    private final List<WorkflowExecutionInfo> executionInfos;

    private final String nextPageToken;

    private ListClosedWorkflowExecutionsResponse(BuilderImpl builder) {
        super(builder);
        this.executionInfos = builder.executionInfos;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * Returns true if the ExecutionInfos property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasExecutionInfos() {
        return executionInfos != null && !(executionInfos instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of workflow information structures.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasExecutionInfos()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of workflow information structures.
     */
    public List<WorkflowExecutionInfo> executionInfos() {
        return executionInfos;
    }

    /**
     * <p>
     * If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To retrieve
     * the next page of results, make the call again using the returned token in <code>nextPageToken</code>. Keep all
     * other arguments unchanged.
     * </p>
     * <p>
     * The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.
     * </p>
     * 
     * @return If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To
     *         retrieve the next page of results, make the call again using the returned token in
     *         <code>nextPageToken</code>. Keep all other arguments unchanged.</p>
     *         <p>
     *         The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.
     */
    public String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(executionInfos());
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClosedWorkflowExecutionsResponse)) {
            return false;
        }
        ListClosedWorkflowExecutionsResponse other = (ListClosedWorkflowExecutionsResponse) obj;
        return Objects.equals(executionInfos(), other.executionInfos()) && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListClosedWorkflowExecutionsResponse").add("ExecutionInfos", executionInfos())
                .add("NextPageToken", nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "executionInfos":
            return Optional.ofNullable(clazz.cast(executionInfos()));
        case "nextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListClosedWorkflowExecutionsResponse, T> g) {
        return obj -> g.apply((ListClosedWorkflowExecutionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SwfResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListClosedWorkflowExecutionsResponse> {
        /**
         * <p>
         * The list of workflow information structures.
         * </p>
         * 
         * @param executionInfos
         *        The list of workflow information structures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionInfos(Collection<WorkflowExecutionInfo> executionInfos);

        /**
         * <p>
         * The list of workflow information structures.
         * </p>
         * 
         * @param executionInfos
         *        The list of workflow information structures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionInfos(WorkflowExecutionInfo... executionInfos);

        /**
         * <p>
         * The list of workflow information structures.
         * </p>
         * This is a convenience that creates an instance of the {@link List<WorkflowExecutionInfo>.Builder} avoiding
         * the need to create one manually via {@link List<WorkflowExecutionInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<WorkflowExecutionInfo>.Builder#build()} is called
         * immediately and its result is passed to {@link #executionInfos(List<WorkflowExecutionInfo>)}.
         * 
         * @param executionInfos
         *        a consumer that will call methods on {@link List<WorkflowExecutionInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executionInfos(List<WorkflowExecutionInfo>)
         */
        Builder executionInfos(Consumer<WorkflowExecutionInfo.Builder>... executionInfos);

        /**
         * <p>
         * If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To
         * retrieve the next page of results, make the call again using the returned token in <code>nextPageToken</code>
         * . Keep all other arguments unchanged.
         * </p>
         * <p>
         * The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.
         * </p>
         * 
         * @param nextPageToken
         *        If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To
         *        retrieve the next page of results, make the call again using the returned token in
         *        <code>nextPageToken</code>. Keep all other arguments unchanged.</p>
         *        <p>
         *        The configured <code>maximumPageSize</code> determines how many results can be returned in a single
         *        call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl extends SwfResponse.BuilderImpl implements Builder {
        private List<WorkflowExecutionInfo> executionInfos = DefaultSdkAutoConstructList.getInstance();

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListClosedWorkflowExecutionsResponse model) {
            super(model);
            executionInfos(model.executionInfos);
            nextPageToken(model.nextPageToken);
        }

        public final Collection<WorkflowExecutionInfo.Builder> getExecutionInfos() {
            return executionInfos != null ? executionInfos.stream().map(WorkflowExecutionInfo::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder executionInfos(Collection<WorkflowExecutionInfo> executionInfos) {
            this.executionInfos = WorkflowExecutionInfoListCopier.copy(executionInfos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder executionInfos(WorkflowExecutionInfo... executionInfos) {
            executionInfos(Arrays.asList(executionInfos));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder executionInfos(Consumer<WorkflowExecutionInfo.Builder>... executionInfos) {
            executionInfos(Stream.of(executionInfos).map(c -> WorkflowExecutionInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setExecutionInfos(Collection<WorkflowExecutionInfo.BuilderImpl> executionInfos) {
            this.executionInfos = WorkflowExecutionInfoListCopier.copyFromBuilder(executionInfos);
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public ListClosedWorkflowExecutionsResponse build() {
            return new ListClosedWorkflowExecutionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
