/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input data for a TaskCompleted response to a decision task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RespondDecisionTaskCompletedRequest extends SwfRequest implements
        ToCopyableBuilder<RespondDecisionTaskCompletedRequest.Builder, RespondDecisionTaskCompletedRequest> {
    private static final SdkField<String> TASK_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RespondDecisionTaskCompletedRequest::taskToken)).setter(setter(Builder::taskToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskToken").build()).build();

    private static final SdkField<List<Decision>> DECISIONS_FIELD = SdkField
            .<List<Decision>> builder(MarshallingType.LIST)
            .getter(getter(RespondDecisionTaskCompletedRequest::decisions))
            .setter(setter(Builder::decisions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decisions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Decision> builder(MarshallingType.SDK_POJO)
                                            .constructor(Decision::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> EXECUTION_CONTEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RespondDecisionTaskCompletedRequest::executionContext)).setter(setter(Builder::executionContext))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionContext").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_TOKEN_FIELD,
            DECISIONS_FIELD, EXECUTION_CONTEXT_FIELD));

    private final String taskToken;

    private final List<Decision> decisions;

    private final String executionContext;

    private RespondDecisionTaskCompletedRequest(BuilderImpl builder) {
        super(builder);
        this.taskToken = builder.taskToken;
        this.decisions = builder.decisions;
        this.executionContext = builder.executionContext;
    }

    /**
     * <p>
     * The <code>taskToken</code> from the <a>DecisionTask</a>.
     * </p>
     * <important>
     * <p>
     * <code>taskToken</code> is generated by the service and should be treated as an opaque value. If the task is
     * passed to another process, its <code>taskToken</code> must also be passed. This enables it to provide its
     * progress and respond with results.
     * </p>
     * </important>
     * 
     * @return The <code>taskToken</code> from the <a>DecisionTask</a>.</p> <important>
     *         <p>
     *         <code>taskToken</code> is generated by the service and should be treated as an opaque value. If the task
     *         is passed to another process, its <code>taskToken</code> must also be passed. This enables it to provide
     *         its progress and respond with results.
     *         </p>
     */
    public String taskToken() {
        return taskToken;
    }

    /**
     * Returns true if the Decisions property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasDecisions() {
        return decisions != null && !(decisions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of decisions (possibly empty) made by the decider while processing this decision task. See the docs for
     * the <a>Decision</a> structure for details.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDecisions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of decisions (possibly empty) made by the decider while processing this decision task. See the
     *         docs for the <a>Decision</a> structure for details.
     */
    public List<Decision> decisions() {
        return decisions;
    }

    /**
     * <p>
     * User defined context to add to workflow execution.
     * </p>
     * 
     * @return User defined context to add to workflow execution.
     */
    public String executionContext() {
        return executionContext;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(taskToken());
        hashCode = 31 * hashCode + Objects.hashCode(decisions());
        hashCode = 31 * hashCode + Objects.hashCode(executionContext());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RespondDecisionTaskCompletedRequest)) {
            return false;
        }
        RespondDecisionTaskCompletedRequest other = (RespondDecisionTaskCompletedRequest) obj;
        return Objects.equals(taskToken(), other.taskToken()) && Objects.equals(decisions(), other.decisions())
                && Objects.equals(executionContext(), other.executionContext());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RespondDecisionTaskCompletedRequest").add("TaskToken", taskToken())
                .add("Decisions", decisions()).add("ExecutionContext", executionContext()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "taskToken":
            return Optional.ofNullable(clazz.cast(taskToken()));
        case "decisions":
            return Optional.ofNullable(clazz.cast(decisions()));
        case "executionContext":
            return Optional.ofNullable(clazz.cast(executionContext()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RespondDecisionTaskCompletedRequest, T> g) {
        return obj -> g.apply((RespondDecisionTaskCompletedRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SwfRequest.Builder, SdkPojo, CopyableBuilder<Builder, RespondDecisionTaskCompletedRequest> {
        /**
         * <p>
         * The <code>taskToken</code> from the <a>DecisionTask</a>.
         * </p>
         * <important>
         * <p>
         * <code>taskToken</code> is generated by the service and should be treated as an opaque value. If the task is
         * passed to another process, its <code>taskToken</code> must also be passed. This enables it to provide its
         * progress and respond with results.
         * </p>
         * </important>
         * 
         * @param taskToken
         *        The <code>taskToken</code> from the <a>DecisionTask</a>.</p> <important>
         *        <p>
         *        <code>taskToken</code> is generated by the service and should be treated as an opaque value. If the
         *        task is passed to another process, its <code>taskToken</code> must also be passed. This enables it to
         *        provide its progress and respond with results.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskToken(String taskToken);

        /**
         * <p>
         * The list of decisions (possibly empty) made by the decider while processing this decision task. See the docs
         * for the <a>Decision</a> structure for details.
         * </p>
         * 
         * @param decisions
         *        The list of decisions (possibly empty) made by the decider while processing this decision task. See
         *        the docs for the <a>Decision</a> structure for details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decisions(Collection<Decision> decisions);

        /**
         * <p>
         * The list of decisions (possibly empty) made by the decider while processing this decision task. See the docs
         * for the <a>Decision</a> structure for details.
         * </p>
         * 
         * @param decisions
         *        The list of decisions (possibly empty) made by the decider while processing this decision task. See
         *        the docs for the <a>Decision</a> structure for details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decisions(Decision... decisions);

        /**
         * <p>
         * The list of decisions (possibly empty) made by the decider while processing this decision task. See the docs
         * for the <a>Decision</a> structure for details.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Decision>.Builder} avoiding the need to
         * create one manually via {@link List<Decision>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Decision>.Builder#build()} is called immediately and its
         * result is passed to {@link #decisions(List<Decision>)}.
         * 
         * @param decisions
         *        a consumer that will call methods on {@link List<Decision>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #decisions(List<Decision>)
         */
        Builder decisions(Consumer<Decision.Builder>... decisions);

        /**
         * <p>
         * User defined context to add to workflow execution.
         * </p>
         * 
         * @param executionContext
         *        User defined context to add to workflow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionContext(String executionContext);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SwfRequest.BuilderImpl implements Builder {
        private String taskToken;

        private List<Decision> decisions = DefaultSdkAutoConstructList.getInstance();

        private String executionContext;

        private BuilderImpl() {
        }

        private BuilderImpl(RespondDecisionTaskCompletedRequest model) {
            super(model);
            taskToken(model.taskToken);
            decisions(model.decisions);
            executionContext(model.executionContext);
        }

        public final String getTaskToken() {
            return taskToken;
        }

        @Override
        public final Builder taskToken(String taskToken) {
            this.taskToken = taskToken;
            return this;
        }

        public final void setTaskToken(String taskToken) {
            this.taskToken = taskToken;
        }

        public final Collection<Decision.Builder> getDecisions() {
            return decisions != null ? decisions.stream().map(Decision::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder decisions(Collection<Decision> decisions) {
            this.decisions = DecisionListCopier.copy(decisions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder decisions(Decision... decisions) {
            decisions(Arrays.asList(decisions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder decisions(Consumer<Decision.Builder>... decisions) {
            decisions(Stream.of(decisions).map(c -> Decision.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDecisions(Collection<Decision.BuilderImpl> decisions) {
            this.decisions = DecisionListCopier.copyFromBuilder(decisions);
        }

        public final String getExecutionContext() {
            return executionContext;
        }

        @Override
        public final Builder executionContext(String executionContext) {
            this.executionContext = executionContext;
            return this;
        }

        public final void setExecutionContext(String executionContext) {
            this.executionContext = executionContext;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RespondDecisionTaskCompletedRequest build() {
            return new RespondDecisionTaskCompletedRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
