/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UndeprecateActivityTypeRequest extends SwfRequest implements
        ToCopyableBuilder<UndeprecateActivityTypeRequest.Builder, UndeprecateActivityTypeRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UndeprecateActivityTypeRequest::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domain").build()).build();

    private static final SdkField<ActivityType> ACTIVITY_TYPE_FIELD = SdkField.<ActivityType> builder(MarshallingType.SDK_POJO)
            .getter(getter(UndeprecateActivityTypeRequest::activityType)).setter(setter(Builder::activityType))
            .constructor(ActivityType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activityType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD,
            ACTIVITY_TYPE_FIELD));

    private final String domain;

    private final ActivityType activityType;

    private UndeprecateActivityTypeRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.activityType = builder.activityType;
    }

    /**
     * <p>
     * The name of the domain of the deprecated activity type.
     * </p>
     * 
     * @return The name of the domain of the deprecated activity type.
     */
    public String domain() {
        return domain;
    }

    /**
     * <p>
     * The activity type to undeprecate.
     * </p>
     * 
     * @return The activity type to undeprecate.
     */
    public ActivityType activityType() {
        return activityType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(activityType());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UndeprecateActivityTypeRequest)) {
            return false;
        }
        UndeprecateActivityTypeRequest other = (UndeprecateActivityTypeRequest) obj;
        return Objects.equals(domain(), other.domain()) && Objects.equals(activityType(), other.activityType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UndeprecateActivityTypeRequest").add("Domain", domain()).add("ActivityType", activityType())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "activityType":
            return Optional.ofNullable(clazz.cast(activityType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UndeprecateActivityTypeRequest, T> g) {
        return obj -> g.apply((UndeprecateActivityTypeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SwfRequest.Builder, SdkPojo, CopyableBuilder<Builder, UndeprecateActivityTypeRequest> {
        /**
         * <p>
         * The name of the domain of the deprecated activity type.
         * </p>
         * 
         * @param domain
         *        The name of the domain of the deprecated activity type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The activity type to undeprecate.
         * </p>
         * 
         * @param activityType
         *        The activity type to undeprecate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activityType(ActivityType activityType);

        /**
         * <p>
         * The activity type to undeprecate.
         * </p>
         * This is a convenience that creates an instance of the {@link ActivityType.Builder} avoiding the need to
         * create one manually via {@link ActivityType#builder()}.
         *
         * When the {@link Consumer} completes, {@link ActivityType.Builder#build()} is called immediately and its
         * result is passed to {@link #activityType(ActivityType)}.
         * 
         * @param activityType
         *        a consumer that will call methods on {@link ActivityType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activityType(ActivityType)
         */
        default Builder activityType(Consumer<ActivityType.Builder> activityType) {
            return activityType(ActivityType.builder().applyMutation(activityType).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SwfRequest.BuilderImpl implements Builder {
        private String domain;

        private ActivityType activityType;

        private BuilderImpl() {
        }

        private BuilderImpl(UndeprecateActivityTypeRequest model) {
            super(model);
            domain(model.domain);
            activityType(model.activityType);
        }

        public final String getDomain() {
            return domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final ActivityType.Builder getActivityType() {
            return activityType != null ? activityType.toBuilder() : null;
        }

        @Override
        public final Builder activityType(ActivityType activityType) {
            this.activityType = activityType;
            return this;
        }

        public final void setActivityType(ActivityType.BuilderImpl activityType) {
            this.activityType = activityType != null ? activityType.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UndeprecateActivityTypeRequest build() {
            return new UndeprecateActivityTypeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
