/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that represents a decision task. Decision tasks are sent to deciders in order for them to make decisions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PollForDecisionTaskResponse extends SwfResponse implements
        ToCopyableBuilder<PollForDecisionTaskResponse.Builder, PollForDecisionTaskResponse> {
    private static final SdkField<String> TASK_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PollForDecisionTaskResponse::taskToken)).setter(setter(Builder::taskToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskToken").build()).build();

    private static final SdkField<Long> STARTED_EVENT_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(PollForDecisionTaskResponse::startedEventId)).setter(setter(Builder::startedEventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedEventId").build()).build();

    private static final SdkField<WorkflowExecution> WORKFLOW_EXECUTION_FIELD = SdkField
            .<WorkflowExecution> builder(MarshallingType.SDK_POJO).getter(getter(PollForDecisionTaskResponse::workflowExecution))
            .setter(setter(Builder::workflowExecution)).constructor(WorkflowExecution::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowExecution").build()).build();

    private static final SdkField<WorkflowType> WORKFLOW_TYPE_FIELD = SdkField.<WorkflowType> builder(MarshallingType.SDK_POJO)
            .getter(getter(PollForDecisionTaskResponse::workflowType)).setter(setter(Builder::workflowType))
            .constructor(WorkflowType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowType").build()).build();

    private static final SdkField<List<HistoryEvent>> EVENTS_FIELD = SdkField
            .<List<HistoryEvent>> builder(MarshallingType.LIST)
            .getter(getter(PollForDecisionTaskResponse::events))
            .setter(setter(Builder::events))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("events").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HistoryEvent> builder(MarshallingType.SDK_POJO)
                                            .constructor(HistoryEvent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PollForDecisionTaskResponse::nextPageToken)).setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageToken").build()).build();

    private static final SdkField<Long> PREVIOUS_STARTED_EVENT_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(PollForDecisionTaskResponse::previousStartedEventId)).setter(setter(Builder::previousStartedEventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("previousStartedEventId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_TOKEN_FIELD,
            STARTED_EVENT_ID_FIELD, WORKFLOW_EXECUTION_FIELD, WORKFLOW_TYPE_FIELD, EVENTS_FIELD, NEXT_PAGE_TOKEN_FIELD,
            PREVIOUS_STARTED_EVENT_ID_FIELD));

    private final String taskToken;

    private final Long startedEventId;

    private final WorkflowExecution workflowExecution;

    private final WorkflowType workflowType;

    private final List<HistoryEvent> events;

    private final String nextPageToken;

    private final Long previousStartedEventId;

    private PollForDecisionTaskResponse(BuilderImpl builder) {
        super(builder);
        this.taskToken = builder.taskToken;
        this.startedEventId = builder.startedEventId;
        this.workflowExecution = builder.workflowExecution;
        this.workflowType = builder.workflowType;
        this.events = builder.events;
        this.nextPageToken = builder.nextPageToken;
        this.previousStartedEventId = builder.previousStartedEventId;
    }

    /**
     * <p>
     * The opaque string used as a handle on the task. This token is used by workers to communicate progress and
     * response information back to the system about the task.
     * </p>
     * 
     * @return The opaque string used as a handle on the task. This token is used by workers to communicate progress and
     *         response information back to the system about the task.
     */
    public String taskToken() {
        return taskToken;
    }

    /**
     * <p>
     * The ID of the <code>DecisionTaskStarted</code> event recorded in the history.
     * </p>
     * 
     * @return The ID of the <code>DecisionTaskStarted</code> event recorded in the history.
     */
    public Long startedEventId() {
        return startedEventId;
    }

    /**
     * <p>
     * The workflow execution for which this decision task was created.
     * </p>
     * 
     * @return The workflow execution for which this decision task was created.
     */
    public WorkflowExecution workflowExecution() {
        return workflowExecution;
    }

    /**
     * <p>
     * The type of the workflow execution for which this decision task was created.
     * </p>
     * 
     * @return The type of the workflow execution for which this decision task was created.
     */
    public WorkflowType workflowType() {
        return workflowType;
    }

    /**
     * Returns true if the Events property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasEvents() {
        return events != null && !(events instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A paginated list of history events of the workflow execution. The decider uses this during the processing of the
     * decision task.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEvents()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A paginated list of history events of the workflow execution. The decider uses this during the processing
     *         of the decision task.
     */
    public List<HistoryEvent> events() {
        return events;
    }

    /**
     * <p>
     * If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To retrieve
     * the next page of results, make the call again using the returned token in <code>nextPageToken</code>. Keep all
     * other arguments unchanged.
     * </p>
     * <p>
     * The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.
     * </p>
     * 
     * @return If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To
     *         retrieve the next page of results, make the call again using the returned token in
     *         <code>nextPageToken</code>. Keep all other arguments unchanged.</p>
     *         <p>
     *         The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.
     */
    public String nextPageToken() {
        return nextPageToken;
    }

    /**
     * <p>
     * The ID of the DecisionTaskStarted event of the previous decision task of this workflow execution that was
     * processed by the decider. This can be used to determine the events in the history new since the last decision
     * task received by the decider.
     * </p>
     * 
     * @return The ID of the DecisionTaskStarted event of the previous decision task of this workflow execution that was
     *         processed by the decider. This can be used to determine the events in the history new since the last
     *         decision task received by the decider.
     */
    public Long previousStartedEventId() {
        return previousStartedEventId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(taskToken());
        hashCode = 31 * hashCode + Objects.hashCode(startedEventId());
        hashCode = 31 * hashCode + Objects.hashCode(workflowExecution());
        hashCode = 31 * hashCode + Objects.hashCode(workflowType());
        hashCode = 31 * hashCode + Objects.hashCode(events());
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        hashCode = 31 * hashCode + Objects.hashCode(previousStartedEventId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PollForDecisionTaskResponse)) {
            return false;
        }
        PollForDecisionTaskResponse other = (PollForDecisionTaskResponse) obj;
        return Objects.equals(taskToken(), other.taskToken()) && Objects.equals(startedEventId(), other.startedEventId())
                && Objects.equals(workflowExecution(), other.workflowExecution())
                && Objects.equals(workflowType(), other.workflowType()) && Objects.equals(events(), other.events())
                && Objects.equals(nextPageToken(), other.nextPageToken())
                && Objects.equals(previousStartedEventId(), other.previousStartedEventId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PollForDecisionTaskResponse").add("TaskToken", taskToken())
                .add("StartedEventId", startedEventId()).add("WorkflowExecution", workflowExecution())
                .add("WorkflowType", workflowType()).add("Events", events()).add("NextPageToken", nextPageToken())
                .add("PreviousStartedEventId", previousStartedEventId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "taskToken":
            return Optional.ofNullable(clazz.cast(taskToken()));
        case "startedEventId":
            return Optional.ofNullable(clazz.cast(startedEventId()));
        case "workflowExecution":
            return Optional.ofNullable(clazz.cast(workflowExecution()));
        case "workflowType":
            return Optional.ofNullable(clazz.cast(workflowType()));
        case "events":
            return Optional.ofNullable(clazz.cast(events()));
        case "nextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        case "previousStartedEventId":
            return Optional.ofNullable(clazz.cast(previousStartedEventId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PollForDecisionTaskResponse, T> g) {
        return obj -> g.apply((PollForDecisionTaskResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SwfResponse.Builder, SdkPojo, CopyableBuilder<Builder, PollForDecisionTaskResponse> {
        /**
         * <p>
         * The opaque string used as a handle on the task. This token is used by workers to communicate progress and
         * response information back to the system about the task.
         * </p>
         * 
         * @param taskToken
         *        The opaque string used as a handle on the task. This token is used by workers to communicate progress
         *        and response information back to the system about the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskToken(String taskToken);

        /**
         * <p>
         * The ID of the <code>DecisionTaskStarted</code> event recorded in the history.
         * </p>
         * 
         * @param startedEventId
         *        The ID of the <code>DecisionTaskStarted</code> event recorded in the history.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedEventId(Long startedEventId);

        /**
         * <p>
         * The workflow execution for which this decision task was created.
         * </p>
         * 
         * @param workflowExecution
         *        The workflow execution for which this decision task was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowExecution(WorkflowExecution workflowExecution);

        /**
         * <p>
         * The workflow execution for which this decision task was created.
         * </p>
         * This is a convenience that creates an instance of the {@link WorkflowExecution.Builder} avoiding the need to
         * create one manually via {@link WorkflowExecution#builder()}.
         *
         * When the {@link Consumer} completes, {@link WorkflowExecution.Builder#build()} is called immediately and its
         * result is passed to {@link #workflowExecution(WorkflowExecution)}.
         * 
         * @param workflowExecution
         *        a consumer that will call methods on {@link WorkflowExecution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workflowExecution(WorkflowExecution)
         */
        default Builder workflowExecution(Consumer<WorkflowExecution.Builder> workflowExecution) {
            return workflowExecution(WorkflowExecution.builder().applyMutation(workflowExecution).build());
        }

        /**
         * <p>
         * The type of the workflow execution for which this decision task was created.
         * </p>
         * 
         * @param workflowType
         *        The type of the workflow execution for which this decision task was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowType(WorkflowType workflowType);

        /**
         * <p>
         * The type of the workflow execution for which this decision task was created.
         * </p>
         * This is a convenience that creates an instance of the {@link WorkflowType.Builder} avoiding the need to
         * create one manually via {@link WorkflowType#builder()}.
         *
         * When the {@link Consumer} completes, {@link WorkflowType.Builder#build()} is called immediately and its
         * result is passed to {@link #workflowType(WorkflowType)}.
         * 
         * @param workflowType
         *        a consumer that will call methods on {@link WorkflowType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workflowType(WorkflowType)
         */
        default Builder workflowType(Consumer<WorkflowType.Builder> workflowType) {
            return workflowType(WorkflowType.builder().applyMutation(workflowType).build());
        }

        /**
         * <p>
         * A paginated list of history events of the workflow execution. The decider uses this during the processing of
         * the decision task.
         * </p>
         * 
         * @param events
         *        A paginated list of history events of the workflow execution. The decider uses this during the
         *        processing of the decision task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(Collection<HistoryEvent> events);

        /**
         * <p>
         * A paginated list of history events of the workflow execution. The decider uses this during the processing of
         * the decision task.
         * </p>
         * 
         * @param events
         *        A paginated list of history events of the workflow execution. The decider uses this during the
         *        processing of the decision task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(HistoryEvent... events);

        /**
         * <p>
         * A paginated list of history events of the workflow execution. The decider uses this during the processing of
         * the decision task.
         * </p>
         * This is a convenience that creates an instance of the {@link List<HistoryEvent>.Builder} avoiding the need to
         * create one manually via {@link List<HistoryEvent>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<HistoryEvent>.Builder#build()} is called immediately and its
         * result is passed to {@link #events(List<HistoryEvent>)}.
         * 
         * @param events
         *        a consumer that will call methods on {@link List<HistoryEvent>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #events(List<HistoryEvent>)
         */
        Builder events(Consumer<HistoryEvent.Builder>... events);

        /**
         * <p>
         * If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To
         * retrieve the next page of results, make the call again using the returned token in <code>nextPageToken</code>
         * . Keep all other arguments unchanged.
         * </p>
         * <p>
         * The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.
         * </p>
         * 
         * @param nextPageToken
         *        If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To
         *        retrieve the next page of results, make the call again using the returned token in
         *        <code>nextPageToken</code>. Keep all other arguments unchanged.</p>
         *        <p>
         *        The configured <code>maximumPageSize</code> determines how many results can be returned in a single
         *        call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);

        /**
         * <p>
         * The ID of the DecisionTaskStarted event of the previous decision task of this workflow execution that was
         * processed by the decider. This can be used to determine the events in the history new since the last decision
         * task received by the decider.
         * </p>
         * 
         * @param previousStartedEventId
         *        The ID of the DecisionTaskStarted event of the previous decision task of this workflow execution that
         *        was processed by the decider. This can be used to determine the events in the history new since the
         *        last decision task received by the decider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previousStartedEventId(Long previousStartedEventId);
    }

    static final class BuilderImpl extends SwfResponse.BuilderImpl implements Builder {
        private String taskToken;

        private Long startedEventId;

        private WorkflowExecution workflowExecution;

        private WorkflowType workflowType;

        private List<HistoryEvent> events = DefaultSdkAutoConstructList.getInstance();

        private String nextPageToken;

        private Long previousStartedEventId;

        private BuilderImpl() {
        }

        private BuilderImpl(PollForDecisionTaskResponse model) {
            super(model);
            taskToken(model.taskToken);
            startedEventId(model.startedEventId);
            workflowExecution(model.workflowExecution);
            workflowType(model.workflowType);
            events(model.events);
            nextPageToken(model.nextPageToken);
            previousStartedEventId(model.previousStartedEventId);
        }

        public final String getTaskToken() {
            return taskToken;
        }

        @Override
        public final Builder taskToken(String taskToken) {
            this.taskToken = taskToken;
            return this;
        }

        public final void setTaskToken(String taskToken) {
            this.taskToken = taskToken;
        }

        public final Long getStartedEventId() {
            return startedEventId;
        }

        @Override
        public final Builder startedEventId(Long startedEventId) {
            this.startedEventId = startedEventId;
            return this;
        }

        public final void setStartedEventId(Long startedEventId) {
            this.startedEventId = startedEventId;
        }

        public final WorkflowExecution.Builder getWorkflowExecution() {
            return workflowExecution != null ? workflowExecution.toBuilder() : null;
        }

        @Override
        public final Builder workflowExecution(WorkflowExecution workflowExecution) {
            this.workflowExecution = workflowExecution;
            return this;
        }

        public final void setWorkflowExecution(WorkflowExecution.BuilderImpl workflowExecution) {
            this.workflowExecution = workflowExecution != null ? workflowExecution.build() : null;
        }

        public final WorkflowType.Builder getWorkflowType() {
            return workflowType != null ? workflowType.toBuilder() : null;
        }

        @Override
        public final Builder workflowType(WorkflowType workflowType) {
            this.workflowType = workflowType;
            return this;
        }

        public final void setWorkflowType(WorkflowType.BuilderImpl workflowType) {
            this.workflowType = workflowType != null ? workflowType.build() : null;
        }

        public final Collection<HistoryEvent.Builder> getEvents() {
            return events != null ? events.stream().map(HistoryEvent::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder events(Collection<HistoryEvent> events) {
            this.events = HistoryEventListCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(HistoryEvent... events) {
            events(Arrays.asList(events));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(Consumer<HistoryEvent.Builder>... events) {
            events(Stream.of(events).map(c -> HistoryEvent.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEvents(Collection<HistoryEvent.BuilderImpl> events) {
            this.events = HistoryEventListCopier.copyFromBuilder(events);
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        public final Long getPreviousStartedEventId() {
            return previousStartedEventId;
        }

        @Override
        public final Builder previousStartedEventId(Long previousStartedEventId) {
            this.previousStartedEventId = previousStartedEventId;
            return this;
        }

        public final void setPreviousStartedEventId(Long previousStartedEventId) {
            this.previousStartedEventId = previousStartedEventId;
        }

        @Override
        public PollForDecisionTaskResponse build() {
            return new PollForDecisionTaskResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
