/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import static java.util.stream.Collectors.toSet;

import java.util.Set;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

@Generated("software.amazon.awssdk:codegen")
public enum StartChildWorkflowExecutionFailedCause {
    WORKFLOW_TYPE_DOES_NOT_EXIST("WORKFLOW_TYPE_DOES_NOT_EXIST"),

    WORKFLOW_TYPE_DEPRECATED("WORKFLOW_TYPE_DEPRECATED"),

    OPEN_CHILDREN_LIMIT_EXCEEDED("OPEN_CHILDREN_LIMIT_EXCEEDED"),

    OPEN_WORKFLOWS_LIMIT_EXCEEDED("OPEN_WORKFLOWS_LIMIT_EXCEEDED"),

    CHILD_CREATION_RATE_EXCEEDED("CHILD_CREATION_RATE_EXCEEDED"),

    WORKFLOW_ALREADY_RUNNING("WORKFLOW_ALREADY_RUNNING"),

    DEFAULT_EXECUTION_START_TO_CLOSE_TIMEOUT_UNDEFINED("DEFAULT_EXECUTION_START_TO_CLOSE_TIMEOUT_UNDEFINED"),

    DEFAULT_TASK_LIST_UNDEFINED("DEFAULT_TASK_LIST_UNDEFINED"),

    DEFAULT_TASK_START_TO_CLOSE_TIMEOUT_UNDEFINED("DEFAULT_TASK_START_TO_CLOSE_TIMEOUT_UNDEFINED"),

    DEFAULT_CHILD_POLICY_UNDEFINED("DEFAULT_CHILD_POLICY_UNDEFINED"),

    OPERATION_NOT_PERMITTED("OPERATION_NOT_PERMITTED"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private StartChildWorkflowExecutionFailedCause(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return StartChildWorkflowExecutionFailedCause corresponding to the value
     */
    public static StartChildWorkflowExecutionFailedCause fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(StartChildWorkflowExecutionFailedCause.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link StartChildWorkflowExecutionFailedCause}s
     */
    public static Set<StartChildWorkflowExecutionFailedCause> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(toSet());
    }
}
