/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the details of the <code>StartChildWorkflowExecutionFailed</code> event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartChildWorkflowExecutionFailedEventAttributes
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<StartChildWorkflowExecutionFailedEventAttributes.Builder, StartChildWorkflowExecutionFailedEventAttributes> {
    private static final SdkField<WorkflowType> WORKFLOW_TYPE_FIELD = SdkField.<WorkflowType> builder(MarshallingType.SDK_POJO)
            .getter(getter(StartChildWorkflowExecutionFailedEventAttributes::workflowType)).setter(setter(Builder::workflowType))
            .constructor(WorkflowType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowType").build()).build();

    private static final SdkField<String> CAUSE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartChildWorkflowExecutionFailedEventAttributes::causeAsString)).setter(setter(Builder::cause))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cause").build()).build();

    private static final SdkField<String> WORKFLOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartChildWorkflowExecutionFailedEventAttributes::workflowId)).setter(setter(Builder::workflowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowId").build()).build();

    private static final SdkField<Long> INITIATED_EVENT_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(StartChildWorkflowExecutionFailedEventAttributes::initiatedEventId))
            .setter(setter(Builder::initiatedEventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initiatedEventId").build()).build();

    private static final SdkField<Long> DECISION_TASK_COMPLETED_EVENT_ID_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .getter(getter(StartChildWorkflowExecutionFailedEventAttributes::decisionTaskCompletedEventId))
            .setter(setter(Builder::decisionTaskCompletedEventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decisionTaskCompletedEventId")
                    .build()).build();

    private static final SdkField<String> CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartChildWorkflowExecutionFailedEventAttributes::control)).setter(setter(Builder::control))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("control").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_TYPE_FIELD,
            CAUSE_FIELD, WORKFLOW_ID_FIELD, INITIATED_EVENT_ID_FIELD, DECISION_TASK_COMPLETED_EVENT_ID_FIELD, CONTROL_FIELD));

    private static final long serialVersionUID = 1L;

    private final WorkflowType workflowType;

    private final String causeValue;

    private final String workflowId;

    private final Long initiatedEventId;

    private final Long decisionTaskCompletedEventId;

    private final String control;

    private StartChildWorkflowExecutionFailedEventAttributes(BuilderImpl builder) {
        this.workflowType = builder.workflowType;
        this.causeValue = builder.causeValue;
        this.workflowId = builder.workflowId;
        this.initiatedEventId = builder.initiatedEventId;
        this.decisionTaskCompletedEventId = builder.decisionTaskCompletedEventId;
        this.control = builder.control;
    }

    /**
     * <p>
     * The workflow type provided in the <code>StartChildWorkflowExecution</code> <a>Decision</a> that failed.
     * </p>
     * 
     * @return The workflow type provided in the <code>StartChildWorkflowExecution</code> <a>Decision</a> that failed.
     */
    public WorkflowType workflowType() {
        return workflowType;
    }

    /**
     * <p>
     * The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.
     * </p>
     * <note>
     * <p>
     * When <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision fails because it lacks
     * sufficient permissions. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html"> Using IAM to Manage Access
     * to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #cause} will return
     * {@link StartChildWorkflowExecutionFailedCause#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #causeAsString}.
     * </p>
     * 
     * @return The cause of the failure. This information is generated by the system and can be useful for diagnostic
     *         purposes.</p> <note>
     *         <p>
     *         When <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision fails because it
     *         lacks sufficient permissions. For details and example IAM policies, see <a
     *         href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html"> Using IAM to Manage
     *         Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     *         </p>
     * @see StartChildWorkflowExecutionFailedCause
     */
    public StartChildWorkflowExecutionFailedCause cause() {
        return StartChildWorkflowExecutionFailedCause.fromValue(causeValue);
    }

    /**
     * <p>
     * The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.
     * </p>
     * <note>
     * <p>
     * When <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision fails because it lacks
     * sufficient permissions. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html"> Using IAM to Manage Access
     * to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #cause} will return
     * {@link StartChildWorkflowExecutionFailedCause#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #causeAsString}.
     * </p>
     * 
     * @return The cause of the failure. This information is generated by the system and can be useful for diagnostic
     *         purposes.</p> <note>
     *         <p>
     *         When <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision fails because it
     *         lacks sufficient permissions. For details and example IAM policies, see <a
     *         href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html"> Using IAM to Manage
     *         Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     *         </p>
     * @see StartChildWorkflowExecutionFailedCause
     */
    public String causeAsString() {
        return causeValue;
    }

    /**
     * <p>
     * The <code>workflowId</code> of the child workflow execution.
     * </p>
     * 
     * @return The <code>workflowId</code> of the child workflow execution.
     */
    public String workflowId() {
        return workflowId;
    }

    /**
     * <p>
     * When the <code>cause</code> is <code>WORKFLOW_ALREADY_RUNNING</code>, <code>initiatedEventId</code> is the ID of
     * the <code>StartChildWorkflowExecutionInitiated</code> event that corresponds to the
     * <code>StartChildWorkflowExecution</code> <a>Decision</a> to start the workflow execution. You can use this
     * information to diagnose problems by tracing back the chain of events leading up to this event.
     * </p>
     * <p>
     * When the <code>cause</code> isn't <code>WORKFLOW_ALREADY_RUNNING</code>, <code>initiatedEventId</code> is set to
     * <code>0</code> because the <code>StartChildWorkflowExecutionInitiated</code> event doesn't exist.
     * </p>
     * 
     * @return When the <code>cause</code> is <code>WORKFLOW_ALREADY_RUNNING</code>, <code>initiatedEventId</code> is
     *         the ID of the <code>StartChildWorkflowExecutionInitiated</code> event that corresponds to the
     *         <code>StartChildWorkflowExecution</code> <a>Decision</a> to start the workflow execution. You can use
     *         this information to diagnose problems by tracing back the chain of events leading up to this event.</p>
     *         <p>
     *         When the <code>cause</code> isn't <code>WORKFLOW_ALREADY_RUNNING</code>, <code>initiatedEventId</code> is
     *         set to <code>0</code> because the <code>StartChildWorkflowExecutionInitiated</code> event doesn't exist.
     */
    public Long initiatedEventId() {
        return initiatedEventId;
    }

    /**
     * <p>
     * The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
     * <code>StartChildWorkflowExecution</code> <a>Decision</a> to request this child workflow execution. This
     * information can be useful for diagnosing problems by tracing back the chain of events.
     * </p>
     * 
     * @return The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted
     *         in the <code>StartChildWorkflowExecution</code> <a>Decision</a> to request this child workflow execution.
     *         This information can be useful for diagnosing problems by tracing back the chain of events.
     */
    public Long decisionTaskCompletedEventId() {
        return decisionTaskCompletedEventId;
    }

    /**
     * <p>
     * The data attached to the event that the decider can use in subsequent workflow tasks. This data isn't sent to the
     * child workflow execution.
     * </p>
     * 
     * @return The data attached to the event that the decider can use in subsequent workflow tasks. This data isn't
     *         sent to the child workflow execution.
     */
    public String control() {
        return control;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(workflowType());
        hashCode = 31 * hashCode + Objects.hashCode(causeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(workflowId());
        hashCode = 31 * hashCode + Objects.hashCode(initiatedEventId());
        hashCode = 31 * hashCode + Objects.hashCode(decisionTaskCompletedEventId());
        hashCode = 31 * hashCode + Objects.hashCode(control());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartChildWorkflowExecutionFailedEventAttributes)) {
            return false;
        }
        StartChildWorkflowExecutionFailedEventAttributes other = (StartChildWorkflowExecutionFailedEventAttributes) obj;
        return Objects.equals(workflowType(), other.workflowType()) && Objects.equals(causeAsString(), other.causeAsString())
                && Objects.equals(workflowId(), other.workflowId())
                && Objects.equals(initiatedEventId(), other.initiatedEventId())
                && Objects.equals(decisionTaskCompletedEventId(), other.decisionTaskCompletedEventId())
                && Objects.equals(control(), other.control());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StartChildWorkflowExecutionFailedEventAttributes").add("WorkflowType", workflowType())
                .add("Cause", causeAsString()).add("WorkflowId", workflowId()).add("InitiatedEventId", initiatedEventId())
                .add("DecisionTaskCompletedEventId", decisionTaskCompletedEventId()).add("Control", control()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "workflowType":
            return Optional.ofNullable(clazz.cast(workflowType()));
        case "cause":
            return Optional.ofNullable(clazz.cast(causeAsString()));
        case "workflowId":
            return Optional.ofNullable(clazz.cast(workflowId()));
        case "initiatedEventId":
            return Optional.ofNullable(clazz.cast(initiatedEventId()));
        case "decisionTaskCompletedEventId":
            return Optional.ofNullable(clazz.cast(decisionTaskCompletedEventId()));
        case "control":
            return Optional.ofNullable(clazz.cast(control()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartChildWorkflowExecutionFailedEventAttributes, T> g) {
        return obj -> g.apply((StartChildWorkflowExecutionFailedEventAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StartChildWorkflowExecutionFailedEventAttributes> {
        /**
         * <p>
         * The workflow type provided in the <code>StartChildWorkflowExecution</code> <a>Decision</a> that failed.
         * </p>
         * 
         * @param workflowType
         *        The workflow type provided in the <code>StartChildWorkflowExecution</code> <a>Decision</a> that
         *        failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowType(WorkflowType workflowType);

        /**
         * <p>
         * The workflow type provided in the <code>StartChildWorkflowExecution</code> <a>Decision</a> that failed.
         * </p>
         * This is a convenience that creates an instance of the {@link WorkflowType.Builder} avoiding the need to
         * create one manually via {@link WorkflowType#builder()}.
         *
         * When the {@link Consumer} completes, {@link WorkflowType.Builder#build()} is called immediately and its
         * result is passed to {@link #workflowType(WorkflowType)}.
         * 
         * @param workflowType
         *        a consumer that will call methods on {@link WorkflowType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workflowType(WorkflowType)
         */
        default Builder workflowType(Consumer<WorkflowType.Builder> workflowType) {
            return workflowType(WorkflowType.builder().applyMutation(workflowType).build());
        }

        /**
         * <p>
         * The cause of the failure. This information is generated by the system and can be useful for diagnostic
         * purposes.
         * </p>
         * <note>
         * <p>
         * When <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision fails because it lacks
         * sufficient permissions. For details and example IAM policies, see <a
         * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html"> Using IAM to Manage
         * Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
         * </p>
         * </note>
         * 
         * @param causeValue
         *        The cause of the failure. This information is generated by the system and can be useful for diagnostic
         *        purposes.</p> <note>
         *        <p>
         *        When <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision fails because it
         *        lacks sufficient permissions. For details and example IAM policies, see <a
         *        href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html"> Using IAM to
         *        Manage Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
         *        </p>
         * @see StartChildWorkflowExecutionFailedCause
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StartChildWorkflowExecutionFailedCause
         */
        Builder cause(String causeValue);

        /**
         * <p>
         * The cause of the failure. This information is generated by the system and can be useful for diagnostic
         * purposes.
         * </p>
         * <note>
         * <p>
         * When <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision fails because it lacks
         * sufficient permissions. For details and example IAM policies, see <a
         * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html"> Using IAM to Manage
         * Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
         * </p>
         * </note>
         * 
         * @param causeValue
         *        The cause of the failure. This information is generated by the system and can be useful for diagnostic
         *        purposes.</p> <note>
         *        <p>
         *        When <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision fails because it
         *        lacks sufficient permissions. For details and example IAM policies, see <a
         *        href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html"> Using IAM to
         *        Manage Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
         *        </p>
         * @see StartChildWorkflowExecutionFailedCause
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StartChildWorkflowExecutionFailedCause
         */
        Builder cause(StartChildWorkflowExecutionFailedCause causeValue);

        /**
         * <p>
         * The <code>workflowId</code> of the child workflow execution.
         * </p>
         * 
         * @param workflowId
         *        The <code>workflowId</code> of the child workflow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowId(String workflowId);

        /**
         * <p>
         * When the <code>cause</code> is <code>WORKFLOW_ALREADY_RUNNING</code>, <code>initiatedEventId</code> is the ID
         * of the <code>StartChildWorkflowExecutionInitiated</code> event that corresponds to the
         * <code>StartChildWorkflowExecution</code> <a>Decision</a> to start the workflow execution. You can use this
         * information to diagnose problems by tracing back the chain of events leading up to this event.
         * </p>
         * <p>
         * When the <code>cause</code> isn't <code>WORKFLOW_ALREADY_RUNNING</code>, <code>initiatedEventId</code> is set
         * to <code>0</code> because the <code>StartChildWorkflowExecutionInitiated</code> event doesn't exist.
         * </p>
         * 
         * @param initiatedEventId
         *        When the <code>cause</code> is <code>WORKFLOW_ALREADY_RUNNING</code>, <code>initiatedEventId</code> is
         *        the ID of the <code>StartChildWorkflowExecutionInitiated</code> event that corresponds to the
         *        <code>StartChildWorkflowExecution</code> <a>Decision</a> to start the workflow execution. You can use
         *        this information to diagnose problems by tracing back the chain of events leading up to this
         *        event.</p>
         *        <p>
         *        When the <code>cause</code> isn't <code>WORKFLOW_ALREADY_RUNNING</code>, <code>initiatedEventId</code>
         *        is set to <code>0</code> because the <code>StartChildWorkflowExecutionInitiated</code> event doesn't
         *        exist.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initiatedEventId(Long initiatedEventId);

        /**
         * <p>
         * The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in
         * the <code>StartChildWorkflowExecution</code> <a>Decision</a> to request this child workflow execution. This
         * information can be useful for diagnosing problems by tracing back the chain of events.
         * </p>
         * 
         * @param decisionTaskCompletedEventId
         *        The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that
         *        resulted in the <code>StartChildWorkflowExecution</code> <a>Decision</a> to request this child
         *        workflow execution. This information can be useful for diagnosing problems by tracing back the chain
         *        of events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decisionTaskCompletedEventId(Long decisionTaskCompletedEventId);

        /**
         * <p>
         * The data attached to the event that the decider can use in subsequent workflow tasks. This data isn't sent to
         * the child workflow execution.
         * </p>
         * 
         * @param control
         *        The data attached to the event that the decider can use in subsequent workflow tasks. This data isn't
         *        sent to the child workflow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder control(String control);
    }

    static final class BuilderImpl implements Builder {
        private WorkflowType workflowType;

        private String causeValue;

        private String workflowId;

        private Long initiatedEventId;

        private Long decisionTaskCompletedEventId;

        private String control;

        private BuilderImpl() {
        }

        private BuilderImpl(StartChildWorkflowExecutionFailedEventAttributes model) {
            workflowType(model.workflowType);
            cause(model.causeValue);
            workflowId(model.workflowId);
            initiatedEventId(model.initiatedEventId);
            decisionTaskCompletedEventId(model.decisionTaskCompletedEventId);
            control(model.control);
        }

        public final WorkflowType.Builder getWorkflowType() {
            return workflowType != null ? workflowType.toBuilder() : null;
        }

        @Override
        public final Builder workflowType(WorkflowType workflowType) {
            this.workflowType = workflowType;
            return this;
        }

        public final void setWorkflowType(WorkflowType.BuilderImpl workflowType) {
            this.workflowType = workflowType != null ? workflowType.build() : null;
        }

        public final String getCauseAsString() {
            return causeValue;
        }

        @Override
        public final Builder cause(String causeValue) {
            this.causeValue = causeValue;
            return this;
        }

        @Override
        public final Builder cause(StartChildWorkflowExecutionFailedCause causeValue) {
            this.cause(causeValue == null ? null : causeValue.toString());
            return this;
        }

        public final void setCause(String causeValue) {
            this.causeValue = causeValue;
        }

        public final String getWorkflowId() {
            return workflowId;
        }

        @Override
        public final Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public final void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        public final Long getInitiatedEventId() {
            return initiatedEventId;
        }

        @Override
        public final Builder initiatedEventId(Long initiatedEventId) {
            this.initiatedEventId = initiatedEventId;
            return this;
        }

        public final void setInitiatedEventId(Long initiatedEventId) {
            this.initiatedEventId = initiatedEventId;
        }

        public final Long getDecisionTaskCompletedEventId() {
            return decisionTaskCompletedEventId;
        }

        @Override
        public final Builder decisionTaskCompletedEventId(Long decisionTaskCompletedEventId) {
            this.decisionTaskCompletedEventId = decisionTaskCompletedEventId;
            return this;
        }

        public final void setDecisionTaskCompletedEventId(Long decisionTaskCompletedEventId) {
            this.decisionTaskCompletedEventId = decisionTaskCompletedEventId;
        }

        public final String getControl() {
            return control;
        }

        @Override
        public final Builder control(String control) {
            this.control = control;
            return this;
        }

        public final void setControl(String control) {
            this.control = control;
        }

        @Override
        public StartChildWorkflowExecutionFailedEventAttributes build() {
            return new StartChildWorkflowExecutionFailedEventAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
