/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Used to filter the workflow executions in visibility APIs by various time-based rules. Each parameter, if specified,
 * defines a rule that must be satisfied by each returned query result. The parameter values are in the <a
 * href="https://en.wikipedia.org/wiki/Unix_time">Unix Time format</a>. For example:
 * <code>"oldestDate": 1325376070.</code>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecutionTimeFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<ExecutionTimeFilter.Builder, ExecutionTimeFilter> {
    private static final SdkField<Instant> OLDEST_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ExecutionTimeFilter::oldestDate)).setter(setter(Builder::oldestDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oldestDate").build()).build();

    private static final SdkField<Instant> LATEST_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ExecutionTimeFilter::latestDate)).setter(setter(Builder::latestDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OLDEST_DATE_FIELD,
            LATEST_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant oldestDate;

    private final Instant latestDate;

    private ExecutionTimeFilter(BuilderImpl builder) {
        this.oldestDate = builder.oldestDate;
        this.latestDate = builder.latestDate;
    }

    /**
     * <p>
     * Specifies the oldest start or close date and time to return.
     * </p>
     * 
     * @return Specifies the oldest start or close date and time to return.
     */
    public Instant oldestDate() {
        return oldestDate;
    }

    /**
     * <p>
     * Specifies the latest start or close date and time to return.
     * </p>
     * 
     * @return Specifies the latest start or close date and time to return.
     */
    public Instant latestDate() {
        return latestDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(oldestDate());
        hashCode = 31 * hashCode + Objects.hashCode(latestDate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionTimeFilter)) {
            return false;
        }
        ExecutionTimeFilter other = (ExecutionTimeFilter) obj;
        return Objects.equals(oldestDate(), other.oldestDate()) && Objects.equals(latestDate(), other.latestDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ExecutionTimeFilter").add("OldestDate", oldestDate()).add("LatestDate", latestDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "oldestDate":
            return Optional.ofNullable(clazz.cast(oldestDate()));
        case "latestDate":
            return Optional.ofNullable(clazz.cast(latestDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecutionTimeFilter, T> g) {
        return obj -> g.apply((ExecutionTimeFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExecutionTimeFilter> {
        /**
         * <p>
         * Specifies the oldest start or close date and time to return.
         * </p>
         * 
         * @param oldestDate
         *        Specifies the oldest start or close date and time to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oldestDate(Instant oldestDate);

        /**
         * <p>
         * Specifies the latest start or close date and time to return.
         * </p>
         * 
         * @param latestDate
         *        Specifies the latest start or close date and time to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestDate(Instant latestDate);
    }

    static final class BuilderImpl implements Builder {
        private Instant oldestDate;

        private Instant latestDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionTimeFilter model) {
            oldestDate(model.oldestDate);
            latestDate(model.latestDate);
        }

        public final Instant getOldestDate() {
            return oldestDate;
        }

        @Override
        public final Builder oldestDate(Instant oldestDate) {
            this.oldestDate = oldestDate;
            return this;
        }

        public final void setOldestDate(Instant oldestDate) {
            this.oldestDate = oldestDate;
        }

        public final Instant getLatestDate() {
            return latestDate;
        }

        @Override
        public final Builder latestDate(Instant latestDate) {
            this.latestDate = latestDate;
            return this;
        }

        public final void setLatestDate(Instant latestDate) {
            this.latestDate = latestDate;
        }

        @Override
        public ExecutionTimeFilter build() {
            return new ExecutionTimeFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
