/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the details of the <code>StartChildWorkflowExecutionInitiated</code> event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartChildWorkflowExecutionInitiatedEventAttributes
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<StartChildWorkflowExecutionInitiatedEventAttributes.Builder, StartChildWorkflowExecutionInitiatedEventAttributes> {
    private static final SdkField<String> WORKFLOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartChildWorkflowExecutionInitiatedEventAttributes::workflowId)).setter(setter(Builder::workflowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowId").build()).build();

    private static final SdkField<WorkflowType> WORKFLOW_TYPE_FIELD = SdkField.<WorkflowType> builder(MarshallingType.SDK_POJO)
            .getter(getter(StartChildWorkflowExecutionInitiatedEventAttributes::workflowType))
            .setter(setter(Builder::workflowType)).constructor(WorkflowType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowType").build()).build();

    private static final SdkField<String> CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartChildWorkflowExecutionInitiatedEventAttributes::control)).setter(setter(Builder::control))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("control").build()).build();

    private static final SdkField<String> INPUT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartChildWorkflowExecutionInitiatedEventAttributes::input)).setter(setter(Builder::input))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()).build();

    private static final SdkField<String> EXECUTION_START_TO_CLOSE_TIMEOUT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(StartChildWorkflowExecutionInitiatedEventAttributes::executionStartToCloseTimeout))
            .setter(setter(Builder::executionStartToCloseTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionStartToCloseTimeout")
                    .build()).build();

    private static final SdkField<TaskList> TASK_LIST_FIELD = SdkField.<TaskList> builder(MarshallingType.SDK_POJO)
            .getter(getter(StartChildWorkflowExecutionInitiatedEventAttributes::taskList)).setter(setter(Builder::taskList))
            .constructor(TaskList::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskList").build()).build();

    private static final SdkField<String> TASK_PRIORITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartChildWorkflowExecutionInitiatedEventAttributes::taskPriority))
            .setter(setter(Builder::taskPriority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskPriority").build()).build();

    private static final SdkField<Long> DECISION_TASK_COMPLETED_EVENT_ID_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .getter(getter(StartChildWorkflowExecutionInitiatedEventAttributes::decisionTaskCompletedEventId))
            .setter(setter(Builder::decisionTaskCompletedEventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decisionTaskCompletedEventId")
                    .build()).build();

    private static final SdkField<String> CHILD_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartChildWorkflowExecutionInitiatedEventAttributes::childPolicyAsString))
            .setter(setter(Builder::childPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("childPolicy").build()).build();

    private static final SdkField<String> TASK_START_TO_CLOSE_TIMEOUT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartChildWorkflowExecutionInitiatedEventAttributes::taskStartToCloseTimeout))
            .setter(setter(Builder::taskStartToCloseTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskStartToCloseTimeout").build())
            .build();

    private static final SdkField<List<String>> TAG_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(StartChildWorkflowExecutionInitiatedEventAttributes::tagList))
            .setter(setter(Builder::tagList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LAMBDA_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartChildWorkflowExecutionInitiatedEventAttributes::lambdaRole)).setter(setter(Builder::lambdaRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaRole").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_ID_FIELD,
            WORKFLOW_TYPE_FIELD, CONTROL_FIELD, INPUT_FIELD, EXECUTION_START_TO_CLOSE_TIMEOUT_FIELD, TASK_LIST_FIELD,
            TASK_PRIORITY_FIELD, DECISION_TASK_COMPLETED_EVENT_ID_FIELD, CHILD_POLICY_FIELD, TASK_START_TO_CLOSE_TIMEOUT_FIELD,
            TAG_LIST_FIELD, LAMBDA_ROLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String workflowId;

    private final WorkflowType workflowType;

    private final String control;

    private final String input;

    private final String executionStartToCloseTimeout;

    private final TaskList taskList;

    private final String taskPriority;

    private final Long decisionTaskCompletedEventId;

    private final String childPolicy;

    private final String taskStartToCloseTimeout;

    private final List<String> tagList;

    private final String lambdaRole;

    private StartChildWorkflowExecutionInitiatedEventAttributes(BuilderImpl builder) {
        this.workflowId = builder.workflowId;
        this.workflowType = builder.workflowType;
        this.control = builder.control;
        this.input = builder.input;
        this.executionStartToCloseTimeout = builder.executionStartToCloseTimeout;
        this.taskList = builder.taskList;
        this.taskPriority = builder.taskPriority;
        this.decisionTaskCompletedEventId = builder.decisionTaskCompletedEventId;
        this.childPolicy = builder.childPolicy;
        this.taskStartToCloseTimeout = builder.taskStartToCloseTimeout;
        this.tagList = builder.tagList;
        this.lambdaRole = builder.lambdaRole;
    }

    /**
     * <p>
     * The <code>workflowId</code> of the child workflow execution.
     * </p>
     * 
     * @return The <code>workflowId</code> of the child workflow execution.
     */
    public String workflowId() {
        return workflowId;
    }

    /**
     * <p>
     * The type of the child workflow execution.
     * </p>
     * 
     * @return The type of the child workflow execution.
     */
    public WorkflowType workflowType() {
        return workflowType;
    }

    /**
     * <p>
     * Data attached to the event that can be used by the decider in subsequent decision tasks. This data isn't sent to
     * the activity.
     * </p>
     * 
     * @return Data attached to the event that can be used by the decider in subsequent decision tasks. This data isn't
     *         sent to the activity.
     */
    public String control() {
        return control;
    }

    /**
     * <p>
     * The inputs provided to the child workflow execution.
     * </p>
     * 
     * @return The inputs provided to the child workflow execution.
     */
    public String input() {
        return input;
    }

    /**
     * <p>
     * The maximum duration for the child workflow execution. If the workflow execution isn't closed within this
     * duration, it is timed out and force-terminated.
     * </p>
     * <p>
     * The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
     * <code>NONE</code> to specify unlimited duration.
     * </p>
     * 
     * @return The maximum duration for the child workflow execution. If the workflow execution isn't closed within this
     *         duration, it is timed out and force-terminated.</p>
     *         <p>
     *         The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
     *         <code>NONE</code> to specify unlimited duration.
     */
    public String executionStartToCloseTimeout() {
        return executionStartToCloseTimeout;
    }

    /**
     * <p>
     * The name of the task list used for the decision tasks of the child workflow execution.
     * </p>
     * 
     * @return The name of the task list used for the decision tasks of the child workflow execution.
     */
    public TaskList taskList() {
        return taskList;
    }

    /**
     * <p>
     * The priority assigned for the decision tasks for this workflow execution. Valid values are integers that range
     * from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647). Higher
     * numbers indicate higher priority.
     * </p>
     * <p>
     * For more information about setting task priority, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
     * Priority</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * 
     * @return The priority assigned for the decision tasks for this workflow execution. Valid values are integers that
     *         range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to <code>Integer.MAX_VALUE</code>
     *         (2147483647). Higher numbers indicate higher priority.</p>
     *         <p>
     *         For more information about setting task priority, see <a
     *         href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
     *         Priority</a> in the <i>Amazon SWF Developer Guide</i>.
     */
    public String taskPriority() {
        return taskPriority;
    }

    /**
     * <p>
     * The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
     * <code>StartChildWorkflowExecution</code> <a>Decision</a> to request this child workflow execution. This
     * information can be useful for diagnosing problems by tracing back the cause of events.
     * </p>
     * 
     * @return The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted
     *         in the <code>StartChildWorkflowExecution</code> <a>Decision</a> to request this child workflow execution.
     *         This information can be useful for diagnosing problems by tracing back the cause of events.
     */
    public Long decisionTaskCompletedEventId() {
        return decisionTaskCompletedEventId;
    }

    /**
     * <p>
     * The policy to use for the child workflow executions if this execution gets terminated by explicitly calling the
     * <a>TerminateWorkflowExecution</a> action or due to an expired timeout.
     * </p>
     * <p>
     * The supported child policies are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TERMINATE</code> – The child executions are terminated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child execution by recording a
     * <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take appropriate
     * actions when it receives an execution history with this event.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ABANDON</code> – No action is taken. The child executions continue to run.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #childPolicy} will
     * return {@link ChildPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #childPolicyAsString}.
     * </p>
     * 
     * @return The policy to use for the child workflow executions if this execution gets terminated by explicitly
     *         calling the <a>TerminateWorkflowExecution</a> action or due to an expired timeout.</p>
     *         <p>
     *         The supported child policies are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>TERMINATE</code> – The child executions are terminated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child execution by recording a
     *         <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
     *         appropriate actions when it receives an execution history with this event.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ABANDON</code> – No action is taken. The child executions continue to run.
     *         </p>
     *         </li>
     * @see ChildPolicy
     */
    public ChildPolicy childPolicy() {
        return ChildPolicy.fromValue(childPolicy);
    }

    /**
     * <p>
     * The policy to use for the child workflow executions if this execution gets terminated by explicitly calling the
     * <a>TerminateWorkflowExecution</a> action or due to an expired timeout.
     * </p>
     * <p>
     * The supported child policies are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TERMINATE</code> – The child executions are terminated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child execution by recording a
     * <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take appropriate
     * actions when it receives an execution history with this event.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ABANDON</code> – No action is taken. The child executions continue to run.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #childPolicy} will
     * return {@link ChildPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #childPolicyAsString}.
     * </p>
     * 
     * @return The policy to use for the child workflow executions if this execution gets terminated by explicitly
     *         calling the <a>TerminateWorkflowExecution</a> action or due to an expired timeout.</p>
     *         <p>
     *         The supported child policies are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>TERMINATE</code> – The child executions are terminated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child execution by recording a
     *         <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
     *         appropriate actions when it receives an execution history with this event.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ABANDON</code> – No action is taken. The child executions continue to run.
     *         </p>
     *         </li>
     * @see ChildPolicy
     */
    public String childPolicyAsString() {
        return childPolicy;
    }

    /**
     * <p>
     * The maximum duration allowed for the decision tasks for this workflow execution.
     * </p>
     * <p>
     * The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
     * <code>NONE</code> to specify unlimited duration.
     * </p>
     * 
     * @return The maximum duration allowed for the decision tasks for this workflow execution.</p>
     *         <p>
     *         The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
     *         <code>NONE</code> to specify unlimited duration.
     */
    public String taskStartToCloseTimeout() {
        return taskStartToCloseTimeout;
    }

    /**
     * Returns true if the TagList property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTagList() {
        return tagList != null && !(tagList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of tags to associated with the child workflow execution.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTagList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of tags to associated with the child workflow execution.
     */
    public List<String> tagList() {
        return tagList;
    }

    /**
     * <p>
     * The IAM role to attach to the child workflow execution.
     * </p>
     * 
     * @return The IAM role to attach to the child workflow execution.
     */
    public String lambdaRole() {
        return lambdaRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(workflowId());
        hashCode = 31 * hashCode + Objects.hashCode(workflowType());
        hashCode = 31 * hashCode + Objects.hashCode(control());
        hashCode = 31 * hashCode + Objects.hashCode(input());
        hashCode = 31 * hashCode + Objects.hashCode(executionStartToCloseTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(taskList());
        hashCode = 31 * hashCode + Objects.hashCode(taskPriority());
        hashCode = 31 * hashCode + Objects.hashCode(decisionTaskCompletedEventId());
        hashCode = 31 * hashCode + Objects.hashCode(childPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(taskStartToCloseTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(tagList());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaRole());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartChildWorkflowExecutionInitiatedEventAttributes)) {
            return false;
        }
        StartChildWorkflowExecutionInitiatedEventAttributes other = (StartChildWorkflowExecutionInitiatedEventAttributes) obj;
        return Objects.equals(workflowId(), other.workflowId()) && Objects.equals(workflowType(), other.workflowType())
                && Objects.equals(control(), other.control()) && Objects.equals(input(), other.input())
                && Objects.equals(executionStartToCloseTimeout(), other.executionStartToCloseTimeout())
                && Objects.equals(taskList(), other.taskList()) && Objects.equals(taskPriority(), other.taskPriority())
                && Objects.equals(decisionTaskCompletedEventId(), other.decisionTaskCompletedEventId())
                && Objects.equals(childPolicyAsString(), other.childPolicyAsString())
                && Objects.equals(taskStartToCloseTimeout(), other.taskStartToCloseTimeout())
                && Objects.equals(tagList(), other.tagList()) && Objects.equals(lambdaRole(), other.lambdaRole());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StartChildWorkflowExecutionInitiatedEventAttributes").add("WorkflowId", workflowId())
                .add("WorkflowType", workflowType()).add("Control", control()).add("Input", input())
                .add("ExecutionStartToCloseTimeout", executionStartToCloseTimeout()).add("TaskList", taskList())
                .add("TaskPriority", taskPriority()).add("DecisionTaskCompletedEventId", decisionTaskCompletedEventId())
                .add("ChildPolicy", childPolicyAsString()).add("TaskStartToCloseTimeout", taskStartToCloseTimeout())
                .add("TagList", tagList()).add("LambdaRole", lambdaRole()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "workflowId":
            return Optional.ofNullable(clazz.cast(workflowId()));
        case "workflowType":
            return Optional.ofNullable(clazz.cast(workflowType()));
        case "control":
            return Optional.ofNullable(clazz.cast(control()));
        case "input":
            return Optional.ofNullable(clazz.cast(input()));
        case "executionStartToCloseTimeout":
            return Optional.ofNullable(clazz.cast(executionStartToCloseTimeout()));
        case "taskList":
            return Optional.ofNullable(clazz.cast(taskList()));
        case "taskPriority":
            return Optional.ofNullable(clazz.cast(taskPriority()));
        case "decisionTaskCompletedEventId":
            return Optional.ofNullable(clazz.cast(decisionTaskCompletedEventId()));
        case "childPolicy":
            return Optional.ofNullable(clazz.cast(childPolicyAsString()));
        case "taskStartToCloseTimeout":
            return Optional.ofNullable(clazz.cast(taskStartToCloseTimeout()));
        case "tagList":
            return Optional.ofNullable(clazz.cast(tagList()));
        case "lambdaRole":
            return Optional.ofNullable(clazz.cast(lambdaRole()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartChildWorkflowExecutionInitiatedEventAttributes, T> g) {
        return obj -> g.apply((StartChildWorkflowExecutionInitiatedEventAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StartChildWorkflowExecutionInitiatedEventAttributes> {
        /**
         * <p>
         * The <code>workflowId</code> of the child workflow execution.
         * </p>
         * 
         * @param workflowId
         *        The <code>workflowId</code> of the child workflow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowId(String workflowId);

        /**
         * <p>
         * The type of the child workflow execution.
         * </p>
         * 
         * @param workflowType
         *        The type of the child workflow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowType(WorkflowType workflowType);

        /**
         * <p>
         * The type of the child workflow execution.
         * </p>
         * This is a convenience that creates an instance of the {@link WorkflowType.Builder} avoiding the need to
         * create one manually via {@link WorkflowType#builder()}.
         *
         * When the {@link Consumer} completes, {@link WorkflowType.Builder#build()} is called immediately and its
         * result is passed to {@link #workflowType(WorkflowType)}.
         * 
         * @param workflowType
         *        a consumer that will call methods on {@link WorkflowType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workflowType(WorkflowType)
         */
        default Builder workflowType(Consumer<WorkflowType.Builder> workflowType) {
            return workflowType(WorkflowType.builder().applyMutation(workflowType).build());
        }

        /**
         * <p>
         * Data attached to the event that can be used by the decider in subsequent decision tasks. This data isn't sent
         * to the activity.
         * </p>
         * 
         * @param control
         *        Data attached to the event that can be used by the decider in subsequent decision tasks. This data
         *        isn't sent to the activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder control(String control);

        /**
         * <p>
         * The inputs provided to the child workflow execution.
         * </p>
         * 
         * @param input
         *        The inputs provided to the child workflow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(String input);

        /**
         * <p>
         * The maximum duration for the child workflow execution. If the workflow execution isn't closed within this
         * duration, it is timed out and force-terminated.
         * </p>
         * <p>
         * The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
         * <code>NONE</code> to specify unlimited duration.
         * </p>
         * 
         * @param executionStartToCloseTimeout
         *        The maximum duration for the child workflow execution. If the workflow execution isn't closed within
         *        this duration, it is timed out and force-terminated.</p>
         *        <p>
         *        The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
         *        <code>NONE</code> to specify unlimited duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionStartToCloseTimeout(String executionStartToCloseTimeout);

        /**
         * <p>
         * The name of the task list used for the decision tasks of the child workflow execution.
         * </p>
         * 
         * @param taskList
         *        The name of the task list used for the decision tasks of the child workflow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskList(TaskList taskList);

        /**
         * <p>
         * The name of the task list used for the decision tasks of the child workflow execution.
         * </p>
         * This is a convenience that creates an instance of the {@link TaskList.Builder} avoiding the need to create
         * one manually via {@link TaskList#builder()}.
         *
         * When the {@link Consumer} completes, {@link TaskList.Builder#build()} is called immediately and its result is
         * passed to {@link #taskList(TaskList)}.
         * 
         * @param taskList
         *        a consumer that will call methods on {@link TaskList.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taskList(TaskList)
         */
        default Builder taskList(Consumer<TaskList.Builder> taskList) {
            return taskList(TaskList.builder().applyMutation(taskList).build());
        }

        /**
         * <p>
         * The priority assigned for the decision tasks for this workflow execution. Valid values are integers that
         * range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to <code>Integer.MAX_VALUE</code>
         * (2147483647). Higher numbers indicate higher priority.
         * </p>
         * <p>
         * For more information about setting task priority, see <a
         * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
         * Priority</a> in the <i>Amazon SWF Developer Guide</i>.
         * </p>
         * 
         * @param taskPriority
         *        The priority assigned for the decision tasks for this workflow execution. Valid values are integers
         *        that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to <code>Integer.MAX_VALUE</code>
         *        (2147483647). Higher numbers indicate higher priority.</p>
         *        <p>
         *        For more information about setting task priority, see <a
         *        href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting
         *        Task Priority</a> in the <i>Amazon SWF Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskPriority(String taskPriority);

        /**
         * <p>
         * The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in
         * the <code>StartChildWorkflowExecution</code> <a>Decision</a> to request this child workflow execution. This
         * information can be useful for diagnosing problems by tracing back the cause of events.
         * </p>
         * 
         * @param decisionTaskCompletedEventId
         *        The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that
         *        resulted in the <code>StartChildWorkflowExecution</code> <a>Decision</a> to request this child
         *        workflow execution. This information can be useful for diagnosing problems by tracing back the cause
         *        of events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decisionTaskCompletedEventId(Long decisionTaskCompletedEventId);

        /**
         * <p>
         * The policy to use for the child workflow executions if this execution gets terminated by explicitly calling
         * the <a>TerminateWorkflowExecution</a> action or due to an expired timeout.
         * </p>
         * <p>
         * The supported child policies are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>TERMINATE</code> – The child executions are terminated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child execution by recording a
         * <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         * appropriate actions when it receives an execution history with this event.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ABANDON</code> – No action is taken. The child executions continue to run.
         * </p>
         * </li>
         * </ul>
         * 
         * @param childPolicy
         *        The policy to use for the child workflow executions if this execution gets terminated by explicitly
         *        calling the <a>TerminateWorkflowExecution</a> action or due to an expired timeout.</p>
         *        <p>
         *        The supported child policies are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>TERMINATE</code> – The child executions are terminated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child execution by recording a
         *        <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         *        appropriate actions when it receives an execution history with this event.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ABANDON</code> – No action is taken. The child executions continue to run.
         *        </p>
         *        </li>
         * @see ChildPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChildPolicy
         */
        Builder childPolicy(String childPolicy);

        /**
         * <p>
         * The policy to use for the child workflow executions if this execution gets terminated by explicitly calling
         * the <a>TerminateWorkflowExecution</a> action or due to an expired timeout.
         * </p>
         * <p>
         * The supported child policies are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>TERMINATE</code> – The child executions are terminated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child execution by recording a
         * <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         * appropriate actions when it receives an execution history with this event.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ABANDON</code> – No action is taken. The child executions continue to run.
         * </p>
         * </li>
         * </ul>
         * 
         * @param childPolicy
         *        The policy to use for the child workflow executions if this execution gets terminated by explicitly
         *        calling the <a>TerminateWorkflowExecution</a> action or due to an expired timeout.</p>
         *        <p>
         *        The supported child policies are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>TERMINATE</code> – The child executions are terminated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child execution by recording a
         *        <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         *        appropriate actions when it receives an execution history with this event.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ABANDON</code> – No action is taken. The child executions continue to run.
         *        </p>
         *        </li>
         * @see ChildPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChildPolicy
         */
        Builder childPolicy(ChildPolicy childPolicy);

        /**
         * <p>
         * The maximum duration allowed for the decision tasks for this workflow execution.
         * </p>
         * <p>
         * The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
         * <code>NONE</code> to specify unlimited duration.
         * </p>
         * 
         * @param taskStartToCloseTimeout
         *        The maximum duration allowed for the decision tasks for this workflow execution.</p>
         *        <p>
         *        The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
         *        <code>NONE</code> to specify unlimited duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskStartToCloseTimeout(String taskStartToCloseTimeout);

        /**
         * <p>
         * The list of tags to associated with the child workflow execution.
         * </p>
         * 
         * @param tagList
         *        The list of tags to associated with the child workflow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagList(Collection<String> tagList);

        /**
         * <p>
         * The list of tags to associated with the child workflow execution.
         * </p>
         * 
         * @param tagList
         *        The list of tags to associated with the child workflow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagList(String... tagList);

        /**
         * <p>
         * The IAM role to attach to the child workflow execution.
         * </p>
         * 
         * @param lambdaRole
         *        The IAM role to attach to the child workflow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaRole(String lambdaRole);
    }

    static final class BuilderImpl implements Builder {
        private String workflowId;

        private WorkflowType workflowType;

        private String control;

        private String input;

        private String executionStartToCloseTimeout;

        private TaskList taskList;

        private String taskPriority;

        private Long decisionTaskCompletedEventId;

        private String childPolicy;

        private String taskStartToCloseTimeout;

        private List<String> tagList = DefaultSdkAutoConstructList.getInstance();

        private String lambdaRole;

        private BuilderImpl() {
        }

        private BuilderImpl(StartChildWorkflowExecutionInitiatedEventAttributes model) {
            workflowId(model.workflowId);
            workflowType(model.workflowType);
            control(model.control);
            input(model.input);
            executionStartToCloseTimeout(model.executionStartToCloseTimeout);
            taskList(model.taskList);
            taskPriority(model.taskPriority);
            decisionTaskCompletedEventId(model.decisionTaskCompletedEventId);
            childPolicy(model.childPolicy);
            taskStartToCloseTimeout(model.taskStartToCloseTimeout);
            tagList(model.tagList);
            lambdaRole(model.lambdaRole);
        }

        public final String getWorkflowId() {
            return workflowId;
        }

        @Override
        public final Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public final void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        public final WorkflowType.Builder getWorkflowType() {
            return workflowType != null ? workflowType.toBuilder() : null;
        }

        @Override
        public final Builder workflowType(WorkflowType workflowType) {
            this.workflowType = workflowType;
            return this;
        }

        public final void setWorkflowType(WorkflowType.BuilderImpl workflowType) {
            this.workflowType = workflowType != null ? workflowType.build() : null;
        }

        public final String getControl() {
            return control;
        }

        @Override
        public final Builder control(String control) {
            this.control = control;
            return this;
        }

        public final void setControl(String control) {
            this.control = control;
        }

        public final String getInput() {
            return input;
        }

        @Override
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        public final String getExecutionStartToCloseTimeout() {
            return executionStartToCloseTimeout;
        }

        @Override
        public final Builder executionStartToCloseTimeout(String executionStartToCloseTimeout) {
            this.executionStartToCloseTimeout = executionStartToCloseTimeout;
            return this;
        }

        public final void setExecutionStartToCloseTimeout(String executionStartToCloseTimeout) {
            this.executionStartToCloseTimeout = executionStartToCloseTimeout;
        }

        public final TaskList.Builder getTaskList() {
            return taskList != null ? taskList.toBuilder() : null;
        }

        @Override
        public final Builder taskList(TaskList taskList) {
            this.taskList = taskList;
            return this;
        }

        public final void setTaskList(TaskList.BuilderImpl taskList) {
            this.taskList = taskList != null ? taskList.build() : null;
        }

        public final String getTaskPriority() {
            return taskPriority;
        }

        @Override
        public final Builder taskPriority(String taskPriority) {
            this.taskPriority = taskPriority;
            return this;
        }

        public final void setTaskPriority(String taskPriority) {
            this.taskPriority = taskPriority;
        }

        public final Long getDecisionTaskCompletedEventId() {
            return decisionTaskCompletedEventId;
        }

        @Override
        public final Builder decisionTaskCompletedEventId(Long decisionTaskCompletedEventId) {
            this.decisionTaskCompletedEventId = decisionTaskCompletedEventId;
            return this;
        }

        public final void setDecisionTaskCompletedEventId(Long decisionTaskCompletedEventId) {
            this.decisionTaskCompletedEventId = decisionTaskCompletedEventId;
        }

        public final String getChildPolicyAsString() {
            return childPolicy;
        }

        @Override
        public final Builder childPolicy(String childPolicy) {
            this.childPolicy = childPolicy;
            return this;
        }

        @Override
        public final Builder childPolicy(ChildPolicy childPolicy) {
            this.childPolicy(childPolicy == null ? null : childPolicy.toString());
            return this;
        }

        public final void setChildPolicy(String childPolicy) {
            this.childPolicy = childPolicy;
        }

        public final String getTaskStartToCloseTimeout() {
            return taskStartToCloseTimeout;
        }

        @Override
        public final Builder taskStartToCloseTimeout(String taskStartToCloseTimeout) {
            this.taskStartToCloseTimeout = taskStartToCloseTimeout;
            return this;
        }

        public final void setTaskStartToCloseTimeout(String taskStartToCloseTimeout) {
            this.taskStartToCloseTimeout = taskStartToCloseTimeout;
        }

        public final Collection<String> getTagList() {
            return tagList;
        }

        @Override
        public final Builder tagList(Collection<String> tagList) {
            this.tagList = TagListCopier.copy(tagList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(String... tagList) {
            tagList(Arrays.asList(tagList));
            return this;
        }

        public final void setTagList(Collection<String> tagList) {
            this.tagList = TagListCopier.copy(tagList);
        }

        public final String getLambdaRole() {
            return lambdaRole;
        }

        @Override
        public final Builder lambdaRole(String lambdaRole) {
            this.lambdaRole = lambdaRole;
            return this;
        }

        public final void setLambdaRole(String lambdaRole) {
            this.lambdaRole = lambdaRole;
        }

        @Override
        public StartChildWorkflowExecutionInitiatedEventAttributes build() {
            return new StartChildWorkflowExecutionInitiatedEventAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
