/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.swf.model.ActivityType;
import software.amazon.awssdk.services.swf.model.RegistrationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ActivityTypeInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ActivityTypeInfo> {
    private static final SdkField<ActivityType> ACTIVITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ActivityTypeInfo.getter(ActivityTypeInfo::activityType)).setter(ActivityTypeInfo.setter(Builder::activityType)).constructor(ActivityType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activityType").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ActivityTypeInfo.getter(ActivityTypeInfo::statusAsString)).setter(ActivityTypeInfo.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ActivityTypeInfo.getter(ActivityTypeInfo::description)).setter(ActivityTypeInfo.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ActivityTypeInfo.getter(ActivityTypeInfo::creationDate)).setter(ActivityTypeInfo.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()}).build();
    private static final SdkField<Instant> DEPRECATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ActivityTypeInfo.getter(ActivityTypeInfo::deprecationDate)).setter(ActivityTypeInfo.setter(Builder::deprecationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deprecationDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVITY_TYPE_FIELD, STATUS_FIELD, DESCRIPTION_FIELD, CREATION_DATE_FIELD, DEPRECATION_DATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final ActivityType activityType;
    private final String status;
    private final String description;
    private final Instant creationDate;
    private final Instant deprecationDate;

    private ActivityTypeInfo(BuilderImpl builder) {
        this.activityType = builder.activityType;
        this.status = builder.status;
        this.description = builder.description;
        this.creationDate = builder.creationDate;
        this.deprecationDate = builder.deprecationDate;
    }

    public ActivityType activityType() {
        return this.activityType;
    }

    public RegistrationStatus status() {
        return RegistrationStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String description() {
        return this.description;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public Instant deprecationDate() {
        return this.deprecationDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.activityType());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.deprecationDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActivityTypeInfo)) {
            return false;
        }
        ActivityTypeInfo other = (ActivityTypeInfo)obj;
        return Objects.equals(this.activityType(), other.activityType()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.deprecationDate(), other.deprecationDate());
    }

    public String toString() {
        return ToString.builder((String)"ActivityTypeInfo").add("ActivityType", (Object)this.activityType()).add("Status", (Object)this.statusAsString()).add("Description", (Object)this.description()).add("CreationDate", (Object)this.creationDate()).add("DeprecationDate", (Object)this.deprecationDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "activityType": {
                return Optional.ofNullable(clazz.cast(this.activityType()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "creationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "deprecationDate": {
                return Optional.ofNullable(clazz.cast(this.deprecationDate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActivityTypeInfo, T> g) {
        return obj -> g.apply((ActivityTypeInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ActivityType activityType;
        private String status;
        private String description;
        private Instant creationDate;
        private Instant deprecationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ActivityTypeInfo model) {
            this.activityType(model.activityType);
            this.status(model.status);
            this.description(model.description);
            this.creationDate(model.creationDate);
            this.deprecationDate(model.deprecationDate);
        }

        public final ActivityType.Builder getActivityType() {
            return this.activityType != null ? this.activityType.toBuilder() : null;
        }

        @Override
        public final Builder activityType(ActivityType activityType) {
            this.activityType = activityType;
            return this;
        }

        public final void setActivityType(ActivityType.BuilderImpl activityType) {
            this.activityType = activityType != null ? activityType.build() : null;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RegistrationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Instant getDeprecationDate() {
            return this.deprecationDate;
        }

        @Override
        public final Builder deprecationDate(Instant deprecationDate) {
            this.deprecationDate = deprecationDate;
            return this;
        }

        public final void setDeprecationDate(Instant deprecationDate) {
            this.deprecationDate = deprecationDate;
        }

        public ActivityTypeInfo build() {
            return new ActivityTypeInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ActivityTypeInfo> {
        public Builder activityType(ActivityType var1);

        default public Builder activityType(Consumer<ActivityType.Builder> activityType) {
            return this.activityType((ActivityType)((ActivityType.Builder)ActivityType.builder().applyMutation(activityType)).build());
        }

        public Builder status(String var1);

        public Builder status(RegistrationStatus var1);

        public Builder description(String var1);

        public Builder creationDate(Instant var1);

        public Builder deprecationDate(Instant var1);
    }
}

