/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the details of the <code>ChildWorkflowExecutionFailed</code> event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChildWorkflowExecutionFailedEventAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<ChildWorkflowExecutionFailedEventAttributes.Builder, ChildWorkflowExecutionFailedEventAttributes> {
    private static final SdkField<WorkflowExecution> WORKFLOW_EXECUTION_FIELD = SdkField
            .<WorkflowExecution> builder(MarshallingType.SDK_POJO)
            .getter(getter(ChildWorkflowExecutionFailedEventAttributes::workflowExecution))
            .setter(setter(Builder::workflowExecution)).constructor(WorkflowExecution::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowExecution").build()).build();

    private static final SdkField<WorkflowType> WORKFLOW_TYPE_FIELD = SdkField.<WorkflowType> builder(MarshallingType.SDK_POJO)
            .getter(getter(ChildWorkflowExecutionFailedEventAttributes::workflowType)).setter(setter(Builder::workflowType))
            .constructor(WorkflowType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowType").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ChildWorkflowExecutionFailedEventAttributes::reason)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()).build();

    private static final SdkField<String> DETAILS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ChildWorkflowExecutionFailedEventAttributes::details)).setter(setter(Builder::details))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("details").build()).build();

    private static final SdkField<Long> INITIATED_EVENT_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(ChildWorkflowExecutionFailedEventAttributes::initiatedEventId))
            .setter(setter(Builder::initiatedEventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initiatedEventId").build()).build();

    private static final SdkField<Long> STARTED_EVENT_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(ChildWorkflowExecutionFailedEventAttributes::startedEventId)).setter(setter(Builder::startedEventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedEventId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_EXECUTION_FIELD,
            WORKFLOW_TYPE_FIELD, REASON_FIELD, DETAILS_FIELD, INITIATED_EVENT_ID_FIELD, STARTED_EVENT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final WorkflowExecution workflowExecution;

    private final WorkflowType workflowType;

    private final String reason;

    private final String details;

    private final Long initiatedEventId;

    private final Long startedEventId;

    private ChildWorkflowExecutionFailedEventAttributes(BuilderImpl builder) {
        this.workflowExecution = builder.workflowExecution;
        this.workflowType = builder.workflowType;
        this.reason = builder.reason;
        this.details = builder.details;
        this.initiatedEventId = builder.initiatedEventId;
        this.startedEventId = builder.startedEventId;
    }

    /**
     * <p>
     * The child workflow execution that failed.
     * </p>
     * 
     * @return The child workflow execution that failed.
     */
    public WorkflowExecution workflowExecution() {
        return workflowExecution;
    }

    /**
     * <p>
     * The type of the child workflow execution.
     * </p>
     * 
     * @return The type of the child workflow execution.
     */
    public WorkflowType workflowType() {
        return workflowType;
    }

    /**
     * <p>
     * The reason for the failure (if provided).
     * </p>
     * 
     * @return The reason for the failure (if provided).
     */
    public String reason() {
        return reason;
    }

    /**
     * <p>
     * The details of the failure (if provided).
     * </p>
     * 
     * @return The details of the failure (if provided).
     */
    public String details() {
        return details;
    }

    /**
     * <p>
     * The ID of the <code>StartChildWorkflowExecutionInitiated</code> event corresponding to the
     * <code>StartChildWorkflowExecution</code> <a>Decision</a> to start this child workflow execution. This information
     * can be useful for diagnosing problems by tracing back the chain of events leading up to this event.
     * </p>
     * 
     * @return The ID of the <code>StartChildWorkflowExecutionInitiated</code> event corresponding to the
     *         <code>StartChildWorkflowExecution</code> <a>Decision</a> to start this child workflow execution. This
     *         information can be useful for diagnosing problems by tracing back the chain of events leading up to this
     *         event.
     */
    public Long initiatedEventId() {
        return initiatedEventId;
    }

    /**
     * <p>
     * The ID of the <code>ChildWorkflowExecutionStarted</code> event recorded when this child workflow execution was
     * started. This information can be useful for diagnosing problems by tracing back the chain of events leading up to
     * this event.
     * </p>
     * 
     * @return The ID of the <code>ChildWorkflowExecutionStarted</code> event recorded when this child workflow
     *         execution was started. This information can be useful for diagnosing problems by tracing back the chain
     *         of events leading up to this event.
     */
    public Long startedEventId() {
        return startedEventId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(workflowExecution());
        hashCode = 31 * hashCode + Objects.hashCode(workflowType());
        hashCode = 31 * hashCode + Objects.hashCode(reason());
        hashCode = 31 * hashCode + Objects.hashCode(details());
        hashCode = 31 * hashCode + Objects.hashCode(initiatedEventId());
        hashCode = 31 * hashCode + Objects.hashCode(startedEventId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChildWorkflowExecutionFailedEventAttributes)) {
            return false;
        }
        ChildWorkflowExecutionFailedEventAttributes other = (ChildWorkflowExecutionFailedEventAttributes) obj;
        return Objects.equals(workflowExecution(), other.workflowExecution())
                && Objects.equals(workflowType(), other.workflowType()) && Objects.equals(reason(), other.reason())
                && Objects.equals(details(), other.details()) && Objects.equals(initiatedEventId(), other.initiatedEventId())
                && Objects.equals(startedEventId(), other.startedEventId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ChildWorkflowExecutionFailedEventAttributes").add("WorkflowExecution", workflowExecution())
                .add("WorkflowType", workflowType()).add("Reason", reason()).add("Details", details())
                .add("InitiatedEventId", initiatedEventId()).add("StartedEventId", startedEventId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "workflowExecution":
            return Optional.ofNullable(clazz.cast(workflowExecution()));
        case "workflowType":
            return Optional.ofNullable(clazz.cast(workflowType()));
        case "reason":
            return Optional.ofNullable(clazz.cast(reason()));
        case "details":
            return Optional.ofNullable(clazz.cast(details()));
        case "initiatedEventId":
            return Optional.ofNullable(clazz.cast(initiatedEventId()));
        case "startedEventId":
            return Optional.ofNullable(clazz.cast(startedEventId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChildWorkflowExecutionFailedEventAttributes, T> g) {
        return obj -> g.apply((ChildWorkflowExecutionFailedEventAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChildWorkflowExecutionFailedEventAttributes> {
        /**
         * <p>
         * The child workflow execution that failed.
         * </p>
         * 
         * @param workflowExecution
         *        The child workflow execution that failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowExecution(WorkflowExecution workflowExecution);

        /**
         * <p>
         * The child workflow execution that failed.
         * </p>
         * This is a convenience that creates an instance of the {@link WorkflowExecution.Builder} avoiding the need to
         * create one manually via {@link WorkflowExecution#builder()}.
         *
         * When the {@link Consumer} completes, {@link WorkflowExecution.Builder#build()} is called immediately and its
         * result is passed to {@link #workflowExecution(WorkflowExecution)}.
         * 
         * @param workflowExecution
         *        a consumer that will call methods on {@link WorkflowExecution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workflowExecution(WorkflowExecution)
         */
        default Builder workflowExecution(Consumer<WorkflowExecution.Builder> workflowExecution) {
            return workflowExecution(WorkflowExecution.builder().applyMutation(workflowExecution).build());
        }

        /**
         * <p>
         * The type of the child workflow execution.
         * </p>
         * 
         * @param workflowType
         *        The type of the child workflow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowType(WorkflowType workflowType);

        /**
         * <p>
         * The type of the child workflow execution.
         * </p>
         * This is a convenience that creates an instance of the {@link WorkflowType.Builder} avoiding the need to
         * create one manually via {@link WorkflowType#builder()}.
         *
         * When the {@link Consumer} completes, {@link WorkflowType.Builder#build()} is called immediately and its
         * result is passed to {@link #workflowType(WorkflowType)}.
         * 
         * @param workflowType
         *        a consumer that will call methods on {@link WorkflowType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workflowType(WorkflowType)
         */
        default Builder workflowType(Consumer<WorkflowType.Builder> workflowType) {
            return workflowType(WorkflowType.builder().applyMutation(workflowType).build());
        }

        /**
         * <p>
         * The reason for the failure (if provided).
         * </p>
         * 
         * @param reason
         *        The reason for the failure (if provided).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);

        /**
         * <p>
         * The details of the failure (if provided).
         * </p>
         * 
         * @param details
         *        The details of the failure (if provided).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(String details);

        /**
         * <p>
         * The ID of the <code>StartChildWorkflowExecutionInitiated</code> event corresponding to the
         * <code>StartChildWorkflowExecution</code> <a>Decision</a> to start this child workflow execution. This
         * information can be useful for diagnosing problems by tracing back the chain of events leading up to this
         * event.
         * </p>
         * 
         * @param initiatedEventId
         *        The ID of the <code>StartChildWorkflowExecutionInitiated</code> event corresponding to the
         *        <code>StartChildWorkflowExecution</code> <a>Decision</a> to start this child workflow execution. This
         *        information can be useful for diagnosing problems by tracing back the chain of events leading up to
         *        this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initiatedEventId(Long initiatedEventId);

        /**
         * <p>
         * The ID of the <code>ChildWorkflowExecutionStarted</code> event recorded when this child workflow execution
         * was started. This information can be useful for diagnosing problems by tracing back the chain of events
         * leading up to this event.
         * </p>
         * 
         * @param startedEventId
         *        The ID of the <code>ChildWorkflowExecutionStarted</code> event recorded when this child workflow
         *        execution was started. This information can be useful for diagnosing problems by tracing back the
         *        chain of events leading up to this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedEventId(Long startedEventId);
    }

    static final class BuilderImpl implements Builder {
        private WorkflowExecution workflowExecution;

        private WorkflowType workflowType;

        private String reason;

        private String details;

        private Long initiatedEventId;

        private Long startedEventId;

        private BuilderImpl() {
        }

        private BuilderImpl(ChildWorkflowExecutionFailedEventAttributes model) {
            workflowExecution(model.workflowExecution);
            workflowType(model.workflowType);
            reason(model.reason);
            details(model.details);
            initiatedEventId(model.initiatedEventId);
            startedEventId(model.startedEventId);
        }

        public final WorkflowExecution.Builder getWorkflowExecution() {
            return workflowExecution != null ? workflowExecution.toBuilder() : null;
        }

        @Override
        public final Builder workflowExecution(WorkflowExecution workflowExecution) {
            this.workflowExecution = workflowExecution;
            return this;
        }

        public final void setWorkflowExecution(WorkflowExecution.BuilderImpl workflowExecution) {
            this.workflowExecution = workflowExecution != null ? workflowExecution.build() : null;
        }

        public final WorkflowType.Builder getWorkflowType() {
            return workflowType != null ? workflowType.toBuilder() : null;
        }

        @Override
        public final Builder workflowType(WorkflowType workflowType) {
            this.workflowType = workflowType;
            return this;
        }

        public final void setWorkflowType(WorkflowType.BuilderImpl workflowType) {
            this.workflowType = workflowType != null ? workflowType.build() : null;
        }

        public final String getReason() {
            return reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        public final String getDetails() {
            return details;
        }

        @Override
        public final Builder details(String details) {
            this.details = details;
            return this;
        }

        public final void setDetails(String details) {
            this.details = details;
        }

        public final Long getInitiatedEventId() {
            return initiatedEventId;
        }

        @Override
        public final Builder initiatedEventId(Long initiatedEventId) {
            this.initiatedEventId = initiatedEventId;
            return this;
        }

        public final void setInitiatedEventId(Long initiatedEventId) {
            this.initiatedEventId = initiatedEventId;
        }

        public final Long getStartedEventId() {
            return startedEventId;
        }

        @Override
        public final Builder startedEventId(Long startedEventId) {
            this.startedEventId = startedEventId;
            return this;
        }

        public final void setStartedEventId(Long startedEventId) {
            this.startedEventId = startedEventId;
        }

        @Override
        public ChildWorkflowExecutionFailedEventAttributes build() {
            return new ChildWorkflowExecutionFailedEventAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
