/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.swf.model.DomainInfo;
import software.amazon.awssdk.services.swf.model.DomainInfoListCopier;
import software.amazon.awssdk.services.swf.model.SwfResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDomainsResponse
extends SwfResponse
implements ToCopyableBuilder<Builder, ListDomainsResponse> {
    private static final SdkField<List<DomainInfo>> DOMAIN_INFOS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("domainInfos").getter(ListDomainsResponse.getter(ListDomainsResponse::domainInfos)).setter(ListDomainsResponse.setter(Builder::domainInfos)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainInfos").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DomainInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextPageToken").getter(ListDomainsResponse.getter(ListDomainsResponse::nextPageToken)).setter(ListDomainsResponse.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_INFOS_FIELD, NEXT_PAGE_TOKEN_FIELD));
    private final List<DomainInfo> domainInfos;
    private final String nextPageToken;

    private ListDomainsResponse(BuilderImpl builder) {
        super(builder);
        this.domainInfos = builder.domainInfos;
        this.nextPageToken = builder.nextPageToken;
    }

    public boolean hasDomainInfos() {
        return this.domainInfos != null && !(this.domainInfos instanceof SdkAutoConstructList);
    }

    public List<DomainInfo> domainInfos() {
        return this.domainInfos;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainInfos());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDomainsResponse)) {
            return false;
        }
        ListDomainsResponse other = (ListDomainsResponse)((Object)obj);
        return Objects.equals(this.domainInfos(), other.domainInfos()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public String toString() {
        return ToString.builder((String)"ListDomainsResponse").add("DomainInfos", this.domainInfos()).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainInfos": {
                return Optional.ofNullable(clazz.cast(this.domainInfos()));
            }
            case "nextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDomainsResponse, T> g) {
        return obj -> g.apply((ListDomainsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SwfResponse.BuilderImpl
    implements Builder {
        private List<DomainInfo> domainInfos = DefaultSdkAutoConstructList.getInstance();
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDomainsResponse model) {
            super(model);
            this.domainInfos(model.domainInfos);
            this.nextPageToken(model.nextPageToken);
        }

        public final Collection<DomainInfo.Builder> getDomainInfos() {
            return this.domainInfos != null ? (Collection)this.domainInfos.stream().map(DomainInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder domainInfos(Collection<DomainInfo> domainInfos) {
            this.domainInfos = DomainInfoListCopier.copy(domainInfos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainInfos(DomainInfo ... domainInfos) {
            this.domainInfos(Arrays.asList(domainInfos));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainInfos(Consumer<DomainInfo.Builder> ... domainInfos) {
            this.domainInfos(Stream.of(domainInfos).map(c -> (DomainInfo)((DomainInfo.Builder)DomainInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDomainInfos(Collection<DomainInfo.BuilderImpl> domainInfos) {
            this.domainInfos = DomainInfoListCopier.copyFromBuilder(domainInfos);
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public ListDomainsResponse build() {
            return new ListDomainsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SwfResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDomainsResponse> {
        public Builder domainInfos(Collection<DomainInfo> var1);

        public Builder domainInfos(DomainInfo ... var1);

        public Builder domainInfos(Consumer<DomainInfo.Builder> ... var1);

        public Builder nextPageToken(String var1);
    }
}

