/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.swf.model.SwfResponse;
import software.amazon.awssdk.services.swf.model.WorkflowExecutionInfo;
import software.amazon.awssdk.services.swf.model.WorkflowExecutionInfoListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListOpenWorkflowExecutionsResponse
extends SwfResponse
implements ToCopyableBuilder<Builder, ListOpenWorkflowExecutionsResponse> {
    private static final SdkField<List<WorkflowExecutionInfo>> EXECUTION_INFOS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("executionInfos").getter(ListOpenWorkflowExecutionsResponse.getter(ListOpenWorkflowExecutionsResponse::executionInfos)).setter(ListOpenWorkflowExecutionsResponse.setter(Builder::executionInfos)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionInfos").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorkflowExecutionInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextPageToken").getter(ListOpenWorkflowExecutionsResponse.getter(ListOpenWorkflowExecutionsResponse::nextPageToken)).setter(ListOpenWorkflowExecutionsResponse.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_INFOS_FIELD, NEXT_PAGE_TOKEN_FIELD));
    private final List<WorkflowExecutionInfo> executionInfos;
    private final String nextPageToken;

    private ListOpenWorkflowExecutionsResponse(BuilderImpl builder) {
        super(builder);
        this.executionInfos = builder.executionInfos;
        this.nextPageToken = builder.nextPageToken;
    }

    public boolean hasExecutionInfos() {
        return this.executionInfos != null && !(this.executionInfos instanceof SdkAutoConstructList);
    }

    public List<WorkflowExecutionInfo> executionInfos() {
        return this.executionInfos;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.executionInfos());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOpenWorkflowExecutionsResponse)) {
            return false;
        }
        ListOpenWorkflowExecutionsResponse other = (ListOpenWorkflowExecutionsResponse)((Object)obj);
        return Objects.equals(this.executionInfos(), other.executionInfos()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public String toString() {
        return ToString.builder((String)"ListOpenWorkflowExecutionsResponse").add("ExecutionInfos", this.executionInfos()).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "executionInfos": {
                return Optional.ofNullable(clazz.cast(this.executionInfos()));
            }
            case "nextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListOpenWorkflowExecutionsResponse, T> g) {
        return obj -> g.apply((ListOpenWorkflowExecutionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SwfResponse.BuilderImpl
    implements Builder {
        private List<WorkflowExecutionInfo> executionInfos = DefaultSdkAutoConstructList.getInstance();
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOpenWorkflowExecutionsResponse model) {
            super(model);
            this.executionInfos(model.executionInfos);
            this.nextPageToken(model.nextPageToken);
        }

        public final Collection<WorkflowExecutionInfo.Builder> getExecutionInfos() {
            return this.executionInfos != null ? (Collection)this.executionInfos.stream().map(WorkflowExecutionInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder executionInfos(Collection<WorkflowExecutionInfo> executionInfos) {
            this.executionInfos = WorkflowExecutionInfoListCopier.copy(executionInfos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder executionInfos(WorkflowExecutionInfo ... executionInfos) {
            this.executionInfos(Arrays.asList(executionInfos));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder executionInfos(Consumer<WorkflowExecutionInfo.Builder> ... executionInfos) {
            this.executionInfos(Stream.of(executionInfos).map(c -> (WorkflowExecutionInfo)((WorkflowExecutionInfo.Builder)WorkflowExecutionInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setExecutionInfos(Collection<WorkflowExecutionInfo.BuilderImpl> executionInfos) {
            this.executionInfos = WorkflowExecutionInfoListCopier.copyFromBuilder(executionInfos);
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public ListOpenWorkflowExecutionsResponse build() {
            return new ListOpenWorkflowExecutionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SwfResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListOpenWorkflowExecutionsResponse> {
        public Builder executionInfos(Collection<WorkflowExecutionInfo> var1);

        public Builder executionInfos(WorkflowExecutionInfo ... var1);

        public Builder executionInfos(Consumer<WorkflowExecutionInfo.Builder> ... var1);

        public Builder nextPageToken(String var1);
    }
}

