/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.swf.model.Decision;
import software.amazon.awssdk.services.swf.model.DecisionListCopier;
import software.amazon.awssdk.services.swf.model.SwfRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RespondDecisionTaskCompletedRequest
extends SwfRequest
implements ToCopyableBuilder<Builder, RespondDecisionTaskCompletedRequest> {
    private static final SdkField<String> TASK_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskToken").getter(RespondDecisionTaskCompletedRequest.getter(RespondDecisionTaskCompletedRequest::taskToken)).setter(RespondDecisionTaskCompletedRequest.setter(Builder::taskToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskToken").build()}).build();
    private static final SdkField<List<Decision>> DECISIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("decisions").getter(RespondDecisionTaskCompletedRequest.getter(RespondDecisionTaskCompletedRequest::decisions)).setter(RespondDecisionTaskCompletedRequest.setter(Builder::decisions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decisions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Decision::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> EXECUTION_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionContext").getter(RespondDecisionTaskCompletedRequest.getter(RespondDecisionTaskCompletedRequest::executionContext)).setter(RespondDecisionTaskCompletedRequest.setter(Builder::executionContext)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionContext").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_TOKEN_FIELD, DECISIONS_FIELD, EXECUTION_CONTEXT_FIELD));
    private final String taskToken;
    private final List<Decision> decisions;
    private final String executionContext;

    private RespondDecisionTaskCompletedRequest(BuilderImpl builder) {
        super(builder);
        this.taskToken = builder.taskToken;
        this.decisions = builder.decisions;
        this.executionContext = builder.executionContext;
    }

    public String taskToken() {
        return this.taskToken;
    }

    public boolean hasDecisions() {
        return this.decisions != null && !(this.decisions instanceof SdkAutoConstructList);
    }

    public List<Decision> decisions() {
        return this.decisions;
    }

    public String executionContext() {
        return this.executionContext;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.taskToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.decisions());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionContext());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RespondDecisionTaskCompletedRequest)) {
            return false;
        }
        RespondDecisionTaskCompletedRequest other = (RespondDecisionTaskCompletedRequest)((Object)obj);
        return Objects.equals(this.taskToken(), other.taskToken()) && Objects.equals(this.decisions(), other.decisions()) && Objects.equals(this.executionContext(), other.executionContext());
    }

    public String toString() {
        return ToString.builder((String)"RespondDecisionTaskCompletedRequest").add("TaskToken", (Object)this.taskToken()).add("Decisions", this.decisions()).add("ExecutionContext", (Object)this.executionContext()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "taskToken": {
                return Optional.ofNullable(clazz.cast(this.taskToken()));
            }
            case "decisions": {
                return Optional.ofNullable(clazz.cast(this.decisions()));
            }
            case "executionContext": {
                return Optional.ofNullable(clazz.cast(this.executionContext()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RespondDecisionTaskCompletedRequest, T> g) {
        return obj -> g.apply((RespondDecisionTaskCompletedRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SwfRequest.BuilderImpl
    implements Builder {
        private String taskToken;
        private List<Decision> decisions = DefaultSdkAutoConstructList.getInstance();
        private String executionContext;

        private BuilderImpl() {
        }

        private BuilderImpl(RespondDecisionTaskCompletedRequest model) {
            super(model);
            this.taskToken(model.taskToken);
            this.decisions(model.decisions);
            this.executionContext(model.executionContext);
        }

        public final String getTaskToken() {
            return this.taskToken;
        }

        @Override
        public final Builder taskToken(String taskToken) {
            this.taskToken = taskToken;
            return this;
        }

        public final void setTaskToken(String taskToken) {
            this.taskToken = taskToken;
        }

        public final Collection<Decision.Builder> getDecisions() {
            return this.decisions != null ? (Collection)this.decisions.stream().map(Decision::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder decisions(Collection<Decision> decisions) {
            this.decisions = DecisionListCopier.copy(decisions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder decisions(Decision ... decisions) {
            this.decisions(Arrays.asList(decisions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder decisions(Consumer<Decision.Builder> ... decisions) {
            this.decisions(Stream.of(decisions).map(c -> (Decision)((Decision.Builder)Decision.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDecisions(Collection<Decision.BuilderImpl> decisions) {
            this.decisions = DecisionListCopier.copyFromBuilder(decisions);
        }

        public final String getExecutionContext() {
            return this.executionContext;
        }

        @Override
        public final Builder executionContext(String executionContext) {
            this.executionContext = executionContext;
            return this;
        }

        public final void setExecutionContext(String executionContext) {
            this.executionContext = executionContext;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RespondDecisionTaskCompletedRequest build() {
            return new RespondDecisionTaskCompletedRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SwfRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RespondDecisionTaskCompletedRequest> {
        public Builder taskToken(String var1);

        public Builder decisions(Collection<Decision> var1);

        public Builder decisions(Decision ... var1);

        public Builder decisions(Consumer<Decision.Builder> ... var1);

        public Builder executionContext(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

