/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the details of the <code>DecisionTaskCompleted</code> event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DecisionTaskCompletedEventAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<DecisionTaskCompletedEventAttributes.Builder, DecisionTaskCompletedEventAttributes> {
    private static final SdkField<String> EXECUTION_CONTEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionContext").getter(getter(DecisionTaskCompletedEventAttributes::executionContext))
            .setter(setter(Builder::executionContext))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionContext").build()).build();

    private static final SdkField<Long> SCHEDULED_EVENT_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("scheduledEventId").getter(getter(DecisionTaskCompletedEventAttributes::scheduledEventId))
            .setter(setter(Builder::scheduledEventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduledEventId").build()).build();

    private static final SdkField<Long> STARTED_EVENT_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("startedEventId").getter(getter(DecisionTaskCompletedEventAttributes::startedEventId))
            .setter(setter(Builder::startedEventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedEventId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_CONTEXT_FIELD,
            SCHEDULED_EVENT_ID_FIELD, STARTED_EVENT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String executionContext;

    private final Long scheduledEventId;

    private final Long startedEventId;

    private DecisionTaskCompletedEventAttributes(BuilderImpl builder) {
        this.executionContext = builder.executionContext;
        this.scheduledEventId = builder.scheduledEventId;
        this.startedEventId = builder.startedEventId;
    }

    /**
     * <p>
     * User defined context for the workflow execution.
     * </p>
     * 
     * @return User defined context for the workflow execution.
     */
    public final String executionContext() {
        return executionContext;
    }

    /**
     * <p>
     * The ID of the <code>DecisionTaskScheduled</code> event that was recorded when this decision task was scheduled.
     * This information can be useful for diagnosing problems by tracing back the chain of events leading up to this
     * event.
     * </p>
     * 
     * @return The ID of the <code>DecisionTaskScheduled</code> event that was recorded when this decision task was
     *         scheduled. This information can be useful for diagnosing problems by tracing back the chain of events
     *         leading up to this event.
     */
    public final Long scheduledEventId() {
        return scheduledEventId;
    }

    /**
     * <p>
     * The ID of the <code>DecisionTaskStarted</code> event recorded when this decision task was started. This
     * information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.
     * </p>
     * 
     * @return The ID of the <code>DecisionTaskStarted</code> event recorded when this decision task was started. This
     *         information can be useful for diagnosing problems by tracing back the chain of events leading up to this
     *         event.
     */
    public final Long startedEventId() {
        return startedEventId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(executionContext());
        hashCode = 31 * hashCode + Objects.hashCode(scheduledEventId());
        hashCode = 31 * hashCode + Objects.hashCode(startedEventId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DecisionTaskCompletedEventAttributes)) {
            return false;
        }
        DecisionTaskCompletedEventAttributes other = (DecisionTaskCompletedEventAttributes) obj;
        return Objects.equals(executionContext(), other.executionContext())
                && Objects.equals(scheduledEventId(), other.scheduledEventId())
                && Objects.equals(startedEventId(), other.startedEventId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DecisionTaskCompletedEventAttributes").add("ExecutionContext", executionContext())
                .add("ScheduledEventId", scheduledEventId()).add("StartedEventId", startedEventId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "executionContext":
            return Optional.ofNullable(clazz.cast(executionContext()));
        case "scheduledEventId":
            return Optional.ofNullable(clazz.cast(scheduledEventId()));
        case "startedEventId":
            return Optional.ofNullable(clazz.cast(startedEventId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DecisionTaskCompletedEventAttributes, T> g) {
        return obj -> g.apply((DecisionTaskCompletedEventAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DecisionTaskCompletedEventAttributes> {
        /**
         * <p>
         * User defined context for the workflow execution.
         * </p>
         * 
         * @param executionContext
         *        User defined context for the workflow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionContext(String executionContext);

        /**
         * <p>
         * The ID of the <code>DecisionTaskScheduled</code> event that was recorded when this decision task was
         * scheduled. This information can be useful for diagnosing problems by tracing back the chain of events leading
         * up to this event.
         * </p>
         * 
         * @param scheduledEventId
         *        The ID of the <code>DecisionTaskScheduled</code> event that was recorded when this decision task was
         *        scheduled. This information can be useful for diagnosing problems by tracing back the chain of events
         *        leading up to this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledEventId(Long scheduledEventId);

        /**
         * <p>
         * The ID of the <code>DecisionTaskStarted</code> event recorded when this decision task was started. This
         * information can be useful for diagnosing problems by tracing back the chain of events leading up to this
         * event.
         * </p>
         * 
         * @param startedEventId
         *        The ID of the <code>DecisionTaskStarted</code> event recorded when this decision task was started.
         *        This information can be useful for diagnosing problems by tracing back the chain of events leading up
         *        to this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedEventId(Long startedEventId);
    }

    static final class BuilderImpl implements Builder {
        private String executionContext;

        private Long scheduledEventId;

        private Long startedEventId;

        private BuilderImpl() {
        }

        private BuilderImpl(DecisionTaskCompletedEventAttributes model) {
            executionContext(model.executionContext);
            scheduledEventId(model.scheduledEventId);
            startedEventId(model.startedEventId);
        }

        public final String getExecutionContext() {
            return executionContext;
        }

        @Override
        public final Builder executionContext(String executionContext) {
            this.executionContext = executionContext;
            return this;
        }

        public final void setExecutionContext(String executionContext) {
            this.executionContext = executionContext;
        }

        public final Long getScheduledEventId() {
            return scheduledEventId;
        }

        @Override
        public final Builder scheduledEventId(Long scheduledEventId) {
            this.scheduledEventId = scheduledEventId;
            return this;
        }

        public final void setScheduledEventId(Long scheduledEventId) {
            this.scheduledEventId = scheduledEventId;
        }

        public final Long getStartedEventId() {
            return startedEventId;
        }

        @Override
        public final Builder startedEventId(Long startedEventId) {
            this.startedEventId = startedEventId;
            return this;
        }

        public final void setStartedEventId(Long startedEventId) {
            this.startedEventId = startedEventId;
        }

        @Override
        public DecisionTaskCompletedEventAttributes build() {
            return new DecisionTaskCompletedEventAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
