/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

@Generated("software.amazon.awssdk:codegen")
public enum EventType {
    WORKFLOW_EXECUTION_STARTED("WorkflowExecutionStarted"),

    WORKFLOW_EXECUTION_CANCEL_REQUESTED("WorkflowExecutionCancelRequested"),

    WORKFLOW_EXECUTION_COMPLETED("WorkflowExecutionCompleted"),

    COMPLETE_WORKFLOW_EXECUTION_FAILED("CompleteWorkflowExecutionFailed"),

    WORKFLOW_EXECUTION_FAILED("WorkflowExecutionFailed"),

    FAIL_WORKFLOW_EXECUTION_FAILED("FailWorkflowExecutionFailed"),

    WORKFLOW_EXECUTION_TIMED_OUT("WorkflowExecutionTimedOut"),

    WORKFLOW_EXECUTION_CANCELED("WorkflowExecutionCanceled"),

    CANCEL_WORKFLOW_EXECUTION_FAILED("CancelWorkflowExecutionFailed"),

    WORKFLOW_EXECUTION_CONTINUED_AS_NEW("WorkflowExecutionContinuedAsNew"),

    CONTINUE_AS_NEW_WORKFLOW_EXECUTION_FAILED("ContinueAsNewWorkflowExecutionFailed"),

    WORKFLOW_EXECUTION_TERMINATED("WorkflowExecutionTerminated"),

    DECISION_TASK_SCHEDULED("DecisionTaskScheduled"),

    DECISION_TASK_STARTED("DecisionTaskStarted"),

    DECISION_TASK_COMPLETED("DecisionTaskCompleted"),

    DECISION_TASK_TIMED_OUT("DecisionTaskTimedOut"),

    ACTIVITY_TASK_SCHEDULED("ActivityTaskScheduled"),

    SCHEDULE_ACTIVITY_TASK_FAILED("ScheduleActivityTaskFailed"),

    ACTIVITY_TASK_STARTED("ActivityTaskStarted"),

    ACTIVITY_TASK_COMPLETED("ActivityTaskCompleted"),

    ACTIVITY_TASK_FAILED("ActivityTaskFailed"),

    ACTIVITY_TASK_TIMED_OUT("ActivityTaskTimedOut"),

    ACTIVITY_TASK_CANCELED("ActivityTaskCanceled"),

    ACTIVITY_TASK_CANCEL_REQUESTED("ActivityTaskCancelRequested"),

    REQUEST_CANCEL_ACTIVITY_TASK_FAILED("RequestCancelActivityTaskFailed"),

    WORKFLOW_EXECUTION_SIGNALED("WorkflowExecutionSignaled"),

    MARKER_RECORDED("MarkerRecorded"),

    RECORD_MARKER_FAILED("RecordMarkerFailed"),

    TIMER_STARTED("TimerStarted"),

    START_TIMER_FAILED("StartTimerFailed"),

    TIMER_FIRED("TimerFired"),

    TIMER_CANCELED("TimerCanceled"),

    CANCEL_TIMER_FAILED("CancelTimerFailed"),

    START_CHILD_WORKFLOW_EXECUTION_INITIATED("StartChildWorkflowExecutionInitiated"),

    START_CHILD_WORKFLOW_EXECUTION_FAILED("StartChildWorkflowExecutionFailed"),

    CHILD_WORKFLOW_EXECUTION_STARTED("ChildWorkflowExecutionStarted"),

    CHILD_WORKFLOW_EXECUTION_COMPLETED("ChildWorkflowExecutionCompleted"),

    CHILD_WORKFLOW_EXECUTION_FAILED("ChildWorkflowExecutionFailed"),

    CHILD_WORKFLOW_EXECUTION_TIMED_OUT("ChildWorkflowExecutionTimedOut"),

    CHILD_WORKFLOW_EXECUTION_CANCELED("ChildWorkflowExecutionCanceled"),

    CHILD_WORKFLOW_EXECUTION_TERMINATED("ChildWorkflowExecutionTerminated"),

    SIGNAL_EXTERNAL_WORKFLOW_EXECUTION_INITIATED("SignalExternalWorkflowExecutionInitiated"),

    SIGNAL_EXTERNAL_WORKFLOW_EXECUTION_FAILED("SignalExternalWorkflowExecutionFailed"),

    EXTERNAL_WORKFLOW_EXECUTION_SIGNALED("ExternalWorkflowExecutionSignaled"),

    REQUEST_CANCEL_EXTERNAL_WORKFLOW_EXECUTION_INITIATED("RequestCancelExternalWorkflowExecutionInitiated"),

    REQUEST_CANCEL_EXTERNAL_WORKFLOW_EXECUTION_FAILED("RequestCancelExternalWorkflowExecutionFailed"),

    EXTERNAL_WORKFLOW_EXECUTION_CANCEL_REQUESTED("ExternalWorkflowExecutionCancelRequested"),

    LAMBDA_FUNCTION_SCHEDULED("LambdaFunctionScheduled"),

    LAMBDA_FUNCTION_STARTED("LambdaFunctionStarted"),

    LAMBDA_FUNCTION_COMPLETED("LambdaFunctionCompleted"),

    LAMBDA_FUNCTION_FAILED("LambdaFunctionFailed"),

    LAMBDA_FUNCTION_TIMED_OUT("LambdaFunctionTimedOut"),

    SCHEDULE_LAMBDA_FUNCTION_FAILED("ScheduleLambdaFunctionFailed"),

    START_LAMBDA_FUNCTION_FAILED("StartLambdaFunctionFailed"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private EventType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return EventType corresponding to the value
     */
    public static EventType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(EventType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link EventType}s
     */
    public static Set<EventType> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}
