/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.swf.model.ChildPolicy;
import software.amazon.awssdk.services.swf.model.SwfRequest;
import software.amazon.awssdk.services.swf.model.TaskList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterWorkflowTypeRequest
extends SwfRequest
implements ToCopyableBuilder<Builder, RegisterWorkflowTypeRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domain").getter(RegisterWorkflowTypeRequest.getter(RegisterWorkflowTypeRequest::domain)).setter(RegisterWorkflowTypeRequest.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domain").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(RegisterWorkflowTypeRequest.getter(RegisterWorkflowTypeRequest::name)).setter(RegisterWorkflowTypeRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(RegisterWorkflowTypeRequest.getter(RegisterWorkflowTypeRequest::version)).setter(RegisterWorkflowTypeRequest.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(RegisterWorkflowTypeRequest.getter(RegisterWorkflowTypeRequest::description)).setter(RegisterWorkflowTypeRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DEFAULT_TASK_START_TO_CLOSE_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("defaultTaskStartToCloseTimeout").getter(RegisterWorkflowTypeRequest.getter(RegisterWorkflowTypeRequest::defaultTaskStartToCloseTimeout)).setter(RegisterWorkflowTypeRequest.setter(Builder::defaultTaskStartToCloseTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultTaskStartToCloseTimeout").build()}).build();
    private static final SdkField<String> DEFAULT_EXECUTION_START_TO_CLOSE_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("defaultExecutionStartToCloseTimeout").getter(RegisterWorkflowTypeRequest.getter(RegisterWorkflowTypeRequest::defaultExecutionStartToCloseTimeout)).setter(RegisterWorkflowTypeRequest.setter(Builder::defaultExecutionStartToCloseTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultExecutionStartToCloseTimeout").build()}).build();
    private static final SdkField<TaskList> DEFAULT_TASK_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("defaultTaskList").getter(RegisterWorkflowTypeRequest.getter(RegisterWorkflowTypeRequest::defaultTaskList)).setter(RegisterWorkflowTypeRequest.setter(Builder::defaultTaskList)).constructor(TaskList::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultTaskList").build()}).build();
    private static final SdkField<String> DEFAULT_TASK_PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("defaultTaskPriority").getter(RegisterWorkflowTypeRequest.getter(RegisterWorkflowTypeRequest::defaultTaskPriority)).setter(RegisterWorkflowTypeRequest.setter(Builder::defaultTaskPriority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultTaskPriority").build()}).build();
    private static final SdkField<String> DEFAULT_CHILD_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("defaultChildPolicy").getter(RegisterWorkflowTypeRequest.getter(RegisterWorkflowTypeRequest::defaultChildPolicyAsString)).setter(RegisterWorkflowTypeRequest.setter(Builder::defaultChildPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultChildPolicy").build()}).build();
    private static final SdkField<String> DEFAULT_LAMBDA_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("defaultLambdaRole").getter(RegisterWorkflowTypeRequest.getter(RegisterWorkflowTypeRequest::defaultLambdaRole)).setter(RegisterWorkflowTypeRequest.setter(Builder::defaultLambdaRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultLambdaRole").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD, NAME_FIELD, VERSION_FIELD, DESCRIPTION_FIELD, DEFAULT_TASK_START_TO_CLOSE_TIMEOUT_FIELD, DEFAULT_EXECUTION_START_TO_CLOSE_TIMEOUT_FIELD, DEFAULT_TASK_LIST_FIELD, DEFAULT_TASK_PRIORITY_FIELD, DEFAULT_CHILD_POLICY_FIELD, DEFAULT_LAMBDA_ROLE_FIELD));
    private final String domain;
    private final String name;
    private final String version;
    private final String description;
    private final String defaultTaskStartToCloseTimeout;
    private final String defaultExecutionStartToCloseTimeout;
    private final TaskList defaultTaskList;
    private final String defaultTaskPriority;
    private final String defaultChildPolicy;
    private final String defaultLambdaRole;

    private RegisterWorkflowTypeRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.name = builder.name;
        this.version = builder.version;
        this.description = builder.description;
        this.defaultTaskStartToCloseTimeout = builder.defaultTaskStartToCloseTimeout;
        this.defaultExecutionStartToCloseTimeout = builder.defaultExecutionStartToCloseTimeout;
        this.defaultTaskList = builder.defaultTaskList;
        this.defaultTaskPriority = builder.defaultTaskPriority;
        this.defaultChildPolicy = builder.defaultChildPolicy;
        this.defaultLambdaRole = builder.defaultLambdaRole;
    }

    public final String domain() {
        return this.domain;
    }

    public final String name() {
        return this.name;
    }

    public final String version() {
        return this.version;
    }

    public final String description() {
        return this.description;
    }

    public final String defaultTaskStartToCloseTimeout() {
        return this.defaultTaskStartToCloseTimeout;
    }

    public final String defaultExecutionStartToCloseTimeout() {
        return this.defaultExecutionStartToCloseTimeout;
    }

    public final TaskList defaultTaskList() {
        return this.defaultTaskList;
    }

    public final String defaultTaskPriority() {
        return this.defaultTaskPriority;
    }

    public final ChildPolicy defaultChildPolicy() {
        return ChildPolicy.fromValue(this.defaultChildPolicy);
    }

    public final String defaultChildPolicyAsString() {
        return this.defaultChildPolicy;
    }

    public final String defaultLambdaRole() {
        return this.defaultLambdaRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultTaskStartToCloseTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultExecutionStartToCloseTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultTaskList());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultTaskPriority());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultChildPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultLambdaRole());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterWorkflowTypeRequest)) {
            return false;
        }
        RegisterWorkflowTypeRequest other = (RegisterWorkflowTypeRequest)((Object)obj);
        return Objects.equals(this.domain(), other.domain()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.defaultTaskStartToCloseTimeout(), other.defaultTaskStartToCloseTimeout()) && Objects.equals(this.defaultExecutionStartToCloseTimeout(), other.defaultExecutionStartToCloseTimeout()) && Objects.equals(this.defaultTaskList(), other.defaultTaskList()) && Objects.equals(this.defaultTaskPriority(), other.defaultTaskPriority()) && Objects.equals(this.defaultChildPolicyAsString(), other.defaultChildPolicyAsString()) && Objects.equals(this.defaultLambdaRole(), other.defaultLambdaRole());
    }

    public final String toString() {
        return ToString.builder((String)"RegisterWorkflowTypeRequest").add("Domain", (Object)this.domain()).add("Name", (Object)this.name()).add("Version", (Object)this.version()).add("Description", (Object)this.description()).add("DefaultTaskStartToCloseTimeout", (Object)this.defaultTaskStartToCloseTimeout()).add("DefaultExecutionStartToCloseTimeout", (Object)this.defaultExecutionStartToCloseTimeout()).add("DefaultTaskList", (Object)this.defaultTaskList()).add("DefaultTaskPriority", (Object)this.defaultTaskPriority()).add("DefaultChildPolicy", (Object)this.defaultChildPolicyAsString()).add("DefaultLambdaRole", (Object)this.defaultLambdaRole()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "defaultTaskStartToCloseTimeout": {
                return Optional.ofNullable(clazz.cast(this.defaultTaskStartToCloseTimeout()));
            }
            case "defaultExecutionStartToCloseTimeout": {
                return Optional.ofNullable(clazz.cast(this.defaultExecutionStartToCloseTimeout()));
            }
            case "defaultTaskList": {
                return Optional.ofNullable(clazz.cast(this.defaultTaskList()));
            }
            case "defaultTaskPriority": {
                return Optional.ofNullable(clazz.cast(this.defaultTaskPriority()));
            }
            case "defaultChildPolicy": {
                return Optional.ofNullable(clazz.cast(this.defaultChildPolicyAsString()));
            }
            case "defaultLambdaRole": {
                return Optional.ofNullable(clazz.cast(this.defaultLambdaRole()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterWorkflowTypeRequest, T> g) {
        return obj -> g.apply((RegisterWorkflowTypeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SwfRequest.BuilderImpl
    implements Builder {
        private String domain;
        private String name;
        private String version;
        private String description;
        private String defaultTaskStartToCloseTimeout;
        private String defaultExecutionStartToCloseTimeout;
        private TaskList defaultTaskList;
        private String defaultTaskPriority;
        private String defaultChildPolicy;
        private String defaultLambdaRole;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterWorkflowTypeRequest model) {
            super(model);
            this.domain(model.domain);
            this.name(model.name);
            this.version(model.version);
            this.description(model.description);
            this.defaultTaskStartToCloseTimeout(model.defaultTaskStartToCloseTimeout);
            this.defaultExecutionStartToCloseTimeout(model.defaultExecutionStartToCloseTimeout);
            this.defaultTaskList(model.defaultTaskList);
            this.defaultTaskPriority(model.defaultTaskPriority);
            this.defaultChildPolicy(model.defaultChildPolicy);
            this.defaultLambdaRole(model.defaultLambdaRole);
        }

        public final String getDomain() {
            return this.domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDefaultTaskStartToCloseTimeout() {
            return this.defaultTaskStartToCloseTimeout;
        }

        @Override
        public final Builder defaultTaskStartToCloseTimeout(String defaultTaskStartToCloseTimeout) {
            this.defaultTaskStartToCloseTimeout = defaultTaskStartToCloseTimeout;
            return this;
        }

        public final void setDefaultTaskStartToCloseTimeout(String defaultTaskStartToCloseTimeout) {
            this.defaultTaskStartToCloseTimeout = defaultTaskStartToCloseTimeout;
        }

        public final String getDefaultExecutionStartToCloseTimeout() {
            return this.defaultExecutionStartToCloseTimeout;
        }

        @Override
        public final Builder defaultExecutionStartToCloseTimeout(String defaultExecutionStartToCloseTimeout) {
            this.defaultExecutionStartToCloseTimeout = defaultExecutionStartToCloseTimeout;
            return this;
        }

        public final void setDefaultExecutionStartToCloseTimeout(String defaultExecutionStartToCloseTimeout) {
            this.defaultExecutionStartToCloseTimeout = defaultExecutionStartToCloseTimeout;
        }

        public final TaskList.Builder getDefaultTaskList() {
            return this.defaultTaskList != null ? this.defaultTaskList.toBuilder() : null;
        }

        @Override
        public final Builder defaultTaskList(TaskList defaultTaskList) {
            this.defaultTaskList = defaultTaskList;
            return this;
        }

        public final void setDefaultTaskList(TaskList.BuilderImpl defaultTaskList) {
            this.defaultTaskList = defaultTaskList != null ? defaultTaskList.build() : null;
        }

        public final String getDefaultTaskPriority() {
            return this.defaultTaskPriority;
        }

        @Override
        public final Builder defaultTaskPriority(String defaultTaskPriority) {
            this.defaultTaskPriority = defaultTaskPriority;
            return this;
        }

        public final void setDefaultTaskPriority(String defaultTaskPriority) {
            this.defaultTaskPriority = defaultTaskPriority;
        }

        public final String getDefaultChildPolicy() {
            return this.defaultChildPolicy;
        }

        @Override
        public final Builder defaultChildPolicy(String defaultChildPolicy) {
            this.defaultChildPolicy = defaultChildPolicy;
            return this;
        }

        @Override
        public final Builder defaultChildPolicy(ChildPolicy defaultChildPolicy) {
            this.defaultChildPolicy(defaultChildPolicy == null ? null : defaultChildPolicy.toString());
            return this;
        }

        public final void setDefaultChildPolicy(String defaultChildPolicy) {
            this.defaultChildPolicy = defaultChildPolicy;
        }

        public final String getDefaultLambdaRole() {
            return this.defaultLambdaRole;
        }

        @Override
        public final Builder defaultLambdaRole(String defaultLambdaRole) {
            this.defaultLambdaRole = defaultLambdaRole;
            return this;
        }

        public final void setDefaultLambdaRole(String defaultLambdaRole) {
            this.defaultLambdaRole = defaultLambdaRole;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterWorkflowTypeRequest build() {
            return new RegisterWorkflowTypeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SwfRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RegisterWorkflowTypeRequest> {
        public Builder domain(String var1);

        public Builder name(String var1);

        public Builder version(String var1);

        public Builder description(String var1);

        public Builder defaultTaskStartToCloseTimeout(String var1);

        public Builder defaultExecutionStartToCloseTimeout(String var1);

        public Builder defaultTaskList(TaskList var1);

        default public Builder defaultTaskList(Consumer<TaskList.Builder> defaultTaskList) {
            return this.defaultTaskList((TaskList)((TaskList.Builder)TaskList.builder().applyMutation(defaultTaskList)).build());
        }

        public Builder defaultTaskPriority(String var1);

        public Builder defaultChildPolicy(String var1);

        public Builder defaultChildPolicy(ChildPolicy var1);

        public Builder defaultLambdaRole(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

