/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CountClosedWorkflowExecutionsRequest extends SwfRequest implements
        ToCopyableBuilder<CountClosedWorkflowExecutionsRequest.Builder, CountClosedWorkflowExecutionsRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("domain")
            .getter(getter(CountClosedWorkflowExecutionsRequest::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domain").build()).build();

    private static final SdkField<ExecutionTimeFilter> START_TIME_FILTER_FIELD = SdkField
            .<ExecutionTimeFilter> builder(MarshallingType.SDK_POJO).memberName("startTimeFilter")
            .getter(getter(CountClosedWorkflowExecutionsRequest::startTimeFilter)).setter(setter(Builder::startTimeFilter))
            .constructor(ExecutionTimeFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTimeFilter").build()).build();

    private static final SdkField<ExecutionTimeFilter> CLOSE_TIME_FILTER_FIELD = SdkField
            .<ExecutionTimeFilter> builder(MarshallingType.SDK_POJO).memberName("closeTimeFilter")
            .getter(getter(CountClosedWorkflowExecutionsRequest::closeTimeFilter)).setter(setter(Builder::closeTimeFilter))
            .constructor(ExecutionTimeFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("closeTimeFilter").build()).build();

    private static final SdkField<WorkflowExecutionFilter> EXECUTION_FILTER_FIELD = SdkField
            .<WorkflowExecutionFilter> builder(MarshallingType.SDK_POJO).memberName("executionFilter")
            .getter(getter(CountClosedWorkflowExecutionsRequest::executionFilter)).setter(setter(Builder::executionFilter))
            .constructor(WorkflowExecutionFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionFilter").build()).build();

    private static final SdkField<WorkflowTypeFilter> TYPE_FILTER_FIELD = SdkField
            .<WorkflowTypeFilter> builder(MarshallingType.SDK_POJO).memberName("typeFilter")
            .getter(getter(CountClosedWorkflowExecutionsRequest::typeFilter)).setter(setter(Builder::typeFilter))
            .constructor(WorkflowTypeFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeFilter").build()).build();

    private static final SdkField<TagFilter> TAG_FILTER_FIELD = SdkField.<TagFilter> builder(MarshallingType.SDK_POJO)
            .memberName("tagFilter").getter(getter(CountClosedWorkflowExecutionsRequest::tagFilter))
            .setter(setter(Builder::tagFilter)).constructor(TagFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagFilter").build()).build();

    private static final SdkField<CloseStatusFilter> CLOSE_STATUS_FILTER_FIELD = SdkField
            .<CloseStatusFilter> builder(MarshallingType.SDK_POJO).memberName("closeStatusFilter")
            .getter(getter(CountClosedWorkflowExecutionsRequest::closeStatusFilter)).setter(setter(Builder::closeStatusFilter))
            .constructor(CloseStatusFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("closeStatusFilter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD,
            START_TIME_FILTER_FIELD, CLOSE_TIME_FILTER_FIELD, EXECUTION_FILTER_FIELD, TYPE_FILTER_FIELD, TAG_FILTER_FIELD,
            CLOSE_STATUS_FILTER_FIELD));

    private final String domain;

    private final ExecutionTimeFilter startTimeFilter;

    private final ExecutionTimeFilter closeTimeFilter;

    private final WorkflowExecutionFilter executionFilter;

    private final WorkflowTypeFilter typeFilter;

    private final TagFilter tagFilter;

    private final CloseStatusFilter closeStatusFilter;

    private CountClosedWorkflowExecutionsRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.startTimeFilter = builder.startTimeFilter;
        this.closeTimeFilter = builder.closeTimeFilter;
        this.executionFilter = builder.executionFilter;
        this.typeFilter = builder.typeFilter;
        this.tagFilter = builder.tagFilter;
        this.closeStatusFilter = builder.closeStatusFilter;
    }

    /**
     * <p>
     * The name of the domain containing the workflow executions to count.
     * </p>
     * 
     * @return The name of the domain containing the workflow executions to count.
     */
    public final String domain() {
        return domain;
    }

    /**
     * <p>
     * If specified, only workflow executions that meet the start time criteria of the filter are counted.
     * </p>
     * <note>
     * <p>
     * <code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You must specify one of
     * these in a request but not both.
     * </p>
     * </note>
     * 
     * @return If specified, only workflow executions that meet the start time criteria of the filter are counted.</p>
     *         <note>
     *         <p>
     *         <code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You must specify
     *         one of these in a request but not both.
     *         </p>
     */
    public final ExecutionTimeFilter startTimeFilter() {
        return startTimeFilter;
    }

    /**
     * <p>
     * If specified, only workflow executions that meet the close time criteria of the filter are counted.
     * </p>
     * <note>
     * <p>
     * <code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You must specify one of
     * these in a request but not both.
     * </p>
     * </note>
     * 
     * @return If specified, only workflow executions that meet the close time criteria of the filter are counted.</p>
     *         <note>
     *         <p>
     *         <code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You must specify
     *         one of these in a request but not both.
     *         </p>
     */
    public final ExecutionTimeFilter closeTimeFilter() {
        return closeTimeFilter;
    }

    /**
     * <p>
     * If specified, only workflow executions matching the <code>WorkflowId</code> in the filter are counted.
     * </p>
     * <note>
     * <p>
     * <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code>
     * are mutually exclusive. You can specify at most one of these in a request.
     * </p>
     * </note>
     * 
     * @return If specified, only workflow executions matching the <code>WorkflowId</code> in the filter are
     *         counted.</p> <note>
     *         <p>
     *         <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
     *         <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.
     *         </p>
     */
    public final WorkflowExecutionFilter executionFilter() {
        return executionFilter;
    }

    /**
     * <p>
     * If specified, indicates the type of the workflow executions to be counted.
     * </p>
     * <note>
     * <p>
     * <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code>
     * are mutually exclusive. You can specify at most one of these in a request.
     * </p>
     * </note>
     * 
     * @return If specified, indicates the type of the workflow executions to be counted.</p> <note>
     *         <p>
     *         <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
     *         <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.
     *         </p>
     */
    public final WorkflowTypeFilter typeFilter() {
        return typeFilter;
    }

    /**
     * <p>
     * If specified, only executions that have a tag that matches the filter are counted.
     * </p>
     * <note>
     * <p>
     * <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code>
     * are mutually exclusive. You can specify at most one of these in a request.
     * </p>
     * </note>
     * 
     * @return If specified, only executions that have a tag that matches the filter are counted.</p> <note>
     *         <p>
     *         <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
     *         <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.
     *         </p>
     */
    public final TagFilter tagFilter() {
        return tagFilter;
    }

    /**
     * <p>
     * If specified, only workflow executions that match this close status are counted. This filter has an affect only
     * if <code>executionStatus</code> is specified as <code>CLOSED</code>.
     * </p>
     * <note>
     * <p>
     * <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code>
     * are mutually exclusive. You can specify at most one of these in a request.
     * </p>
     * </note>
     * 
     * @return If specified, only workflow executions that match this close status are counted. This filter has an
     *         affect only if <code>executionStatus</code> is specified as <code>CLOSED</code>.</p> <note>
     *         <p>
     *         <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
     *         <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.
     *         </p>
     */
    public final CloseStatusFilter closeStatusFilter() {
        return closeStatusFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(startTimeFilter());
        hashCode = 31 * hashCode + Objects.hashCode(closeTimeFilter());
        hashCode = 31 * hashCode + Objects.hashCode(executionFilter());
        hashCode = 31 * hashCode + Objects.hashCode(typeFilter());
        hashCode = 31 * hashCode + Objects.hashCode(tagFilter());
        hashCode = 31 * hashCode + Objects.hashCode(closeStatusFilter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CountClosedWorkflowExecutionsRequest)) {
            return false;
        }
        CountClosedWorkflowExecutionsRequest other = (CountClosedWorkflowExecutionsRequest) obj;
        return Objects.equals(domain(), other.domain()) && Objects.equals(startTimeFilter(), other.startTimeFilter())
                && Objects.equals(closeTimeFilter(), other.closeTimeFilter())
                && Objects.equals(executionFilter(), other.executionFilter()) && Objects.equals(typeFilter(), other.typeFilter())
                && Objects.equals(tagFilter(), other.tagFilter())
                && Objects.equals(closeStatusFilter(), other.closeStatusFilter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CountClosedWorkflowExecutionsRequest").add("Domain", domain())
                .add("StartTimeFilter", startTimeFilter()).add("CloseTimeFilter", closeTimeFilter())
                .add("ExecutionFilter", executionFilter()).add("TypeFilter", typeFilter()).add("TagFilter", tagFilter())
                .add("CloseStatusFilter", closeStatusFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "startTimeFilter":
            return Optional.ofNullable(clazz.cast(startTimeFilter()));
        case "closeTimeFilter":
            return Optional.ofNullable(clazz.cast(closeTimeFilter()));
        case "executionFilter":
            return Optional.ofNullable(clazz.cast(executionFilter()));
        case "typeFilter":
            return Optional.ofNullable(clazz.cast(typeFilter()));
        case "tagFilter":
            return Optional.ofNullable(clazz.cast(tagFilter()));
        case "closeStatusFilter":
            return Optional.ofNullable(clazz.cast(closeStatusFilter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CountClosedWorkflowExecutionsRequest, T> g) {
        return obj -> g.apply((CountClosedWorkflowExecutionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SwfRequest.Builder, SdkPojo, CopyableBuilder<Builder, CountClosedWorkflowExecutionsRequest> {
        /**
         * <p>
         * The name of the domain containing the workflow executions to count.
         * </p>
         * 
         * @param domain
         *        The name of the domain containing the workflow executions to count.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * If specified, only workflow executions that meet the start time criteria of the filter are counted.
         * </p>
         * <note>
         * <p>
         * <code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You must specify one of
         * these in a request but not both.
         * </p>
         * </note>
         * 
         * @param startTimeFilter
         *        If specified, only workflow executions that meet the start time criteria of the filter are
         *        counted.</p> <note>
         *        <p>
         *        <code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You must specify
         *        one of these in a request but not both.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimeFilter(ExecutionTimeFilter startTimeFilter);

        /**
         * <p>
         * If specified, only workflow executions that meet the start time criteria of the filter are counted.
         * </p>
         * <note>
         * <p>
         * <code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You must specify one of
         * these in a request but not both.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link ExecutionTimeFilter.Builder} avoiding
         * the need to create one manually via {@link ExecutionTimeFilter#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExecutionTimeFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #startTimeFilter(ExecutionTimeFilter)}.
         * 
         * @param startTimeFilter
         *        a consumer that will call methods on {@link ExecutionTimeFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #startTimeFilter(ExecutionTimeFilter)
         */
        default Builder startTimeFilter(Consumer<ExecutionTimeFilter.Builder> startTimeFilter) {
            return startTimeFilter(ExecutionTimeFilter.builder().applyMutation(startTimeFilter).build());
        }

        /**
         * <p>
         * If specified, only workflow executions that meet the close time criteria of the filter are counted.
         * </p>
         * <note>
         * <p>
         * <code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You must specify one of
         * these in a request but not both.
         * </p>
         * </note>
         * 
         * @param closeTimeFilter
         *        If specified, only workflow executions that meet the close time criteria of the filter are
         *        counted.</p> <note>
         *        <p>
         *        <code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You must specify
         *        one of these in a request but not both.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder closeTimeFilter(ExecutionTimeFilter closeTimeFilter);

        /**
         * <p>
         * If specified, only workflow executions that meet the close time criteria of the filter are counted.
         * </p>
         * <note>
         * <p>
         * <code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You must specify one of
         * these in a request but not both.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link ExecutionTimeFilter.Builder} avoiding
         * the need to create one manually via {@link ExecutionTimeFilter#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExecutionTimeFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #closeTimeFilter(ExecutionTimeFilter)}.
         * 
         * @param closeTimeFilter
         *        a consumer that will call methods on {@link ExecutionTimeFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #closeTimeFilter(ExecutionTimeFilter)
         */
        default Builder closeTimeFilter(Consumer<ExecutionTimeFilter.Builder> closeTimeFilter) {
            return closeTimeFilter(ExecutionTimeFilter.builder().applyMutation(closeTimeFilter).build());
        }

        /**
         * <p>
         * If specified, only workflow executions matching the <code>WorkflowId</code> in the filter are counted.
         * </p>
         * <note>
         * <p>
         * <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
         * <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.
         * </p>
         * </note>
         * 
         * @param executionFilter
         *        If specified, only workflow executions matching the <code>WorkflowId</code> in the filter are
         *        counted.</p> <note>
         *        <p>
         *        <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
         *        <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionFilter(WorkflowExecutionFilter executionFilter);

        /**
         * <p>
         * If specified, only workflow executions matching the <code>WorkflowId</code> in the filter are counted.
         * </p>
         * <note>
         * <p>
         * <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
         * <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link WorkflowExecutionFilter.Builder}
         * avoiding the need to create one manually via {@link WorkflowExecutionFilter#builder()}.
         *
         * When the {@link Consumer} completes, {@link WorkflowExecutionFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #executionFilter(WorkflowExecutionFilter)}.
         * 
         * @param executionFilter
         *        a consumer that will call methods on {@link WorkflowExecutionFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executionFilter(WorkflowExecutionFilter)
         */
        default Builder executionFilter(Consumer<WorkflowExecutionFilter.Builder> executionFilter) {
            return executionFilter(WorkflowExecutionFilter.builder().applyMutation(executionFilter).build());
        }

        /**
         * <p>
         * If specified, indicates the type of the workflow executions to be counted.
         * </p>
         * <note>
         * <p>
         * <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
         * <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.
         * </p>
         * </note>
         * 
         * @param typeFilter
         *        If specified, indicates the type of the workflow executions to be counted.</p> <note>
         *        <p>
         *        <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
         *        <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeFilter(WorkflowTypeFilter typeFilter);

        /**
         * <p>
         * If specified, indicates the type of the workflow executions to be counted.
         * </p>
         * <note>
         * <p>
         * <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
         * <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link WorkflowTypeFilter.Builder} avoiding the
         * need to create one manually via {@link WorkflowTypeFilter#builder()}.
         *
         * When the {@link Consumer} completes, {@link WorkflowTypeFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #typeFilter(WorkflowTypeFilter)}.
         * 
         * @param typeFilter
         *        a consumer that will call methods on {@link WorkflowTypeFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #typeFilter(WorkflowTypeFilter)
         */
        default Builder typeFilter(Consumer<WorkflowTypeFilter.Builder> typeFilter) {
            return typeFilter(WorkflowTypeFilter.builder().applyMutation(typeFilter).build());
        }

        /**
         * <p>
         * If specified, only executions that have a tag that matches the filter are counted.
         * </p>
         * <note>
         * <p>
         * <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
         * <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.
         * </p>
         * </note>
         * 
         * @param tagFilter
         *        If specified, only executions that have a tag that matches the filter are counted.</p> <note>
         *        <p>
         *        <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
         *        <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagFilter(TagFilter tagFilter);

        /**
         * <p>
         * If specified, only executions that have a tag that matches the filter are counted.
         * </p>
         * <note>
         * <p>
         * <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
         * <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link TagFilter.Builder} avoiding the need to
         * create one manually via {@link TagFilter#builder()}.
         *
         * When the {@link Consumer} completes, {@link TagFilter.Builder#build()} is called immediately and its result
         * is passed to {@link #tagFilter(TagFilter)}.
         * 
         * @param tagFilter
         *        a consumer that will call methods on {@link TagFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagFilter(TagFilter)
         */
        default Builder tagFilter(Consumer<TagFilter.Builder> tagFilter) {
            return tagFilter(TagFilter.builder().applyMutation(tagFilter).build());
        }

        /**
         * <p>
         * If specified, only workflow executions that match this close status are counted. This filter has an affect
         * only if <code>executionStatus</code> is specified as <code>CLOSED</code>.
         * </p>
         * <note>
         * <p>
         * <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
         * <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.
         * </p>
         * </note>
         * 
         * @param closeStatusFilter
         *        If specified, only workflow executions that match this close status are counted. This filter has an
         *        affect only if <code>executionStatus</code> is specified as <code>CLOSED</code>.</p> <note>
         *        <p>
         *        <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
         *        <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder closeStatusFilter(CloseStatusFilter closeStatusFilter);

        /**
         * <p>
         * If specified, only workflow executions that match this close status are counted. This filter has an affect
         * only if <code>executionStatus</code> is specified as <code>CLOSED</code>.
         * </p>
         * <note>
         * <p>
         * <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
         * <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link CloseStatusFilter.Builder} avoiding the
         * need to create one manually via {@link CloseStatusFilter#builder()}.
         *
         * When the {@link Consumer} completes, {@link CloseStatusFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #closeStatusFilter(CloseStatusFilter)}.
         * 
         * @param closeStatusFilter
         *        a consumer that will call methods on {@link CloseStatusFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #closeStatusFilter(CloseStatusFilter)
         */
        default Builder closeStatusFilter(Consumer<CloseStatusFilter.Builder> closeStatusFilter) {
            return closeStatusFilter(CloseStatusFilter.builder().applyMutation(closeStatusFilter).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SwfRequest.BuilderImpl implements Builder {
        private String domain;

        private ExecutionTimeFilter startTimeFilter;

        private ExecutionTimeFilter closeTimeFilter;

        private WorkflowExecutionFilter executionFilter;

        private WorkflowTypeFilter typeFilter;

        private TagFilter tagFilter;

        private CloseStatusFilter closeStatusFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(CountClosedWorkflowExecutionsRequest model) {
            super(model);
            domain(model.domain);
            startTimeFilter(model.startTimeFilter);
            closeTimeFilter(model.closeTimeFilter);
            executionFilter(model.executionFilter);
            typeFilter(model.typeFilter);
            tagFilter(model.tagFilter);
            closeStatusFilter(model.closeStatusFilter);
        }

        public final String getDomain() {
            return domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        @Transient
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final ExecutionTimeFilter.Builder getStartTimeFilter() {
            return startTimeFilter != null ? startTimeFilter.toBuilder() : null;
        }

        public final void setStartTimeFilter(ExecutionTimeFilter.BuilderImpl startTimeFilter) {
            this.startTimeFilter = startTimeFilter != null ? startTimeFilter.build() : null;
        }

        @Override
        @Transient
        public final Builder startTimeFilter(ExecutionTimeFilter startTimeFilter) {
            this.startTimeFilter = startTimeFilter;
            return this;
        }

        public final ExecutionTimeFilter.Builder getCloseTimeFilter() {
            return closeTimeFilter != null ? closeTimeFilter.toBuilder() : null;
        }

        public final void setCloseTimeFilter(ExecutionTimeFilter.BuilderImpl closeTimeFilter) {
            this.closeTimeFilter = closeTimeFilter != null ? closeTimeFilter.build() : null;
        }

        @Override
        @Transient
        public final Builder closeTimeFilter(ExecutionTimeFilter closeTimeFilter) {
            this.closeTimeFilter = closeTimeFilter;
            return this;
        }

        public final WorkflowExecutionFilter.Builder getExecutionFilter() {
            return executionFilter != null ? executionFilter.toBuilder() : null;
        }

        public final void setExecutionFilter(WorkflowExecutionFilter.BuilderImpl executionFilter) {
            this.executionFilter = executionFilter != null ? executionFilter.build() : null;
        }

        @Override
        @Transient
        public final Builder executionFilter(WorkflowExecutionFilter executionFilter) {
            this.executionFilter = executionFilter;
            return this;
        }

        public final WorkflowTypeFilter.Builder getTypeFilter() {
            return typeFilter != null ? typeFilter.toBuilder() : null;
        }

        public final void setTypeFilter(WorkflowTypeFilter.BuilderImpl typeFilter) {
            this.typeFilter = typeFilter != null ? typeFilter.build() : null;
        }

        @Override
        @Transient
        public final Builder typeFilter(WorkflowTypeFilter typeFilter) {
            this.typeFilter = typeFilter;
            return this;
        }

        public final TagFilter.Builder getTagFilter() {
            return tagFilter != null ? tagFilter.toBuilder() : null;
        }

        public final void setTagFilter(TagFilter.BuilderImpl tagFilter) {
            this.tagFilter = tagFilter != null ? tagFilter.build() : null;
        }

        @Override
        @Transient
        public final Builder tagFilter(TagFilter tagFilter) {
            this.tagFilter = tagFilter;
            return this;
        }

        public final CloseStatusFilter.Builder getCloseStatusFilter() {
            return closeStatusFilter != null ? closeStatusFilter.toBuilder() : null;
        }

        public final void setCloseStatusFilter(CloseStatusFilter.BuilderImpl closeStatusFilter) {
            this.closeStatusFilter = closeStatusFilter != null ? closeStatusFilter.build() : null;
        }

        @Override
        @Transient
        public final Builder closeStatusFilter(CloseStatusFilter closeStatusFilter) {
            this.closeStatusFilter = closeStatusFilter;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CountClosedWorkflowExecutionsRequest build() {
            return new CountClosedWorkflowExecutionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
