/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the details of the <code>WorkflowExecutionSignaled</code> event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkflowExecutionSignaledEventAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<WorkflowExecutionSignaledEventAttributes.Builder, WorkflowExecutionSignaledEventAttributes> {
    private static final SdkField<String> SIGNAL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("signalName").getter(getter(WorkflowExecutionSignaledEventAttributes::signalName))
            .setter(setter(Builder::signalName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signalName").build()).build();

    private static final SdkField<String> INPUT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("input")
            .getter(getter(WorkflowExecutionSignaledEventAttributes::input)).setter(setter(Builder::input))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()).build();

    private static final SdkField<WorkflowExecution> EXTERNAL_WORKFLOW_EXECUTION_FIELD = SdkField
            .<WorkflowExecution> builder(MarshallingType.SDK_POJO).memberName("externalWorkflowExecution")
            .getter(getter(WorkflowExecutionSignaledEventAttributes::externalWorkflowExecution))
            .setter(setter(Builder::externalWorkflowExecution)).constructor(WorkflowExecution::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalWorkflowExecution").build())
            .build();

    private static final SdkField<Long> EXTERNAL_INITIATED_EVENT_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("externalInitiatedEventId")
            .getter(getter(WorkflowExecutionSignaledEventAttributes::externalInitiatedEventId))
            .setter(setter(Builder::externalInitiatedEventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalInitiatedEventId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIGNAL_NAME_FIELD,
            INPUT_FIELD, EXTERNAL_WORKFLOW_EXECUTION_FIELD, EXTERNAL_INITIATED_EVENT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String signalName;

    private final String input;

    private final WorkflowExecution externalWorkflowExecution;

    private final Long externalInitiatedEventId;

    private WorkflowExecutionSignaledEventAttributes(BuilderImpl builder) {
        this.signalName = builder.signalName;
        this.input = builder.input;
        this.externalWorkflowExecution = builder.externalWorkflowExecution;
        this.externalInitiatedEventId = builder.externalInitiatedEventId;
    }

    /**
     * <p>
     * The name of the signal received. The decider can use the signal name and inputs to determine how to the process
     * the signal.
     * </p>
     * 
     * @return The name of the signal received. The decider can use the signal name and inputs to determine how to the
     *         process the signal.
     */
    public final String signalName() {
        return signalName;
    }

    /**
     * <p>
     * The inputs provided with the signal. The decider can use the signal name and inputs to determine how to process
     * the signal.
     * </p>
     * 
     * @return The inputs provided with the signal. The decider can use the signal name and inputs to determine how to
     *         process the signal.
     */
    public final String input() {
        return input;
    }

    /**
     * <p>
     * The workflow execution that sent the signal. This is set only of the signal was sent by another workflow
     * execution.
     * </p>
     * 
     * @return The workflow execution that sent the signal. This is set only of the signal was sent by another workflow
     *         execution.
     */
    public final WorkflowExecution externalWorkflowExecution() {
        return externalWorkflowExecution;
    }

    /**
     * <p>
     * The ID of the <code>SignalExternalWorkflowExecutionInitiated</code> event corresponding to the
     * <code>SignalExternalWorkflow</code> decision to signal this workflow execution.The source event with this ID can
     * be found in the history of the source workflow execution. This information can be useful for diagnosing problems
     * by tracing back the chain of events leading up to this event. This field is set only if the signal was initiated
     * by another workflow execution.
     * </p>
     * 
     * @return The ID of the <code>SignalExternalWorkflowExecutionInitiated</code> event corresponding to the
     *         <code>SignalExternalWorkflow</code> decision to signal this workflow execution.The source event with this
     *         ID can be found in the history of the source workflow execution. This information can be useful for
     *         diagnosing problems by tracing back the chain of events leading up to this event. This field is set only
     *         if the signal was initiated by another workflow execution.
     */
    public final Long externalInitiatedEventId() {
        return externalInitiatedEventId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(signalName());
        hashCode = 31 * hashCode + Objects.hashCode(input());
        hashCode = 31 * hashCode + Objects.hashCode(externalWorkflowExecution());
        hashCode = 31 * hashCode + Objects.hashCode(externalInitiatedEventId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowExecutionSignaledEventAttributes)) {
            return false;
        }
        WorkflowExecutionSignaledEventAttributes other = (WorkflowExecutionSignaledEventAttributes) obj;
        return Objects.equals(signalName(), other.signalName()) && Objects.equals(input(), other.input())
                && Objects.equals(externalWorkflowExecution(), other.externalWorkflowExecution())
                && Objects.equals(externalInitiatedEventId(), other.externalInitiatedEventId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkflowExecutionSignaledEventAttributes").add("SignalName", signalName()).add("Input", input())
                .add("ExternalWorkflowExecution", externalWorkflowExecution())
                .add("ExternalInitiatedEventId", externalInitiatedEventId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "signalName":
            return Optional.ofNullable(clazz.cast(signalName()));
        case "input":
            return Optional.ofNullable(clazz.cast(input()));
        case "externalWorkflowExecution":
            return Optional.ofNullable(clazz.cast(externalWorkflowExecution()));
        case "externalInitiatedEventId":
            return Optional.ofNullable(clazz.cast(externalInitiatedEventId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkflowExecutionSignaledEventAttributes, T> g) {
        return obj -> g.apply((WorkflowExecutionSignaledEventAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkflowExecutionSignaledEventAttributes> {
        /**
         * <p>
         * The name of the signal received. The decider can use the signal name and inputs to determine how to the
         * process the signal.
         * </p>
         * 
         * @param signalName
         *        The name of the signal received. The decider can use the signal name and inputs to determine how to
         *        the process the signal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signalName(String signalName);

        /**
         * <p>
         * The inputs provided with the signal. The decider can use the signal name and inputs to determine how to
         * process the signal.
         * </p>
         * 
         * @param input
         *        The inputs provided with the signal. The decider can use the signal name and inputs to determine how
         *        to process the signal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(String input);

        /**
         * <p>
         * The workflow execution that sent the signal. This is set only of the signal was sent by another workflow
         * execution.
         * </p>
         * 
         * @param externalWorkflowExecution
         *        The workflow execution that sent the signal. This is set only of the signal was sent by another
         *        workflow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalWorkflowExecution(WorkflowExecution externalWorkflowExecution);

        /**
         * <p>
         * The workflow execution that sent the signal. This is set only of the signal was sent by another workflow
         * execution.
         * </p>
         * This is a convenience that creates an instance of the {@link WorkflowExecution.Builder} avoiding the need to
         * create one manually via {@link WorkflowExecution#builder()}.
         *
         * When the {@link Consumer} completes, {@link WorkflowExecution.Builder#build()} is called immediately and its
         * result is passed to {@link #externalWorkflowExecution(WorkflowExecution)}.
         * 
         * @param externalWorkflowExecution
         *        a consumer that will call methods on {@link WorkflowExecution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #externalWorkflowExecution(WorkflowExecution)
         */
        default Builder externalWorkflowExecution(Consumer<WorkflowExecution.Builder> externalWorkflowExecution) {
            return externalWorkflowExecution(WorkflowExecution.builder().applyMutation(externalWorkflowExecution).build());
        }

        /**
         * <p>
         * The ID of the <code>SignalExternalWorkflowExecutionInitiated</code> event corresponding to the
         * <code>SignalExternalWorkflow</code> decision to signal this workflow execution.The source event with this ID
         * can be found in the history of the source workflow execution. This information can be useful for diagnosing
         * problems by tracing back the chain of events leading up to this event. This field is set only if the signal
         * was initiated by another workflow execution.
         * </p>
         * 
         * @param externalInitiatedEventId
         *        The ID of the <code>SignalExternalWorkflowExecutionInitiated</code> event corresponding to the
         *        <code>SignalExternalWorkflow</code> decision to signal this workflow execution.The source event with
         *        this ID can be found in the history of the source workflow execution. This information can be useful
         *        for diagnosing problems by tracing back the chain of events leading up to this event. This field is
         *        set only if the signal was initiated by another workflow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalInitiatedEventId(Long externalInitiatedEventId);
    }

    static final class BuilderImpl implements Builder {
        private String signalName;

        private String input;

        private WorkflowExecution externalWorkflowExecution;

        private Long externalInitiatedEventId;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowExecutionSignaledEventAttributes model) {
            signalName(model.signalName);
            input(model.input);
            externalWorkflowExecution(model.externalWorkflowExecution);
            externalInitiatedEventId(model.externalInitiatedEventId);
        }

        public final String getSignalName() {
            return signalName;
        }

        public final void setSignalName(String signalName) {
            this.signalName = signalName;
        }

        @Override
        @Transient
        public final Builder signalName(String signalName) {
            this.signalName = signalName;
            return this;
        }

        public final String getInput() {
            return input;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        @Override
        @Transient
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        public final WorkflowExecution.Builder getExternalWorkflowExecution() {
            return externalWorkflowExecution != null ? externalWorkflowExecution.toBuilder() : null;
        }

        public final void setExternalWorkflowExecution(WorkflowExecution.BuilderImpl externalWorkflowExecution) {
            this.externalWorkflowExecution = externalWorkflowExecution != null ? externalWorkflowExecution.build() : null;
        }

        @Override
        @Transient
        public final Builder externalWorkflowExecution(WorkflowExecution externalWorkflowExecution) {
            this.externalWorkflowExecution = externalWorkflowExecution;
            return this;
        }

        public final Long getExternalInitiatedEventId() {
            return externalInitiatedEventId;
        }

        public final void setExternalInitiatedEventId(Long externalInitiatedEventId) {
            this.externalInitiatedEventId = externalInitiatedEventId;
        }

        @Override
        @Transient
        public final Builder externalInitiatedEventId(Long externalInitiatedEventId) {
            this.externalInitiatedEventId = externalInitiatedEventId;
            return this;
        }

        @Override
        public WorkflowExecutionSignaledEventAttributes build() {
            return new WorkflowExecutionSignaledEventAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
