/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.swf.model.ExecutionTimeFilter;
import software.amazon.awssdk.services.swf.model.SwfRequest;
import software.amazon.awssdk.services.swf.model.TagFilter;
import software.amazon.awssdk.services.swf.model.WorkflowExecutionFilter;
import software.amazon.awssdk.services.swf.model.WorkflowTypeFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListOpenWorkflowExecutionsRequest
extends SwfRequest
implements ToCopyableBuilder<Builder, ListOpenWorkflowExecutionsRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domain").getter(ListOpenWorkflowExecutionsRequest.getter(ListOpenWorkflowExecutionsRequest::domain)).setter(ListOpenWorkflowExecutionsRequest.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domain").build()}).build();
    private static final SdkField<ExecutionTimeFilter> START_TIME_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("startTimeFilter").getter(ListOpenWorkflowExecutionsRequest.getter(ListOpenWorkflowExecutionsRequest::startTimeFilter)).setter(ListOpenWorkflowExecutionsRequest.setter(Builder::startTimeFilter)).constructor(ExecutionTimeFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTimeFilter").build()}).build();
    private static final SdkField<WorkflowTypeFilter> TYPE_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("typeFilter").getter(ListOpenWorkflowExecutionsRequest.getter(ListOpenWorkflowExecutionsRequest::typeFilter)).setter(ListOpenWorkflowExecutionsRequest.setter(Builder::typeFilter)).constructor(WorkflowTypeFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeFilter").build()}).build();
    private static final SdkField<TagFilter> TAG_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("tagFilter").getter(ListOpenWorkflowExecutionsRequest.getter(ListOpenWorkflowExecutionsRequest::tagFilter)).setter(ListOpenWorkflowExecutionsRequest.setter(Builder::tagFilter)).constructor(TagFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagFilter").build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextPageToken").getter(ListOpenWorkflowExecutionsRequest.getter(ListOpenWorkflowExecutionsRequest::nextPageToken)).setter(ListOpenWorkflowExecutionsRequest.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageToken").build()}).build();
    private static final SdkField<Integer> MAXIMUM_PAGE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maximumPageSize").getter(ListOpenWorkflowExecutionsRequest.getter(ListOpenWorkflowExecutionsRequest::maximumPageSize)).setter(ListOpenWorkflowExecutionsRequest.setter(Builder::maximumPageSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumPageSize").build()}).build();
    private static final SdkField<Boolean> REVERSE_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("reverseOrder").getter(ListOpenWorkflowExecutionsRequest.getter(ListOpenWorkflowExecutionsRequest::reverseOrder)).setter(ListOpenWorkflowExecutionsRequest.setter(Builder::reverseOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reverseOrder").build()}).build();
    private static final SdkField<WorkflowExecutionFilter> EXECUTION_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("executionFilter").getter(ListOpenWorkflowExecutionsRequest.getter(ListOpenWorkflowExecutionsRequest::executionFilter)).setter(ListOpenWorkflowExecutionsRequest.setter(Builder::executionFilter)).constructor(WorkflowExecutionFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionFilter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD, START_TIME_FILTER_FIELD, TYPE_FILTER_FIELD, TAG_FILTER_FIELD, NEXT_PAGE_TOKEN_FIELD, MAXIMUM_PAGE_SIZE_FIELD, REVERSE_ORDER_FIELD, EXECUTION_FILTER_FIELD));
    private final String domain;
    private final ExecutionTimeFilter startTimeFilter;
    private final WorkflowTypeFilter typeFilter;
    private final TagFilter tagFilter;
    private final String nextPageToken;
    private final Integer maximumPageSize;
    private final Boolean reverseOrder;
    private final WorkflowExecutionFilter executionFilter;

    private ListOpenWorkflowExecutionsRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.startTimeFilter = builder.startTimeFilter;
        this.typeFilter = builder.typeFilter;
        this.tagFilter = builder.tagFilter;
        this.nextPageToken = builder.nextPageToken;
        this.maximumPageSize = builder.maximumPageSize;
        this.reverseOrder = builder.reverseOrder;
        this.executionFilter = builder.executionFilter;
    }

    public final String domain() {
        return this.domain;
    }

    public final ExecutionTimeFilter startTimeFilter() {
        return this.startTimeFilter;
    }

    public final WorkflowTypeFilter typeFilter() {
        return this.typeFilter;
    }

    public final TagFilter tagFilter() {
        return this.tagFilter;
    }

    public final String nextPageToken() {
        return this.nextPageToken;
    }

    public final Integer maximumPageSize() {
        return this.maximumPageSize;
    }

    public final Boolean reverseOrder() {
        return this.reverseOrder;
    }

    public final WorkflowExecutionFilter executionFilter() {
        return this.executionFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTimeFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumPageSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.reverseOrder());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionFilter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOpenWorkflowExecutionsRequest)) {
            return false;
        }
        ListOpenWorkflowExecutionsRequest other = (ListOpenWorkflowExecutionsRequest)((Object)obj);
        return Objects.equals(this.domain(), other.domain()) && Objects.equals(this.startTimeFilter(), other.startTimeFilter()) && Objects.equals(this.typeFilter(), other.typeFilter()) && Objects.equals(this.tagFilter(), other.tagFilter()) && Objects.equals(this.nextPageToken(), other.nextPageToken()) && Objects.equals(this.maximumPageSize(), other.maximumPageSize()) && Objects.equals(this.reverseOrder(), other.reverseOrder()) && Objects.equals(this.executionFilter(), other.executionFilter());
    }

    public final String toString() {
        return ToString.builder((String)"ListOpenWorkflowExecutionsRequest").add("Domain", (Object)this.domain()).add("StartTimeFilter", (Object)this.startTimeFilter()).add("TypeFilter", (Object)this.typeFilter()).add("TagFilter", (Object)this.tagFilter()).add("NextPageToken", (Object)this.nextPageToken()).add("MaximumPageSize", (Object)this.maximumPageSize()).add("ReverseOrder", (Object)this.reverseOrder()).add("ExecutionFilter", (Object)this.executionFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "startTimeFilter": {
                return Optional.ofNullable(clazz.cast(this.startTimeFilter()));
            }
            case "typeFilter": {
                return Optional.ofNullable(clazz.cast(this.typeFilter()));
            }
            case "tagFilter": {
                return Optional.ofNullable(clazz.cast(this.tagFilter()));
            }
            case "nextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
            case "maximumPageSize": {
                return Optional.ofNullable(clazz.cast(this.maximumPageSize()));
            }
            case "reverseOrder": {
                return Optional.ofNullable(clazz.cast(this.reverseOrder()));
            }
            case "executionFilter": {
                return Optional.ofNullable(clazz.cast(this.executionFilter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListOpenWorkflowExecutionsRequest, T> g) {
        return obj -> g.apply((ListOpenWorkflowExecutionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SwfRequest.BuilderImpl
    implements Builder {
        private String domain;
        private ExecutionTimeFilter startTimeFilter;
        private WorkflowTypeFilter typeFilter;
        private TagFilter tagFilter;
        private String nextPageToken;
        private Integer maximumPageSize;
        private Boolean reverseOrder;
        private WorkflowExecutionFilter executionFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOpenWorkflowExecutionsRequest model) {
            super(model);
            this.domain(model.domain);
            this.startTimeFilter(model.startTimeFilter);
            this.typeFilter(model.typeFilter);
            this.tagFilter(model.tagFilter);
            this.nextPageToken(model.nextPageToken);
            this.maximumPageSize(model.maximumPageSize);
            this.reverseOrder(model.reverseOrder);
            this.executionFilter(model.executionFilter);
        }

        public final String getDomain() {
            return this.domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        @Transient
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final ExecutionTimeFilter.Builder getStartTimeFilter() {
            return this.startTimeFilter != null ? this.startTimeFilter.toBuilder() : null;
        }

        public final void setStartTimeFilter(ExecutionTimeFilter.BuilderImpl startTimeFilter) {
            this.startTimeFilter = startTimeFilter != null ? startTimeFilter.build() : null;
        }

        @Override
        @Transient
        public final Builder startTimeFilter(ExecutionTimeFilter startTimeFilter) {
            this.startTimeFilter = startTimeFilter;
            return this;
        }

        public final WorkflowTypeFilter.Builder getTypeFilter() {
            return this.typeFilter != null ? this.typeFilter.toBuilder() : null;
        }

        public final void setTypeFilter(WorkflowTypeFilter.BuilderImpl typeFilter) {
            this.typeFilter = typeFilter != null ? typeFilter.build() : null;
        }

        @Override
        @Transient
        public final Builder typeFilter(WorkflowTypeFilter typeFilter) {
            this.typeFilter = typeFilter;
            return this;
        }

        public final TagFilter.Builder getTagFilter() {
            return this.tagFilter != null ? this.tagFilter.toBuilder() : null;
        }

        public final void setTagFilter(TagFilter.BuilderImpl tagFilter) {
            this.tagFilter = tagFilter != null ? tagFilter.build() : null;
        }

        @Override
        @Transient
        public final Builder tagFilter(TagFilter tagFilter) {
            this.tagFilter = tagFilter;
            return this;
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        @Transient
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final Integer getMaximumPageSize() {
            return this.maximumPageSize;
        }

        public final void setMaximumPageSize(Integer maximumPageSize) {
            this.maximumPageSize = maximumPageSize;
        }

        @Override
        @Transient
        public final Builder maximumPageSize(Integer maximumPageSize) {
            this.maximumPageSize = maximumPageSize;
            return this;
        }

        public final Boolean getReverseOrder() {
            return this.reverseOrder;
        }

        public final void setReverseOrder(Boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
        }

        @Override
        @Transient
        public final Builder reverseOrder(Boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
            return this;
        }

        public final WorkflowExecutionFilter.Builder getExecutionFilter() {
            return this.executionFilter != null ? this.executionFilter.toBuilder() : null;
        }

        public final void setExecutionFilter(WorkflowExecutionFilter.BuilderImpl executionFilter) {
            this.executionFilter = executionFilter != null ? executionFilter.build() : null;
        }

        @Override
        @Transient
        public final Builder executionFilter(WorkflowExecutionFilter executionFilter) {
            this.executionFilter = executionFilter;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListOpenWorkflowExecutionsRequest build() {
            return new ListOpenWorkflowExecutionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SwfRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListOpenWorkflowExecutionsRequest> {
        public Builder domain(String var1);

        public Builder startTimeFilter(ExecutionTimeFilter var1);

        default public Builder startTimeFilter(Consumer<ExecutionTimeFilter.Builder> startTimeFilter) {
            return this.startTimeFilter((ExecutionTimeFilter)((ExecutionTimeFilter.Builder)ExecutionTimeFilter.builder().applyMutation(startTimeFilter)).build());
        }

        public Builder typeFilter(WorkflowTypeFilter var1);

        default public Builder typeFilter(Consumer<WorkflowTypeFilter.Builder> typeFilter) {
            return this.typeFilter((WorkflowTypeFilter)((WorkflowTypeFilter.Builder)WorkflowTypeFilter.builder().applyMutation(typeFilter)).build());
        }

        public Builder tagFilter(TagFilter var1);

        default public Builder tagFilter(Consumer<TagFilter.Builder> tagFilter) {
            return this.tagFilter((TagFilter)((TagFilter.Builder)TagFilter.builder().applyMutation(tagFilter)).build());
        }

        public Builder nextPageToken(String var1);

        public Builder maximumPageSize(Integer var1);

        public Builder reverseOrder(Boolean var1);

        public Builder executionFilter(WorkflowExecutionFilter var1);

        default public Builder executionFilter(Consumer<WorkflowExecutionFilter.Builder> executionFilter) {
            return this.executionFilter((WorkflowExecutionFilter)((WorkflowExecutionFilter.Builder)WorkflowExecutionFilter.builder().applyMutation(executionFilter)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

