/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the details of the <code>ScheduleActivityTask</code> decision.
 * </p>
 * <p>
 * <b>Access Control</b>
 * </p>
 * <p>
 * You can use IAM policies to control this decision's access to Amazon SWF resources as follows:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
 * </p>
 * </li>
 * <li>
 * <p>
 * Use an <code>Action</code> element to allow or deny permission to call this action.
 * </p>
 * </li>
 * <li>
 * <p>
 * Constrain the following parameters by using a <code>Condition</code> element with the appropriate keys.
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>activityType.name</code> – String constraint. The key is <code>swf:activityType.name</code>.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>activityType.version</code> – String constraint. The key is <code>swf:activityType.version</code>.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>taskList</code> – String constraint. The key is <code>swf:taskList.name</code>.
 * </p>
 * </li>
 * </ul>
 * </li>
 * </ul>
 * <p>
 * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
 * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
 * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
 * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
 * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScheduleActivityTaskDecisionAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<ScheduleActivityTaskDecisionAttributes.Builder, ScheduleActivityTaskDecisionAttributes> {
    private static final SdkField<ActivityType> ACTIVITY_TYPE_FIELD = SdkField.<ActivityType> builder(MarshallingType.SDK_POJO)
            .memberName("activityType").getter(getter(ScheduleActivityTaskDecisionAttributes::activityType))
            .setter(setter(Builder::activityType)).constructor(ActivityType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activityType").build()).build();

    private static final SdkField<String> ACTIVITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("activityId").getter(getter(ScheduleActivityTaskDecisionAttributes::activityId))
            .setter(setter(Builder::activityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activityId").build()).build();

    private static final SdkField<String> CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("control")
            .getter(getter(ScheduleActivityTaskDecisionAttributes::control)).setter(setter(Builder::control))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("control").build()).build();

    private static final SdkField<String> INPUT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("input")
            .getter(getter(ScheduleActivityTaskDecisionAttributes::input)).setter(setter(Builder::input))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()).build();

    private static final SdkField<String> SCHEDULE_TO_CLOSE_TIMEOUT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scheduleToCloseTimeout").getter(getter(ScheduleActivityTaskDecisionAttributes::scheduleToCloseTimeout))
            .setter(setter(Builder::scheduleToCloseTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduleToCloseTimeout").build())
            .build();

    private static final SdkField<TaskList> TASK_LIST_FIELD = SdkField.<TaskList> builder(MarshallingType.SDK_POJO)
            .memberName("taskList").getter(getter(ScheduleActivityTaskDecisionAttributes::taskList))
            .setter(setter(Builder::taskList)).constructor(TaskList::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskList").build()).build();

    private static final SdkField<String> TASK_PRIORITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("taskPriority").getter(getter(ScheduleActivityTaskDecisionAttributes::taskPriority))
            .setter(setter(Builder::taskPriority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskPriority").build()).build();

    private static final SdkField<String> SCHEDULE_TO_START_TIMEOUT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scheduleToStartTimeout").getter(getter(ScheduleActivityTaskDecisionAttributes::scheduleToStartTimeout))
            .setter(setter(Builder::scheduleToStartTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduleToStartTimeout").build())
            .build();

    private static final SdkField<String> START_TO_CLOSE_TIMEOUT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("startToCloseTimeout").getter(getter(ScheduleActivityTaskDecisionAttributes::startToCloseTimeout))
            .setter(setter(Builder::startToCloseTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startToCloseTimeout").build())
            .build();

    private static final SdkField<String> HEARTBEAT_TIMEOUT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("heartbeatTimeout").getter(getter(ScheduleActivityTaskDecisionAttributes::heartbeatTimeout))
            .setter(setter(Builder::heartbeatTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("heartbeatTimeout").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVITY_TYPE_FIELD,
            ACTIVITY_ID_FIELD, CONTROL_FIELD, INPUT_FIELD, SCHEDULE_TO_CLOSE_TIMEOUT_FIELD, TASK_LIST_FIELD, TASK_PRIORITY_FIELD,
            SCHEDULE_TO_START_TIMEOUT_FIELD, START_TO_CLOSE_TIMEOUT_FIELD, HEARTBEAT_TIMEOUT_FIELD));

    private static final long serialVersionUID = 1L;

    private final ActivityType activityType;

    private final String activityId;

    private final String control;

    private final String input;

    private final String scheduleToCloseTimeout;

    private final TaskList taskList;

    private final String taskPriority;

    private final String scheduleToStartTimeout;

    private final String startToCloseTimeout;

    private final String heartbeatTimeout;

    private ScheduleActivityTaskDecisionAttributes(BuilderImpl builder) {
        this.activityType = builder.activityType;
        this.activityId = builder.activityId;
        this.control = builder.control;
        this.input = builder.input;
        this.scheduleToCloseTimeout = builder.scheduleToCloseTimeout;
        this.taskList = builder.taskList;
        this.taskPriority = builder.taskPriority;
        this.scheduleToStartTimeout = builder.scheduleToStartTimeout;
        this.startToCloseTimeout = builder.startToCloseTimeout;
        this.heartbeatTimeout = builder.heartbeatTimeout;
    }

    /**
     * <p>
     * The type of the activity task to schedule.
     * </p>
     * 
     * @return The type of the activity task to schedule.
     */
    public final ActivityType activityType() {
        return activityType;
    }

    /**
     * <p>
     * The <code>activityId</code> of the activity task.
     * </p>
     * <p>
     * The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
     * <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code> |
     * <code>\u007f-\u009f</code>). Also, it must not contain the literal string <code>arn</code>.
     * </p>
     * 
     * @return The <code>activityId</code> of the activity task.</p>
     *         <p>
     *         The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
     *         <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (
     *         <code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not contain the literal string
     *         <code>arn</code>.
     */
    public final String activityId() {
        return activityId;
    }

    /**
     * <p>
     * Data attached to the event that can be used by the decider in subsequent workflow tasks. This data isn't sent to
     * the activity.
     * </p>
     * 
     * @return Data attached to the event that can be used by the decider in subsequent workflow tasks. This data isn't
     *         sent to the activity.
     */
    public final String control() {
        return control;
    }

    /**
     * <p>
     * The input provided to the activity task.
     * </p>
     * 
     * @return The input provided to the activity task.
     */
    public final String input() {
        return input;
    }

    /**
     * <p>
     * The maximum duration for this activity task.
     * </p>
     * <p>
     * The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
     * <code>NONE</code> to specify unlimited duration.
     * </p>
     * <note>
     * <p>
     * A schedule-to-close timeout for this activity task must be specified either as a default for the activity type or
     * through this field. If neither this field is set nor a default schedule-to-close timeout was specified at
     * registration time then a fault is returned.
     * </p>
     * </note>
     * 
     * @return The maximum duration for this activity task.</p>
     *         <p>
     *         The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
     *         <code>NONE</code> to specify unlimited duration.
     *         </p>
     *         <note>
     *         <p>
     *         A schedule-to-close timeout for this activity task must be specified either as a default for the activity
     *         type or through this field. If neither this field is set nor a default schedule-to-close timeout was
     *         specified at registration time then a fault is returned.
     *         </p>
     */
    public final String scheduleToCloseTimeout() {
        return scheduleToCloseTimeout;
    }

    /**
     * <p>
     * If set, specifies the name of the task list in which to schedule the activity task. If not specified, the
     * <code>defaultTaskList</code> registered with the activity type is used.
     * </p>
     * <note>
     * <p>
     * A task list for this activity task must be specified either as a default for the activity type or through this
     * field. If neither this field is set nor a default task list was specified at registration time then a fault is
     * returned.
     * </p>
     * </note>
     * <p>
     * The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
     * <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code> |
     * <code>\u007f-\u009f</code>). Also, it must not contain the literal string <code>arn</code>.
     * </p>
     * 
     * @return If set, specifies the name of the task list in which to schedule the activity task. If not specified, the
     *         <code>defaultTaskList</code> registered with the activity type is used.</p> <note>
     *         <p>
     *         A task list for this activity task must be specified either as a default for the activity type or through
     *         this field. If neither this field is set nor a default task list was specified at registration time then
     *         a fault is returned.
     *         </p>
     *         </note>
     *         <p>
     *         The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
     *         <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (
     *         <code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not contain the literal string
     *         <code>arn</code>.
     */
    public final TaskList taskList() {
        return taskList;
    }

    /**
     * <p>
     * If set, specifies the priority with which the activity task is to be assigned to a worker. This overrides the
     * defaultTaskPriority specified when registering the activity type using <a>RegisterActivityType</a>. Valid values
     * are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to
     * <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.
     * </p>
     * <p>
     * For more information about setting task priority, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
     * Priority</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * 
     * @return If set, specifies the priority with which the activity task is to be assigned to a worker. This overrides
     *         the defaultTaskPriority specified when registering the activity type using <a>RegisterActivityType</a>.
     *         Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to
     *         <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.</p>
     *         <p>
     *         For more information about setting task priority, see <a
     *         href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
     *         Priority</a> in the <i>Amazon SWF Developer Guide</i>.
     */
    public final String taskPriority() {
        return taskPriority;
    }

    /**
     * <p>
     * If set, specifies the maximum duration the activity task can wait to be assigned to a worker. This overrides the
     * default schedule-to-start timeout specified when registering the activity type using <a>RegisterActivityType</a>.
     * </p>
     * <p>
     * The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
     * <code>NONE</code> to specify unlimited duration.
     * </p>
     * <note>
     * <p>
     * A schedule-to-start timeout for this activity task must be specified either as a default for the activity type or
     * through this field. If neither this field is set nor a default schedule-to-start timeout was specified at
     * registration time then a fault is returned.
     * </p>
     * </note>
     * 
     * @return If set, specifies the maximum duration the activity task can wait to be assigned to a worker. This
     *         overrides the default schedule-to-start timeout specified when registering the activity type using
     *         <a>RegisterActivityType</a>.</p>
     *         <p>
     *         The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
     *         <code>NONE</code> to specify unlimited duration.
     *         </p>
     *         <note>
     *         <p>
     *         A schedule-to-start timeout for this activity task must be specified either as a default for the activity
     *         type or through this field. If neither this field is set nor a default schedule-to-start timeout was
     *         specified at registration time then a fault is returned.
     *         </p>
     */
    public final String scheduleToStartTimeout() {
        return scheduleToStartTimeout;
    }

    /**
     * <p>
     * If set, specifies the maximum duration a worker may take to process this activity task. This overrides the
     * default start-to-close timeout specified when registering the activity type using <a>RegisterActivityType</a>.
     * </p>
     * <p>
     * The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
     * <code>NONE</code> to specify unlimited duration.
     * </p>
     * <note>
     * <p>
     * A start-to-close timeout for this activity task must be specified either as a default for the activity type or
     * through this field. If neither this field is set nor a default start-to-close timeout was specified at
     * registration time then a fault is returned.
     * </p>
     * </note>
     * 
     * @return If set, specifies the maximum duration a worker may take to process this activity task. This overrides
     *         the default start-to-close timeout specified when registering the activity type using
     *         <a>RegisterActivityType</a>.</p>
     *         <p>
     *         The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
     *         <code>NONE</code> to specify unlimited duration.
     *         </p>
     *         <note>
     *         <p>
     *         A start-to-close timeout for this activity task must be specified either as a default for the activity
     *         type or through this field. If neither this field is set nor a default start-to-close timeout was
     *         specified at registration time then a fault is returned.
     *         </p>
     */
    public final String startToCloseTimeout() {
        return startToCloseTimeout;
    }

    /**
     * <p>
     * If set, specifies the maximum time before which a worker processing a task of this type must report progress by
     * calling <a>RecordActivityTaskHeartbeat</a>. If the timeout is exceeded, the activity task is automatically timed
     * out. If the worker subsequently attempts to record a heartbeat or returns a result, it is ignored. This overrides
     * the default heartbeat timeout specified when registering the activity type using <a>RegisterActivityType</a>.
     * </p>
     * <p>
     * The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
     * <code>NONE</code> to specify unlimited duration.
     * </p>
     * 
     * @return If set, specifies the maximum time before which a worker processing a task of this type must report
     *         progress by calling <a>RecordActivityTaskHeartbeat</a>. If the timeout is exceeded, the activity task is
     *         automatically timed out. If the worker subsequently attempts to record a heartbeat or returns a result,
     *         it is ignored. This overrides the default heartbeat timeout specified when registering the activity type
     *         using <a>RegisterActivityType</a>.</p>
     *         <p>
     *         The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
     *         <code>NONE</code> to specify unlimited duration.
     */
    public final String heartbeatTimeout() {
        return heartbeatTimeout;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(activityType());
        hashCode = 31 * hashCode + Objects.hashCode(activityId());
        hashCode = 31 * hashCode + Objects.hashCode(control());
        hashCode = 31 * hashCode + Objects.hashCode(input());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleToCloseTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(taskList());
        hashCode = 31 * hashCode + Objects.hashCode(taskPriority());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleToStartTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(startToCloseTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(heartbeatTimeout());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduleActivityTaskDecisionAttributes)) {
            return false;
        }
        ScheduleActivityTaskDecisionAttributes other = (ScheduleActivityTaskDecisionAttributes) obj;
        return Objects.equals(activityType(), other.activityType()) && Objects.equals(activityId(), other.activityId())
                && Objects.equals(control(), other.control()) && Objects.equals(input(), other.input())
                && Objects.equals(scheduleToCloseTimeout(), other.scheduleToCloseTimeout())
                && Objects.equals(taskList(), other.taskList()) && Objects.equals(taskPriority(), other.taskPriority())
                && Objects.equals(scheduleToStartTimeout(), other.scheduleToStartTimeout())
                && Objects.equals(startToCloseTimeout(), other.startToCloseTimeout())
                && Objects.equals(heartbeatTimeout(), other.heartbeatTimeout());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScheduleActivityTaskDecisionAttributes").add("ActivityType", activityType())
                .add("ActivityId", activityId()).add("Control", control()).add("Input", input())
                .add("ScheduleToCloseTimeout", scheduleToCloseTimeout()).add("TaskList", taskList())
                .add("TaskPriority", taskPriority()).add("ScheduleToStartTimeout", scheduleToStartTimeout())
                .add("StartToCloseTimeout", startToCloseTimeout()).add("HeartbeatTimeout", heartbeatTimeout()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "activityType":
            return Optional.ofNullable(clazz.cast(activityType()));
        case "activityId":
            return Optional.ofNullable(clazz.cast(activityId()));
        case "control":
            return Optional.ofNullable(clazz.cast(control()));
        case "input":
            return Optional.ofNullable(clazz.cast(input()));
        case "scheduleToCloseTimeout":
            return Optional.ofNullable(clazz.cast(scheduleToCloseTimeout()));
        case "taskList":
            return Optional.ofNullable(clazz.cast(taskList()));
        case "taskPriority":
            return Optional.ofNullable(clazz.cast(taskPriority()));
        case "scheduleToStartTimeout":
            return Optional.ofNullable(clazz.cast(scheduleToStartTimeout()));
        case "startToCloseTimeout":
            return Optional.ofNullable(clazz.cast(startToCloseTimeout()));
        case "heartbeatTimeout":
            return Optional.ofNullable(clazz.cast(heartbeatTimeout()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScheduleActivityTaskDecisionAttributes, T> g) {
        return obj -> g.apply((ScheduleActivityTaskDecisionAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScheduleActivityTaskDecisionAttributes> {
        /**
         * <p>
         * The type of the activity task to schedule.
         * </p>
         * 
         * @param activityType
         *        The type of the activity task to schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activityType(ActivityType activityType);

        /**
         * <p>
         * The type of the activity task to schedule.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActivityType.Builder} avoiding the need
         * to create one manually via {@link ActivityType#builder()}.
         *
         * When the {@link Consumer} completes, {@link ActivityType.Builder#build()} is called immediately and its
         * result is passed to {@link #activityType(ActivityType)}.
         * 
         * @param activityType
         *        a consumer that will call methods on {@link ActivityType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activityType(ActivityType)
         */
        default Builder activityType(Consumer<ActivityType.Builder> activityType) {
            return activityType(ActivityType.builder().applyMutation(activityType).build());
        }

        /**
         * <p>
         * The <code>activityId</code> of the activity task.
         * </p>
         * <p>
         * The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
         * <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code>
         * | <code>\u007f-\u009f</code>). Also, it must not contain the literal string <code>arn</code>.
         * </p>
         * 
         * @param activityId
         *        The <code>activityId</code> of the activity task.</p>
         *        <p>
         *        The specified string must not start or end with whitespace. It must not contain a <code>:</code>
         *        (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (
         *        <code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not contain the literal string
         *        <code>arn</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activityId(String activityId);

        /**
         * <p>
         * Data attached to the event that can be used by the decider in subsequent workflow tasks. This data isn't sent
         * to the activity.
         * </p>
         * 
         * @param control
         *        Data attached to the event that can be used by the decider in subsequent workflow tasks. This data
         *        isn't sent to the activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder control(String control);

        /**
         * <p>
         * The input provided to the activity task.
         * </p>
         * 
         * @param input
         *        The input provided to the activity task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(String input);

        /**
         * <p>
         * The maximum duration for this activity task.
         * </p>
         * <p>
         * The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
         * <code>NONE</code> to specify unlimited duration.
         * </p>
         * <note>
         * <p>
         * A schedule-to-close timeout for this activity task must be specified either as a default for the activity
         * type or through this field. If neither this field is set nor a default schedule-to-close timeout was
         * specified at registration time then a fault is returned.
         * </p>
         * </note>
         * 
         * @param scheduleToCloseTimeout
         *        The maximum duration for this activity task.</p>
         *        <p>
         *        The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
         *        <code>NONE</code> to specify unlimited duration.
         *        </p>
         *        <note>
         *        <p>
         *        A schedule-to-close timeout for this activity task must be specified either as a default for the
         *        activity type or through this field. If neither this field is set nor a default schedule-to-close
         *        timeout was specified at registration time then a fault is returned.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleToCloseTimeout(String scheduleToCloseTimeout);

        /**
         * <p>
         * If set, specifies the name of the task list in which to schedule the activity task. If not specified, the
         * <code>defaultTaskList</code> registered with the activity type is used.
         * </p>
         * <note>
         * <p>
         * A task list for this activity task must be specified either as a default for the activity type or through
         * this field. If neither this field is set nor a default task list was specified at registration time then a
         * fault is returned.
         * </p>
         * </note>
         * <p>
         * The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
         * <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code>
         * | <code>\u007f-\u009f</code>). Also, it must not contain the literal string <code>arn</code>.
         * </p>
         * 
         * @param taskList
         *        If set, specifies the name of the task list in which to schedule the activity task. If not specified,
         *        the <code>defaultTaskList</code> registered with the activity type is used.</p> <note>
         *        <p>
         *        A task list for this activity task must be specified either as a default for the activity type or
         *        through this field. If neither this field is set nor a default task list was specified at registration
         *        time then a fault is returned.
         *        </p>
         *        </note>
         *        <p>
         *        The specified string must not start or end with whitespace. It must not contain a <code>:</code>
         *        (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (
         *        <code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not contain the literal string
         *        <code>arn</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskList(TaskList taskList);

        /**
         * <p>
         * If set, specifies the name of the task list in which to schedule the activity task. If not specified, the
         * <code>defaultTaskList</code> registered with the activity type is used.
         * </p>
         * <note>
         * <p>
         * A task list for this activity task must be specified either as a default for the activity type or through
         * this field. If neither this field is set nor a default task list was specified at registration time then a
         * fault is returned.
         * </p>
         * </note>
         * <p>
         * The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
         * <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code>
         * | <code>\u007f-\u009f</code>). Also, it must not contain the literal string <code>arn</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link TaskList.Builder} avoiding the need to
         * create one manually via {@link TaskList#builder()}.
         *
         * When the {@link Consumer} completes, {@link TaskList.Builder#build()} is called immediately and its result is
         * passed to {@link #taskList(TaskList)}.
         * 
         * @param taskList
         *        a consumer that will call methods on {@link TaskList.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taskList(TaskList)
         */
        default Builder taskList(Consumer<TaskList.Builder> taskList) {
            return taskList(TaskList.builder().applyMutation(taskList).build());
        }

        /**
         * <p>
         * If set, specifies the priority with which the activity task is to be assigned to a worker. This overrides the
         * defaultTaskPriority specified when registering the activity type using <a>RegisterActivityType</a>. Valid
         * values are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to
         * <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.
         * </p>
         * <p>
         * For more information about setting task priority, see <a
         * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
         * Priority</a> in the <i>Amazon SWF Developer Guide</i>.
         * </p>
         * 
         * @param taskPriority
         *        If set, specifies the priority with which the activity task is to be assigned to a worker. This
         *        overrides the defaultTaskPriority specified when registering the activity type using
         *        <a>RegisterActivityType</a>. Valid values are integers that range from Java's
         *        <code>Integer.MIN_VALUE</code> (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647). Higher
         *        numbers indicate higher priority.</p>
         *        <p>
         *        For more information about setting task priority, see <a
         *        href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting
         *        Task Priority</a> in the <i>Amazon SWF Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskPriority(String taskPriority);

        /**
         * <p>
         * If set, specifies the maximum duration the activity task can wait to be assigned to a worker. This overrides
         * the default schedule-to-start timeout specified when registering the activity type using
         * <a>RegisterActivityType</a>.
         * </p>
         * <p>
         * The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
         * <code>NONE</code> to specify unlimited duration.
         * </p>
         * <note>
         * <p>
         * A schedule-to-start timeout for this activity task must be specified either as a default for the activity
         * type or through this field. If neither this field is set nor a default schedule-to-start timeout was
         * specified at registration time then a fault is returned.
         * </p>
         * </note>
         * 
         * @param scheduleToStartTimeout
         *        If set, specifies the maximum duration the activity task can wait to be assigned to a worker. This
         *        overrides the default schedule-to-start timeout specified when registering the activity type using
         *        <a>RegisterActivityType</a>.</p>
         *        <p>
         *        The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
         *        <code>NONE</code> to specify unlimited duration.
         *        </p>
         *        <note>
         *        <p>
         *        A schedule-to-start timeout for this activity task must be specified either as a default for the
         *        activity type or through this field. If neither this field is set nor a default schedule-to-start
         *        timeout was specified at registration time then a fault is returned.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleToStartTimeout(String scheduleToStartTimeout);

        /**
         * <p>
         * If set, specifies the maximum duration a worker may take to process this activity task. This overrides the
         * default start-to-close timeout specified when registering the activity type using
         * <a>RegisterActivityType</a>.
         * </p>
         * <p>
         * The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
         * <code>NONE</code> to specify unlimited duration.
         * </p>
         * <note>
         * <p>
         * A start-to-close timeout for this activity task must be specified either as a default for the activity type
         * or through this field. If neither this field is set nor a default start-to-close timeout was specified at
         * registration time then a fault is returned.
         * </p>
         * </note>
         * 
         * @param startToCloseTimeout
         *        If set, specifies the maximum duration a worker may take to process this activity task. This overrides
         *        the default start-to-close timeout specified when registering the activity type using
         *        <a>RegisterActivityType</a>.</p>
         *        <p>
         *        The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
         *        <code>NONE</code> to specify unlimited duration.
         *        </p>
         *        <note>
         *        <p>
         *        A start-to-close timeout for this activity task must be specified either as a default for the activity
         *        type or through this field. If neither this field is set nor a default start-to-close timeout was
         *        specified at registration time then a fault is returned.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startToCloseTimeout(String startToCloseTimeout);

        /**
         * <p>
         * If set, specifies the maximum time before which a worker processing a task of this type must report progress
         * by calling <a>RecordActivityTaskHeartbeat</a>. If the timeout is exceeded, the activity task is automatically
         * timed out. If the worker subsequently attempts to record a heartbeat or returns a result, it is ignored. This
         * overrides the default heartbeat timeout specified when registering the activity type using
         * <a>RegisterActivityType</a>.
         * </p>
         * <p>
         * The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
         * <code>NONE</code> to specify unlimited duration.
         * </p>
         * 
         * @param heartbeatTimeout
         *        If set, specifies the maximum time before which a worker processing a task of this type must report
         *        progress by calling <a>RecordActivityTaskHeartbeat</a>. If the timeout is exceeded, the activity task
         *        is automatically timed out. If the worker subsequently attempts to record a heartbeat or returns a
         *        result, it is ignored. This overrides the default heartbeat timeout specified when registering the
         *        activity type using <a>RegisterActivityType</a>.</p>
         *        <p>
         *        The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
         *        <code>NONE</code> to specify unlimited duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder heartbeatTimeout(String heartbeatTimeout);
    }

    static final class BuilderImpl implements Builder {
        private ActivityType activityType;

        private String activityId;

        private String control;

        private String input;

        private String scheduleToCloseTimeout;

        private TaskList taskList;

        private String taskPriority;

        private String scheduleToStartTimeout;

        private String startToCloseTimeout;

        private String heartbeatTimeout;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduleActivityTaskDecisionAttributes model) {
            activityType(model.activityType);
            activityId(model.activityId);
            control(model.control);
            input(model.input);
            scheduleToCloseTimeout(model.scheduleToCloseTimeout);
            taskList(model.taskList);
            taskPriority(model.taskPriority);
            scheduleToStartTimeout(model.scheduleToStartTimeout);
            startToCloseTimeout(model.startToCloseTimeout);
            heartbeatTimeout(model.heartbeatTimeout);
        }

        public final ActivityType.Builder getActivityType() {
            return activityType != null ? activityType.toBuilder() : null;
        }

        public final void setActivityType(ActivityType.BuilderImpl activityType) {
            this.activityType = activityType != null ? activityType.build() : null;
        }

        @Override
        public final Builder activityType(ActivityType activityType) {
            this.activityType = activityType;
            return this;
        }

        public final String getActivityId() {
            return activityId;
        }

        public final void setActivityId(String activityId) {
            this.activityId = activityId;
        }

        @Override
        public final Builder activityId(String activityId) {
            this.activityId = activityId;
            return this;
        }

        public final String getControl() {
            return control;
        }

        public final void setControl(String control) {
            this.control = control;
        }

        @Override
        public final Builder control(String control) {
            this.control = control;
            return this;
        }

        public final String getInput() {
            return input;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        @Override
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        public final String getScheduleToCloseTimeout() {
            return scheduleToCloseTimeout;
        }

        public final void setScheduleToCloseTimeout(String scheduleToCloseTimeout) {
            this.scheduleToCloseTimeout = scheduleToCloseTimeout;
        }

        @Override
        public final Builder scheduleToCloseTimeout(String scheduleToCloseTimeout) {
            this.scheduleToCloseTimeout = scheduleToCloseTimeout;
            return this;
        }

        public final TaskList.Builder getTaskList() {
            return taskList != null ? taskList.toBuilder() : null;
        }

        public final void setTaskList(TaskList.BuilderImpl taskList) {
            this.taskList = taskList != null ? taskList.build() : null;
        }

        @Override
        public final Builder taskList(TaskList taskList) {
            this.taskList = taskList;
            return this;
        }

        public final String getTaskPriority() {
            return taskPriority;
        }

        public final void setTaskPriority(String taskPriority) {
            this.taskPriority = taskPriority;
        }

        @Override
        public final Builder taskPriority(String taskPriority) {
            this.taskPriority = taskPriority;
            return this;
        }

        public final String getScheduleToStartTimeout() {
            return scheduleToStartTimeout;
        }

        public final void setScheduleToStartTimeout(String scheduleToStartTimeout) {
            this.scheduleToStartTimeout = scheduleToStartTimeout;
        }

        @Override
        public final Builder scheduleToStartTimeout(String scheduleToStartTimeout) {
            this.scheduleToStartTimeout = scheduleToStartTimeout;
            return this;
        }

        public final String getStartToCloseTimeout() {
            return startToCloseTimeout;
        }

        public final void setStartToCloseTimeout(String startToCloseTimeout) {
            this.startToCloseTimeout = startToCloseTimeout;
        }

        @Override
        public final Builder startToCloseTimeout(String startToCloseTimeout) {
            this.startToCloseTimeout = startToCloseTimeout;
            return this;
        }

        public final String getHeartbeatTimeout() {
            return heartbeatTimeout;
        }

        public final void setHeartbeatTimeout(String heartbeatTimeout) {
            this.heartbeatTimeout = heartbeatTimeout;
        }

        @Override
        public final Builder heartbeatTimeout(String heartbeatTimeout) {
            this.heartbeatTimeout = heartbeatTimeout;
            return this;
        }

        @Override
        public ScheduleActivityTaskDecisionAttributes build() {
            return new ScheduleActivityTaskDecisionAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
