/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the details of the <code>ActivityTaskScheduled</code> event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActivityTaskScheduledEventAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<ActivityTaskScheduledEventAttributes.Builder, ActivityTaskScheduledEventAttributes> {
    private static final SdkField<ActivityType> ACTIVITY_TYPE_FIELD = SdkField.<ActivityType> builder(MarshallingType.SDK_POJO)
            .memberName("activityType").getter(getter(ActivityTaskScheduledEventAttributes::activityType))
            .setter(setter(Builder::activityType)).constructor(ActivityType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activityType").build()).build();

    private static final SdkField<String> ACTIVITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("activityId").getter(getter(ActivityTaskScheduledEventAttributes::activityId))
            .setter(setter(Builder::activityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activityId").build()).build();

    private static final SdkField<String> INPUT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("input")
            .getter(getter(ActivityTaskScheduledEventAttributes::input)).setter(setter(Builder::input))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()).build();

    private static final SdkField<String> CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("control")
            .getter(getter(ActivityTaskScheduledEventAttributes::control)).setter(setter(Builder::control))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("control").build()).build();

    private static final SdkField<String> SCHEDULE_TO_START_TIMEOUT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scheduleToStartTimeout").getter(getter(ActivityTaskScheduledEventAttributes::scheduleToStartTimeout))
            .setter(setter(Builder::scheduleToStartTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduleToStartTimeout").build())
            .build();

    private static final SdkField<String> SCHEDULE_TO_CLOSE_TIMEOUT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scheduleToCloseTimeout").getter(getter(ActivityTaskScheduledEventAttributes::scheduleToCloseTimeout))
            .setter(setter(Builder::scheduleToCloseTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduleToCloseTimeout").build())
            .build();

    private static final SdkField<String> START_TO_CLOSE_TIMEOUT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("startToCloseTimeout").getter(getter(ActivityTaskScheduledEventAttributes::startToCloseTimeout))
            .setter(setter(Builder::startToCloseTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startToCloseTimeout").build())
            .build();

    private static final SdkField<TaskList> TASK_LIST_FIELD = SdkField.<TaskList> builder(MarshallingType.SDK_POJO)
            .memberName("taskList").getter(getter(ActivityTaskScheduledEventAttributes::taskList))
            .setter(setter(Builder::taskList)).constructor(TaskList::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskList").build()).build();

    private static final SdkField<String> TASK_PRIORITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("taskPriority").getter(getter(ActivityTaskScheduledEventAttributes::taskPriority))
            .setter(setter(Builder::taskPriority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskPriority").build()).build();

    private static final SdkField<Long> DECISION_TASK_COMPLETED_EVENT_ID_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("decisionTaskCompletedEventId")
            .getter(getter(ActivityTaskScheduledEventAttributes::decisionTaskCompletedEventId))
            .setter(setter(Builder::decisionTaskCompletedEventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decisionTaskCompletedEventId")
                    .build()).build();

    private static final SdkField<String> HEARTBEAT_TIMEOUT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("heartbeatTimeout").getter(getter(ActivityTaskScheduledEventAttributes::heartbeatTimeout))
            .setter(setter(Builder::heartbeatTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("heartbeatTimeout").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVITY_TYPE_FIELD,
            ACTIVITY_ID_FIELD, INPUT_FIELD, CONTROL_FIELD, SCHEDULE_TO_START_TIMEOUT_FIELD, SCHEDULE_TO_CLOSE_TIMEOUT_FIELD,
            START_TO_CLOSE_TIMEOUT_FIELD, TASK_LIST_FIELD, TASK_PRIORITY_FIELD, DECISION_TASK_COMPLETED_EVENT_ID_FIELD,
            HEARTBEAT_TIMEOUT_FIELD));

    private static final long serialVersionUID = 1L;

    private final ActivityType activityType;

    private final String activityId;

    private final String input;

    private final String control;

    private final String scheduleToStartTimeout;

    private final String scheduleToCloseTimeout;

    private final String startToCloseTimeout;

    private final TaskList taskList;

    private final String taskPriority;

    private final Long decisionTaskCompletedEventId;

    private final String heartbeatTimeout;

    private ActivityTaskScheduledEventAttributes(BuilderImpl builder) {
        this.activityType = builder.activityType;
        this.activityId = builder.activityId;
        this.input = builder.input;
        this.control = builder.control;
        this.scheduleToStartTimeout = builder.scheduleToStartTimeout;
        this.scheduleToCloseTimeout = builder.scheduleToCloseTimeout;
        this.startToCloseTimeout = builder.startToCloseTimeout;
        this.taskList = builder.taskList;
        this.taskPriority = builder.taskPriority;
        this.decisionTaskCompletedEventId = builder.decisionTaskCompletedEventId;
        this.heartbeatTimeout = builder.heartbeatTimeout;
    }

    /**
     * <p>
     * The type of the activity task.
     * </p>
     * 
     * @return The type of the activity task.
     */
    public final ActivityType activityType() {
        return activityType;
    }

    /**
     * <p>
     * The unique ID of the activity task.
     * </p>
     * 
     * @return The unique ID of the activity task.
     */
    public final String activityId() {
        return activityId;
    }

    /**
     * <p>
     * The input provided to the activity task.
     * </p>
     * 
     * @return The input provided to the activity task.
     */
    public final String input() {
        return input;
    }

    /**
     * <p>
     * Data attached to the event that can be used by the decider in subsequent workflow tasks. This data isn't sent to
     * the activity.
     * </p>
     * 
     * @return Data attached to the event that can be used by the decider in subsequent workflow tasks. This data isn't
     *         sent to the activity.
     */
    public final String control() {
        return control;
    }

    /**
     * <p>
     * The maximum amount of time the activity task can wait to be assigned to a worker.
     * </p>
     * 
     * @return The maximum amount of time the activity task can wait to be assigned to a worker.
     */
    public final String scheduleToStartTimeout() {
        return scheduleToStartTimeout;
    }

    /**
     * <p>
     * The maximum amount of time for this activity task.
     * </p>
     * 
     * @return The maximum amount of time for this activity task.
     */
    public final String scheduleToCloseTimeout() {
        return scheduleToCloseTimeout;
    }

    /**
     * <p>
     * The maximum amount of time a worker may take to process the activity task.
     * </p>
     * 
     * @return The maximum amount of time a worker may take to process the activity task.
     */
    public final String startToCloseTimeout() {
        return startToCloseTimeout;
    }

    /**
     * <p>
     * The task list in which the activity task has been scheduled.
     * </p>
     * 
     * @return The task list in which the activity task has been scheduled.
     */
    public final TaskList taskList() {
        return taskList;
    }

    /**
     * <p>
     * The priority to assign to the scheduled activity task. If set, this overrides any default priority value that was
     * assigned when the activity type was registered.
     * </p>
     * <p>
     * Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to
     * <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.
     * </p>
     * <p>
     * For more information about setting task priority, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
     * Priority</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * 
     * @return The priority to assign to the scheduled activity task. If set, this overrides any default priority value
     *         that was assigned when the activity type was registered.</p>
     *         <p>
     *         Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to
     *         <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.
     *         </p>
     *         <p>
     *         For more information about setting task priority, see <a
     *         href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
     *         Priority</a> in the <i>Amazon SWF Developer Guide</i>.
     */
    public final String taskPriority() {
        return taskPriority;
    }

    /**
     * <p>
     * The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision that resulted in the
     * scheduling of this activity task. This information can be useful for diagnosing problems by tracing back the
     * chain of events leading up to this event.
     * </p>
     * 
     * @return The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision that resulted in the
     *         scheduling of this activity task. This information can be useful for diagnosing problems by tracing back
     *         the chain of events leading up to this event.
     */
    public final Long decisionTaskCompletedEventId() {
        return decisionTaskCompletedEventId;
    }

    /**
     * <p>
     * The maximum time before which the worker processing this task must report progress by calling
     * <a>RecordActivityTaskHeartbeat</a>. If the timeout is exceeded, the activity task is automatically timed out. If
     * the worker subsequently attempts to record a heartbeat or return a result, it is ignored.
     * </p>
     * 
     * @return The maximum time before which the worker processing this task must report progress by calling
     *         <a>RecordActivityTaskHeartbeat</a>. If the timeout is exceeded, the activity task is automatically timed
     *         out. If the worker subsequently attempts to record a heartbeat or return a result, it is ignored.
     */
    public final String heartbeatTimeout() {
        return heartbeatTimeout;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(activityType());
        hashCode = 31 * hashCode + Objects.hashCode(activityId());
        hashCode = 31 * hashCode + Objects.hashCode(input());
        hashCode = 31 * hashCode + Objects.hashCode(control());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleToStartTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleToCloseTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(startToCloseTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(taskList());
        hashCode = 31 * hashCode + Objects.hashCode(taskPriority());
        hashCode = 31 * hashCode + Objects.hashCode(decisionTaskCompletedEventId());
        hashCode = 31 * hashCode + Objects.hashCode(heartbeatTimeout());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActivityTaskScheduledEventAttributes)) {
            return false;
        }
        ActivityTaskScheduledEventAttributes other = (ActivityTaskScheduledEventAttributes) obj;
        return Objects.equals(activityType(), other.activityType()) && Objects.equals(activityId(), other.activityId())
                && Objects.equals(input(), other.input()) && Objects.equals(control(), other.control())
                && Objects.equals(scheduleToStartTimeout(), other.scheduleToStartTimeout())
                && Objects.equals(scheduleToCloseTimeout(), other.scheduleToCloseTimeout())
                && Objects.equals(startToCloseTimeout(), other.startToCloseTimeout())
                && Objects.equals(taskList(), other.taskList()) && Objects.equals(taskPriority(), other.taskPriority())
                && Objects.equals(decisionTaskCompletedEventId(), other.decisionTaskCompletedEventId())
                && Objects.equals(heartbeatTimeout(), other.heartbeatTimeout());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActivityTaskScheduledEventAttributes").add("ActivityType", activityType())
                .add("ActivityId", activityId()).add("Input", input()).add("Control", control())
                .add("ScheduleToStartTimeout", scheduleToStartTimeout()).add("ScheduleToCloseTimeout", scheduleToCloseTimeout())
                .add("StartToCloseTimeout", startToCloseTimeout()).add("TaskList", taskList())
                .add("TaskPriority", taskPriority()).add("DecisionTaskCompletedEventId", decisionTaskCompletedEventId())
                .add("HeartbeatTimeout", heartbeatTimeout()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "activityType":
            return Optional.ofNullable(clazz.cast(activityType()));
        case "activityId":
            return Optional.ofNullable(clazz.cast(activityId()));
        case "input":
            return Optional.ofNullable(clazz.cast(input()));
        case "control":
            return Optional.ofNullable(clazz.cast(control()));
        case "scheduleToStartTimeout":
            return Optional.ofNullable(clazz.cast(scheduleToStartTimeout()));
        case "scheduleToCloseTimeout":
            return Optional.ofNullable(clazz.cast(scheduleToCloseTimeout()));
        case "startToCloseTimeout":
            return Optional.ofNullable(clazz.cast(startToCloseTimeout()));
        case "taskList":
            return Optional.ofNullable(clazz.cast(taskList()));
        case "taskPriority":
            return Optional.ofNullable(clazz.cast(taskPriority()));
        case "decisionTaskCompletedEventId":
            return Optional.ofNullable(clazz.cast(decisionTaskCompletedEventId()));
        case "heartbeatTimeout":
            return Optional.ofNullable(clazz.cast(heartbeatTimeout()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActivityTaskScheduledEventAttributes, T> g) {
        return obj -> g.apply((ActivityTaskScheduledEventAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActivityTaskScheduledEventAttributes> {
        /**
         * <p>
         * The type of the activity task.
         * </p>
         * 
         * @param activityType
         *        The type of the activity task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activityType(ActivityType activityType);

        /**
         * <p>
         * The type of the activity task.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActivityType.Builder} avoiding the need
         * to create one manually via {@link ActivityType#builder()}.
         *
         * When the {@link Consumer} completes, {@link ActivityType.Builder#build()} is called immediately and its
         * result is passed to {@link #activityType(ActivityType)}.
         * 
         * @param activityType
         *        a consumer that will call methods on {@link ActivityType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activityType(ActivityType)
         */
        default Builder activityType(Consumer<ActivityType.Builder> activityType) {
            return activityType(ActivityType.builder().applyMutation(activityType).build());
        }

        /**
         * <p>
         * The unique ID of the activity task.
         * </p>
         * 
         * @param activityId
         *        The unique ID of the activity task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activityId(String activityId);

        /**
         * <p>
         * The input provided to the activity task.
         * </p>
         * 
         * @param input
         *        The input provided to the activity task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(String input);

        /**
         * <p>
         * Data attached to the event that can be used by the decider in subsequent workflow tasks. This data isn't sent
         * to the activity.
         * </p>
         * 
         * @param control
         *        Data attached to the event that can be used by the decider in subsequent workflow tasks. This data
         *        isn't sent to the activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder control(String control);

        /**
         * <p>
         * The maximum amount of time the activity task can wait to be assigned to a worker.
         * </p>
         * 
         * @param scheduleToStartTimeout
         *        The maximum amount of time the activity task can wait to be assigned to a worker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleToStartTimeout(String scheduleToStartTimeout);

        /**
         * <p>
         * The maximum amount of time for this activity task.
         * </p>
         * 
         * @param scheduleToCloseTimeout
         *        The maximum amount of time for this activity task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleToCloseTimeout(String scheduleToCloseTimeout);

        /**
         * <p>
         * The maximum amount of time a worker may take to process the activity task.
         * </p>
         * 
         * @param startToCloseTimeout
         *        The maximum amount of time a worker may take to process the activity task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startToCloseTimeout(String startToCloseTimeout);

        /**
         * <p>
         * The task list in which the activity task has been scheduled.
         * </p>
         * 
         * @param taskList
         *        The task list in which the activity task has been scheduled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskList(TaskList taskList);

        /**
         * <p>
         * The task list in which the activity task has been scheduled.
         * </p>
         * This is a convenience method that creates an instance of the {@link TaskList.Builder} avoiding the need to
         * create one manually via {@link TaskList#builder()}.
         *
         * When the {@link Consumer} completes, {@link TaskList.Builder#build()} is called immediately and its result is
         * passed to {@link #taskList(TaskList)}.
         * 
         * @param taskList
         *        a consumer that will call methods on {@link TaskList.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taskList(TaskList)
         */
        default Builder taskList(Consumer<TaskList.Builder> taskList) {
            return taskList(TaskList.builder().applyMutation(taskList).build());
        }

        /**
         * <p>
         * The priority to assign to the scheduled activity task. If set, this overrides any default priority value that
         * was assigned when the activity type was registered.
         * </p>
         * <p>
         * Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to
         * <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.
         * </p>
         * <p>
         * For more information about setting task priority, see <a
         * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
         * Priority</a> in the <i>Amazon SWF Developer Guide</i>.
         * </p>
         * 
         * @param taskPriority
         *        The priority to assign to the scheduled activity task. If set, this overrides any default priority
         *        value that was assigned when the activity type was registered.</p>
         *        <p>
         *        Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to
         *        <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.
         *        </p>
         *        <p>
         *        For more information about setting task priority, see <a
         *        href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting
         *        Task Priority</a> in the <i>Amazon SWF Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskPriority(String taskPriority);

        /**
         * <p>
         * The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision that resulted in the
         * scheduling of this activity task. This information can be useful for diagnosing problems by tracing back the
         * chain of events leading up to this event.
         * </p>
         * 
         * @param decisionTaskCompletedEventId
         *        The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision that resulted in
         *        the scheduling of this activity task. This information can be useful for diagnosing problems by
         *        tracing back the chain of events leading up to this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decisionTaskCompletedEventId(Long decisionTaskCompletedEventId);

        /**
         * <p>
         * The maximum time before which the worker processing this task must report progress by calling
         * <a>RecordActivityTaskHeartbeat</a>. If the timeout is exceeded, the activity task is automatically timed out.
         * If the worker subsequently attempts to record a heartbeat or return a result, it is ignored.
         * </p>
         * 
         * @param heartbeatTimeout
         *        The maximum time before which the worker processing this task must report progress by calling
         *        <a>RecordActivityTaskHeartbeat</a>. If the timeout is exceeded, the activity task is automatically
         *        timed out. If the worker subsequently attempts to record a heartbeat or return a result, it is
         *        ignored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder heartbeatTimeout(String heartbeatTimeout);
    }

    static final class BuilderImpl implements Builder {
        private ActivityType activityType;

        private String activityId;

        private String input;

        private String control;

        private String scheduleToStartTimeout;

        private String scheduleToCloseTimeout;

        private String startToCloseTimeout;

        private TaskList taskList;

        private String taskPriority;

        private Long decisionTaskCompletedEventId;

        private String heartbeatTimeout;

        private BuilderImpl() {
        }

        private BuilderImpl(ActivityTaskScheduledEventAttributes model) {
            activityType(model.activityType);
            activityId(model.activityId);
            input(model.input);
            control(model.control);
            scheduleToStartTimeout(model.scheduleToStartTimeout);
            scheduleToCloseTimeout(model.scheduleToCloseTimeout);
            startToCloseTimeout(model.startToCloseTimeout);
            taskList(model.taskList);
            taskPriority(model.taskPriority);
            decisionTaskCompletedEventId(model.decisionTaskCompletedEventId);
            heartbeatTimeout(model.heartbeatTimeout);
        }

        public final ActivityType.Builder getActivityType() {
            return activityType != null ? activityType.toBuilder() : null;
        }

        public final void setActivityType(ActivityType.BuilderImpl activityType) {
            this.activityType = activityType != null ? activityType.build() : null;
        }

        @Override
        public final Builder activityType(ActivityType activityType) {
            this.activityType = activityType;
            return this;
        }

        public final String getActivityId() {
            return activityId;
        }

        public final void setActivityId(String activityId) {
            this.activityId = activityId;
        }

        @Override
        public final Builder activityId(String activityId) {
            this.activityId = activityId;
            return this;
        }

        public final String getInput() {
            return input;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        @Override
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        public final String getControl() {
            return control;
        }

        public final void setControl(String control) {
            this.control = control;
        }

        @Override
        public final Builder control(String control) {
            this.control = control;
            return this;
        }

        public final String getScheduleToStartTimeout() {
            return scheduleToStartTimeout;
        }

        public final void setScheduleToStartTimeout(String scheduleToStartTimeout) {
            this.scheduleToStartTimeout = scheduleToStartTimeout;
        }

        @Override
        public final Builder scheduleToStartTimeout(String scheduleToStartTimeout) {
            this.scheduleToStartTimeout = scheduleToStartTimeout;
            return this;
        }

        public final String getScheduleToCloseTimeout() {
            return scheduleToCloseTimeout;
        }

        public final void setScheduleToCloseTimeout(String scheduleToCloseTimeout) {
            this.scheduleToCloseTimeout = scheduleToCloseTimeout;
        }

        @Override
        public final Builder scheduleToCloseTimeout(String scheduleToCloseTimeout) {
            this.scheduleToCloseTimeout = scheduleToCloseTimeout;
            return this;
        }

        public final String getStartToCloseTimeout() {
            return startToCloseTimeout;
        }

        public final void setStartToCloseTimeout(String startToCloseTimeout) {
            this.startToCloseTimeout = startToCloseTimeout;
        }

        @Override
        public final Builder startToCloseTimeout(String startToCloseTimeout) {
            this.startToCloseTimeout = startToCloseTimeout;
            return this;
        }

        public final TaskList.Builder getTaskList() {
            return taskList != null ? taskList.toBuilder() : null;
        }

        public final void setTaskList(TaskList.BuilderImpl taskList) {
            this.taskList = taskList != null ? taskList.build() : null;
        }

        @Override
        public final Builder taskList(TaskList taskList) {
            this.taskList = taskList;
            return this;
        }

        public final String getTaskPriority() {
            return taskPriority;
        }

        public final void setTaskPriority(String taskPriority) {
            this.taskPriority = taskPriority;
        }

        @Override
        public final Builder taskPriority(String taskPriority) {
            this.taskPriority = taskPriority;
            return this;
        }

        public final Long getDecisionTaskCompletedEventId() {
            return decisionTaskCompletedEventId;
        }

        public final void setDecisionTaskCompletedEventId(Long decisionTaskCompletedEventId) {
            this.decisionTaskCompletedEventId = decisionTaskCompletedEventId;
        }

        @Override
        public final Builder decisionTaskCompletedEventId(Long decisionTaskCompletedEventId) {
            this.decisionTaskCompletedEventId = decisionTaskCompletedEventId;
            return this;
        }

        public final String getHeartbeatTimeout() {
            return heartbeatTimeout;
        }

        public final void setHeartbeatTimeout(String heartbeatTimeout) {
            this.heartbeatTimeout = heartbeatTimeout;
        }

        @Override
        public final Builder heartbeatTimeout(String heartbeatTimeout) {
            this.heartbeatTimeout = heartbeatTimeout;
            return this;
        }

        @Override
        public ActivityTaskScheduledEventAttributes build() {
            return new ActivityTaskScheduledEventAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
