/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterDomainRequest extends SwfRequest implements
        ToCopyableBuilder<RegisterDomainRequest.Builder, RegisterDomainRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(RegisterDomainRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(RegisterDomainRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> WORKFLOW_EXECUTION_RETENTION_PERIOD_IN_DAYS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("workflowExecutionRetentionPeriodInDays")
            .getter(getter(RegisterDomainRequest::workflowExecutionRetentionPeriodInDays))
            .setter(setter(Builder::workflowExecutionRetentionPeriodInDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("workflowExecutionRetentionPeriodInDays").build()).build();

    private static final SdkField<List<ResourceTag>> TAGS_FIELD = SdkField
            .<List<ResourceTag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(RegisterDomainRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceTag> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceTag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            WORKFLOW_EXECUTION_RETENTION_PERIOD_IN_DAYS_FIELD, TAGS_FIELD));

    private final String name;

    private final String description;

    private final String workflowExecutionRetentionPeriodInDays;

    private final List<ResourceTag> tags;

    private RegisterDomainRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.workflowExecutionRetentionPeriodInDays = builder.workflowExecutionRetentionPeriodInDays;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Name of the domain to register. The name must be unique in the region that the domain is registered in.
     * </p>
     * <p>
     * The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
     * <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code> |
     * <code>\u007f-\u009f</code>). Also, it must not <i>be</i> the literal string <code>arn</code>.
     * </p>
     * 
     * @return Name of the domain to register. The name must be unique in the region that the domain is registered
     *         in.</p>
     *         <p>
     *         The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
     *         <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (
     *         <code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not <i>be</i> the literal string
     *         <code>arn</code>.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A text description of the domain.
     * </p>
     * 
     * @return A text description of the domain.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The duration (in days) that records and histories of workflow executions on the domain should be kept by the
     * service. After the retention period, the workflow execution isn't available in the results of visibility calls.
     * </p>
     * <p>
     * If you pass the value <code>NONE</code> or <code>0</code> (zero), then the workflow execution history isn't
     * retained. As soon as the workflow execution completes, the execution record and its history are deleted.
     * </p>
     * <p>
     * The maximum workflow execution retention period is 90 days. For more information about Amazon SWF service limits,
     * see: <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-limits.html">Amazon SWF Service
     * Limits</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * 
     * @return The duration (in days) that records and histories of workflow executions on the domain should be kept by
     *         the service. After the retention period, the workflow execution isn't available in the results of
     *         visibility calls.</p>
     *         <p>
     *         If you pass the value <code>NONE</code> or <code>0</code> (zero), then the workflow execution history
     *         isn't retained. As soon as the workflow execution completes, the execution record and its history are
     *         deleted.
     *         </p>
     *         <p>
     *         The maximum workflow execution retention period is 90 days. For more information about Amazon SWF service
     *         limits, see: <a
     *         href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-limits.html">Amazon SWF Service
     *         Limits</a> in the <i>Amazon SWF Developer Guide</i>.
     */
    public final String workflowExecutionRetentionPeriodInDays() {
        return workflowExecutionRetentionPeriodInDays;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Tags to be added when registering a domain.
     * </p>
     * <p>
     * Tags may only contain unicode letters, digits, whitespace, or these symbols: <code>_ . : / = + - @</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags to be added when registering a domain.</p>
     *         <p>
     *         Tags may only contain unicode letters, digits, whitespace, or these symbols: <code>_ . : / = + - @</code>.
     */
    public final List<ResourceTag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(workflowExecutionRetentionPeriodInDays());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterDomainRequest)) {
            return false;
        }
        RegisterDomainRequest other = (RegisterDomainRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(workflowExecutionRetentionPeriodInDays(), other.workflowExecutionRetentionPeriodInDays())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterDomainRequest").add("Name", name()).add("Description", description())
                .add("WorkflowExecutionRetentionPeriodInDays", workflowExecutionRetentionPeriodInDays())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "workflowExecutionRetentionPeriodInDays":
            return Optional.ofNullable(clazz.cast(workflowExecutionRetentionPeriodInDays()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterDomainRequest, T> g) {
        return obj -> g.apply((RegisterDomainRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SwfRequest.Builder, SdkPojo, CopyableBuilder<Builder, RegisterDomainRequest> {
        /**
         * <p>
         * Name of the domain to register. The name must be unique in the region that the domain is registered in.
         * </p>
         * <p>
         * The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
         * <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code>
         * | <code>\u007f-\u009f</code>). Also, it must not <i>be</i> the literal string <code>arn</code>.
         * </p>
         * 
         * @param name
         *        Name of the domain to register. The name must be unique in the region that the domain is registered
         *        in.</p>
         *        <p>
         *        The specified string must not start or end with whitespace. It must not contain a <code>:</code>
         *        (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (
         *        <code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not <i>be</i> the literal
         *        string <code>arn</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A text description of the domain.
         * </p>
         * 
         * @param description
         *        A text description of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The duration (in days) that records and histories of workflow executions on the domain should be kept by the
         * service. After the retention period, the workflow execution isn't available in the results of visibility
         * calls.
         * </p>
         * <p>
         * If you pass the value <code>NONE</code> or <code>0</code> (zero), then the workflow execution history isn't
         * retained. As soon as the workflow execution completes, the execution record and its history are deleted.
         * </p>
         * <p>
         * The maximum workflow execution retention period is 90 days. For more information about Amazon SWF service
         * limits, see: <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-limits.html">Amazon
         * SWF Service Limits</a> in the <i>Amazon SWF Developer Guide</i>.
         * </p>
         * 
         * @param workflowExecutionRetentionPeriodInDays
         *        The duration (in days) that records and histories of workflow executions on the domain should be kept
         *        by the service. After the retention period, the workflow execution isn't available in the results of
         *        visibility calls.</p>
         *        <p>
         *        If you pass the value <code>NONE</code> or <code>0</code> (zero), then the workflow execution history
         *        isn't retained. As soon as the workflow execution completes, the execution record and its history are
         *        deleted.
         *        </p>
         *        <p>
         *        The maximum workflow execution retention period is 90 days. For more information about Amazon SWF
         *        service limits, see: <a
         *        href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-limits.html">Amazon SWF
         *        Service Limits</a> in the <i>Amazon SWF Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowExecutionRetentionPeriodInDays(String workflowExecutionRetentionPeriodInDays);

        /**
         * <p>
         * Tags to be added when registering a domain.
         * </p>
         * <p>
         * Tags may only contain unicode letters, digits, whitespace, or these symbols: <code>_ . : / = + - @</code>.
         * </p>
         * 
         * @param tags
         *        Tags to be added when registering a domain.</p>
         *        <p>
         *        Tags may only contain unicode letters, digits, whitespace, or these symbols:
         *        <code>_ . : / = + - @</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<ResourceTag> tags);

        /**
         * <p>
         * Tags to be added when registering a domain.
         * </p>
         * <p>
         * Tags may only contain unicode letters, digits, whitespace, or these symbols: <code>_ . : / = + - @</code>.
         * </p>
         * 
         * @param tags
         *        Tags to be added when registering a domain.</p>
         *        <p>
         *        Tags may only contain unicode letters, digits, whitespace, or these symbols:
         *        <code>_ . : / = + - @</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(ResourceTag... tags);

        /**
         * <p>
         * Tags to be added when registering a domain.
         * </p>
         * <p>
         * Tags may only contain unicode letters, digits, whitespace, or these symbols: <code>_ . : / = + - @</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.swf.model.ResourceTag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.swf.model.ResourceTag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.swf.model.ResourceTag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<ResourceTag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.swf.model.ResourceTag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<ResourceTag>)
         */
        Builder tags(Consumer<ResourceTag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SwfRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private String workflowExecutionRetentionPeriodInDays;

        private List<ResourceTag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterDomainRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            workflowExecutionRetentionPeriodInDays(model.workflowExecutionRetentionPeriodInDays);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getWorkflowExecutionRetentionPeriodInDays() {
            return workflowExecutionRetentionPeriodInDays;
        }

        public final void setWorkflowExecutionRetentionPeriodInDays(String workflowExecutionRetentionPeriodInDays) {
            this.workflowExecutionRetentionPeriodInDays = workflowExecutionRetentionPeriodInDays;
        }

        @Override
        public final Builder workflowExecutionRetentionPeriodInDays(String workflowExecutionRetentionPeriodInDays) {
            this.workflowExecutionRetentionPeriodInDays = workflowExecutionRetentionPeriodInDays;
            return this;
        }

        public final List<ResourceTag.Builder> getTags() {
            List<ResourceTag.Builder> result = ResourceTagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<ResourceTag.BuilderImpl> tags) {
            this.tags = ResourceTagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<ResourceTag> tags) {
            this.tags = ResourceTagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(ResourceTag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<ResourceTag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> ResourceTag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterDomainRequest build() {
            return new RegisterDomainRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
