/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetWorkflowExecutionHistoryRequest extends SwfRequest implements
        ToCopyableBuilder<GetWorkflowExecutionHistoryRequest.Builder, GetWorkflowExecutionHistoryRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("domain")
            .getter(getter(GetWorkflowExecutionHistoryRequest::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domain").build()).build();

    private static final SdkField<WorkflowExecution> EXECUTION_FIELD = SdkField
            .<WorkflowExecution> builder(MarshallingType.SDK_POJO).memberName("execution")
            .getter(getter(GetWorkflowExecutionHistoryRequest::execution)).setter(setter(Builder::execution))
            .constructor(WorkflowExecution::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("execution").build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextPageToken").getter(getter(GetWorkflowExecutionHistoryRequest::nextPageToken))
            .setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageToken").build()).build();

    private static final SdkField<Integer> MAXIMUM_PAGE_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maximumPageSize").getter(getter(GetWorkflowExecutionHistoryRequest::maximumPageSize))
            .setter(setter(Builder::maximumPageSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumPageSize").build()).build();

    private static final SdkField<Boolean> REVERSE_ORDER_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("reverseOrder").getter(getter(GetWorkflowExecutionHistoryRequest::reverseOrder))
            .setter(setter(Builder::reverseOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reverseOrder").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD, EXECUTION_FIELD,
            NEXT_PAGE_TOKEN_FIELD, MAXIMUM_PAGE_SIZE_FIELD, REVERSE_ORDER_FIELD));

    private final String domain;

    private final WorkflowExecution execution;

    private final String nextPageToken;

    private final Integer maximumPageSize;

    private final Boolean reverseOrder;

    private GetWorkflowExecutionHistoryRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.execution = builder.execution;
        this.nextPageToken = builder.nextPageToken;
        this.maximumPageSize = builder.maximumPageSize;
        this.reverseOrder = builder.reverseOrder;
    }

    /**
     * <p>
     * The name of the domain containing the workflow execution.
     * </p>
     * 
     * @return The name of the domain containing the workflow execution.
     */
    public final String domain() {
        return domain;
    }

    /**
     * <p>
     * Specifies the workflow execution for which to return the history.
     * </p>
     * 
     * @return Specifies the workflow execution for which to return the history.
     */
    public final WorkflowExecution execution() {
        return execution;
    }

    /**
     * <p>
     * If <code>NextPageToken</code> is returned there are more results available. The value of
     * <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using the returned
     * token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 60
     * seconds. Using an expired pagination token will return a <code>400</code> error: "
     * <code>Specified token has exceeded its maximum lifetime</code>".
     * </p>
     * <p>
     * The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.
     * </p>
     * 
     * @return If <code>NextPageToken</code> is returned there are more results available. The value of
     *         <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using the
     *         returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token
     *         expires after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "
     *         <code>Specified token has exceeded its maximum lifetime</code>". </p>
     *         <p>
     *         The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.
     */
    public final String nextPageToken() {
        return nextPageToken;
    }

    /**
     * <p>
     * The maximum number of results that are returned per call. Use <code>nextPageToken</code> to obtain further pages
     * of results.
     * </p>
     * 
     * @return The maximum number of results that are returned per call. Use <code>nextPageToken</code> to obtain
     *         further pages of results.
     */
    public final Integer maximumPageSize() {
        return maximumPageSize;
    }

    /**
     * <p>
     * When set to <code>true</code>, returns the events in reverse order. By default the results are returned in
     * ascending order of the <code>eventTimeStamp</code> of the events.
     * </p>
     * 
     * @return When set to <code>true</code>, returns the events in reverse order. By default the results are returned
     *         in ascending order of the <code>eventTimeStamp</code> of the events.
     */
    public final Boolean reverseOrder() {
        return reverseOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(execution());
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        hashCode = 31 * hashCode + Objects.hashCode(maximumPageSize());
        hashCode = 31 * hashCode + Objects.hashCode(reverseOrder());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWorkflowExecutionHistoryRequest)) {
            return false;
        }
        GetWorkflowExecutionHistoryRequest other = (GetWorkflowExecutionHistoryRequest) obj;
        return Objects.equals(domain(), other.domain()) && Objects.equals(execution(), other.execution())
                && Objects.equals(nextPageToken(), other.nextPageToken())
                && Objects.equals(maximumPageSize(), other.maximumPageSize())
                && Objects.equals(reverseOrder(), other.reverseOrder());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetWorkflowExecutionHistoryRequest").add("Domain", domain()).add("Execution", execution())
                .add("NextPageToken", nextPageToken()).add("MaximumPageSize", maximumPageSize())
                .add("ReverseOrder", reverseOrder()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "execution":
            return Optional.ofNullable(clazz.cast(execution()));
        case "nextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        case "maximumPageSize":
            return Optional.ofNullable(clazz.cast(maximumPageSize()));
        case "reverseOrder":
            return Optional.ofNullable(clazz.cast(reverseOrder()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetWorkflowExecutionHistoryRequest, T> g) {
        return obj -> g.apply((GetWorkflowExecutionHistoryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SwfRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetWorkflowExecutionHistoryRequest> {
        /**
         * <p>
         * The name of the domain containing the workflow execution.
         * </p>
         * 
         * @param domain
         *        The name of the domain containing the workflow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * Specifies the workflow execution for which to return the history.
         * </p>
         * 
         * @param execution
         *        Specifies the workflow execution for which to return the history.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder execution(WorkflowExecution execution);

        /**
         * <p>
         * Specifies the workflow execution for which to return the history.
         * </p>
         * This is a convenience that creates an instance of the {@link WorkflowExecution.Builder} avoiding the need to
         * create one manually via {@link WorkflowExecution#builder()}.
         *
         * When the {@link Consumer} completes, {@link WorkflowExecution.Builder#build()} is called immediately and its
         * result is passed to {@link #execution(WorkflowExecution)}.
         * 
         * @param execution
         *        a consumer that will call methods on {@link WorkflowExecution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #execution(WorkflowExecution)
         */
        default Builder execution(Consumer<WorkflowExecution.Builder> execution) {
            return execution(WorkflowExecution.builder().applyMutation(execution).build());
        }

        /**
         * <p>
         * If <code>NextPageToken</code> is returned there are more results available. The value of
         * <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using the returned
         * token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 60
         * seconds. Using an expired pagination token will return a <code>400</code> error: "
         * <code>Specified token has exceeded its maximum lifetime</code>".
         * </p>
         * <p>
         * The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.
         * </p>
         * 
         * @param nextPageToken
         *        If <code>NextPageToken</code> is returned there are more results available. The value of
         *        <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using the
         *        returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token
         *        expires after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "
         *        <code>Specified token has exceeded its maximum lifetime</code>". </p>
         *        <p>
         *        The configured <code>maximumPageSize</code> determines how many results can be returned in a single
         *        call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);

        /**
         * <p>
         * The maximum number of results that are returned per call. Use <code>nextPageToken</code> to obtain further
         * pages of results.
         * </p>
         * 
         * @param maximumPageSize
         *        The maximum number of results that are returned per call. Use <code>nextPageToken</code> to obtain
         *        further pages of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumPageSize(Integer maximumPageSize);

        /**
         * <p>
         * When set to <code>true</code>, returns the events in reverse order. By default the results are returned in
         * ascending order of the <code>eventTimeStamp</code> of the events.
         * </p>
         * 
         * @param reverseOrder
         *        When set to <code>true</code>, returns the events in reverse order. By default the results are
         *        returned in ascending order of the <code>eventTimeStamp</code> of the events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reverseOrder(Boolean reverseOrder);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SwfRequest.BuilderImpl implements Builder {
        private String domain;

        private WorkflowExecution execution;

        private String nextPageToken;

        private Integer maximumPageSize;

        private Boolean reverseOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWorkflowExecutionHistoryRequest model) {
            super(model);
            domain(model.domain);
            execution(model.execution);
            nextPageToken(model.nextPageToken);
            maximumPageSize(model.maximumPageSize);
            reverseOrder(model.reverseOrder);
        }

        public final String getDomain() {
            return domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        @Transient
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final WorkflowExecution.Builder getExecution() {
            return execution != null ? execution.toBuilder() : null;
        }

        public final void setExecution(WorkflowExecution.BuilderImpl execution) {
            this.execution = execution != null ? execution.build() : null;
        }

        @Override
        @Transient
        public final Builder execution(WorkflowExecution execution) {
            this.execution = execution;
            return this;
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        @Transient
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final Integer getMaximumPageSize() {
            return maximumPageSize;
        }

        public final void setMaximumPageSize(Integer maximumPageSize) {
            this.maximumPageSize = maximumPageSize;
        }

        @Override
        @Transient
        public final Builder maximumPageSize(Integer maximumPageSize) {
            this.maximumPageSize = maximumPageSize;
            return this;
        }

        public final Boolean getReverseOrder() {
            return reverseOrder;
        }

        public final void setReverseOrder(Boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
        }

        @Override
        @Transient
        public final Builder reverseOrder(Boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetWorkflowExecutionHistoryRequest build() {
            return new GetWorkflowExecutionHistoryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
