/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.swf.model.HistoryEvent;
import software.amazon.awssdk.services.swf.model.HistoryEventListCopier;
import software.amazon.awssdk.services.swf.model.SwfResponse;
import software.amazon.awssdk.services.swf.model.WorkflowExecution;
import software.amazon.awssdk.services.swf.model.WorkflowType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PollForDecisionTaskResponse
extends SwfResponse
implements ToCopyableBuilder<Builder, PollForDecisionTaskResponse> {
    private static final SdkField<String> TASK_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskToken").getter(PollForDecisionTaskResponse.getter(PollForDecisionTaskResponse::taskToken)).setter(PollForDecisionTaskResponse.setter(Builder::taskToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskToken").build()}).build();
    private static final SdkField<Long> STARTED_EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("startedEventId").getter(PollForDecisionTaskResponse.getter(PollForDecisionTaskResponse::startedEventId)).setter(PollForDecisionTaskResponse.setter(Builder::startedEventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedEventId").build()}).build();
    private static final SdkField<WorkflowExecution> WORKFLOW_EXECUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("workflowExecution").getter(PollForDecisionTaskResponse.getter(PollForDecisionTaskResponse::workflowExecution)).setter(PollForDecisionTaskResponse.setter(Builder::workflowExecution)).constructor(WorkflowExecution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowExecution").build()}).build();
    private static final SdkField<WorkflowType> WORKFLOW_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("workflowType").getter(PollForDecisionTaskResponse.getter(PollForDecisionTaskResponse::workflowType)).setter(PollForDecisionTaskResponse.setter(Builder::workflowType)).constructor(WorkflowType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowType").build()}).build();
    private static final SdkField<List<HistoryEvent>> EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("events").getter(PollForDecisionTaskResponse.getter(PollForDecisionTaskResponse::events)).setter(PollForDecisionTaskResponse.setter(Builder::events)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("events").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HistoryEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextPageToken").getter(PollForDecisionTaskResponse.getter(PollForDecisionTaskResponse::nextPageToken)).setter(PollForDecisionTaskResponse.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageToken").build()}).build();
    private static final SdkField<Long> PREVIOUS_STARTED_EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("previousStartedEventId").getter(PollForDecisionTaskResponse.getter(PollForDecisionTaskResponse::previousStartedEventId)).setter(PollForDecisionTaskResponse.setter(Builder::previousStartedEventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("previousStartedEventId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_TOKEN_FIELD, STARTED_EVENT_ID_FIELD, WORKFLOW_EXECUTION_FIELD, WORKFLOW_TYPE_FIELD, EVENTS_FIELD, NEXT_PAGE_TOKEN_FIELD, PREVIOUS_STARTED_EVENT_ID_FIELD));
    private final String taskToken;
    private final Long startedEventId;
    private final WorkflowExecution workflowExecution;
    private final WorkflowType workflowType;
    private final List<HistoryEvent> events;
    private final String nextPageToken;
    private final Long previousStartedEventId;

    private PollForDecisionTaskResponse(BuilderImpl builder) {
        super(builder);
        this.taskToken = builder.taskToken;
        this.startedEventId = builder.startedEventId;
        this.workflowExecution = builder.workflowExecution;
        this.workflowType = builder.workflowType;
        this.events = builder.events;
        this.nextPageToken = builder.nextPageToken;
        this.previousStartedEventId = builder.previousStartedEventId;
    }

    public final String taskToken() {
        return this.taskToken;
    }

    public final Long startedEventId() {
        return this.startedEventId;
    }

    public final WorkflowExecution workflowExecution() {
        return this.workflowExecution;
    }

    public final WorkflowType workflowType() {
        return this.workflowType;
    }

    public final boolean hasEvents() {
        return this.events != null && !(this.events instanceof SdkAutoConstructList);
    }

    public final List<HistoryEvent> events() {
        return this.events;
    }

    public final String nextPageToken() {
        return this.nextPageToken;
    }

    public final Long previousStartedEventId() {
        return this.previousStartedEventId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.taskToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedEventId());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowExecution());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEvents() ? this.events() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.previousStartedEventId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PollForDecisionTaskResponse)) {
            return false;
        }
        PollForDecisionTaskResponse other = (PollForDecisionTaskResponse)((Object)obj);
        return Objects.equals(this.taskToken(), other.taskToken()) && Objects.equals(this.startedEventId(), other.startedEventId()) && Objects.equals(this.workflowExecution(), other.workflowExecution()) && Objects.equals(this.workflowType(), other.workflowType()) && this.hasEvents() == other.hasEvents() && Objects.equals(this.events(), other.events()) && Objects.equals(this.nextPageToken(), other.nextPageToken()) && Objects.equals(this.previousStartedEventId(), other.previousStartedEventId());
    }

    public final String toString() {
        return ToString.builder((String)"PollForDecisionTaskResponse").add("TaskToken", (Object)this.taskToken()).add("StartedEventId", (Object)this.startedEventId()).add("WorkflowExecution", (Object)this.workflowExecution()).add("WorkflowType", (Object)this.workflowType()).add("Events", this.hasEvents() ? this.events() : null).add("NextPageToken", (Object)this.nextPageToken()).add("PreviousStartedEventId", (Object)this.previousStartedEventId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "taskToken": {
                return Optional.ofNullable(clazz.cast(this.taskToken()));
            }
            case "startedEventId": {
                return Optional.ofNullable(clazz.cast(this.startedEventId()));
            }
            case "workflowExecution": {
                return Optional.ofNullable(clazz.cast(this.workflowExecution()));
            }
            case "workflowType": {
                return Optional.ofNullable(clazz.cast(this.workflowType()));
            }
            case "events": {
                return Optional.ofNullable(clazz.cast(this.events()));
            }
            case "nextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
            case "previousStartedEventId": {
                return Optional.ofNullable(clazz.cast(this.previousStartedEventId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PollForDecisionTaskResponse, T> g) {
        return obj -> g.apply((PollForDecisionTaskResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SwfResponse.BuilderImpl
    implements Builder {
        private String taskToken;
        private Long startedEventId;
        private WorkflowExecution workflowExecution;
        private WorkflowType workflowType;
        private List<HistoryEvent> events = DefaultSdkAutoConstructList.getInstance();
        private String nextPageToken;
        private Long previousStartedEventId;

        private BuilderImpl() {
        }

        private BuilderImpl(PollForDecisionTaskResponse model) {
            super(model);
            this.taskToken(model.taskToken);
            this.startedEventId(model.startedEventId);
            this.workflowExecution(model.workflowExecution);
            this.workflowType(model.workflowType);
            this.events(model.events);
            this.nextPageToken(model.nextPageToken);
            this.previousStartedEventId(model.previousStartedEventId);
        }

        public final String getTaskToken() {
            return this.taskToken;
        }

        public final void setTaskToken(String taskToken) {
            this.taskToken = taskToken;
        }

        @Override
        @Transient
        public final Builder taskToken(String taskToken) {
            this.taskToken = taskToken;
            return this;
        }

        public final Long getStartedEventId() {
            return this.startedEventId;
        }

        public final void setStartedEventId(Long startedEventId) {
            this.startedEventId = startedEventId;
        }

        @Override
        @Transient
        public final Builder startedEventId(Long startedEventId) {
            this.startedEventId = startedEventId;
            return this;
        }

        public final WorkflowExecution.Builder getWorkflowExecution() {
            return this.workflowExecution != null ? this.workflowExecution.toBuilder() : null;
        }

        public final void setWorkflowExecution(WorkflowExecution.BuilderImpl workflowExecution) {
            this.workflowExecution = workflowExecution != null ? workflowExecution.build() : null;
        }

        @Override
        @Transient
        public final Builder workflowExecution(WorkflowExecution workflowExecution) {
            this.workflowExecution = workflowExecution;
            return this;
        }

        public final WorkflowType.Builder getWorkflowType() {
            return this.workflowType != null ? this.workflowType.toBuilder() : null;
        }

        public final void setWorkflowType(WorkflowType.BuilderImpl workflowType) {
            this.workflowType = workflowType != null ? workflowType.build() : null;
        }

        @Override
        @Transient
        public final Builder workflowType(WorkflowType workflowType) {
            this.workflowType = workflowType;
            return this;
        }

        public final List<HistoryEvent.Builder> getEvents() {
            List<HistoryEvent.Builder> result = HistoryEventListCopier.copyToBuilder(this.events);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEvents(Collection<HistoryEvent.BuilderImpl> events) {
            this.events = HistoryEventListCopier.copyFromBuilder(events);
        }

        @Override
        @Transient
        public final Builder events(Collection<HistoryEvent> events) {
            this.events = HistoryEventListCopier.copy(events);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder events(HistoryEvent ... events) {
            this.events(Arrays.asList(events));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder events(Consumer<HistoryEvent.Builder> ... events) {
            this.events(Stream.of(events).map(c -> (HistoryEvent)((HistoryEvent.Builder)HistoryEvent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        @Transient
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final Long getPreviousStartedEventId() {
            return this.previousStartedEventId;
        }

        public final void setPreviousStartedEventId(Long previousStartedEventId) {
            this.previousStartedEventId = previousStartedEventId;
        }

        @Override
        @Transient
        public final Builder previousStartedEventId(Long previousStartedEventId) {
            this.previousStartedEventId = previousStartedEventId;
            return this;
        }

        @Override
        public PollForDecisionTaskResponse build() {
            return new PollForDecisionTaskResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SwfResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PollForDecisionTaskResponse> {
        public Builder taskToken(String var1);

        public Builder startedEventId(Long var1);

        public Builder workflowExecution(WorkflowExecution var1);

        default public Builder workflowExecution(Consumer<WorkflowExecution.Builder> workflowExecution) {
            return this.workflowExecution((WorkflowExecution)((WorkflowExecution.Builder)WorkflowExecution.builder().applyMutation(workflowExecution)).build());
        }

        public Builder workflowType(WorkflowType var1);

        default public Builder workflowType(Consumer<WorkflowType.Builder> workflowType) {
            return this.workflowType((WorkflowType)((WorkflowType.Builder)WorkflowType.builder().applyMutation(workflowType)).build());
        }

        public Builder events(Collection<HistoryEvent> var1);

        public Builder events(HistoryEvent ... var1);

        public Builder events(Consumer<HistoryEvent.Builder> ... var1);

        public Builder nextPageToken(String var1);

        public Builder previousStartedEventId(Long var1);
    }
}

