/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.swf.model.CountClosedWorkflowExecutionsRequest;
import software.amazon.awssdk.services.swf.model.CountClosedWorkflowExecutionsResponse;
import software.amazon.awssdk.services.swf.model.CountOpenWorkflowExecutionsRequest;
import software.amazon.awssdk.services.swf.model.CountOpenWorkflowExecutionsResponse;
import software.amazon.awssdk.services.swf.model.CountPendingActivityTasksRequest;
import software.amazon.awssdk.services.swf.model.CountPendingActivityTasksResponse;
import software.amazon.awssdk.services.swf.model.CountPendingDecisionTasksRequest;
import software.amazon.awssdk.services.swf.model.CountPendingDecisionTasksResponse;
import software.amazon.awssdk.services.swf.model.DefaultUndefinedException;
import software.amazon.awssdk.services.swf.model.DeprecateActivityTypeRequest;
import software.amazon.awssdk.services.swf.model.DeprecateActivityTypeResponse;
import software.amazon.awssdk.services.swf.model.DeprecateDomainRequest;
import software.amazon.awssdk.services.swf.model.DeprecateDomainResponse;
import software.amazon.awssdk.services.swf.model.DeprecateWorkflowTypeRequest;
import software.amazon.awssdk.services.swf.model.DeprecateWorkflowTypeResponse;
import software.amazon.awssdk.services.swf.model.DescribeActivityTypeRequest;
import software.amazon.awssdk.services.swf.model.DescribeActivityTypeResponse;
import software.amazon.awssdk.services.swf.model.DescribeDomainRequest;
import software.amazon.awssdk.services.swf.model.DescribeDomainResponse;
import software.amazon.awssdk.services.swf.model.DescribeWorkflowExecutionRequest;
import software.amazon.awssdk.services.swf.model.DescribeWorkflowExecutionResponse;
import software.amazon.awssdk.services.swf.model.DescribeWorkflowTypeRequest;
import software.amazon.awssdk.services.swf.model.DescribeWorkflowTypeResponse;
import software.amazon.awssdk.services.swf.model.DomainAlreadyExistsException;
import software.amazon.awssdk.services.swf.model.DomainDeprecatedException;
import software.amazon.awssdk.services.swf.model.GetWorkflowExecutionHistoryRequest;
import software.amazon.awssdk.services.swf.model.GetWorkflowExecutionHistoryResponse;
import software.amazon.awssdk.services.swf.model.LimitExceededException;
import software.amazon.awssdk.services.swf.model.ListActivityTypesRequest;
import software.amazon.awssdk.services.swf.model.ListActivityTypesResponse;
import software.amazon.awssdk.services.swf.model.ListClosedWorkflowExecutionsRequest;
import software.amazon.awssdk.services.swf.model.ListClosedWorkflowExecutionsResponse;
import software.amazon.awssdk.services.swf.model.ListDomainsRequest;
import software.amazon.awssdk.services.swf.model.ListDomainsResponse;
import software.amazon.awssdk.services.swf.model.ListOpenWorkflowExecutionsRequest;
import software.amazon.awssdk.services.swf.model.ListOpenWorkflowExecutionsResponse;
import software.amazon.awssdk.services.swf.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.swf.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.swf.model.ListWorkflowTypesRequest;
import software.amazon.awssdk.services.swf.model.ListWorkflowTypesResponse;
import software.amazon.awssdk.services.swf.model.OperationNotPermittedException;
import software.amazon.awssdk.services.swf.model.PollForActivityTaskRequest;
import software.amazon.awssdk.services.swf.model.PollForActivityTaskResponse;
import software.amazon.awssdk.services.swf.model.PollForDecisionTaskRequest;
import software.amazon.awssdk.services.swf.model.PollForDecisionTaskResponse;
import software.amazon.awssdk.services.swf.model.RecordActivityTaskHeartbeatRequest;
import software.amazon.awssdk.services.swf.model.RecordActivityTaskHeartbeatResponse;
import software.amazon.awssdk.services.swf.model.RegisterActivityTypeRequest;
import software.amazon.awssdk.services.swf.model.RegisterActivityTypeResponse;
import software.amazon.awssdk.services.swf.model.RegisterDomainRequest;
import software.amazon.awssdk.services.swf.model.RegisterDomainResponse;
import software.amazon.awssdk.services.swf.model.RegisterWorkflowTypeRequest;
import software.amazon.awssdk.services.swf.model.RegisterWorkflowTypeResponse;
import software.amazon.awssdk.services.swf.model.RequestCancelWorkflowExecutionRequest;
import software.amazon.awssdk.services.swf.model.RequestCancelWorkflowExecutionResponse;
import software.amazon.awssdk.services.swf.model.RespondActivityTaskCanceledRequest;
import software.amazon.awssdk.services.swf.model.RespondActivityTaskCanceledResponse;
import software.amazon.awssdk.services.swf.model.RespondActivityTaskCompletedRequest;
import software.amazon.awssdk.services.swf.model.RespondActivityTaskCompletedResponse;
import software.amazon.awssdk.services.swf.model.RespondActivityTaskFailedRequest;
import software.amazon.awssdk.services.swf.model.RespondActivityTaskFailedResponse;
import software.amazon.awssdk.services.swf.model.RespondDecisionTaskCompletedRequest;
import software.amazon.awssdk.services.swf.model.RespondDecisionTaskCompletedResponse;
import software.amazon.awssdk.services.swf.model.SignalWorkflowExecutionRequest;
import software.amazon.awssdk.services.swf.model.SignalWorkflowExecutionResponse;
import software.amazon.awssdk.services.swf.model.StartWorkflowExecutionRequest;
import software.amazon.awssdk.services.swf.model.StartWorkflowExecutionResponse;
import software.amazon.awssdk.services.swf.model.SwfException;
import software.amazon.awssdk.services.swf.model.TagResourceRequest;
import software.amazon.awssdk.services.swf.model.TagResourceResponse;
import software.amazon.awssdk.services.swf.model.TerminateWorkflowExecutionRequest;
import software.amazon.awssdk.services.swf.model.TerminateWorkflowExecutionResponse;
import software.amazon.awssdk.services.swf.model.TooManyTagsException;
import software.amazon.awssdk.services.swf.model.TypeAlreadyExistsException;
import software.amazon.awssdk.services.swf.model.TypeDeprecatedException;
import software.amazon.awssdk.services.swf.model.UndeprecateActivityTypeRequest;
import software.amazon.awssdk.services.swf.model.UndeprecateActivityTypeResponse;
import software.amazon.awssdk.services.swf.model.UndeprecateDomainRequest;
import software.amazon.awssdk.services.swf.model.UndeprecateDomainResponse;
import software.amazon.awssdk.services.swf.model.UndeprecateWorkflowTypeRequest;
import software.amazon.awssdk.services.swf.model.UndeprecateWorkflowTypeResponse;
import software.amazon.awssdk.services.swf.model.UnknownResourceException;
import software.amazon.awssdk.services.swf.model.UntagResourceRequest;
import software.amazon.awssdk.services.swf.model.UntagResourceResponse;
import software.amazon.awssdk.services.swf.model.WorkflowExecutionAlreadyStartedException;
import software.amazon.awssdk.services.swf.paginators.GetWorkflowExecutionHistoryIterable;
import software.amazon.awssdk.services.swf.paginators.ListActivityTypesIterable;
import software.amazon.awssdk.services.swf.paginators.ListClosedWorkflowExecutionsIterable;
import software.amazon.awssdk.services.swf.paginators.ListDomainsIterable;
import software.amazon.awssdk.services.swf.paginators.ListOpenWorkflowExecutionsIterable;
import software.amazon.awssdk.services.swf.paginators.ListWorkflowTypesIterable;
import software.amazon.awssdk.services.swf.paginators.PollForDecisionTaskIterable;

/**
 * Service client for accessing Amazon SWF. This can be created using the static {@link #builder()} method.
 *
 * <fullname>Amazon Simple Workflow Service</fullname>
 * <p>
 * The Amazon Simple Workflow Service (Amazon SWF) makes it easy to build applications that use Amazon's cloud to
 * coordinate work across distributed components. In Amazon SWF, a <i>task</i> represents a logical unit of work that is
 * performed by a component of your workflow. Coordinating tasks in a workflow involves managing intertask dependencies,
 * scheduling, and concurrency in accordance with the logical flow of the application.
 * </p>
 * <p>
 * Amazon SWF gives you full control over implementing tasks and coordinating them without worrying about underlying
 * complexities such as tracking their progress and maintaining their state.
 * </p>
 * <p>
 * This documentation serves as reference only. For a broader overview of the Amazon SWF programming model, see the <i>
 * <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/">Amazon SWF Developer Guide</a> </i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface SwfClient extends SdkClient {
    String SERVICE_NAME = "swf";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "swf";

    /**
     * <p>
     * Returns the number of closed workflow executions within the given domain that meet the specified filtering
     * criteria.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates
     * and changes.
     * </p>
     * </note>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * Constrain the following parameters by using a <code>Condition</code> element with the appropriate keys.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>tagFilter.tag</code>: String constraint. The key is <code>swf:tagFilter.tag</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>typeFilter.name</code>: String constraint. The key is <code>swf:typeFilter.name</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>typeFilter.version</code>: String constraint. The key is <code>swf:typeFilter.version</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     *
     * @param countClosedWorkflowExecutionsRequest
     * @return Result of the CountClosedWorkflowExecutions operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.CountClosedWorkflowExecutions
     */
    default CountClosedWorkflowExecutionsResponse countClosedWorkflowExecutions(
            CountClosedWorkflowExecutionsRequest countClosedWorkflowExecutionsRequest) throws UnknownResourceException,
            OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the number of closed workflow executions within the given domain that meet the specified filtering
     * criteria.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates
     * and changes.
     * </p>
     * </note>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * Constrain the following parameters by using a <code>Condition</code> element with the appropriate keys.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>tagFilter.tag</code>: String constraint. The key is <code>swf:tagFilter.tag</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>typeFilter.name</code>: String constraint. The key is <code>swf:typeFilter.name</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>typeFilter.version</code>: String constraint. The key is <code>swf:typeFilter.version</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CountClosedWorkflowExecutionsRequest.Builder}
     * avoiding the need to create one manually via {@link CountClosedWorkflowExecutionsRequest#builder()}
     * </p>
     *
     * @param countClosedWorkflowExecutionsRequest
     *        A {@link Consumer} that will call methods on {@link CountClosedWorkflowExecutionsInput.Builder} to create
     *        a request.
     * @return Result of the CountClosedWorkflowExecutions operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.CountClosedWorkflowExecutions
     */
    default CountClosedWorkflowExecutionsResponse countClosedWorkflowExecutions(
            Consumer<CountClosedWorkflowExecutionsRequest.Builder> countClosedWorkflowExecutionsRequest)
            throws UnknownResourceException, OperationNotPermittedException, AwsServiceException, SdkClientException,
            SwfException {
        return countClosedWorkflowExecutions(CountClosedWorkflowExecutionsRequest.builder()
                .applyMutation(countClosedWorkflowExecutionsRequest).build());
    }

    /**
     * <p>
     * Returns the number of open workflow executions within the given domain that meet the specified filtering
     * criteria.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates
     * and changes.
     * </p>
     * </note>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * Constrain the following parameters by using a <code>Condition</code> element with the appropriate keys.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>tagFilter.tag</code>: String constraint. The key is <code>swf:tagFilter.tag</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>typeFilter.name</code>: String constraint. The key is <code>swf:typeFilter.name</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>typeFilter.version</code>: String constraint. The key is <code>swf:typeFilter.version</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     *
     * @param countOpenWorkflowExecutionsRequest
     * @return Result of the CountOpenWorkflowExecutions operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.CountOpenWorkflowExecutions
     */
    default CountOpenWorkflowExecutionsResponse countOpenWorkflowExecutions(
            CountOpenWorkflowExecutionsRequest countOpenWorkflowExecutionsRequest) throws UnknownResourceException,
            OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the number of open workflow executions within the given domain that meet the specified filtering
     * criteria.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates
     * and changes.
     * </p>
     * </note>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * Constrain the following parameters by using a <code>Condition</code> element with the appropriate keys.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>tagFilter.tag</code>: String constraint. The key is <code>swf:tagFilter.tag</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>typeFilter.name</code>: String constraint. The key is <code>swf:typeFilter.name</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>typeFilter.version</code>: String constraint. The key is <code>swf:typeFilter.version</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CountOpenWorkflowExecutionsRequest.Builder}
     * avoiding the need to create one manually via {@link CountOpenWorkflowExecutionsRequest#builder()}
     * </p>
     *
     * @param countOpenWorkflowExecutionsRequest
     *        A {@link Consumer} that will call methods on {@link CountOpenWorkflowExecutionsInput.Builder} to create a
     *        request.
     * @return Result of the CountOpenWorkflowExecutions operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.CountOpenWorkflowExecutions
     */
    default CountOpenWorkflowExecutionsResponse countOpenWorkflowExecutions(
            Consumer<CountOpenWorkflowExecutionsRequest.Builder> countOpenWorkflowExecutionsRequest)
            throws UnknownResourceException, OperationNotPermittedException, AwsServiceException, SdkClientException,
            SwfException {
        return countOpenWorkflowExecutions(CountOpenWorkflowExecutionsRequest.builder()
                .applyMutation(countOpenWorkflowExecutionsRequest).build());
    }

    /**
     * <p>
     * Returns the estimated number of activity tasks in the specified task list. The count returned is an approximation
     * and isn't guaranteed to be exact. If you specify a task list that no activity task was ever scheduled in then
     * <code>0</code> is returned.
     * </p>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * Constrain the <code>taskList.name</code> parameter by using a <code>Condition</code> element with the
     * <code>swf:taskList.name</code> key to allow the action to access only certain task lists.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     *
     * @param countPendingActivityTasksRequest
     * @return Result of the CountPendingActivityTasks operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.CountPendingActivityTasks
     */
    default CountPendingActivityTasksResponse countPendingActivityTasks(
            CountPendingActivityTasksRequest countPendingActivityTasksRequest) throws UnknownResourceException,
            OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the estimated number of activity tasks in the specified task list. The count returned is an approximation
     * and isn't guaranteed to be exact. If you specify a task list that no activity task was ever scheduled in then
     * <code>0</code> is returned.
     * </p>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * Constrain the <code>taskList.name</code> parameter by using a <code>Condition</code> element with the
     * <code>swf:taskList.name</code> key to allow the action to access only certain task lists.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CountPendingActivityTasksRequest.Builder} avoiding
     * the need to create one manually via {@link CountPendingActivityTasksRequest#builder()}
     * </p>
     *
     * @param countPendingActivityTasksRequest
     *        A {@link Consumer} that will call methods on {@link CountPendingActivityTasksInput.Builder} to create a
     *        request.
     * @return Result of the CountPendingActivityTasks operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.CountPendingActivityTasks
     */
    default CountPendingActivityTasksResponse countPendingActivityTasks(
            Consumer<CountPendingActivityTasksRequest.Builder> countPendingActivityTasksRequest) throws UnknownResourceException,
            OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        return countPendingActivityTasks(CountPendingActivityTasksRequest.builder()
                .applyMutation(countPendingActivityTasksRequest).build());
    }

    /**
     * <p>
     * Returns the estimated number of decision tasks in the specified task list. The count returned is an approximation
     * and isn't guaranteed to be exact. If you specify a task list that no decision task was ever scheduled in then
     * <code>0</code> is returned.
     * </p>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * Constrain the <code>taskList.name</code> parameter by using a <code>Condition</code> element with the
     * <code>swf:taskList.name</code> key to allow the action to access only certain task lists.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     *
     * @param countPendingDecisionTasksRequest
     * @return Result of the CountPendingDecisionTasks operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.CountPendingDecisionTasks
     */
    default CountPendingDecisionTasksResponse countPendingDecisionTasks(
            CountPendingDecisionTasksRequest countPendingDecisionTasksRequest) throws UnknownResourceException,
            OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the estimated number of decision tasks in the specified task list. The count returned is an approximation
     * and isn't guaranteed to be exact. If you specify a task list that no decision task was ever scheduled in then
     * <code>0</code> is returned.
     * </p>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * Constrain the <code>taskList.name</code> parameter by using a <code>Condition</code> element with the
     * <code>swf:taskList.name</code> key to allow the action to access only certain task lists.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CountPendingDecisionTasksRequest.Builder} avoiding
     * the need to create one manually via {@link CountPendingDecisionTasksRequest#builder()}
     * </p>
     *
     * @param countPendingDecisionTasksRequest
     *        A {@link Consumer} that will call methods on {@link CountPendingDecisionTasksInput.Builder} to create a
     *        request.
     * @return Result of the CountPendingDecisionTasks operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.CountPendingDecisionTasks
     */
    default CountPendingDecisionTasksResponse countPendingDecisionTasks(
            Consumer<CountPendingDecisionTasksRequest.Builder> countPendingDecisionTasksRequest) throws UnknownResourceException,
            OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        return countPendingDecisionTasks(CountPendingDecisionTasksRequest.builder()
                .applyMutation(countPendingDecisionTasksRequest).build());
    }

    /**
     * <p>
     * Deprecates the specified <i>activity type</i>. After an activity type has been deprecated, you cannot create new
     * tasks of that activity type. Tasks of this type that were scheduled before the type was deprecated continue to
     * run.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates
     * and changes.
     * </p>
     * </note>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * Constrain the following parameters by using a <code>Condition</code> element with the appropriate keys.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>activityType.name</code>: String constraint. The key is <code>swf:activityType.name</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>activityType.version</code>: String constraint. The key is <code>swf:activityType.version</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     *
     * @param deprecateActivityTypeRequest
     * @return Result of the DeprecateActivityType operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws TypeDeprecatedException
     *         Returned when the specified activity or workflow type was already deprecated.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.DeprecateActivityType
     */
    default DeprecateActivityTypeResponse deprecateActivityType(DeprecateActivityTypeRequest deprecateActivityTypeRequest)
            throws UnknownResourceException, TypeDeprecatedException, OperationNotPermittedException, AwsServiceException,
            SdkClientException, SwfException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deprecates the specified <i>activity type</i>. After an activity type has been deprecated, you cannot create new
     * tasks of that activity type. Tasks of this type that were scheduled before the type was deprecated continue to
     * run.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates
     * and changes.
     * </p>
     * </note>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * Constrain the following parameters by using a <code>Condition</code> element with the appropriate keys.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>activityType.name</code>: String constraint. The key is <code>swf:activityType.name</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>activityType.version</code>: String constraint. The key is <code>swf:activityType.version</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeprecateActivityTypeRequest.Builder} avoiding the
     * need to create one manually via {@link DeprecateActivityTypeRequest#builder()}
     * </p>
     *
     * @param deprecateActivityTypeRequest
     *        A {@link Consumer} that will call methods on {@link DeprecateActivityTypeInput.Builder} to create a
     *        request.
     * @return Result of the DeprecateActivityType operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws TypeDeprecatedException
     *         Returned when the specified activity or workflow type was already deprecated.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.DeprecateActivityType
     */
    default DeprecateActivityTypeResponse deprecateActivityType(
            Consumer<DeprecateActivityTypeRequest.Builder> deprecateActivityTypeRequest) throws UnknownResourceException,
            TypeDeprecatedException, OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        return deprecateActivityType(DeprecateActivityTypeRequest.builder().applyMutation(deprecateActivityTypeRequest).build());
    }

    /**
     * <p>
     * Deprecates the specified domain. After a domain has been deprecated it cannot be used to create new workflow
     * executions or register new types. However, you can still use visibility actions on this domain. Deprecating a
     * domain also deprecates all activity and workflow types registered in the domain. Executions that were started
     * before the domain was deprecated continues to run.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates
     * and changes.
     * </p>
     * </note>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot use an IAM policy to constrain this action's parameters.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     *
     * @param deprecateDomainRequest
     * @return Result of the DeprecateDomain operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws DomainDeprecatedException
     *         Returned when the specified domain has been deprecated.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.DeprecateDomain
     */
    default DeprecateDomainResponse deprecateDomain(DeprecateDomainRequest deprecateDomainRequest)
            throws UnknownResourceException, DomainDeprecatedException, OperationNotPermittedException, AwsServiceException,
            SdkClientException, SwfException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deprecates the specified domain. After a domain has been deprecated it cannot be used to create new workflow
     * executions or register new types. However, you can still use visibility actions on this domain. Deprecating a
     * domain also deprecates all activity and workflow types registered in the domain. Executions that were started
     * before the domain was deprecated continues to run.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates
     * and changes.
     * </p>
     * </note>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot use an IAM policy to constrain this action's parameters.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeprecateDomainRequest.Builder} avoiding the need
     * to create one manually via {@link DeprecateDomainRequest#builder()}
     * </p>
     *
     * @param deprecateDomainRequest
     *        A {@link Consumer} that will call methods on {@link DeprecateDomainInput.Builder} to create a request.
     * @return Result of the DeprecateDomain operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws DomainDeprecatedException
     *         Returned when the specified domain has been deprecated.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.DeprecateDomain
     */
    default DeprecateDomainResponse deprecateDomain(Consumer<DeprecateDomainRequest.Builder> deprecateDomainRequest)
            throws UnknownResourceException, DomainDeprecatedException, OperationNotPermittedException, AwsServiceException,
            SdkClientException, SwfException {
        return deprecateDomain(DeprecateDomainRequest.builder().applyMutation(deprecateDomainRequest).build());
    }

    /**
     * <p>
     * Deprecates the specified <i>workflow type</i>. After a workflow type has been deprecated, you cannot create new
     * executions of that type. Executions that were started before the type was deprecated continues to run. A
     * deprecated workflow type may still be used when calling visibility actions.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates
     * and changes.
     * </p>
     * </note>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * Constrain the following parameters by using a <code>Condition</code> element with the appropriate keys.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>workflowType.name</code>: String constraint. The key is <code>swf:workflowType.name</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>workflowType.version</code>: String constraint. The key is <code>swf:workflowType.version</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     *
     * @param deprecateWorkflowTypeRequest
     * @return Result of the DeprecateWorkflowType operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws TypeDeprecatedException
     *         Returned when the specified activity or workflow type was already deprecated.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.DeprecateWorkflowType
     */
    default DeprecateWorkflowTypeResponse deprecateWorkflowType(DeprecateWorkflowTypeRequest deprecateWorkflowTypeRequest)
            throws UnknownResourceException, TypeDeprecatedException, OperationNotPermittedException, AwsServiceException,
            SdkClientException, SwfException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deprecates the specified <i>workflow type</i>. After a workflow type has been deprecated, you cannot create new
     * executions of that type. Executions that were started before the type was deprecated continues to run. A
     * deprecated workflow type may still be used when calling visibility actions.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates
     * and changes.
     * </p>
     * </note>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * Constrain the following parameters by using a <code>Condition</code> element with the appropriate keys.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>workflowType.name</code>: String constraint. The key is <code>swf:workflowType.name</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>workflowType.version</code>: String constraint. The key is <code>swf:workflowType.version</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeprecateWorkflowTypeRequest.Builder} avoiding the
     * need to create one manually via {@link DeprecateWorkflowTypeRequest#builder()}
     * </p>
     *
     * @param deprecateWorkflowTypeRequest
     *        A {@link Consumer} that will call methods on {@link DeprecateWorkflowTypeInput.Builder} to create a
     *        request.
     * @return Result of the DeprecateWorkflowType operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws TypeDeprecatedException
     *         Returned when the specified activity or workflow type was already deprecated.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.DeprecateWorkflowType
     */
    default DeprecateWorkflowTypeResponse deprecateWorkflowType(
            Consumer<DeprecateWorkflowTypeRequest.Builder> deprecateWorkflowTypeRequest) throws UnknownResourceException,
            TypeDeprecatedException, OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        return deprecateWorkflowType(DeprecateWorkflowTypeRequest.builder().applyMutation(deprecateWorkflowTypeRequest).build());
    }

    /**
     * <p>
     * Returns information about the specified activity type. This includes configuration settings provided when the
     * type was registered and other general information about the type.
     * </p>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * Constrain the following parameters by using a <code>Condition</code> element with the appropriate keys.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>activityType.name</code>: String constraint. The key is <code>swf:activityType.name</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>activityType.version</code>: String constraint. The key is <code>swf:activityType.version</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     *
     * @param describeActivityTypeRequest
     * @return Result of the DescribeActivityType operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.DescribeActivityType
     */
    default DescribeActivityTypeResponse describeActivityType(DescribeActivityTypeRequest describeActivityTypeRequest)
            throws UnknownResourceException, OperationNotPermittedException, AwsServiceException, SdkClientException,
            SwfException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the specified activity type. This includes configuration settings provided when the
     * type was registered and other general information about the type.
     * </p>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * Constrain the following parameters by using a <code>Condition</code> element with the appropriate keys.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>activityType.name</code>: String constraint. The key is <code>swf:activityType.name</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>activityType.version</code>: String constraint. The key is <code>swf:activityType.version</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeActivityTypeRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeActivityTypeRequest#builder()}
     * </p>
     *
     * @param describeActivityTypeRequest
     *        A {@link Consumer} that will call methods on {@link DescribeActivityTypeInput.Builder} to create a
     *        request.
     * @return Result of the DescribeActivityType operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.DescribeActivityType
     */
    default DescribeActivityTypeResponse describeActivityType(
            Consumer<DescribeActivityTypeRequest.Builder> describeActivityTypeRequest) throws UnknownResourceException,
            OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        return describeActivityType(DescribeActivityTypeRequest.builder().applyMutation(describeActivityTypeRequest).build());
    }

    /**
     * <p>
     * Returns information about the specified domain, including description and status.
     * </p>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot use an IAM policy to constrain this action's parameters.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     *
     * @param describeDomainRequest
     * @return Result of the DescribeDomain operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.DescribeDomain
     */
    default DescribeDomainResponse describeDomain(DescribeDomainRequest describeDomainRequest) throws UnknownResourceException,
            OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the specified domain, including description and status.
     * </p>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot use an IAM policy to constrain this action's parameters.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDomainRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeDomainRequest#builder()}
     * </p>
     *
     * @param describeDomainRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDomainInput.Builder} to create a request.
     * @return Result of the DescribeDomain operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.DescribeDomain
     */
    default DescribeDomainResponse describeDomain(Consumer<DescribeDomainRequest.Builder> describeDomainRequest)
            throws UnknownResourceException, OperationNotPermittedException, AwsServiceException, SdkClientException,
            SwfException {
        return describeDomain(DescribeDomainRequest.builder().applyMutation(describeDomainRequest).build());
    }

    /**
     * <p>
     * Returns information about the specified workflow execution including its type and some statistics.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates
     * and changes.
     * </p>
     * </note>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot use an IAM policy to constrain this action's parameters.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     *
     * @param describeWorkflowExecutionRequest
     * @return Result of the DescribeWorkflowExecution operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.DescribeWorkflowExecution
     */
    default DescribeWorkflowExecutionResponse describeWorkflowExecution(
            DescribeWorkflowExecutionRequest describeWorkflowExecutionRequest) throws UnknownResourceException,
            OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the specified workflow execution including its type and some statistics.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates
     * and changes.
     * </p>
     * </note>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot use an IAM policy to constrain this action's parameters.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorkflowExecutionRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeWorkflowExecutionRequest#builder()}
     * </p>
     *
     * @param describeWorkflowExecutionRequest
     *        A {@link Consumer} that will call methods on {@link DescribeWorkflowExecutionInput.Builder} to create a
     *        request.
     * @return Result of the DescribeWorkflowExecution operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.DescribeWorkflowExecution
     */
    default DescribeWorkflowExecutionResponse describeWorkflowExecution(
            Consumer<DescribeWorkflowExecutionRequest.Builder> describeWorkflowExecutionRequest) throws UnknownResourceException,
            OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        return describeWorkflowExecution(DescribeWorkflowExecutionRequest.builder()
                .applyMutation(describeWorkflowExecutionRequest).build());
    }

    /**
     * <p>
     * Returns information about the specified <i>workflow type</i>. This includes configuration settings specified when
     * the type was registered and other information such as creation date, current status, etc.
     * </p>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * Constrain the following parameters by using a <code>Condition</code> element with the appropriate keys.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>workflowType.name</code>: String constraint. The key is <code>swf:workflowType.name</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>workflowType.version</code>: String constraint. The key is <code>swf:workflowType.version</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     *
     * @param describeWorkflowTypeRequest
     * @return Result of the DescribeWorkflowType operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.DescribeWorkflowType
     */
    default DescribeWorkflowTypeResponse describeWorkflowType(DescribeWorkflowTypeRequest describeWorkflowTypeRequest)
            throws UnknownResourceException, OperationNotPermittedException, AwsServiceException, SdkClientException,
            SwfException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the specified <i>workflow type</i>. This includes configuration settings specified when
     * the type was registered and other information such as creation date, current status, etc.
     * </p>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * Constrain the following parameters by using a <code>Condition</code> element with the appropriate keys.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>workflowType.name</code>: String constraint. The key is <code>swf:workflowType.name</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>workflowType.version</code>: String constraint. The key is <code>swf:workflowType.version</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorkflowTypeRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeWorkflowTypeRequest#builder()}
     * </p>
     *
     * @param describeWorkflowTypeRequest
     *        A {@link Consumer} that will call methods on {@link DescribeWorkflowTypeInput.Builder} to create a
     *        request.
     * @return Result of the DescribeWorkflowType operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.DescribeWorkflowType
     */
    default DescribeWorkflowTypeResponse describeWorkflowType(
            Consumer<DescribeWorkflowTypeRequest.Builder> describeWorkflowTypeRequest) throws UnknownResourceException,
            OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        return describeWorkflowType(DescribeWorkflowTypeRequest.builder().applyMutation(describeWorkflowTypeRequest).build());
    }

    /**
     * <p>
     * Returns the history of the specified workflow execution. The results may be split into multiple pages. To
     * retrieve subsequent pages, make the call again using the <code>nextPageToken</code> returned by the initial call.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates
     * and changes.
     * </p>
     * </note>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot use an IAM policy to constrain this action's parameters.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     *
     * @param getWorkflowExecutionHistoryRequest
     * @return Result of the GetWorkflowExecutionHistory operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.GetWorkflowExecutionHistory
     */
    default GetWorkflowExecutionHistoryResponse getWorkflowExecutionHistory(
            GetWorkflowExecutionHistoryRequest getWorkflowExecutionHistoryRequest) throws UnknownResourceException,
            OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the history of the specified workflow execution. The results may be split into multiple pages. To
     * retrieve subsequent pages, make the call again using the <code>nextPageToken</code> returned by the initial call.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates
     * and changes.
     * </p>
     * </note>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot use an IAM policy to constrain this action's parameters.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorkflowExecutionHistoryRequest.Builder}
     * avoiding the need to create one manually via {@link GetWorkflowExecutionHistoryRequest#builder()}
     * </p>
     *
     * @param getWorkflowExecutionHistoryRequest
     *        A {@link Consumer} that will call methods on {@link GetWorkflowExecutionHistoryInput.Builder} to create a
     *        request.
     * @return Result of the GetWorkflowExecutionHistory operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.GetWorkflowExecutionHistory
     */
    default GetWorkflowExecutionHistoryResponse getWorkflowExecutionHistory(
            Consumer<GetWorkflowExecutionHistoryRequest.Builder> getWorkflowExecutionHistoryRequest)
            throws UnknownResourceException, OperationNotPermittedException, AwsServiceException, SdkClientException,
            SwfException {
        return getWorkflowExecutionHistory(GetWorkflowExecutionHistoryRequest.builder()
                .applyMutation(getWorkflowExecutionHistoryRequest).build());
    }

    /**
     * <p>
     * Returns the history of the specified workflow execution. The results may be split into multiple pages. To
     * retrieve subsequent pages, make the call again using the <code>nextPageToken</code> returned by the initial call.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates
     * and changes.
     * </p>
     * </note>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot use an IAM policy to constrain this action's parameters.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getWorkflowExecutionHistory(software.amazon.awssdk.services.swf.model.GetWorkflowExecutionHistoryRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.swf.paginators.GetWorkflowExecutionHistoryIterable responses = client.getWorkflowExecutionHistoryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.swf.paginators.GetWorkflowExecutionHistoryIterable responses = client
     *             .getWorkflowExecutionHistoryPaginator(request);
     *     for (software.amazon.awssdk.services.swf.model.GetWorkflowExecutionHistoryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.swf.paginators.GetWorkflowExecutionHistoryIterable responses = client.getWorkflowExecutionHistoryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maximumPageSize won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getWorkflowExecutionHistory(software.amazon.awssdk.services.swf.model.GetWorkflowExecutionHistoryRequest)}
     * operation.</b>
     * </p>
     *
     * @param getWorkflowExecutionHistoryRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.GetWorkflowExecutionHistory
     */
    default GetWorkflowExecutionHistoryIterable getWorkflowExecutionHistoryPaginator(
            GetWorkflowExecutionHistoryRequest getWorkflowExecutionHistoryRequest) throws UnknownResourceException,
            OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the history of the specified workflow execution. The results may be split into multiple pages. To
     * retrieve subsequent pages, make the call again using the <code>nextPageToken</code> returned by the initial call.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates
     * and changes.
     * </p>
     * </note>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot use an IAM policy to constrain this action's parameters.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getWorkflowExecutionHistory(software.amazon.awssdk.services.swf.model.GetWorkflowExecutionHistoryRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.swf.paginators.GetWorkflowExecutionHistoryIterable responses = client.getWorkflowExecutionHistoryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.swf.paginators.GetWorkflowExecutionHistoryIterable responses = client
     *             .getWorkflowExecutionHistoryPaginator(request);
     *     for (software.amazon.awssdk.services.swf.model.GetWorkflowExecutionHistoryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.swf.paginators.GetWorkflowExecutionHistoryIterable responses = client.getWorkflowExecutionHistoryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maximumPageSize won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getWorkflowExecutionHistory(software.amazon.awssdk.services.swf.model.GetWorkflowExecutionHistoryRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorkflowExecutionHistoryRequest.Builder}
     * avoiding the need to create one manually via {@link GetWorkflowExecutionHistoryRequest#builder()}
     * </p>
     *
     * @param getWorkflowExecutionHistoryRequest
     *        A {@link Consumer} that will call methods on {@link GetWorkflowExecutionHistoryInput.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.GetWorkflowExecutionHistory
     */
    default GetWorkflowExecutionHistoryIterable getWorkflowExecutionHistoryPaginator(
            Consumer<GetWorkflowExecutionHistoryRequest.Builder> getWorkflowExecutionHistoryRequest)
            throws UnknownResourceException, OperationNotPermittedException, AwsServiceException, SdkClientException,
            SwfException {
        return getWorkflowExecutionHistoryPaginator(GetWorkflowExecutionHistoryRequest.builder()
                .applyMutation(getWorkflowExecutionHistoryRequest).build());
    }

    /**
     * <p>
     * Returns information about all activities registered in the specified domain that match the specified name and
     * registration status. The result includes information like creation date, current status of the activity, etc. The
     * results may be split into multiple pages. To retrieve subsequent pages, make the call again using the
     * <code>nextPageToken</code> returned by the initial call.
     * </p>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot use an IAM policy to constrain this action's parameters.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     *
     * @param listActivityTypesRequest
     * @return Result of the ListActivityTypes operation returned by the service.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.ListActivityTypes
     */
    default ListActivityTypesResponse listActivityTypes(ListActivityTypesRequest listActivityTypesRequest)
            throws OperationNotPermittedException, UnknownResourceException, AwsServiceException, SdkClientException,
            SwfException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about all activities registered in the specified domain that match the specified name and
     * registration status. The result includes information like creation date, current status of the activity, etc. The
     * results may be split into multiple pages. To retrieve subsequent pages, make the call again using the
     * <code>nextPageToken</code> returned by the initial call.
     * </p>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot use an IAM policy to constrain this action's parameters.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListActivityTypesRequest.Builder} avoiding the need
     * to create one manually via {@link ListActivityTypesRequest#builder()}
     * </p>
     *
     * @param listActivityTypesRequest
     *        A {@link Consumer} that will call methods on {@link ListActivityTypesInput.Builder} to create a request.
     * @return Result of the ListActivityTypes operation returned by the service.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.ListActivityTypes
     */
    default ListActivityTypesResponse listActivityTypes(Consumer<ListActivityTypesRequest.Builder> listActivityTypesRequest)
            throws OperationNotPermittedException, UnknownResourceException, AwsServiceException, SdkClientException,
            SwfException {
        return listActivityTypes(ListActivityTypesRequest.builder().applyMutation(listActivityTypesRequest).build());
    }

    /**
     * <p>
     * Returns information about all activities registered in the specified domain that match the specified name and
     * registration status. The result includes information like creation date, current status of the activity, etc. The
     * results may be split into multiple pages. To retrieve subsequent pages, make the call again using the
     * <code>nextPageToken</code> returned by the initial call.
     * </p>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot use an IAM policy to constrain this action's parameters.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listActivityTypes(software.amazon.awssdk.services.swf.model.ListActivityTypesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.swf.paginators.ListActivityTypesIterable responses = client.listActivityTypesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.swf.paginators.ListActivityTypesIterable responses = client
     *             .listActivityTypesPaginator(request);
     *     for (software.amazon.awssdk.services.swf.model.ListActivityTypesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.swf.paginators.ListActivityTypesIterable responses = client.listActivityTypesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maximumPageSize won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listActivityTypes(software.amazon.awssdk.services.swf.model.ListActivityTypesRequest)} operation.</b>
     * </p>
     *
     * @param listActivityTypesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.ListActivityTypes
     */
    default ListActivityTypesIterable listActivityTypesPaginator(ListActivityTypesRequest listActivityTypesRequest)
            throws OperationNotPermittedException, UnknownResourceException, AwsServiceException, SdkClientException,
            SwfException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about all activities registered in the specified domain that match the specified name and
     * registration status. The result includes information like creation date, current status of the activity, etc. The
     * results may be split into multiple pages. To retrieve subsequent pages, make the call again using the
     * <code>nextPageToken</code> returned by the initial call.
     * </p>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot use an IAM policy to constrain this action's parameters.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listActivityTypes(software.amazon.awssdk.services.swf.model.ListActivityTypesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.swf.paginators.ListActivityTypesIterable responses = client.listActivityTypesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.swf.paginators.ListActivityTypesIterable responses = client
     *             .listActivityTypesPaginator(request);
     *     for (software.amazon.awssdk.services.swf.model.ListActivityTypesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.swf.paginators.ListActivityTypesIterable responses = client.listActivityTypesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maximumPageSize won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listActivityTypes(software.amazon.awssdk.services.swf.model.ListActivityTypesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListActivityTypesRequest.Builder} avoiding the need
     * to create one manually via {@link ListActivityTypesRequest#builder()}
     * </p>
     *
     * @param listActivityTypesRequest
     *        A {@link Consumer} that will call methods on {@link ListActivityTypesInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.ListActivityTypes
     */
    default ListActivityTypesIterable listActivityTypesPaginator(
            Consumer<ListActivityTypesRequest.Builder> listActivityTypesRequest) throws OperationNotPermittedException,
            UnknownResourceException, AwsServiceException, SdkClientException, SwfException {
        return listActivityTypesPaginator(ListActivityTypesRequest.builder().applyMutation(listActivityTypesRequest).build());
    }

    /**
     * <p>
     * Returns a list of closed workflow executions in the specified domain that meet the filtering criteria. The
     * results may be split into multiple pages. To retrieve subsequent pages, make the call again using the
     * nextPageToken returned by the initial call.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates
     * and changes.
     * </p>
     * </note>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * Constrain the following parameters by using a <code>Condition</code> element with the appropriate keys.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>tagFilter.tag</code>: String constraint. The key is <code>swf:tagFilter.tag</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>typeFilter.name</code>: String constraint. The key is <code>swf:typeFilter.name</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>typeFilter.version</code>: String constraint. The key is <code>swf:typeFilter.version</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     *
     * @param listClosedWorkflowExecutionsRequest
     * @return Result of the ListClosedWorkflowExecutions operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.ListClosedWorkflowExecutions
     */
    default ListClosedWorkflowExecutionsResponse listClosedWorkflowExecutions(
            ListClosedWorkflowExecutionsRequest listClosedWorkflowExecutionsRequest) throws UnknownResourceException,
            OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of closed workflow executions in the specified domain that meet the filtering criteria. The
     * results may be split into multiple pages. To retrieve subsequent pages, make the call again using the
     * nextPageToken returned by the initial call.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates
     * and changes.
     * </p>
     * </note>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * Constrain the following parameters by using a <code>Condition</code> element with the appropriate keys.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>tagFilter.tag</code>: String constraint. The key is <code>swf:tagFilter.tag</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>typeFilter.name</code>: String constraint. The key is <code>swf:typeFilter.name</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>typeFilter.version</code>: String constraint. The key is <code>swf:typeFilter.version</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListClosedWorkflowExecutionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListClosedWorkflowExecutionsRequest#builder()}
     * </p>
     *
     * @param listClosedWorkflowExecutionsRequest
     *        A {@link Consumer} that will call methods on {@link ListClosedWorkflowExecutionsInput.Builder} to create a
     *        request.
     * @return Result of the ListClosedWorkflowExecutions operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.ListClosedWorkflowExecutions
     */
    default ListClosedWorkflowExecutionsResponse listClosedWorkflowExecutions(
            Consumer<ListClosedWorkflowExecutionsRequest.Builder> listClosedWorkflowExecutionsRequest)
            throws UnknownResourceException, OperationNotPermittedException, AwsServiceException, SdkClientException,
            SwfException {
        return listClosedWorkflowExecutions(ListClosedWorkflowExecutionsRequest.builder()
                .applyMutation(listClosedWorkflowExecutionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of closed workflow executions in the specified domain that meet the filtering criteria. The
     * results may be split into multiple pages. To retrieve subsequent pages, make the call again using the
     * nextPageToken returned by the initial call.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates
     * and changes.
     * </p>
     * </note>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * Constrain the following parameters by using a <code>Condition</code> element with the appropriate keys.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>tagFilter.tag</code>: String constraint. The key is <code>swf:tagFilter.tag</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>typeFilter.name</code>: String constraint. The key is <code>swf:typeFilter.name</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>typeFilter.version</code>: String constraint. The key is <code>swf:typeFilter.version</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listClosedWorkflowExecutions(software.amazon.awssdk.services.swf.model.ListClosedWorkflowExecutionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.swf.paginators.ListClosedWorkflowExecutionsIterable responses = client.listClosedWorkflowExecutionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.swf.paginators.ListClosedWorkflowExecutionsIterable responses = client
     *             .listClosedWorkflowExecutionsPaginator(request);
     *     for (software.amazon.awssdk.services.swf.model.ListClosedWorkflowExecutionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.swf.paginators.ListClosedWorkflowExecutionsIterable responses = client.listClosedWorkflowExecutionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maximumPageSize won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClosedWorkflowExecutions(software.amazon.awssdk.services.swf.model.ListClosedWorkflowExecutionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listClosedWorkflowExecutionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.ListClosedWorkflowExecutions
     */
    default ListClosedWorkflowExecutionsIterable listClosedWorkflowExecutionsPaginator(
            ListClosedWorkflowExecutionsRequest listClosedWorkflowExecutionsRequest) throws UnknownResourceException,
            OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of closed workflow executions in the specified domain that meet the filtering criteria. The
     * results may be split into multiple pages. To retrieve subsequent pages, make the call again using the
     * nextPageToken returned by the initial call.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates
     * and changes.
     * </p>
     * </note>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * Constrain the following parameters by using a <code>Condition</code> element with the appropriate keys.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>tagFilter.tag</code>: String constraint. The key is <code>swf:tagFilter.tag</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>typeFilter.name</code>: String constraint. The key is <code>swf:typeFilter.name</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>typeFilter.version</code>: String constraint. The key is <code>swf:typeFilter.version</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listClosedWorkflowExecutions(software.amazon.awssdk.services.swf.model.ListClosedWorkflowExecutionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.swf.paginators.ListClosedWorkflowExecutionsIterable responses = client.listClosedWorkflowExecutionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.swf.paginators.ListClosedWorkflowExecutionsIterable responses = client
     *             .listClosedWorkflowExecutionsPaginator(request);
     *     for (software.amazon.awssdk.services.swf.model.ListClosedWorkflowExecutionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.swf.paginators.ListClosedWorkflowExecutionsIterable responses = client.listClosedWorkflowExecutionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maximumPageSize won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClosedWorkflowExecutions(software.amazon.awssdk.services.swf.model.ListClosedWorkflowExecutionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListClosedWorkflowExecutionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListClosedWorkflowExecutionsRequest#builder()}
     * </p>
     *
     * @param listClosedWorkflowExecutionsRequest
     *        A {@link Consumer} that will call methods on {@link ListClosedWorkflowExecutionsInput.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.ListClosedWorkflowExecutions
     */
    default ListClosedWorkflowExecutionsIterable listClosedWorkflowExecutionsPaginator(
            Consumer<ListClosedWorkflowExecutionsRequest.Builder> listClosedWorkflowExecutionsRequest)
            throws UnknownResourceException, OperationNotPermittedException, AwsServiceException, SdkClientException,
            SwfException {
        return listClosedWorkflowExecutionsPaginator(ListClosedWorkflowExecutionsRequest.builder()
                .applyMutation(listClosedWorkflowExecutionsRequest).build());
    }

    /**
     * <p>
     * Returns the list of domains registered in the account. The results may be split into multiple pages. To retrieve
     * subsequent pages, make the call again using the nextPageToken returned by the initial call.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates
     * and changes.
     * </p>
     * </note>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains. The
     * element must be set to <code>arn:aws:swf::AccountID:domain/*</code>, where <i>AccountID</i> is the account ID,
     * with no dashes.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot use an IAM policy to constrain this action's parameters.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     *
     * @param listDomainsRequest
     * @return Result of the ListDomains operation returned by the service.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.ListDomains
     */
    default ListDomainsResponse listDomains(ListDomainsRequest listDomainsRequest) throws OperationNotPermittedException,
            AwsServiceException, SdkClientException, SwfException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the list of domains registered in the account. The results may be split into multiple pages. To retrieve
     * subsequent pages, make the call again using the nextPageToken returned by the initial call.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates
     * and changes.
     * </p>
     * </note>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains. The
     * element must be set to <code>arn:aws:swf::AccountID:domain/*</code>, where <i>AccountID</i> is the account ID,
     * with no dashes.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot use an IAM policy to constrain this action's parameters.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDomainsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDomainsRequest#builder()}
     * </p>
     *
     * @param listDomainsRequest
     *        A {@link Consumer} that will call methods on {@link ListDomainsInput.Builder} to create a request.
     * @return Result of the ListDomains operation returned by the service.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.ListDomains
     */
    default ListDomainsResponse listDomains(Consumer<ListDomainsRequest.Builder> listDomainsRequest)
            throws OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        return listDomains(ListDomainsRequest.builder().applyMutation(listDomainsRequest).build());
    }

    /**
     * <p>
     * Returns the list of domains registered in the account. The results may be split into multiple pages. To retrieve
     * subsequent pages, make the call again using the nextPageToken returned by the initial call.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates
     * and changes.
     * </p>
     * </note>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains. The
     * element must be set to <code>arn:aws:swf::AccountID:domain/*</code>, where <i>AccountID</i> is the account ID,
     * with no dashes.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot use an IAM policy to constrain this action's parameters.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listDomains(software.amazon.awssdk.services.swf.model.ListDomainsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.swf.paginators.ListDomainsIterable responses = client.listDomainsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.swf.paginators.ListDomainsIterable responses = client.listDomainsPaginator(request);
     *     for (software.amazon.awssdk.services.swf.model.ListDomainsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.swf.paginators.ListDomainsIterable responses = client.listDomainsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maximumPageSize won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDomains(software.amazon.awssdk.services.swf.model.ListDomainsRequest)} operation.</b>
     * </p>
     *
     * @param listDomainsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.ListDomains
     */
    default ListDomainsIterable listDomainsPaginator(ListDomainsRequest listDomainsRequest)
            throws OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the list of domains registered in the account. The results may be split into multiple pages. To retrieve
     * subsequent pages, make the call again using the nextPageToken returned by the initial call.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates
     * and changes.
     * </p>
     * </note>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains. The
     * element must be set to <code>arn:aws:swf::AccountID:domain/*</code>, where <i>AccountID</i> is the account ID,
     * with no dashes.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot use an IAM policy to constrain this action's parameters.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listDomains(software.amazon.awssdk.services.swf.model.ListDomainsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.swf.paginators.ListDomainsIterable responses = client.listDomainsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.swf.paginators.ListDomainsIterable responses = client.listDomainsPaginator(request);
     *     for (software.amazon.awssdk.services.swf.model.ListDomainsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.swf.paginators.ListDomainsIterable responses = client.listDomainsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maximumPageSize won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDomains(software.amazon.awssdk.services.swf.model.ListDomainsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDomainsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDomainsRequest#builder()}
     * </p>
     *
     * @param listDomainsRequest
     *        A {@link Consumer} that will call methods on {@link ListDomainsInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.ListDomains
     */
    default ListDomainsIterable listDomainsPaginator(Consumer<ListDomainsRequest.Builder> listDomainsRequest)
            throws OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        return listDomainsPaginator(ListDomainsRequest.builder().applyMutation(listDomainsRequest).build());
    }

    /**
     * <p>
     * Returns a list of open workflow executions in the specified domain that meet the filtering criteria. The results
     * may be split into multiple pages. To retrieve subsequent pages, make the call again using the nextPageToken
     * returned by the initial call.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates
     * and changes.
     * </p>
     * </note>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * Constrain the following parameters by using a <code>Condition</code> element with the appropriate keys.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>tagFilter.tag</code>: String constraint. The key is <code>swf:tagFilter.tag</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>typeFilter.name</code>: String constraint. The key is <code>swf:typeFilter.name</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>typeFilter.version</code>: String constraint. The key is <code>swf:typeFilter.version</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     *
     * @param listOpenWorkflowExecutionsRequest
     * @return Result of the ListOpenWorkflowExecutions operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.ListOpenWorkflowExecutions
     */
    default ListOpenWorkflowExecutionsResponse listOpenWorkflowExecutions(
            ListOpenWorkflowExecutionsRequest listOpenWorkflowExecutionsRequest) throws UnknownResourceException,
            OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of open workflow executions in the specified domain that meet the filtering criteria. The results
     * may be split into multiple pages. To retrieve subsequent pages, make the call again using the nextPageToken
     * returned by the initial call.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates
     * and changes.
     * </p>
     * </note>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * Constrain the following parameters by using a <code>Condition</code> element with the appropriate keys.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>tagFilter.tag</code>: String constraint. The key is <code>swf:tagFilter.tag</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>typeFilter.name</code>: String constraint. The key is <code>swf:typeFilter.name</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>typeFilter.version</code>: String constraint. The key is <code>swf:typeFilter.version</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOpenWorkflowExecutionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListOpenWorkflowExecutionsRequest#builder()}
     * </p>
     *
     * @param listOpenWorkflowExecutionsRequest
     *        A {@link Consumer} that will call methods on {@link ListOpenWorkflowExecutionsInput.Builder} to create a
     *        request.
     * @return Result of the ListOpenWorkflowExecutions operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.ListOpenWorkflowExecutions
     */
    default ListOpenWorkflowExecutionsResponse listOpenWorkflowExecutions(
            Consumer<ListOpenWorkflowExecutionsRequest.Builder> listOpenWorkflowExecutionsRequest)
            throws UnknownResourceException, OperationNotPermittedException, AwsServiceException, SdkClientException,
            SwfException {
        return listOpenWorkflowExecutions(ListOpenWorkflowExecutionsRequest.builder()
                .applyMutation(listOpenWorkflowExecutionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of open workflow executions in the specified domain that meet the filtering criteria. The results
     * may be split into multiple pages. To retrieve subsequent pages, make the call again using the nextPageToken
     * returned by the initial call.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates
     * and changes.
     * </p>
     * </note>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * Constrain the following parameters by using a <code>Condition</code> element with the appropriate keys.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>tagFilter.tag</code>: String constraint. The key is <code>swf:tagFilter.tag</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>typeFilter.name</code>: String constraint. The key is <code>swf:typeFilter.name</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>typeFilter.version</code>: String constraint. The key is <code>swf:typeFilter.version</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listOpenWorkflowExecutions(software.amazon.awssdk.services.swf.model.ListOpenWorkflowExecutionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.swf.paginators.ListOpenWorkflowExecutionsIterable responses = client.listOpenWorkflowExecutionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.swf.paginators.ListOpenWorkflowExecutionsIterable responses = client
     *             .listOpenWorkflowExecutionsPaginator(request);
     *     for (software.amazon.awssdk.services.swf.model.ListOpenWorkflowExecutionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.swf.paginators.ListOpenWorkflowExecutionsIterable responses = client.listOpenWorkflowExecutionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maximumPageSize won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOpenWorkflowExecutions(software.amazon.awssdk.services.swf.model.ListOpenWorkflowExecutionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listOpenWorkflowExecutionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.ListOpenWorkflowExecutions
     */
    default ListOpenWorkflowExecutionsIterable listOpenWorkflowExecutionsPaginator(
            ListOpenWorkflowExecutionsRequest listOpenWorkflowExecutionsRequest) throws UnknownResourceException,
            OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of open workflow executions in the specified domain that meet the filtering criteria. The results
     * may be split into multiple pages. To retrieve subsequent pages, make the call again using the nextPageToken
     * returned by the initial call.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates
     * and changes.
     * </p>
     * </note>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * Constrain the following parameters by using a <code>Condition</code> element with the appropriate keys.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>tagFilter.tag</code>: String constraint. The key is <code>swf:tagFilter.tag</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>typeFilter.name</code>: String constraint. The key is <code>swf:typeFilter.name</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>typeFilter.version</code>: String constraint. The key is <code>swf:typeFilter.version</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listOpenWorkflowExecutions(software.amazon.awssdk.services.swf.model.ListOpenWorkflowExecutionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.swf.paginators.ListOpenWorkflowExecutionsIterable responses = client.listOpenWorkflowExecutionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.swf.paginators.ListOpenWorkflowExecutionsIterable responses = client
     *             .listOpenWorkflowExecutionsPaginator(request);
     *     for (software.amazon.awssdk.services.swf.model.ListOpenWorkflowExecutionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.swf.paginators.ListOpenWorkflowExecutionsIterable responses = client.listOpenWorkflowExecutionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maximumPageSize won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOpenWorkflowExecutions(software.amazon.awssdk.services.swf.model.ListOpenWorkflowExecutionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOpenWorkflowExecutionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListOpenWorkflowExecutionsRequest#builder()}
     * </p>
     *
     * @param listOpenWorkflowExecutionsRequest
     *        A {@link Consumer} that will call methods on {@link ListOpenWorkflowExecutionsInput.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.ListOpenWorkflowExecutions
     */
    default ListOpenWorkflowExecutionsIterable listOpenWorkflowExecutionsPaginator(
            Consumer<ListOpenWorkflowExecutionsRequest.Builder> listOpenWorkflowExecutionsRequest)
            throws UnknownResourceException, OperationNotPermittedException, AwsServiceException, SdkClientException,
            SwfException {
        return listOpenWorkflowExecutionsPaginator(ListOpenWorkflowExecutionsRequest.builder()
                .applyMutation(listOpenWorkflowExecutionsRequest).build());
    }

    /**
     * <p>
     * List tags for a given domain.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws LimitExceededException
     *         Returned by any operation if a system imposed limitation has been reached. To address this fault you
     *         should either clean up unused resources or increase the limit by contacting AWS.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.ListTagsForResource
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws UnknownResourceException, LimitExceededException, OperationNotPermittedException, AwsServiceException,
            SdkClientException, SwfException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List tags for a given domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceInput.Builder} to create a request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws LimitExceededException
     *         Returned by any operation if a system imposed limitation has been reached. To address this fault you
     *         should either clean up unused resources or increase the limit by contacting AWS.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.ListTagsForResource
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws UnknownResourceException,
            LimitExceededException, OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Returns information about workflow types in the specified domain. The results may be split into multiple pages
     * that can be retrieved by making the call repeatedly.
     * </p>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot use an IAM policy to constrain this action's parameters.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     *
     * @param listWorkflowTypesRequest
     * @return Result of the ListWorkflowTypes operation returned by the service.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.ListWorkflowTypes
     */
    default ListWorkflowTypesResponse listWorkflowTypes(ListWorkflowTypesRequest listWorkflowTypesRequest)
            throws OperationNotPermittedException, UnknownResourceException, AwsServiceException, SdkClientException,
            SwfException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about workflow types in the specified domain. The results may be split into multiple pages
     * that can be retrieved by making the call repeatedly.
     * </p>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot use an IAM policy to constrain this action's parameters.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkflowTypesRequest.Builder} avoiding the need
     * to create one manually via {@link ListWorkflowTypesRequest#builder()}
     * </p>
     *
     * @param listWorkflowTypesRequest
     *        A {@link Consumer} that will call methods on {@link ListWorkflowTypesInput.Builder} to create a request.
     * @return Result of the ListWorkflowTypes operation returned by the service.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.ListWorkflowTypes
     */
    default ListWorkflowTypesResponse listWorkflowTypes(Consumer<ListWorkflowTypesRequest.Builder> listWorkflowTypesRequest)
            throws OperationNotPermittedException, UnknownResourceException, AwsServiceException, SdkClientException,
            SwfException {
        return listWorkflowTypes(ListWorkflowTypesRequest.builder().applyMutation(listWorkflowTypesRequest).build());
    }

    /**
     * <p>
     * Returns information about workflow types in the specified domain. The results may be split into multiple pages
     * that can be retrieved by making the call repeatedly.
     * </p>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot use an IAM policy to constrain this action's parameters.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWorkflowTypes(software.amazon.awssdk.services.swf.model.ListWorkflowTypesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.swf.paginators.ListWorkflowTypesIterable responses = client.listWorkflowTypesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.swf.paginators.ListWorkflowTypesIterable responses = client
     *             .listWorkflowTypesPaginator(request);
     *     for (software.amazon.awssdk.services.swf.model.ListWorkflowTypesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.swf.paginators.ListWorkflowTypesIterable responses = client.listWorkflowTypesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maximumPageSize won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkflowTypes(software.amazon.awssdk.services.swf.model.ListWorkflowTypesRequest)} operation.</b>
     * </p>
     *
     * @param listWorkflowTypesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.ListWorkflowTypes
     */
    default ListWorkflowTypesIterable listWorkflowTypesPaginator(ListWorkflowTypesRequest listWorkflowTypesRequest)
            throws OperationNotPermittedException, UnknownResourceException, AwsServiceException, SdkClientException,
            SwfException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about workflow types in the specified domain. The results may be split into multiple pages
     * that can be retrieved by making the call repeatedly.
     * </p>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot use an IAM policy to constrain this action's parameters.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWorkflowTypes(software.amazon.awssdk.services.swf.model.ListWorkflowTypesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.swf.paginators.ListWorkflowTypesIterable responses = client.listWorkflowTypesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.swf.paginators.ListWorkflowTypesIterable responses = client
     *             .listWorkflowTypesPaginator(request);
     *     for (software.amazon.awssdk.services.swf.model.ListWorkflowTypesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.swf.paginators.ListWorkflowTypesIterable responses = client.listWorkflowTypesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maximumPageSize won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkflowTypes(software.amazon.awssdk.services.swf.model.ListWorkflowTypesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkflowTypesRequest.Builder} avoiding the need
     * to create one manually via {@link ListWorkflowTypesRequest#builder()}
     * </p>
     *
     * @param listWorkflowTypesRequest
     *        A {@link Consumer} that will call methods on {@link ListWorkflowTypesInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.ListWorkflowTypes
     */
    default ListWorkflowTypesIterable listWorkflowTypesPaginator(
            Consumer<ListWorkflowTypesRequest.Builder> listWorkflowTypesRequest) throws OperationNotPermittedException,
            UnknownResourceException, AwsServiceException, SdkClientException, SwfException {
        return listWorkflowTypesPaginator(ListWorkflowTypesRequest.builder().applyMutation(listWorkflowTypesRequest).build());
    }

    /**
     * <p>
     * Used by workers to get an <a>ActivityTask</a> from the specified activity <code>taskList</code>. This initiates a
     * long poll, where the service holds the HTTP connection open and responds as soon as a task becomes available. The
     * maximum time the service holds on to the request before responding is 60 seconds. If no task is available within
     * 60 seconds, the poll returns an empty result. An empty result, in this context, means that an ActivityTask is
     * returned, but that the value of taskToken is an empty string. If a task is returned, the worker should use its
     * type to identify and process it correctly.
     * </p>
     * <important>
     * <p>
     * Workers should set their client side socket timeout to at least 70 seconds (10 seconds higher than the maximum
     * time service may hold the poll request).
     * </p>
     * </important>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * Constrain the <code>taskList.name</code> parameter by using a <code>Condition</code> element with the
     * <code>swf:taskList.name</code> key to allow the action to access only certain task lists.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     *
     * @param pollForActivityTaskRequest
     * @return Result of the PollForActivityTask operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws LimitExceededException
     *         Returned by any operation if a system imposed limitation has been reached. To address this fault you
     *         should either clean up unused resources or increase the limit by contacting AWS.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.PollForActivityTask
     */
    default PollForActivityTaskResponse pollForActivityTask(PollForActivityTaskRequest pollForActivityTaskRequest)
            throws UnknownResourceException, OperationNotPermittedException, LimitExceededException, AwsServiceException,
            SdkClientException, SwfException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used by workers to get an <a>ActivityTask</a> from the specified activity <code>taskList</code>. This initiates a
     * long poll, where the service holds the HTTP connection open and responds as soon as a task becomes available. The
     * maximum time the service holds on to the request before responding is 60 seconds. If no task is available within
     * 60 seconds, the poll returns an empty result. An empty result, in this context, means that an ActivityTask is
     * returned, but that the value of taskToken is an empty string. If a task is returned, the worker should use its
     * type to identify and process it correctly.
     * </p>
     * <important>
     * <p>
     * Workers should set their client side socket timeout to at least 70 seconds (10 seconds higher than the maximum
     * time service may hold the poll request).
     * </p>
     * </important>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * Constrain the <code>taskList.name</code> parameter by using a <code>Condition</code> element with the
     * <code>swf:taskList.name</code> key to allow the action to access only certain task lists.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PollForActivityTaskRequest.Builder} avoiding the
     * need to create one manually via {@link PollForActivityTaskRequest#builder()}
     * </p>
     *
     * @param pollForActivityTaskRequest
     *        A {@link Consumer} that will call methods on {@link PollForActivityTaskInput.Builder} to create a request.
     * @return Result of the PollForActivityTask operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws LimitExceededException
     *         Returned by any operation if a system imposed limitation has been reached. To address this fault you
     *         should either clean up unused resources or increase the limit by contacting AWS.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.PollForActivityTask
     */
    default PollForActivityTaskResponse pollForActivityTask(
            Consumer<PollForActivityTaskRequest.Builder> pollForActivityTaskRequest) throws UnknownResourceException,
            OperationNotPermittedException, LimitExceededException, AwsServiceException, SdkClientException, SwfException {
        return pollForActivityTask(PollForActivityTaskRequest.builder().applyMutation(pollForActivityTaskRequest).build());
    }

    /**
     * <p>
     * Used by deciders to get a <a>DecisionTask</a> from the specified decision <code>taskList</code>. A decision task
     * may be returned for any open workflow execution that is using the specified task list. The task includes a
     * paginated view of the history of the workflow execution. The decider should use the workflow type and the history
     * to determine how to properly handle the task.
     * </p>
     * <p>
     * This action initiates a long poll, where the service holds the HTTP connection open and responds as soon a task
     * becomes available. If no decision task is available in the specified task list before the timeout of 60 seconds
     * expires, an empty result is returned. An empty result, in this context, means that a DecisionTask is returned,
     * but that the value of taskToken is an empty string.
     * </p>
     * <important>
     * <p>
     * Deciders should set their client side socket timeout to at least 70 seconds (10 seconds higher than the timeout).
     * </p>
     * </important> <important>
     * <p>
     * Because the number of workflow history events for a single workflow execution might be very large, the result
     * returned might be split up across a number of pages. To retrieve subsequent pages, make additional calls to
     * <code>PollForDecisionTask</code> using the <code>nextPageToken</code> returned by the initial call. Note that you
     * do <i>not</i> call <code>GetWorkflowExecutionHistory</code> with this <code>nextPageToken</code>. Instead, call
     * <code>PollForDecisionTask</code> again.
     * </p>
     * </important>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * Constrain the <code>taskList.name</code> parameter by using a <code>Condition</code> element with the
     * <code>swf:taskList.name</code> key to allow the action to access only certain task lists.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     *
     * @param pollForDecisionTaskRequest
     * @return Result of the PollForDecisionTask operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws LimitExceededException
     *         Returned by any operation if a system imposed limitation has been reached. To address this fault you
     *         should either clean up unused resources or increase the limit by contacting AWS.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.PollForDecisionTask
     */
    default PollForDecisionTaskResponse pollForDecisionTask(PollForDecisionTaskRequest pollForDecisionTaskRequest)
            throws UnknownResourceException, OperationNotPermittedException, LimitExceededException, AwsServiceException,
            SdkClientException, SwfException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used by deciders to get a <a>DecisionTask</a> from the specified decision <code>taskList</code>. A decision task
     * may be returned for any open workflow execution that is using the specified task list. The task includes a
     * paginated view of the history of the workflow execution. The decider should use the workflow type and the history
     * to determine how to properly handle the task.
     * </p>
     * <p>
     * This action initiates a long poll, where the service holds the HTTP connection open and responds as soon a task
     * becomes available. If no decision task is available in the specified task list before the timeout of 60 seconds
     * expires, an empty result is returned. An empty result, in this context, means that a DecisionTask is returned,
     * but that the value of taskToken is an empty string.
     * </p>
     * <important>
     * <p>
     * Deciders should set their client side socket timeout to at least 70 seconds (10 seconds higher than the timeout).
     * </p>
     * </important> <important>
     * <p>
     * Because the number of workflow history events for a single workflow execution might be very large, the result
     * returned might be split up across a number of pages. To retrieve subsequent pages, make additional calls to
     * <code>PollForDecisionTask</code> using the <code>nextPageToken</code> returned by the initial call. Note that you
     * do <i>not</i> call <code>GetWorkflowExecutionHistory</code> with this <code>nextPageToken</code>. Instead, call
     * <code>PollForDecisionTask</code> again.
     * </p>
     * </important>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * Constrain the <code>taskList.name</code> parameter by using a <code>Condition</code> element with the
     * <code>swf:taskList.name</code> key to allow the action to access only certain task lists.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PollForDecisionTaskRequest.Builder} avoiding the
     * need to create one manually via {@link PollForDecisionTaskRequest#builder()}
     * </p>
     *
     * @param pollForDecisionTaskRequest
     *        A {@link Consumer} that will call methods on {@link PollForDecisionTaskInput.Builder} to create a request.
     * @return Result of the PollForDecisionTask operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws LimitExceededException
     *         Returned by any operation if a system imposed limitation has been reached. To address this fault you
     *         should either clean up unused resources or increase the limit by contacting AWS.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.PollForDecisionTask
     */
    default PollForDecisionTaskResponse pollForDecisionTask(
            Consumer<PollForDecisionTaskRequest.Builder> pollForDecisionTaskRequest) throws UnknownResourceException,
            OperationNotPermittedException, LimitExceededException, AwsServiceException, SdkClientException, SwfException {
        return pollForDecisionTask(PollForDecisionTaskRequest.builder().applyMutation(pollForDecisionTaskRequest).build());
    }

    /**
     * <p>
     * Used by deciders to get a <a>DecisionTask</a> from the specified decision <code>taskList</code>. A decision task
     * may be returned for any open workflow execution that is using the specified task list. The task includes a
     * paginated view of the history of the workflow execution. The decider should use the workflow type and the history
     * to determine how to properly handle the task.
     * </p>
     * <p>
     * This action initiates a long poll, where the service holds the HTTP connection open and responds as soon a task
     * becomes available. If no decision task is available in the specified task list before the timeout of 60 seconds
     * expires, an empty result is returned. An empty result, in this context, means that a DecisionTask is returned,
     * but that the value of taskToken is an empty string.
     * </p>
     * <important>
     * <p>
     * Deciders should set their client side socket timeout to at least 70 seconds (10 seconds higher than the timeout).
     * </p>
     * </important> <important>
     * <p>
     * Because the number of workflow history events for a single workflow execution might be very large, the result
     * returned might be split up across a number of pages. To retrieve subsequent pages, make additional calls to
     * <code>PollForDecisionTask</code> using the <code>nextPageToken</code> returned by the initial call. Note that you
     * do <i>not</i> call <code>GetWorkflowExecutionHistory</code> with this <code>nextPageToken</code>. Instead, call
     * <code>PollForDecisionTask</code> again.
     * </p>
     * </important>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * Constrain the <code>taskList.name</code> parameter by using a <code>Condition</code> element with the
     * <code>swf:taskList.name</code> key to allow the action to access only certain task lists.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #pollForDecisionTask(software.amazon.awssdk.services.swf.model.PollForDecisionTaskRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.swf.paginators.PollForDecisionTaskIterable responses = client.pollForDecisionTaskPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.swf.paginators.PollForDecisionTaskIterable responses = client
     *             .pollForDecisionTaskPaginator(request);
     *     for (software.amazon.awssdk.services.swf.model.PollForDecisionTaskResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.swf.paginators.PollForDecisionTaskIterable responses = client.pollForDecisionTaskPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maximumPageSize won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #pollForDecisionTask(software.amazon.awssdk.services.swf.model.PollForDecisionTaskRequest)} operation.</b>
     * </p>
     *
     * @param pollForDecisionTaskRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws LimitExceededException
     *         Returned by any operation if a system imposed limitation has been reached. To address this fault you
     *         should either clean up unused resources or increase the limit by contacting AWS.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.PollForDecisionTask
     */
    default PollForDecisionTaskIterable pollForDecisionTaskPaginator(PollForDecisionTaskRequest pollForDecisionTaskRequest)
            throws UnknownResourceException, OperationNotPermittedException, LimitExceededException, AwsServiceException,
            SdkClientException, SwfException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used by deciders to get a <a>DecisionTask</a> from the specified decision <code>taskList</code>. A decision task
     * may be returned for any open workflow execution that is using the specified task list. The task includes a
     * paginated view of the history of the workflow execution. The decider should use the workflow type and the history
     * to determine how to properly handle the task.
     * </p>
     * <p>
     * This action initiates a long poll, where the service holds the HTTP connection open and responds as soon a task
     * becomes available. If no decision task is available in the specified task list before the timeout of 60 seconds
     * expires, an empty result is returned. An empty result, in this context, means that a DecisionTask is returned,
     * but that the value of taskToken is an empty string.
     * </p>
     * <important>
     * <p>
     * Deciders should set their client side socket timeout to at least 70 seconds (10 seconds higher than the timeout).
     * </p>
     * </important> <important>
     * <p>
     * Because the number of workflow history events for a single workflow execution might be very large, the result
     * returned might be split up across a number of pages. To retrieve subsequent pages, make additional calls to
     * <code>PollForDecisionTask</code> using the <code>nextPageToken</code> returned by the initial call. Note that you
     * do <i>not</i> call <code>GetWorkflowExecutionHistory</code> with this <code>nextPageToken</code>. Instead, call
     * <code>PollForDecisionTask</code> again.
     * </p>
     * </important>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * Constrain the <code>taskList.name</code> parameter by using a <code>Condition</code> element with the
     * <code>swf:taskList.name</code> key to allow the action to access only certain task lists.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #pollForDecisionTask(software.amazon.awssdk.services.swf.model.PollForDecisionTaskRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.swf.paginators.PollForDecisionTaskIterable responses = client.pollForDecisionTaskPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.swf.paginators.PollForDecisionTaskIterable responses = client
     *             .pollForDecisionTaskPaginator(request);
     *     for (software.amazon.awssdk.services.swf.model.PollForDecisionTaskResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.swf.paginators.PollForDecisionTaskIterable responses = client.pollForDecisionTaskPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maximumPageSize won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #pollForDecisionTask(software.amazon.awssdk.services.swf.model.PollForDecisionTaskRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link PollForDecisionTaskRequest.Builder} avoiding the
     * need to create one manually via {@link PollForDecisionTaskRequest#builder()}
     * </p>
     *
     * @param pollForDecisionTaskRequest
     *        A {@link Consumer} that will call methods on {@link PollForDecisionTaskInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws LimitExceededException
     *         Returned by any operation if a system imposed limitation has been reached. To address this fault you
     *         should either clean up unused resources or increase the limit by contacting AWS.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.PollForDecisionTask
     */
    default PollForDecisionTaskIterable pollForDecisionTaskPaginator(
            Consumer<PollForDecisionTaskRequest.Builder> pollForDecisionTaskRequest) throws UnknownResourceException,
            OperationNotPermittedException, LimitExceededException, AwsServiceException, SdkClientException, SwfException {
        return pollForDecisionTaskPaginator(PollForDecisionTaskRequest.builder().applyMutation(pollForDecisionTaskRequest)
                .build());
    }

    /**
     * <p>
     * Used by activity workers to report to the service that the <a>ActivityTask</a> represented by the specified
     * <code>taskToken</code> is still making progress. The worker can also specify details of the progress, for example
     * percent complete, using the <code>details</code> parameter. This action can also be used by the worker as a
     * mechanism to check if cancellation is being requested for the activity task. If a cancellation is being attempted
     * for the specified task, then the boolean <code>cancelRequested</code> flag returned by the service is set to
     * <code>true</code>.
     * </p>
     * <p>
     * This action resets the <code>taskHeartbeatTimeout</code> clock. The <code>taskHeartbeatTimeout</code> is
     * specified in <a>RegisterActivityType</a>.
     * </p>
     * <p>
     * This action doesn't in itself create an event in the workflow execution history. However, if the task times out,
     * the workflow execution history contains a <code>ActivityTaskTimedOut</code> event that contains the information
     * from the last heartbeat generated by the activity worker.
     * </p>
     * <note>
     * <p>
     * The <code>taskStartToCloseTimeout</code> of an activity type is the maximum duration of an activity task,
     * regardless of the number of <a>RecordActivityTaskHeartbeat</a> requests received. The
     * <code>taskStartToCloseTimeout</code> is also specified in <a>RegisterActivityType</a>.
     * </p>
     * </note> <note>
     * <p>
     * This operation is only useful for long-lived activities to report liveliness of the task and to determine if a
     * cancellation is being attempted.
     * </p>
     * </note> <important>
     * <p>
     * If the <code>cancelRequested</code> flag returns <code>true</code>, a cancellation is being attempted. If the
     * worker can cancel the activity, it should respond with <a>RespondActivityTaskCanceled</a>. Otherwise, it should
     * ignore the cancellation request.
     * </p>
     * </important>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot use an IAM policy to constrain this action's parameters.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     *
     * @param recordActivityTaskHeartbeatRequest
     * @return Result of the RecordActivityTaskHeartbeat operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.RecordActivityTaskHeartbeat
     */
    default RecordActivityTaskHeartbeatResponse recordActivityTaskHeartbeat(
            RecordActivityTaskHeartbeatRequest recordActivityTaskHeartbeatRequest) throws UnknownResourceException,
            OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used by activity workers to report to the service that the <a>ActivityTask</a> represented by the specified
     * <code>taskToken</code> is still making progress. The worker can also specify details of the progress, for example
     * percent complete, using the <code>details</code> parameter. This action can also be used by the worker as a
     * mechanism to check if cancellation is being requested for the activity task. If a cancellation is being attempted
     * for the specified task, then the boolean <code>cancelRequested</code> flag returned by the service is set to
     * <code>true</code>.
     * </p>
     * <p>
     * This action resets the <code>taskHeartbeatTimeout</code> clock. The <code>taskHeartbeatTimeout</code> is
     * specified in <a>RegisterActivityType</a>.
     * </p>
     * <p>
     * This action doesn't in itself create an event in the workflow execution history. However, if the task times out,
     * the workflow execution history contains a <code>ActivityTaskTimedOut</code> event that contains the information
     * from the last heartbeat generated by the activity worker.
     * </p>
     * <note>
     * <p>
     * The <code>taskStartToCloseTimeout</code> of an activity type is the maximum duration of an activity task,
     * regardless of the number of <a>RecordActivityTaskHeartbeat</a> requests received. The
     * <code>taskStartToCloseTimeout</code> is also specified in <a>RegisterActivityType</a>.
     * </p>
     * </note> <note>
     * <p>
     * This operation is only useful for long-lived activities to report liveliness of the task and to determine if a
     * cancellation is being attempted.
     * </p>
     * </note> <important>
     * <p>
     * If the <code>cancelRequested</code> flag returns <code>true</code>, a cancellation is being attempted. If the
     * worker can cancel the activity, it should respond with <a>RespondActivityTaskCanceled</a>. Otherwise, it should
     * ignore the cancellation request.
     * </p>
     * </important>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot use an IAM policy to constrain this action's parameters.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RecordActivityTaskHeartbeatRequest.Builder}
     * avoiding the need to create one manually via {@link RecordActivityTaskHeartbeatRequest#builder()}
     * </p>
     *
     * @param recordActivityTaskHeartbeatRequest
     *        A {@link Consumer} that will call methods on {@link RecordActivityTaskHeartbeatInput.Builder} to create a
     *        request.
     * @return Result of the RecordActivityTaskHeartbeat operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.RecordActivityTaskHeartbeat
     */
    default RecordActivityTaskHeartbeatResponse recordActivityTaskHeartbeat(
            Consumer<RecordActivityTaskHeartbeatRequest.Builder> recordActivityTaskHeartbeatRequest)
            throws UnknownResourceException, OperationNotPermittedException, AwsServiceException, SdkClientException,
            SwfException {
        return recordActivityTaskHeartbeat(RecordActivityTaskHeartbeatRequest.builder()
                .applyMutation(recordActivityTaskHeartbeatRequest).build());
    }

    /**
     * <p>
     * Registers a new <i>activity type</i> along with its configuration settings in the specified domain.
     * </p>
     * <important>
     * <p>
     * A <code>TypeAlreadyExists</code> fault is returned if the type already exists in the domain. You cannot change
     * any configuration settings of the type after its registration, and it must be registered as a new version.
     * </p>
     * </important>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * Constrain the following parameters by using a <code>Condition</code> element with the appropriate keys.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>defaultTaskList.name</code>: String constraint. The key is <code>swf:defaultTaskList.name</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>name</code>: String constraint. The key is <code>swf:name</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>version</code>: String constraint. The key is <code>swf:version</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     *
     * @param registerActivityTypeRequest
     * @return Result of the RegisterActivityType operation returned by the service.
     * @throws TypeAlreadyExistsException
     *         Returned if the type already exists in the specified domain. You may get this fault if you are
     *         registering a type that is either already registered or deprecated, or if you undeprecate a type that is
     *         currently registered.
     * @throws LimitExceededException
     *         Returned by any operation if a system imposed limitation has been reached. To address this fault you
     *         should either clean up unused resources or increase the limit by contacting AWS.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.RegisterActivityType
     */
    default RegisterActivityTypeResponse registerActivityType(RegisterActivityTypeRequest registerActivityTypeRequest)
            throws TypeAlreadyExistsException, LimitExceededException, UnknownResourceException, OperationNotPermittedException,
            AwsServiceException, SdkClientException, SwfException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers a new <i>activity type</i> along with its configuration settings in the specified domain.
     * </p>
     * <important>
     * <p>
     * A <code>TypeAlreadyExists</code> fault is returned if the type already exists in the domain. You cannot change
     * any configuration settings of the type after its registration, and it must be registered as a new version.
     * </p>
     * </important>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * Constrain the following parameters by using a <code>Condition</code> element with the appropriate keys.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>defaultTaskList.name</code>: String constraint. The key is <code>swf:defaultTaskList.name</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>name</code>: String constraint. The key is <code>swf:name</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>version</code>: String constraint. The key is <code>swf:version</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterActivityTypeRequest.Builder} avoiding the
     * need to create one manually via {@link RegisterActivityTypeRequest#builder()}
     * </p>
     *
     * @param registerActivityTypeRequest
     *        A {@link Consumer} that will call methods on {@link RegisterActivityTypeInput.Builder} to create a
     *        request.
     * @return Result of the RegisterActivityType operation returned by the service.
     * @throws TypeAlreadyExistsException
     *         Returned if the type already exists in the specified domain. You may get this fault if you are
     *         registering a type that is either already registered or deprecated, or if you undeprecate a type that is
     *         currently registered.
     * @throws LimitExceededException
     *         Returned by any operation if a system imposed limitation has been reached. To address this fault you
     *         should either clean up unused resources or increase the limit by contacting AWS.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.RegisterActivityType
     */
    default RegisterActivityTypeResponse registerActivityType(
            Consumer<RegisterActivityTypeRequest.Builder> registerActivityTypeRequest) throws TypeAlreadyExistsException,
            LimitExceededException, UnknownResourceException, OperationNotPermittedException, AwsServiceException,
            SdkClientException, SwfException {
        return registerActivityType(RegisterActivityTypeRequest.builder().applyMutation(registerActivityTypeRequest).build());
    }

    /**
     * <p>
     * Registers a new domain.
     * </p>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You cannot use an IAM policy to control domain access for this action. The name of the domain being registered is
     * available as the resource of this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot use an IAM policy to constrain this action's parameters.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     *
     * @param registerDomainRequest
     * @return Result of the RegisterDomain operation returned by the service.
     * @throws DomainAlreadyExistsException
     *         Returned if the domain already exists. You may get this fault if you are registering a domain that is
     *         either already registered or deprecated, or if you undeprecate a domain that is currently registered.
     * @throws LimitExceededException
     *         Returned by any operation if a system imposed limitation has been reached. To address this fault you
     *         should either clean up unused resources or increase the limit by contacting AWS.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws TooManyTagsException
     *         You've exceeded the number of tags allowed for a domain.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.RegisterDomain
     */
    default RegisterDomainResponse registerDomain(RegisterDomainRequest registerDomainRequest)
            throws DomainAlreadyExistsException, LimitExceededException, OperationNotPermittedException, TooManyTagsException,
            AwsServiceException, SdkClientException, SwfException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers a new domain.
     * </p>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You cannot use an IAM policy to control domain access for this action. The name of the domain being registered is
     * available as the resource of this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot use an IAM policy to constrain this action's parameters.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterDomainRequest.Builder} avoiding the need to
     * create one manually via {@link RegisterDomainRequest#builder()}
     * </p>
     *
     * @param registerDomainRequest
     *        A {@link Consumer} that will call methods on {@link RegisterDomainInput.Builder} to create a request.
     * @return Result of the RegisterDomain operation returned by the service.
     * @throws DomainAlreadyExistsException
     *         Returned if the domain already exists. You may get this fault if you are registering a domain that is
     *         either already registered or deprecated, or if you undeprecate a domain that is currently registered.
     * @throws LimitExceededException
     *         Returned by any operation if a system imposed limitation has been reached. To address this fault you
     *         should either clean up unused resources or increase the limit by contacting AWS.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws TooManyTagsException
     *         You've exceeded the number of tags allowed for a domain.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.RegisterDomain
     */
    default RegisterDomainResponse registerDomain(Consumer<RegisterDomainRequest.Builder> registerDomainRequest)
            throws DomainAlreadyExistsException, LimitExceededException, OperationNotPermittedException, TooManyTagsException,
            AwsServiceException, SdkClientException, SwfException {
        return registerDomain(RegisterDomainRequest.builder().applyMutation(registerDomainRequest).build());
    }

    /**
     * <p>
     * Registers a new <i>workflow type</i> and its configuration settings in the specified domain.
     * </p>
     * <p>
     * The retention period for the workflow history is set by the <a>RegisterDomain</a> action.
     * </p>
     * <important>
     * <p>
     * If the type already exists, then a <code>TypeAlreadyExists</code> fault is returned. You cannot change the
     * configuration settings of a workflow type once it is registered and it must be registered as a new version.
     * </p>
     * </important>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * Constrain the following parameters by using a <code>Condition</code> element with the appropriate keys.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>defaultTaskList.name</code>: String constraint. The key is <code>swf:defaultTaskList.name</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>name</code>: String constraint. The key is <code>swf:name</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>version</code>: String constraint. The key is <code>swf:version</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     *
     * @param registerWorkflowTypeRequest
     * @return Result of the RegisterWorkflowType operation returned by the service.
     * @throws TypeAlreadyExistsException
     *         Returned if the type already exists in the specified domain. You may get this fault if you are
     *         registering a type that is either already registered or deprecated, or if you undeprecate a type that is
     *         currently registered.
     * @throws LimitExceededException
     *         Returned by any operation if a system imposed limitation has been reached. To address this fault you
     *         should either clean up unused resources or increase the limit by contacting AWS.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.RegisterWorkflowType
     */
    default RegisterWorkflowTypeResponse registerWorkflowType(RegisterWorkflowTypeRequest registerWorkflowTypeRequest)
            throws TypeAlreadyExistsException, LimitExceededException, UnknownResourceException, OperationNotPermittedException,
            AwsServiceException, SdkClientException, SwfException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers a new <i>workflow type</i> and its configuration settings in the specified domain.
     * </p>
     * <p>
     * The retention period for the workflow history is set by the <a>RegisterDomain</a> action.
     * </p>
     * <important>
     * <p>
     * If the type already exists, then a <code>TypeAlreadyExists</code> fault is returned. You cannot change the
     * configuration settings of a workflow type once it is registered and it must be registered as a new version.
     * </p>
     * </important>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * Constrain the following parameters by using a <code>Condition</code> element with the appropriate keys.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>defaultTaskList.name</code>: String constraint. The key is <code>swf:defaultTaskList.name</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>name</code>: String constraint. The key is <code>swf:name</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>version</code>: String constraint. The key is <code>swf:version</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterWorkflowTypeRequest.Builder} avoiding the
     * need to create one manually via {@link RegisterWorkflowTypeRequest#builder()}
     * </p>
     *
     * @param registerWorkflowTypeRequest
     *        A {@link Consumer} that will call methods on {@link RegisterWorkflowTypeInput.Builder} to create a
     *        request.
     * @return Result of the RegisterWorkflowType operation returned by the service.
     * @throws TypeAlreadyExistsException
     *         Returned if the type already exists in the specified domain. You may get this fault if you are
     *         registering a type that is either already registered or deprecated, or if you undeprecate a type that is
     *         currently registered.
     * @throws LimitExceededException
     *         Returned by any operation if a system imposed limitation has been reached. To address this fault you
     *         should either clean up unused resources or increase the limit by contacting AWS.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.RegisterWorkflowType
     */
    default RegisterWorkflowTypeResponse registerWorkflowType(
            Consumer<RegisterWorkflowTypeRequest.Builder> registerWorkflowTypeRequest) throws TypeAlreadyExistsException,
            LimitExceededException, UnknownResourceException, OperationNotPermittedException, AwsServiceException,
            SdkClientException, SwfException {
        return registerWorkflowType(RegisterWorkflowTypeRequest.builder().applyMutation(registerWorkflowTypeRequest).build());
    }

    /**
     * <p>
     * Records a <code>WorkflowExecutionCancelRequested</code> event in the currently running workflow execution
     * identified by the given domain, workflowId, and runId. This logically requests the cancellation of the workflow
     * execution as a whole. It is up to the decider to take appropriate actions when it receives an execution history
     * with this event.
     * </p>
     * <note>
     * <p>
     * If the runId isn't specified, the <code>WorkflowExecutionCancelRequested</code> event is recorded in the history
     * of the current open workflow execution with the specified workflowId in the domain.
     * </p>
     * </note> <note>
     * <p>
     * Because this action allows the workflow to properly clean up and gracefully close, it should be used instead of
     * <a>TerminateWorkflowExecution</a> when possible.
     * </p>
     * </note>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot use an IAM policy to constrain this action's parameters.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     *
     * @param requestCancelWorkflowExecutionRequest
     * @return Result of the RequestCancelWorkflowExecution operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.RequestCancelWorkflowExecution
     */
    default RequestCancelWorkflowExecutionResponse requestCancelWorkflowExecution(
            RequestCancelWorkflowExecutionRequest requestCancelWorkflowExecutionRequest) throws UnknownResourceException,
            OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Records a <code>WorkflowExecutionCancelRequested</code> event in the currently running workflow execution
     * identified by the given domain, workflowId, and runId. This logically requests the cancellation of the workflow
     * execution as a whole. It is up to the decider to take appropriate actions when it receives an execution history
     * with this event.
     * </p>
     * <note>
     * <p>
     * If the runId isn't specified, the <code>WorkflowExecutionCancelRequested</code> event is recorded in the history
     * of the current open workflow execution with the specified workflowId in the domain.
     * </p>
     * </note> <note>
     * <p>
     * Because this action allows the workflow to properly clean up and gracefully close, it should be used instead of
     * <a>TerminateWorkflowExecution</a> when possible.
     * </p>
     * </note>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot use an IAM policy to constrain this action's parameters.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RequestCancelWorkflowExecutionRequest.Builder}
     * avoiding the need to create one manually via {@link RequestCancelWorkflowExecutionRequest#builder()}
     * </p>
     *
     * @param requestCancelWorkflowExecutionRequest
     *        A {@link Consumer} that will call methods on {@link RequestCancelWorkflowExecutionInput.Builder} to create
     *        a request.
     * @return Result of the RequestCancelWorkflowExecution operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.RequestCancelWorkflowExecution
     */
    default RequestCancelWorkflowExecutionResponse requestCancelWorkflowExecution(
            Consumer<RequestCancelWorkflowExecutionRequest.Builder> requestCancelWorkflowExecutionRequest)
            throws UnknownResourceException, OperationNotPermittedException, AwsServiceException, SdkClientException,
            SwfException {
        return requestCancelWorkflowExecution(RequestCancelWorkflowExecutionRequest.builder()
                .applyMutation(requestCancelWorkflowExecutionRequest).build());
    }

    /**
     * <p>
     * Used by workers to tell the service that the <a>ActivityTask</a> identified by the <code>taskToken</code> was
     * successfully canceled. Additional <code>details</code> can be provided using the <code>details</code> argument.
     * </p>
     * <p>
     * These <code>details</code> (if provided) appear in the <code>ActivityTaskCanceled</code> event added to the
     * workflow history.
     * </p>
     * <important>
     * <p>
     * Only use this operation if the <code>canceled</code> flag of a <a>RecordActivityTaskHeartbeat</a> request returns
     * <code>true</code> and if the activity can be safely undone or abandoned.
     * </p>
     * </important>
     * <p>
     * A task is considered open from the time that it is scheduled until it is closed. Therefore a task is reported as
     * open while a worker is processing it. A task is closed after it has been specified in a call to
     * <a>RespondActivityTaskCompleted</a>, RespondActivityTaskCanceled, <a>RespondActivityTaskFailed</a>, or the task
     * has <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-basic.html#swf-dev-timeout-types">timed
     * out</a>.
     * </p>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot use an IAM policy to constrain this action's parameters.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     *
     * @param respondActivityTaskCanceledRequest
     * @return Result of the RespondActivityTaskCanceled operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.RespondActivityTaskCanceled
     */
    default RespondActivityTaskCanceledResponse respondActivityTaskCanceled(
            RespondActivityTaskCanceledRequest respondActivityTaskCanceledRequest) throws UnknownResourceException,
            OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used by workers to tell the service that the <a>ActivityTask</a> identified by the <code>taskToken</code> was
     * successfully canceled. Additional <code>details</code> can be provided using the <code>details</code> argument.
     * </p>
     * <p>
     * These <code>details</code> (if provided) appear in the <code>ActivityTaskCanceled</code> event added to the
     * workflow history.
     * </p>
     * <important>
     * <p>
     * Only use this operation if the <code>canceled</code> flag of a <a>RecordActivityTaskHeartbeat</a> request returns
     * <code>true</code> and if the activity can be safely undone or abandoned.
     * </p>
     * </important>
     * <p>
     * A task is considered open from the time that it is scheduled until it is closed. Therefore a task is reported as
     * open while a worker is processing it. A task is closed after it has been specified in a call to
     * <a>RespondActivityTaskCompleted</a>, RespondActivityTaskCanceled, <a>RespondActivityTaskFailed</a>, or the task
     * has <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-basic.html#swf-dev-timeout-types">timed
     * out</a>.
     * </p>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot use an IAM policy to constrain this action's parameters.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RespondActivityTaskCanceledRequest.Builder}
     * avoiding the need to create one manually via {@link RespondActivityTaskCanceledRequest#builder()}
     * </p>
     *
     * @param respondActivityTaskCanceledRequest
     *        A {@link Consumer} that will call methods on {@link RespondActivityTaskCanceledInput.Builder} to create a
     *        request.
     * @return Result of the RespondActivityTaskCanceled operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.RespondActivityTaskCanceled
     */
    default RespondActivityTaskCanceledResponse respondActivityTaskCanceled(
            Consumer<RespondActivityTaskCanceledRequest.Builder> respondActivityTaskCanceledRequest)
            throws UnknownResourceException, OperationNotPermittedException, AwsServiceException, SdkClientException,
            SwfException {
        return respondActivityTaskCanceled(RespondActivityTaskCanceledRequest.builder()
                .applyMutation(respondActivityTaskCanceledRequest).build());
    }

    /**
     * <p>
     * Used by workers to tell the service that the <a>ActivityTask</a> identified by the <code>taskToken</code>
     * completed successfully with a <code>result</code> (if provided). The <code>result</code> appears in the
     * <code>ActivityTaskCompleted</code> event in the workflow history.
     * </p>
     * <important>
     * <p>
     * If the requested task doesn't complete successfully, use <a>RespondActivityTaskFailed</a> instead. If the worker
     * finds that the task is canceled through the <code>canceled</code> flag returned by
     * <a>RecordActivityTaskHeartbeat</a>, it should cancel the task, clean up and then call
     * <a>RespondActivityTaskCanceled</a>.
     * </p>
     * </important>
     * <p>
     * A task is considered open from the time that it is scheduled until it is closed. Therefore a task is reported as
     * open while a worker is processing it. A task is closed after it has been specified in a call to
     * RespondActivityTaskCompleted, <a>RespondActivityTaskCanceled</a>, <a>RespondActivityTaskFailed</a>, or the task
     * has <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-basic.html#swf-dev-timeout-types">timed
     * out</a>.
     * </p>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot use an IAM policy to constrain this action's parameters.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     *
     * @param respondActivityTaskCompletedRequest
     * @return Result of the RespondActivityTaskCompleted operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.RespondActivityTaskCompleted
     */
    default RespondActivityTaskCompletedResponse respondActivityTaskCompleted(
            RespondActivityTaskCompletedRequest respondActivityTaskCompletedRequest) throws UnknownResourceException,
            OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used by workers to tell the service that the <a>ActivityTask</a> identified by the <code>taskToken</code>
     * completed successfully with a <code>result</code> (if provided). The <code>result</code> appears in the
     * <code>ActivityTaskCompleted</code> event in the workflow history.
     * </p>
     * <important>
     * <p>
     * If the requested task doesn't complete successfully, use <a>RespondActivityTaskFailed</a> instead. If the worker
     * finds that the task is canceled through the <code>canceled</code> flag returned by
     * <a>RecordActivityTaskHeartbeat</a>, it should cancel the task, clean up and then call
     * <a>RespondActivityTaskCanceled</a>.
     * </p>
     * </important>
     * <p>
     * A task is considered open from the time that it is scheduled until it is closed. Therefore a task is reported as
     * open while a worker is processing it. A task is closed after it has been specified in a call to
     * RespondActivityTaskCompleted, <a>RespondActivityTaskCanceled</a>, <a>RespondActivityTaskFailed</a>, or the task
     * has <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-basic.html#swf-dev-timeout-types">timed
     * out</a>.
     * </p>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot use an IAM policy to constrain this action's parameters.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RespondActivityTaskCompletedRequest.Builder}
     * avoiding the need to create one manually via {@link RespondActivityTaskCompletedRequest#builder()}
     * </p>
     *
     * @param respondActivityTaskCompletedRequest
     *        A {@link Consumer} that will call methods on {@link RespondActivityTaskCompletedInput.Builder} to create a
     *        request.
     * @return Result of the RespondActivityTaskCompleted operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.RespondActivityTaskCompleted
     */
    default RespondActivityTaskCompletedResponse respondActivityTaskCompleted(
            Consumer<RespondActivityTaskCompletedRequest.Builder> respondActivityTaskCompletedRequest)
            throws UnknownResourceException, OperationNotPermittedException, AwsServiceException, SdkClientException,
            SwfException {
        return respondActivityTaskCompleted(RespondActivityTaskCompletedRequest.builder()
                .applyMutation(respondActivityTaskCompletedRequest).build());
    }

    /**
     * <p>
     * Used by workers to tell the service that the <a>ActivityTask</a> identified by the <code>taskToken</code> has
     * failed with <code>reason</code> (if specified). The <code>reason</code> and <code>details</code> appear in the
     * <code>ActivityTaskFailed</code> event added to the workflow history.
     * </p>
     * <p>
     * A task is considered open from the time that it is scheduled until it is closed. Therefore a task is reported as
     * open while a worker is processing it. A task is closed after it has been specified in a call to
     * <a>RespondActivityTaskCompleted</a>, <a>RespondActivityTaskCanceled</a>, RespondActivityTaskFailed, or the task
     * has <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-basic.html#swf-dev-timeout-types">timed
     * out</a>.
     * </p>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot use an IAM policy to constrain this action's parameters.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     *
     * @param respondActivityTaskFailedRequest
     * @return Result of the RespondActivityTaskFailed operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.RespondActivityTaskFailed
     */
    default RespondActivityTaskFailedResponse respondActivityTaskFailed(
            RespondActivityTaskFailedRequest respondActivityTaskFailedRequest) throws UnknownResourceException,
            OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used by workers to tell the service that the <a>ActivityTask</a> identified by the <code>taskToken</code> has
     * failed with <code>reason</code> (if specified). The <code>reason</code> and <code>details</code> appear in the
     * <code>ActivityTaskFailed</code> event added to the workflow history.
     * </p>
     * <p>
     * A task is considered open from the time that it is scheduled until it is closed. Therefore a task is reported as
     * open while a worker is processing it. A task is closed after it has been specified in a call to
     * <a>RespondActivityTaskCompleted</a>, <a>RespondActivityTaskCanceled</a>, RespondActivityTaskFailed, or the task
     * has <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-basic.html#swf-dev-timeout-types">timed
     * out</a>.
     * </p>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot use an IAM policy to constrain this action's parameters.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RespondActivityTaskFailedRequest.Builder} avoiding
     * the need to create one manually via {@link RespondActivityTaskFailedRequest#builder()}
     * </p>
     *
     * @param respondActivityTaskFailedRequest
     *        A {@link Consumer} that will call methods on {@link RespondActivityTaskFailedInput.Builder} to create a
     *        request.
     * @return Result of the RespondActivityTaskFailed operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.RespondActivityTaskFailed
     */
    default RespondActivityTaskFailedResponse respondActivityTaskFailed(
            Consumer<RespondActivityTaskFailedRequest.Builder> respondActivityTaskFailedRequest) throws UnknownResourceException,
            OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        return respondActivityTaskFailed(RespondActivityTaskFailedRequest.builder()
                .applyMutation(respondActivityTaskFailedRequest).build());
    }

    /**
     * <p>
     * Used by deciders to tell the service that the <a>DecisionTask</a> identified by the <code>taskToken</code> has
     * successfully completed. The <code>decisions</code> argument specifies the list of decisions made while processing
     * the task.
     * </p>
     * <p>
     * A <code>DecisionTaskCompleted</code> event is added to the workflow history. The <code>executionContext</code>
     * specified is attached to the event in the workflow execution history.
     * </p>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * If an IAM policy grants permission to use <code>RespondDecisionTaskCompleted</code>, it can express permissions
     * for the list of decisions in the <code>decisions</code> parameter. Each of the decisions has one or more
     * parameters, much like a regular API call. To allow for policies to be as readable as possible, you can express
     * permissions on decisions as if they were actual API calls, including applying conditions to some parameters. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     *
     * @param respondDecisionTaskCompletedRequest
     *        Input data for a TaskCompleted response to a decision task.
     * @return Result of the RespondDecisionTaskCompleted operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.RespondDecisionTaskCompleted
     */
    default RespondDecisionTaskCompletedResponse respondDecisionTaskCompleted(
            RespondDecisionTaskCompletedRequest respondDecisionTaskCompletedRequest) throws UnknownResourceException,
            OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used by deciders to tell the service that the <a>DecisionTask</a> identified by the <code>taskToken</code> has
     * successfully completed. The <code>decisions</code> argument specifies the list of decisions made while processing
     * the task.
     * </p>
     * <p>
     * A <code>DecisionTaskCompleted</code> event is added to the workflow history. The <code>executionContext</code>
     * specified is attached to the event in the workflow execution history.
     * </p>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * If an IAM policy grants permission to use <code>RespondDecisionTaskCompleted</code>, it can express permissions
     * for the list of decisions in the <code>decisions</code> parameter. Each of the decisions has one or more
     * parameters, much like a regular API call. To allow for policies to be as readable as possible, you can express
     * permissions on decisions as if they were actual API calls, including applying conditions to some parameters. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RespondDecisionTaskCompletedRequest.Builder}
     * avoiding the need to create one manually via {@link RespondDecisionTaskCompletedRequest#builder()}
     * </p>
     *
     * @param respondDecisionTaskCompletedRequest
     *        A {@link Consumer} that will call methods on {@link RespondDecisionTaskCompletedInput.Builder} to create a
     *        request. Input data for a TaskCompleted response to a decision task.
     * @return Result of the RespondDecisionTaskCompleted operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.RespondDecisionTaskCompleted
     */
    default RespondDecisionTaskCompletedResponse respondDecisionTaskCompleted(
            Consumer<RespondDecisionTaskCompletedRequest.Builder> respondDecisionTaskCompletedRequest)
            throws UnknownResourceException, OperationNotPermittedException, AwsServiceException, SdkClientException,
            SwfException {
        return respondDecisionTaskCompleted(RespondDecisionTaskCompletedRequest.builder()
                .applyMutation(respondDecisionTaskCompletedRequest).build());
    }

    /**
     * <p>
     * Records a <code>WorkflowExecutionSignaled</code> event in the workflow execution history and creates a decision
     * task for the workflow execution identified by the given domain, workflowId and runId. The event is recorded with
     * the specified user defined signalName and input (if provided).
     * </p>
     * <note>
     * <p>
     * If a runId isn't specified, then the <code>WorkflowExecutionSignaled</code> event is recorded in the history of
     * the current open workflow with the matching workflowId in the domain.
     * </p>
     * </note> <note>
     * <p>
     * If the specified workflow execution isn't open, this method fails with <code>UnknownResource</code>.
     * </p>
     * </note>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot use an IAM policy to constrain this action's parameters.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     *
     * @param signalWorkflowExecutionRequest
     * @return Result of the SignalWorkflowExecution operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.SignalWorkflowExecution
     */
    default SignalWorkflowExecutionResponse signalWorkflowExecution(SignalWorkflowExecutionRequest signalWorkflowExecutionRequest)
            throws UnknownResourceException, OperationNotPermittedException, AwsServiceException, SdkClientException,
            SwfException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Records a <code>WorkflowExecutionSignaled</code> event in the workflow execution history and creates a decision
     * task for the workflow execution identified by the given domain, workflowId and runId. The event is recorded with
     * the specified user defined signalName and input (if provided).
     * </p>
     * <note>
     * <p>
     * If a runId isn't specified, then the <code>WorkflowExecutionSignaled</code> event is recorded in the history of
     * the current open workflow with the matching workflowId in the domain.
     * </p>
     * </note> <note>
     * <p>
     * If the specified workflow execution isn't open, this method fails with <code>UnknownResource</code>.
     * </p>
     * </note>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot use an IAM policy to constrain this action's parameters.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SignalWorkflowExecutionRequest.Builder} avoiding
     * the need to create one manually via {@link SignalWorkflowExecutionRequest#builder()}
     * </p>
     *
     * @param signalWorkflowExecutionRequest
     *        A {@link Consumer} that will call methods on {@link SignalWorkflowExecutionInput.Builder} to create a
     *        request.
     * @return Result of the SignalWorkflowExecution operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.SignalWorkflowExecution
     */
    default SignalWorkflowExecutionResponse signalWorkflowExecution(
            Consumer<SignalWorkflowExecutionRequest.Builder> signalWorkflowExecutionRequest) throws UnknownResourceException,
            OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        return signalWorkflowExecution(SignalWorkflowExecutionRequest.builder().applyMutation(signalWorkflowExecutionRequest)
                .build());
    }

    /**
     * <p>
     * Starts an execution of the workflow type in the specified domain using the provided <code>workflowId</code> and
     * input data.
     * </p>
     * <p>
     * This action returns the newly started workflow execution.
     * </p>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * Constrain the following parameters by using a <code>Condition</code> element with the appropriate keys.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>tagList.member.0</code>: The key is <code>swf:tagList.member.0</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tagList.member.1</code>: The key is <code>swf:tagList.member.1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tagList.member.2</code>: The key is <code>swf:tagList.member.2</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tagList.member.3</code>: The key is <code>swf:tagList.member.3</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tagList.member.4</code>: The key is <code>swf:tagList.member.4</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>taskList</code>: String constraint. The key is <code>swf:taskList.name</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>workflowType.name</code>: String constraint. The key is <code>swf:workflowType.name</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>workflowType.version</code>: String constraint. The key is <code>swf:workflowType.version</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     *
     * @param startWorkflowExecutionRequest
     * @return Result of the StartWorkflowExecution operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws TypeDeprecatedException
     *         Returned when the specified activity or workflow type was already deprecated.
     * @throws WorkflowExecutionAlreadyStartedException
     *         Returned by <a>StartWorkflowExecution</a> when an open execution with the same workflowId is already
     *         running in the specified domain.
     * @throws LimitExceededException
     *         Returned by any operation if a system imposed limitation has been reached. To address this fault you
     *         should either clean up unused resources or increase the limit by contacting AWS.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws DefaultUndefinedException
     *         The <code>StartWorkflowExecution</code> API action was called without the required parameters set.</p>
     *         <p>
     *         Some workflow execution parameters, such as the decision <code>taskList</code>, must be set to start the
     *         execution. However, these parameters might have been set as defaults when the workflow type was
     *         registered. In this case, you can omit these parameters from the <code>StartWorkflowExecution</code> call
     *         and Amazon SWF uses the values defined in the workflow type.
     *         </p>
     *         <note>
     *         <p>
     *         If these parameters aren't set and no default parameters were defined in the workflow type, this error is
     *         displayed.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.StartWorkflowExecution
     */
    default StartWorkflowExecutionResponse startWorkflowExecution(StartWorkflowExecutionRequest startWorkflowExecutionRequest)
            throws UnknownResourceException, TypeDeprecatedException, WorkflowExecutionAlreadyStartedException,
            LimitExceededException, OperationNotPermittedException, DefaultUndefinedException, AwsServiceException,
            SdkClientException, SwfException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an execution of the workflow type in the specified domain using the provided <code>workflowId</code> and
     * input data.
     * </p>
     * <p>
     * This action returns the newly started workflow execution.
     * </p>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * Constrain the following parameters by using a <code>Condition</code> element with the appropriate keys.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>tagList.member.0</code>: The key is <code>swf:tagList.member.0</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tagList.member.1</code>: The key is <code>swf:tagList.member.1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tagList.member.2</code>: The key is <code>swf:tagList.member.2</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tagList.member.3</code>: The key is <code>swf:tagList.member.3</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tagList.member.4</code>: The key is <code>swf:tagList.member.4</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>taskList</code>: String constraint. The key is <code>swf:taskList.name</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>workflowType.name</code>: String constraint. The key is <code>swf:workflowType.name</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>workflowType.version</code>: String constraint. The key is <code>swf:workflowType.version</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartWorkflowExecutionRequest.Builder} avoiding the
     * need to create one manually via {@link StartWorkflowExecutionRequest#builder()}
     * </p>
     *
     * @param startWorkflowExecutionRequest
     *        A {@link Consumer} that will call methods on {@link StartWorkflowExecutionInput.Builder} to create a
     *        request.
     * @return Result of the StartWorkflowExecution operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws TypeDeprecatedException
     *         Returned when the specified activity or workflow type was already deprecated.
     * @throws WorkflowExecutionAlreadyStartedException
     *         Returned by <a>StartWorkflowExecution</a> when an open execution with the same workflowId is already
     *         running in the specified domain.
     * @throws LimitExceededException
     *         Returned by any operation if a system imposed limitation has been reached. To address this fault you
     *         should either clean up unused resources or increase the limit by contacting AWS.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws DefaultUndefinedException
     *         The <code>StartWorkflowExecution</code> API action was called without the required parameters set.</p>
     *         <p>
     *         Some workflow execution parameters, such as the decision <code>taskList</code>, must be set to start the
     *         execution. However, these parameters might have been set as defaults when the workflow type was
     *         registered. In this case, you can omit these parameters from the <code>StartWorkflowExecution</code> call
     *         and Amazon SWF uses the values defined in the workflow type.
     *         </p>
     *         <note>
     *         <p>
     *         If these parameters aren't set and no default parameters were defined in the workflow type, this error is
     *         displayed.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.StartWorkflowExecution
     */
    default StartWorkflowExecutionResponse startWorkflowExecution(
            Consumer<StartWorkflowExecutionRequest.Builder> startWorkflowExecutionRequest) throws UnknownResourceException,
            TypeDeprecatedException, WorkflowExecutionAlreadyStartedException, LimitExceededException,
            OperationNotPermittedException, DefaultUndefinedException, AwsServiceException, SdkClientException, SwfException {
        return startWorkflowExecution(StartWorkflowExecutionRequest.builder().applyMutation(startWorkflowExecutionRequest)
                .build());
    }

    /**
     * <p>
     * Add a tag to a Amazon SWF domain.
     * </p>
     * <note>
     * <p>
     * Amazon SWF supports a maximum of 50 tags per resource.
     * </p>
     * </note>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws TooManyTagsException
     *         You've exceeded the number of tags allowed for a domain.
     * @throws LimitExceededException
     *         Returned by any operation if a system imposed limitation has been reached. To address this fault you
     *         should either clean up unused resources or increase the limit by contacting AWS.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.TagResource
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws UnknownResourceException,
            TooManyTagsException, LimitExceededException, OperationNotPermittedException, AwsServiceException,
            SdkClientException, SwfException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Add a tag to a Amazon SWF domain.
     * </p>
     * <note>
     * <p>
     * Amazon SWF supports a maximum of 50 tags per resource.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceInput.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws TooManyTagsException
     *         You've exceeded the number of tags allowed for a domain.
     * @throws LimitExceededException
     *         Returned by any operation if a system imposed limitation has been reached. To address this fault you
     *         should either clean up unused resources or increase the limit by contacting AWS.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.TagResource
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws UnknownResourceException, TooManyTagsException, LimitExceededException, OperationNotPermittedException,
            AwsServiceException, SdkClientException, SwfException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Records a <code>WorkflowExecutionTerminated</code> event and forces closure of the workflow execution identified
     * by the given domain, runId, and workflowId. The child policy, registered with the workflow type or specified when
     * starting this execution, is applied to any open child workflow executions of this workflow execution.
     * </p>
     * <important>
     * <p>
     * If the identified workflow execution was in progress, it is terminated immediately.
     * </p>
     * </important> <note>
     * <p>
     * If a runId isn't specified, then the <code>WorkflowExecutionTerminated</code> event is recorded in the history of
     * the current open workflow with the matching workflowId in the domain.
     * </p>
     * </note> <note>
     * <p>
     * You should consider using <a>RequestCancelWorkflowExecution</a> action instead because it allows the workflow to
     * gracefully close while <a>TerminateWorkflowExecution</a> doesn't.
     * </p>
     * </note>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot use an IAM policy to constrain this action's parameters.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     *
     * @param terminateWorkflowExecutionRequest
     * @return Result of the TerminateWorkflowExecution operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.TerminateWorkflowExecution
     */
    default TerminateWorkflowExecutionResponse terminateWorkflowExecution(
            TerminateWorkflowExecutionRequest terminateWorkflowExecutionRequest) throws UnknownResourceException,
            OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Records a <code>WorkflowExecutionTerminated</code> event and forces closure of the workflow execution identified
     * by the given domain, runId, and workflowId. The child policy, registered with the workflow type or specified when
     * starting this execution, is applied to any open child workflow executions of this workflow execution.
     * </p>
     * <important>
     * <p>
     * If the identified workflow execution was in progress, it is terminated immediately.
     * </p>
     * </important> <note>
     * <p>
     * If a runId isn't specified, then the <code>WorkflowExecutionTerminated</code> event is recorded in the history of
     * the current open workflow with the matching workflowId in the domain.
     * </p>
     * </note> <note>
     * <p>
     * You should consider using <a>RequestCancelWorkflowExecution</a> action instead because it allows the workflow to
     * gracefully close while <a>TerminateWorkflowExecution</a> doesn't.
     * </p>
     * </note>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot use an IAM policy to constrain this action's parameters.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TerminateWorkflowExecutionRequest.Builder} avoiding
     * the need to create one manually via {@link TerminateWorkflowExecutionRequest#builder()}
     * </p>
     *
     * @param terminateWorkflowExecutionRequest
     *        A {@link Consumer} that will call methods on {@link TerminateWorkflowExecutionInput.Builder} to create a
     *        request.
     * @return Result of the TerminateWorkflowExecution operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.TerminateWorkflowExecution
     */
    default TerminateWorkflowExecutionResponse terminateWorkflowExecution(
            Consumer<TerminateWorkflowExecutionRequest.Builder> terminateWorkflowExecutionRequest)
            throws UnknownResourceException, OperationNotPermittedException, AwsServiceException, SdkClientException,
            SwfException {
        return terminateWorkflowExecution(TerminateWorkflowExecutionRequest.builder()
                .applyMutation(terminateWorkflowExecutionRequest).build());
    }

    /**
     * <p>
     * Undeprecates a previously deprecated <i>activity type</i>. After an activity type has been undeprecated, you can
     * create new tasks of that activity type.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates
     * and changes.
     * </p>
     * </note>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * Constrain the following parameters by using a <code>Condition</code> element with the appropriate keys.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>activityType.name</code>: String constraint. The key is <code>swf:activityType.name</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>activityType.version</code>: String constraint. The key is <code>swf:activityType.version</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     *
     * @param undeprecateActivityTypeRequest
     * @return Result of the UndeprecateActivityType operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws TypeAlreadyExistsException
     *         Returned if the type already exists in the specified domain. You may get this fault if you are
     *         registering a type that is either already registered or deprecated, or if you undeprecate a type that is
     *         currently registered.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.UndeprecateActivityType
     */
    default UndeprecateActivityTypeResponse undeprecateActivityType(UndeprecateActivityTypeRequest undeprecateActivityTypeRequest)
            throws UnknownResourceException, TypeAlreadyExistsException, OperationNotPermittedException, AwsServiceException,
            SdkClientException, SwfException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Undeprecates a previously deprecated <i>activity type</i>. After an activity type has been undeprecated, you can
     * create new tasks of that activity type.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates
     * and changes.
     * </p>
     * </note>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * Constrain the following parameters by using a <code>Condition</code> element with the appropriate keys.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>activityType.name</code>: String constraint. The key is <code>swf:activityType.name</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>activityType.version</code>: String constraint. The key is <code>swf:activityType.version</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UndeprecateActivityTypeRequest.Builder} avoiding
     * the need to create one manually via {@link UndeprecateActivityTypeRequest#builder()}
     * </p>
     *
     * @param undeprecateActivityTypeRequest
     *        A {@link Consumer} that will call methods on {@link UndeprecateActivityTypeInput.Builder} to create a
     *        request.
     * @return Result of the UndeprecateActivityType operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws TypeAlreadyExistsException
     *         Returned if the type already exists in the specified domain. You may get this fault if you are
     *         registering a type that is either already registered or deprecated, or if you undeprecate a type that is
     *         currently registered.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.UndeprecateActivityType
     */
    default UndeprecateActivityTypeResponse undeprecateActivityType(
            Consumer<UndeprecateActivityTypeRequest.Builder> undeprecateActivityTypeRequest) throws UnknownResourceException,
            TypeAlreadyExistsException, OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        return undeprecateActivityType(UndeprecateActivityTypeRequest.builder().applyMutation(undeprecateActivityTypeRequest)
                .build());
    }

    /**
     * <p>
     * Undeprecates a previously deprecated domain. After a domain has been undeprecated it can be used to create new
     * workflow executions or register new types.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates
     * and changes.
     * </p>
     * </note>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot use an IAM policy to constrain this action's parameters.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     *
     * @param undeprecateDomainRequest
     * @return Result of the UndeprecateDomain operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws DomainAlreadyExistsException
     *         Returned if the domain already exists. You may get this fault if you are registering a domain that is
     *         either already registered or deprecated, or if you undeprecate a domain that is currently registered.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.UndeprecateDomain
     */
    default UndeprecateDomainResponse undeprecateDomain(UndeprecateDomainRequest undeprecateDomainRequest)
            throws UnknownResourceException, DomainAlreadyExistsException, OperationNotPermittedException, AwsServiceException,
            SdkClientException, SwfException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Undeprecates a previously deprecated domain. After a domain has been undeprecated it can be used to create new
     * workflow executions or register new types.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates
     * and changes.
     * </p>
     * </note>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot use an IAM policy to constrain this action's parameters.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UndeprecateDomainRequest.Builder} avoiding the need
     * to create one manually via {@link UndeprecateDomainRequest#builder()}
     * </p>
     *
     * @param undeprecateDomainRequest
     *        A {@link Consumer} that will call methods on {@link UndeprecateDomainInput.Builder} to create a request.
     * @return Result of the UndeprecateDomain operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws DomainAlreadyExistsException
     *         Returned if the domain already exists. You may get this fault if you are registering a domain that is
     *         either already registered or deprecated, or if you undeprecate a domain that is currently registered.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.UndeprecateDomain
     */
    default UndeprecateDomainResponse undeprecateDomain(Consumer<UndeprecateDomainRequest.Builder> undeprecateDomainRequest)
            throws UnknownResourceException, DomainAlreadyExistsException, OperationNotPermittedException, AwsServiceException,
            SdkClientException, SwfException {
        return undeprecateDomain(UndeprecateDomainRequest.builder().applyMutation(undeprecateDomainRequest).build());
    }

    /**
     * <p>
     * Undeprecates a previously deprecated <i>workflow type</i>. After a workflow type has been undeprecated, you can
     * create new executions of that type.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates
     * and changes.
     * </p>
     * </note>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * Constrain the following parameters by using a <code>Condition</code> element with the appropriate keys.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>workflowType.name</code>: String constraint. The key is <code>swf:workflowType.name</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>workflowType.version</code>: String constraint. The key is <code>swf:workflowType.version</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     *
     * @param undeprecateWorkflowTypeRequest
     * @return Result of the UndeprecateWorkflowType operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws TypeAlreadyExistsException
     *         Returned if the type already exists in the specified domain. You may get this fault if you are
     *         registering a type that is either already registered or deprecated, or if you undeprecate a type that is
     *         currently registered.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.UndeprecateWorkflowType
     */
    default UndeprecateWorkflowTypeResponse undeprecateWorkflowType(UndeprecateWorkflowTypeRequest undeprecateWorkflowTypeRequest)
            throws UnknownResourceException, TypeAlreadyExistsException, OperationNotPermittedException, AwsServiceException,
            SdkClientException, SwfException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Undeprecates a previously deprecated <i>workflow type</i>. After a workflow type has been undeprecated, you can
     * create new executions of that type.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not exactly reflect recent updates
     * and changes.
     * </p>
     * </note>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an <code>Action</code> element to allow or deny permission to call this action.
     * </p>
     * </li>
     * <li>
     * <p>
     * Constrain the following parameters by using a <code>Condition</code> element with the appropriate keys.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>workflowType.name</code>: String constraint. The key is <code>swf:workflowType.name</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>workflowType.version</code>: String constraint. The key is <code>swf:workflowType.version</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <code>cause</code> parameter is set to
     * <code>OPERATION_NOT_PERMITTED</code>. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UndeprecateWorkflowTypeRequest.Builder} avoiding
     * the need to create one manually via {@link UndeprecateWorkflowTypeRequest#builder()}
     * </p>
     *
     * @param undeprecateWorkflowTypeRequest
     *        A {@link Consumer} that will call methods on {@link UndeprecateWorkflowTypeInput.Builder} to create a
     *        request.
     * @return Result of the UndeprecateWorkflowType operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws TypeAlreadyExistsException
     *         Returned if the type already exists in the specified domain. You may get this fault if you are
     *         registering a type that is either already registered or deprecated, or if you undeprecate a type that is
     *         currently registered.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.UndeprecateWorkflowType
     */
    default UndeprecateWorkflowTypeResponse undeprecateWorkflowType(
            Consumer<UndeprecateWorkflowTypeRequest.Builder> undeprecateWorkflowTypeRequest) throws UnknownResourceException,
            TypeAlreadyExistsException, OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        return undeprecateWorkflowType(UndeprecateWorkflowTypeRequest.builder().applyMutation(undeprecateWorkflowTypeRequest)
                .build());
    }

    /**
     * <p>
     * Remove a tag from a Amazon SWF domain.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws LimitExceededException
     *         Returned by any operation if a system imposed limitation has been reached. To address this fault you
     *         should either clean up unused resources or increase the limit by contacting AWS.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.UntagResource
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws UnknownResourceException,
            LimitExceededException, OperationNotPermittedException, AwsServiceException, SdkClientException, SwfException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove a tag from a Amazon SWF domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceInput.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws LimitExceededException
     *         Returned by any operation if a system imposed limitation has been reached. To address this fault you
     *         should either clean up unused resources or increase the limit by contacting AWS.
     * @throws OperationNotPermittedException
     *         Returned when the caller doesn't have sufficient permissions to invoke the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SwfException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SwfClient.UntagResource
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws UnknownResourceException, LimitExceededException, OperationNotPermittedException, AwsServiceException,
            SdkClientException, SwfException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * Create a {@link SwfClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SwfClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SwfClient}.
     */
    static SwfClientBuilder builder() {
        return new DefaultSwfClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }
}
