/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListOpenWorkflowExecutionsRequest extends SwfRequest implements
        ToCopyableBuilder<ListOpenWorkflowExecutionsRequest.Builder, ListOpenWorkflowExecutionsRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("domain")
            .getter(getter(ListOpenWorkflowExecutionsRequest::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domain").build()).build();

    private static final SdkField<ExecutionTimeFilter> START_TIME_FILTER_FIELD = SdkField
            .<ExecutionTimeFilter> builder(MarshallingType.SDK_POJO).memberName("startTimeFilter")
            .getter(getter(ListOpenWorkflowExecutionsRequest::startTimeFilter)).setter(setter(Builder::startTimeFilter))
            .constructor(ExecutionTimeFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTimeFilter").build()).build();

    private static final SdkField<WorkflowTypeFilter> TYPE_FILTER_FIELD = SdkField
            .<WorkflowTypeFilter> builder(MarshallingType.SDK_POJO).memberName("typeFilter")
            .getter(getter(ListOpenWorkflowExecutionsRequest::typeFilter)).setter(setter(Builder::typeFilter))
            .constructor(WorkflowTypeFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeFilter").build()).build();

    private static final SdkField<TagFilter> TAG_FILTER_FIELD = SdkField.<TagFilter> builder(MarshallingType.SDK_POJO)
            .memberName("tagFilter").getter(getter(ListOpenWorkflowExecutionsRequest::tagFilter))
            .setter(setter(Builder::tagFilter)).constructor(TagFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagFilter").build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextPageToken").getter(getter(ListOpenWorkflowExecutionsRequest::nextPageToken))
            .setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageToken").build()).build();

    private static final SdkField<Integer> MAXIMUM_PAGE_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maximumPageSize").getter(getter(ListOpenWorkflowExecutionsRequest::maximumPageSize))
            .setter(setter(Builder::maximumPageSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumPageSize").build()).build();

    private static final SdkField<Boolean> REVERSE_ORDER_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("reverseOrder").getter(getter(ListOpenWorkflowExecutionsRequest::reverseOrder))
            .setter(setter(Builder::reverseOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reverseOrder").build()).build();

    private static final SdkField<WorkflowExecutionFilter> EXECUTION_FILTER_FIELD = SdkField
            .<WorkflowExecutionFilter> builder(MarshallingType.SDK_POJO).memberName("executionFilter")
            .getter(getter(ListOpenWorkflowExecutionsRequest::executionFilter)).setter(setter(Builder::executionFilter))
            .constructor(WorkflowExecutionFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionFilter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD,
            START_TIME_FILTER_FIELD, TYPE_FILTER_FIELD, TAG_FILTER_FIELD, NEXT_PAGE_TOKEN_FIELD, MAXIMUM_PAGE_SIZE_FIELD,
            REVERSE_ORDER_FIELD, EXECUTION_FILTER_FIELD));

    private final String domain;

    private final ExecutionTimeFilter startTimeFilter;

    private final WorkflowTypeFilter typeFilter;

    private final TagFilter tagFilter;

    private final String nextPageToken;

    private final Integer maximumPageSize;

    private final Boolean reverseOrder;

    private final WorkflowExecutionFilter executionFilter;

    private ListOpenWorkflowExecutionsRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.startTimeFilter = builder.startTimeFilter;
        this.typeFilter = builder.typeFilter;
        this.tagFilter = builder.tagFilter;
        this.nextPageToken = builder.nextPageToken;
        this.maximumPageSize = builder.maximumPageSize;
        this.reverseOrder = builder.reverseOrder;
        this.executionFilter = builder.executionFilter;
    }

    /**
     * <p>
     * The name of the domain that contains the workflow executions to list.
     * </p>
     * 
     * @return The name of the domain that contains the workflow executions to list.
     */
    public final String domain() {
        return domain;
    }

    /**
     * <p>
     * Workflow executions are included in the returned results based on whether their start times are within the range
     * specified by this filter.
     * </p>
     * 
     * @return Workflow executions are included in the returned results based on whether their start times are within
     *         the range specified by this filter.
     */
    public final ExecutionTimeFilter startTimeFilter() {
        return startTimeFilter;
    }

    /**
     * <p>
     * If specified, only executions of the type specified in the filter are returned.
     * </p>
     * <note>
     * <p>
     * <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You can
     * specify at most one of these in a request.
     * </p>
     * </note>
     * 
     * @return If specified, only executions of the type specified in the filter are returned.</p> <note>
     *         <p>
     *         <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive.
     *         You can specify at most one of these in a request.
     *         </p>
     */
    public final WorkflowTypeFilter typeFilter() {
        return typeFilter;
    }

    /**
     * <p>
     * If specified, only executions that have the matching tag are listed.
     * </p>
     * <note>
     * <p>
     * <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You can
     * specify at most one of these in a request.
     * </p>
     * </note>
     * 
     * @return If specified, only executions that have the matching tag are listed.</p> <note>
     *         <p>
     *         <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive.
     *         You can specify at most one of these in a request.
     *         </p>
     */
    public final TagFilter tagFilter() {
        return tagFilter;
    }

    /**
     * <p>
     * If <code>NextPageToken</code> is returned there are more results available. The value of
     * <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using the returned
     * token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 60
     * seconds. Using an expired pagination token will return a <code>400</code> error: "
     * <code>Specified token has exceeded its maximum lifetime</code>".
     * </p>
     * <p>
     * The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.
     * </p>
     * 
     * @return If <code>NextPageToken</code> is returned there are more results available. The value of
     *         <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using the
     *         returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token
     *         expires after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "
     *         <code>Specified token has exceeded its maximum lifetime</code>". </p>
     *         <p>
     *         The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.
     */
    public final String nextPageToken() {
        return nextPageToken;
    }

    /**
     * <p>
     * The maximum number of results that are returned per call. Use <code>nextPageToken</code> to obtain further pages
     * of results.
     * </p>
     * 
     * @return The maximum number of results that are returned per call. Use <code>nextPageToken</code> to obtain
     *         further pages of results.
     */
    public final Integer maximumPageSize() {
        return maximumPageSize;
    }

    /**
     * <p>
     * When set to <code>true</code>, returns the results in reverse order. By default the results are returned in
     * descending order of the start time of the executions.
     * </p>
     * 
     * @return When set to <code>true</code>, returns the results in reverse order. By default the results are returned
     *         in descending order of the start time of the executions.
     */
    public final Boolean reverseOrder() {
        return reverseOrder;
    }

    /**
     * <p>
     * If specified, only workflow executions matching the workflow ID specified in the filter are returned.
     * </p>
     * <note>
     * <p>
     * <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You can
     * specify at most one of these in a request.
     * </p>
     * </note>
     * 
     * @return If specified, only workflow executions matching the workflow ID specified in the filter are returned.</p>
     *         <note>
     *         <p>
     *         <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive.
     *         You can specify at most one of these in a request.
     *         </p>
     */
    public final WorkflowExecutionFilter executionFilter() {
        return executionFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(startTimeFilter());
        hashCode = 31 * hashCode + Objects.hashCode(typeFilter());
        hashCode = 31 * hashCode + Objects.hashCode(tagFilter());
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        hashCode = 31 * hashCode + Objects.hashCode(maximumPageSize());
        hashCode = 31 * hashCode + Objects.hashCode(reverseOrder());
        hashCode = 31 * hashCode + Objects.hashCode(executionFilter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOpenWorkflowExecutionsRequest)) {
            return false;
        }
        ListOpenWorkflowExecutionsRequest other = (ListOpenWorkflowExecutionsRequest) obj;
        return Objects.equals(domain(), other.domain()) && Objects.equals(startTimeFilter(), other.startTimeFilter())
                && Objects.equals(typeFilter(), other.typeFilter()) && Objects.equals(tagFilter(), other.tagFilter())
                && Objects.equals(nextPageToken(), other.nextPageToken())
                && Objects.equals(maximumPageSize(), other.maximumPageSize())
                && Objects.equals(reverseOrder(), other.reverseOrder())
                && Objects.equals(executionFilter(), other.executionFilter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListOpenWorkflowExecutionsRequest").add("Domain", domain())
                .add("StartTimeFilter", startTimeFilter()).add("TypeFilter", typeFilter()).add("TagFilter", tagFilter())
                .add("NextPageToken", nextPageToken()).add("MaximumPageSize", maximumPageSize())
                .add("ReverseOrder", reverseOrder()).add("ExecutionFilter", executionFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "startTimeFilter":
            return Optional.ofNullable(clazz.cast(startTimeFilter()));
        case "typeFilter":
            return Optional.ofNullable(clazz.cast(typeFilter()));
        case "tagFilter":
            return Optional.ofNullable(clazz.cast(tagFilter()));
        case "nextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        case "maximumPageSize":
            return Optional.ofNullable(clazz.cast(maximumPageSize()));
        case "reverseOrder":
            return Optional.ofNullable(clazz.cast(reverseOrder()));
        case "executionFilter":
            return Optional.ofNullable(clazz.cast(executionFilter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListOpenWorkflowExecutionsRequest, T> g) {
        return obj -> g.apply((ListOpenWorkflowExecutionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SwfRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListOpenWorkflowExecutionsRequest> {
        /**
         * <p>
         * The name of the domain that contains the workflow executions to list.
         * </p>
         * 
         * @param domain
         *        The name of the domain that contains the workflow executions to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * Workflow executions are included in the returned results based on whether their start times are within the
         * range specified by this filter.
         * </p>
         * 
         * @param startTimeFilter
         *        Workflow executions are included in the returned results based on whether their start times are within
         *        the range specified by this filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimeFilter(ExecutionTimeFilter startTimeFilter);

        /**
         * <p>
         * Workflow executions are included in the returned results based on whether their start times are within the
         * range specified by this filter.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExecutionTimeFilter.Builder} avoiding the
         * need to create one manually via {@link ExecutionTimeFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExecutionTimeFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #startTimeFilter(ExecutionTimeFilter)}.
         * 
         * @param startTimeFilter
         *        a consumer that will call methods on {@link ExecutionTimeFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #startTimeFilter(ExecutionTimeFilter)
         */
        default Builder startTimeFilter(Consumer<ExecutionTimeFilter.Builder> startTimeFilter) {
            return startTimeFilter(ExecutionTimeFilter.builder().applyMutation(startTimeFilter).build());
        }

        /**
         * <p>
         * If specified, only executions of the type specified in the filter are returned.
         * </p>
         * <note>
         * <p>
         * <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You
         * can specify at most one of these in a request.
         * </p>
         * </note>
         * 
         * @param typeFilter
         *        If specified, only executions of the type specified in the filter are returned.</p> <note>
         *        <p>
         *        <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually
         *        exclusive. You can specify at most one of these in a request.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeFilter(WorkflowTypeFilter typeFilter);

        /**
         * <p>
         * If specified, only executions of the type specified in the filter are returned.
         * </p>
         * <note>
         * <p>
         * <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You
         * can specify at most one of these in a request.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link WorkflowTypeFilter.Builder}
         * avoiding the need to create one manually via {@link WorkflowTypeFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkflowTypeFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #typeFilter(WorkflowTypeFilter)}.
         * 
         * @param typeFilter
         *        a consumer that will call methods on {@link WorkflowTypeFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #typeFilter(WorkflowTypeFilter)
         */
        default Builder typeFilter(Consumer<WorkflowTypeFilter.Builder> typeFilter) {
            return typeFilter(WorkflowTypeFilter.builder().applyMutation(typeFilter).build());
        }

        /**
         * <p>
         * If specified, only executions that have the matching tag are listed.
         * </p>
         * <note>
         * <p>
         * <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You
         * can specify at most one of these in a request.
         * </p>
         * </note>
         * 
         * @param tagFilter
         *        If specified, only executions that have the matching tag are listed.</p> <note>
         *        <p>
         *        <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually
         *        exclusive. You can specify at most one of these in a request.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagFilter(TagFilter tagFilter);

        /**
         * <p>
         * If specified, only executions that have the matching tag are listed.
         * </p>
         * <note>
         * <p>
         * <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You
         * can specify at most one of these in a request.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link TagFilter.Builder} avoiding the
         * need to create one manually via {@link TagFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TagFilter.Builder#build()} is called immediately and its result
         * is passed to {@link #tagFilter(TagFilter)}.
         * 
         * @param tagFilter
         *        a consumer that will call methods on {@link TagFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagFilter(TagFilter)
         */
        default Builder tagFilter(Consumer<TagFilter.Builder> tagFilter) {
            return tagFilter(TagFilter.builder().applyMutation(tagFilter).build());
        }

        /**
         * <p>
         * If <code>NextPageToken</code> is returned there are more results available. The value of
         * <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using the returned
         * token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 60
         * seconds. Using an expired pagination token will return a <code>400</code> error: "
         * <code>Specified token has exceeded its maximum lifetime</code>".
         * </p>
         * <p>
         * The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.
         * </p>
         * 
         * @param nextPageToken
         *        If <code>NextPageToken</code> is returned there are more results available. The value of
         *        <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using the
         *        returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token
         *        expires after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "
         *        <code>Specified token has exceeded its maximum lifetime</code>". </p>
         *        <p>
         *        The configured <code>maximumPageSize</code> determines how many results can be returned in a single
         *        call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);

        /**
         * <p>
         * The maximum number of results that are returned per call. Use <code>nextPageToken</code> to obtain further
         * pages of results.
         * </p>
         * 
         * @param maximumPageSize
         *        The maximum number of results that are returned per call. Use <code>nextPageToken</code> to obtain
         *        further pages of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumPageSize(Integer maximumPageSize);

        /**
         * <p>
         * When set to <code>true</code>, returns the results in reverse order. By default the results are returned in
         * descending order of the start time of the executions.
         * </p>
         * 
         * @param reverseOrder
         *        When set to <code>true</code>, returns the results in reverse order. By default the results are
         *        returned in descending order of the start time of the executions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reverseOrder(Boolean reverseOrder);

        /**
         * <p>
         * If specified, only workflow executions matching the workflow ID specified in the filter are returned.
         * </p>
         * <note>
         * <p>
         * <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You
         * can specify at most one of these in a request.
         * </p>
         * </note>
         * 
         * @param executionFilter
         *        If specified, only workflow executions matching the workflow ID specified in the filter are
         *        returned.</p> <note>
         *        <p>
         *        <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually
         *        exclusive. You can specify at most one of these in a request.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionFilter(WorkflowExecutionFilter executionFilter);

        /**
         * <p>
         * If specified, only workflow executions matching the workflow ID specified in the filter are returned.
         * </p>
         * <note>
         * <p>
         * <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You
         * can specify at most one of these in a request.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link WorkflowExecutionFilter.Builder}
         * avoiding the need to create one manually via {@link WorkflowExecutionFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkflowExecutionFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #executionFilter(WorkflowExecutionFilter)}.
         * 
         * @param executionFilter
         *        a consumer that will call methods on {@link WorkflowExecutionFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executionFilter(WorkflowExecutionFilter)
         */
        default Builder executionFilter(Consumer<WorkflowExecutionFilter.Builder> executionFilter) {
            return executionFilter(WorkflowExecutionFilter.builder().applyMutation(executionFilter).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SwfRequest.BuilderImpl implements Builder {
        private String domain;

        private ExecutionTimeFilter startTimeFilter;

        private WorkflowTypeFilter typeFilter;

        private TagFilter tagFilter;

        private String nextPageToken;

        private Integer maximumPageSize;

        private Boolean reverseOrder;

        private WorkflowExecutionFilter executionFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOpenWorkflowExecutionsRequest model) {
            super(model);
            domain(model.domain);
            startTimeFilter(model.startTimeFilter);
            typeFilter(model.typeFilter);
            tagFilter(model.tagFilter);
            nextPageToken(model.nextPageToken);
            maximumPageSize(model.maximumPageSize);
            reverseOrder(model.reverseOrder);
            executionFilter(model.executionFilter);
        }

        public final String getDomain() {
            return domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final ExecutionTimeFilter.Builder getStartTimeFilter() {
            return startTimeFilter != null ? startTimeFilter.toBuilder() : null;
        }

        public final void setStartTimeFilter(ExecutionTimeFilter.BuilderImpl startTimeFilter) {
            this.startTimeFilter = startTimeFilter != null ? startTimeFilter.build() : null;
        }

        @Override
        public final Builder startTimeFilter(ExecutionTimeFilter startTimeFilter) {
            this.startTimeFilter = startTimeFilter;
            return this;
        }

        public final WorkflowTypeFilter.Builder getTypeFilter() {
            return typeFilter != null ? typeFilter.toBuilder() : null;
        }

        public final void setTypeFilter(WorkflowTypeFilter.BuilderImpl typeFilter) {
            this.typeFilter = typeFilter != null ? typeFilter.build() : null;
        }

        @Override
        public final Builder typeFilter(WorkflowTypeFilter typeFilter) {
            this.typeFilter = typeFilter;
            return this;
        }

        public final TagFilter.Builder getTagFilter() {
            return tagFilter != null ? tagFilter.toBuilder() : null;
        }

        public final void setTagFilter(TagFilter.BuilderImpl tagFilter) {
            this.tagFilter = tagFilter != null ? tagFilter.build() : null;
        }

        @Override
        public final Builder tagFilter(TagFilter tagFilter) {
            this.tagFilter = tagFilter;
            return this;
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final Integer getMaximumPageSize() {
            return maximumPageSize;
        }

        public final void setMaximumPageSize(Integer maximumPageSize) {
            this.maximumPageSize = maximumPageSize;
        }

        @Override
        public final Builder maximumPageSize(Integer maximumPageSize) {
            this.maximumPageSize = maximumPageSize;
            return this;
        }

        public final Boolean getReverseOrder() {
            return reverseOrder;
        }

        public final void setReverseOrder(Boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
        }

        @Override
        public final Builder reverseOrder(Boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
            return this;
        }

        public final WorkflowExecutionFilter.Builder getExecutionFilter() {
            return executionFilter != null ? executionFilter.toBuilder() : null;
        }

        public final void setExecutionFilter(WorkflowExecutionFilter.BuilderImpl executionFilter) {
            this.executionFilter = executionFilter != null ? executionFilter.build() : null;
        }

        @Override
        public final Builder executionFilter(WorkflowExecutionFilter executionFilter) {
            this.executionFilter = executionFilter;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListOpenWorkflowExecutionsRequest build() {
            return new ListOpenWorkflowExecutionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
