/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CloseStatus {
    COMPLETED("COMPLETED"),
    FAILED("FAILED"),
    CANCELED("CANCELED"),
    TERMINATED("TERMINATED"),
    CONTINUED_AS_NEW("CONTINUED_AS_NEW"),
    TIMED_OUT("TIMED_OUT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CloseStatus> VALUE_MAP;
    private final String value;

    private CloseStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CloseStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CloseStatus> knownValues() {
        EnumSet<CloseStatus> knownValues = EnumSet.allOf(CloseStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CloseStatus.class, CloseStatus::toString);
    }
}

