/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.swf.model.RegistrationStatus;
import software.amazon.awssdk.services.swf.model.SwfRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWorkflowTypesRequest
extends SwfRequest
implements ToCopyableBuilder<Builder, ListWorkflowTypesRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domain").getter(ListWorkflowTypesRequest.getter(ListWorkflowTypesRequest::domain)).setter(ListWorkflowTypesRequest.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domain").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ListWorkflowTypesRequest.getter(ListWorkflowTypesRequest::name)).setter(ListWorkflowTypesRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> REGISTRATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("registrationStatus").getter(ListWorkflowTypesRequest.getter(ListWorkflowTypesRequest::registrationStatusAsString)).setter(ListWorkflowTypesRequest.setter(Builder::registrationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registrationStatus").build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextPageToken").getter(ListWorkflowTypesRequest.getter(ListWorkflowTypesRequest::nextPageToken)).setter(ListWorkflowTypesRequest.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageToken").build()}).build();
    private static final SdkField<Integer> MAXIMUM_PAGE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maximumPageSize").getter(ListWorkflowTypesRequest.getter(ListWorkflowTypesRequest::maximumPageSize)).setter(ListWorkflowTypesRequest.setter(Builder::maximumPageSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumPageSize").build()}).build();
    private static final SdkField<Boolean> REVERSE_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("reverseOrder").getter(ListWorkflowTypesRequest.getter(ListWorkflowTypesRequest::reverseOrder)).setter(ListWorkflowTypesRequest.setter(Builder::reverseOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reverseOrder").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD, NAME_FIELD, REGISTRATION_STATUS_FIELD, NEXT_PAGE_TOKEN_FIELD, MAXIMUM_PAGE_SIZE_FIELD, REVERSE_ORDER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("domain", DOMAIN_FIELD);
            this.put("name", NAME_FIELD);
            this.put("registrationStatus", REGISTRATION_STATUS_FIELD);
            this.put("nextPageToken", NEXT_PAGE_TOKEN_FIELD);
            this.put("maximumPageSize", MAXIMUM_PAGE_SIZE_FIELD);
            this.put("reverseOrder", REVERSE_ORDER_FIELD);
        }
    });
    private final String domain;
    private final String name;
    private final String registrationStatus;
    private final String nextPageToken;
    private final Integer maximumPageSize;
    private final Boolean reverseOrder;

    private ListWorkflowTypesRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.name = builder.name;
        this.registrationStatus = builder.registrationStatus;
        this.nextPageToken = builder.nextPageToken;
        this.maximumPageSize = builder.maximumPageSize;
        this.reverseOrder = builder.reverseOrder;
    }

    public final String domain() {
        return this.domain;
    }

    public final String name() {
        return this.name;
    }

    public final RegistrationStatus registrationStatus() {
        return RegistrationStatus.fromValue(this.registrationStatus);
    }

    public final String registrationStatusAsString() {
        return this.registrationStatus;
    }

    public final String nextPageToken() {
        return this.nextPageToken;
    }

    public final Integer maximumPageSize() {
        return this.maximumPageSize;
    }

    public final Boolean reverseOrder() {
        return this.reverseOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumPageSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.reverseOrder());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkflowTypesRequest)) {
            return false;
        }
        ListWorkflowTypesRequest other = (ListWorkflowTypesRequest)((Object)obj);
        return Objects.equals(this.domain(), other.domain()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.registrationStatusAsString(), other.registrationStatusAsString()) && Objects.equals(this.nextPageToken(), other.nextPageToken()) && Objects.equals(this.maximumPageSize(), other.maximumPageSize()) && Objects.equals(this.reverseOrder(), other.reverseOrder());
    }

    public final String toString() {
        return ToString.builder((String)"ListWorkflowTypesRequest").add("Domain", (Object)this.domain()).add("Name", (Object)this.name()).add("RegistrationStatus", (Object)this.registrationStatusAsString()).add("NextPageToken", (Object)this.nextPageToken()).add("MaximumPageSize", (Object)this.maximumPageSize()).add("ReverseOrder", (Object)this.reverseOrder()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "registrationStatus": {
                return Optional.ofNullable(clazz.cast(this.registrationStatusAsString()));
            }
            case "nextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
            case "maximumPageSize": {
                return Optional.ofNullable(clazz.cast(this.maximumPageSize()));
            }
            case "reverseOrder": {
                return Optional.ofNullable(clazz.cast(this.reverseOrder()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListWorkflowTypesRequest, T> g) {
        return obj -> g.apply((ListWorkflowTypesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SwfRequest.BuilderImpl
    implements Builder {
        private String domain;
        private String name;
        private String registrationStatus;
        private String nextPageToken;
        private Integer maximumPageSize;
        private Boolean reverseOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkflowTypesRequest model) {
            super(model);
            this.domain(model.domain);
            this.name(model.name);
            this.registrationStatus(model.registrationStatus);
            this.nextPageToken(model.nextPageToken);
            this.maximumPageSize(model.maximumPageSize);
            this.reverseOrder(model.reverseOrder);
        }

        public final String getDomain() {
            return this.domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRegistrationStatus() {
            return this.registrationStatus;
        }

        public final void setRegistrationStatus(String registrationStatus) {
            this.registrationStatus = registrationStatus;
        }

        @Override
        public final Builder registrationStatus(String registrationStatus) {
            this.registrationStatus = registrationStatus;
            return this;
        }

        @Override
        public final Builder registrationStatus(RegistrationStatus registrationStatus) {
            this.registrationStatus(registrationStatus == null ? null : registrationStatus.toString());
            return this;
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final Integer getMaximumPageSize() {
            return this.maximumPageSize;
        }

        public final void setMaximumPageSize(Integer maximumPageSize) {
            this.maximumPageSize = maximumPageSize;
        }

        @Override
        public final Builder maximumPageSize(Integer maximumPageSize) {
            this.maximumPageSize = maximumPageSize;
            return this;
        }

        public final Boolean getReverseOrder() {
            return this.reverseOrder;
        }

        public final void setReverseOrder(Boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
        }

        @Override
        public final Builder reverseOrder(Boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListWorkflowTypesRequest build() {
            return new ListWorkflowTypesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SwfRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListWorkflowTypesRequest> {
        public Builder domain(String var1);

        public Builder name(String var1);

        public Builder registrationStatus(String var1);

        public Builder registrationStatus(RegistrationStatus var1);

        public Builder nextPageToken(String var1);

        public Builder maximumPageSize(Integer var1);

        public Builder reverseOrder(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

