/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.swf.model.ActivityTypeInfo;
import software.amazon.awssdk.services.swf.model.ActivityTypeInfoListCopier;
import software.amazon.awssdk.services.swf.model.SwfResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListActivityTypesResponse
extends SwfResponse
implements ToCopyableBuilder<Builder, ListActivityTypesResponse> {
    private static final SdkField<List<ActivityTypeInfo>> TYPE_INFOS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("typeInfos").getter(ListActivityTypesResponse.getter(ListActivityTypesResponse::typeInfos)).setter(ListActivityTypesResponse.setter(Builder::typeInfos)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeInfos").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ActivityTypeInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextPageToken").getter(ListActivityTypesResponse.getter(ListActivityTypesResponse::nextPageToken)).setter(ListActivityTypesResponse.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_INFOS_FIELD, NEXT_PAGE_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("typeInfos", TYPE_INFOS_FIELD);
            this.put("nextPageToken", NEXT_PAGE_TOKEN_FIELD);
        }
    });
    private final List<ActivityTypeInfo> typeInfos;
    private final String nextPageToken;

    private ListActivityTypesResponse(BuilderImpl builder) {
        super(builder);
        this.typeInfos = builder.typeInfos;
        this.nextPageToken = builder.nextPageToken;
    }

    public final boolean hasTypeInfos() {
        return this.typeInfos != null && !(this.typeInfos instanceof SdkAutoConstructList);
    }

    public final List<ActivityTypeInfo> typeInfos() {
        return this.typeInfos;
    }

    public final String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTypeInfos() ? this.typeInfos() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListActivityTypesResponse)) {
            return false;
        }
        ListActivityTypesResponse other = (ListActivityTypesResponse)((Object)obj);
        return this.hasTypeInfos() == other.hasTypeInfos() && Objects.equals(this.typeInfos(), other.typeInfos()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListActivityTypesResponse").add("TypeInfos", this.hasTypeInfos() ? this.typeInfos() : null).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "typeInfos": {
                return Optional.ofNullable(clazz.cast(this.typeInfos()));
            }
            case "nextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListActivityTypesResponse, T> g) {
        return obj -> g.apply((ListActivityTypesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SwfResponse.BuilderImpl
    implements Builder {
        private List<ActivityTypeInfo> typeInfos = DefaultSdkAutoConstructList.getInstance();
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListActivityTypesResponse model) {
            super(model);
            this.typeInfos(model.typeInfos);
            this.nextPageToken(model.nextPageToken);
        }

        public final List<ActivityTypeInfo.Builder> getTypeInfos() {
            List<ActivityTypeInfo.Builder> result = ActivityTypeInfoListCopier.copyToBuilder(this.typeInfos);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTypeInfos(Collection<ActivityTypeInfo.BuilderImpl> typeInfos) {
            this.typeInfos = ActivityTypeInfoListCopier.copyFromBuilder(typeInfos);
        }

        @Override
        public final Builder typeInfos(Collection<ActivityTypeInfo> typeInfos) {
            this.typeInfos = ActivityTypeInfoListCopier.copy(typeInfos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder typeInfos(ActivityTypeInfo ... typeInfos) {
            this.typeInfos(Arrays.asList(typeInfos));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder typeInfos(Consumer<ActivityTypeInfo.Builder> ... typeInfos) {
            this.typeInfos(Stream.of(typeInfos).map(c -> (ActivityTypeInfo)((ActivityTypeInfo.Builder)ActivityTypeInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        @Override
        public ListActivityTypesResponse build() {
            return new ListActivityTypesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SwfResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListActivityTypesResponse> {
        public Builder typeInfos(Collection<ActivityTypeInfo> var1);

        public Builder typeInfos(ActivityTypeInfo ... var1);

        public Builder typeInfos(Consumer<ActivityTypeInfo.Builder> ... var1);

        public Builder nextPageToken(String var1);
    }
}

