/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the details of the <code>WorkflowExecutionTimedOut</code> event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkflowExecutionTimedOutEventAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<WorkflowExecutionTimedOutEventAttributes.Builder, WorkflowExecutionTimedOutEventAttributes> {
    private static final SdkField<String> TIMEOUT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("timeoutType").getter(getter(WorkflowExecutionTimedOutEventAttributes::timeoutTypeAsString))
            .setter(setter(Builder::timeoutType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutType").build()).build();

    private static final SdkField<String> CHILD_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("childPolicy").getter(getter(WorkflowExecutionTimedOutEventAttributes::childPolicyAsString))
            .setter(setter(Builder::childPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("childPolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMEOUT_TYPE_FIELD,
            CHILD_POLICY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("timeoutType", TIMEOUT_TYPE_FIELD);
                    put("childPolicy", CHILD_POLICY_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String timeoutType;

    private final String childPolicy;

    private WorkflowExecutionTimedOutEventAttributes(BuilderImpl builder) {
        this.timeoutType = builder.timeoutType;
        this.childPolicy = builder.childPolicy;
    }

    /**
     * <p>
     * The type of timeout that caused this event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeoutType} will
     * return {@link WorkflowExecutionTimeoutType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #timeoutTypeAsString}.
     * </p>
     * 
     * @return The type of timeout that caused this event.
     * @see WorkflowExecutionTimeoutType
     */
    public final WorkflowExecutionTimeoutType timeoutType() {
        return WorkflowExecutionTimeoutType.fromValue(timeoutType);
    }

    /**
     * <p>
     * The type of timeout that caused this event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeoutType} will
     * return {@link WorkflowExecutionTimeoutType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #timeoutTypeAsString}.
     * </p>
     * 
     * @return The type of timeout that caused this event.
     * @see WorkflowExecutionTimeoutType
     */
    public final String timeoutTypeAsString() {
        return timeoutType;
    }

    /**
     * <p>
     * The policy used for the child workflow executions of this workflow execution.
     * </p>
     * <p>
     * The supported child policies are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TERMINATE</code> – The child executions are terminated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child execution by recording a
     * <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take appropriate
     * actions when it receives an execution history with this event.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ABANDON</code> – No action is taken. The child executions continue to run.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #childPolicy} will
     * return {@link ChildPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #childPolicyAsString}.
     * </p>
     * 
     * @return The policy used for the child workflow executions of this workflow execution.</p>
     *         <p>
     *         The supported child policies are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>TERMINATE</code> – The child executions are terminated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child execution by recording a
     *         <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
     *         appropriate actions when it receives an execution history with this event.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ABANDON</code> – No action is taken. The child executions continue to run.
     *         </p>
     *         </li>
     * @see ChildPolicy
     */
    public final ChildPolicy childPolicy() {
        return ChildPolicy.fromValue(childPolicy);
    }

    /**
     * <p>
     * The policy used for the child workflow executions of this workflow execution.
     * </p>
     * <p>
     * The supported child policies are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TERMINATE</code> – The child executions are terminated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child execution by recording a
     * <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take appropriate
     * actions when it receives an execution history with this event.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ABANDON</code> – No action is taken. The child executions continue to run.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #childPolicy} will
     * return {@link ChildPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #childPolicyAsString}.
     * </p>
     * 
     * @return The policy used for the child workflow executions of this workflow execution.</p>
     *         <p>
     *         The supported child policies are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>TERMINATE</code> – The child executions are terminated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child execution by recording a
     *         <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
     *         appropriate actions when it receives an execution history with this event.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ABANDON</code> – No action is taken. The child executions continue to run.
     *         </p>
     *         </li>
     * @see ChildPolicy
     */
    public final String childPolicyAsString() {
        return childPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timeoutTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(childPolicyAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowExecutionTimedOutEventAttributes)) {
            return false;
        }
        WorkflowExecutionTimedOutEventAttributes other = (WorkflowExecutionTimedOutEventAttributes) obj;
        return Objects.equals(timeoutTypeAsString(), other.timeoutTypeAsString())
                && Objects.equals(childPolicyAsString(), other.childPolicyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkflowExecutionTimedOutEventAttributes").add("TimeoutType", timeoutTypeAsString())
                .add("ChildPolicy", childPolicyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "timeoutType":
            return Optional.ofNullable(clazz.cast(timeoutTypeAsString()));
        case "childPolicy":
            return Optional.ofNullable(clazz.cast(childPolicyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<WorkflowExecutionTimedOutEventAttributes, T> g) {
        return obj -> g.apply((WorkflowExecutionTimedOutEventAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkflowExecutionTimedOutEventAttributes> {
        /**
         * <p>
         * The type of timeout that caused this event.
         * </p>
         * 
         * @param timeoutType
         *        The type of timeout that caused this event.
         * @see WorkflowExecutionTimeoutType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowExecutionTimeoutType
         */
        Builder timeoutType(String timeoutType);

        /**
         * <p>
         * The type of timeout that caused this event.
         * </p>
         * 
         * @param timeoutType
         *        The type of timeout that caused this event.
         * @see WorkflowExecutionTimeoutType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowExecutionTimeoutType
         */
        Builder timeoutType(WorkflowExecutionTimeoutType timeoutType);

        /**
         * <p>
         * The policy used for the child workflow executions of this workflow execution.
         * </p>
         * <p>
         * The supported child policies are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>TERMINATE</code> – The child executions are terminated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child execution by recording a
         * <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         * appropriate actions when it receives an execution history with this event.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ABANDON</code> – No action is taken. The child executions continue to run.
         * </p>
         * </li>
         * </ul>
         * 
         * @param childPolicy
         *        The policy used for the child workflow executions of this workflow execution.</p>
         *        <p>
         *        The supported child policies are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>TERMINATE</code> – The child executions are terminated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child execution by recording a
         *        <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         *        appropriate actions when it receives an execution history with this event.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ABANDON</code> – No action is taken. The child executions continue to run.
         *        </p>
         *        </li>
         * @see ChildPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChildPolicy
         */
        Builder childPolicy(String childPolicy);

        /**
         * <p>
         * The policy used for the child workflow executions of this workflow execution.
         * </p>
         * <p>
         * The supported child policies are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>TERMINATE</code> – The child executions are terminated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child execution by recording a
         * <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         * appropriate actions when it receives an execution history with this event.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ABANDON</code> – No action is taken. The child executions continue to run.
         * </p>
         * </li>
         * </ul>
         * 
         * @param childPolicy
         *        The policy used for the child workflow executions of this workflow execution.</p>
         *        <p>
         *        The supported child policies are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>TERMINATE</code> – The child executions are terminated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child execution by recording a
         *        <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         *        appropriate actions when it receives an execution history with this event.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ABANDON</code> – No action is taken. The child executions continue to run.
         *        </p>
         *        </li>
         * @see ChildPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChildPolicy
         */
        Builder childPolicy(ChildPolicy childPolicy);
    }

    static final class BuilderImpl implements Builder {
        private String timeoutType;

        private String childPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowExecutionTimedOutEventAttributes model) {
            timeoutType(model.timeoutType);
            childPolicy(model.childPolicy);
        }

        public final String getTimeoutType() {
            return timeoutType;
        }

        public final void setTimeoutType(String timeoutType) {
            this.timeoutType = timeoutType;
        }

        @Override
        public final Builder timeoutType(String timeoutType) {
            this.timeoutType = timeoutType;
            return this;
        }

        @Override
        public final Builder timeoutType(WorkflowExecutionTimeoutType timeoutType) {
            this.timeoutType(timeoutType == null ? null : timeoutType.toString());
            return this;
        }

        public final String getChildPolicy() {
            return childPolicy;
        }

        public final void setChildPolicy(String childPolicy) {
            this.childPolicy = childPolicy;
        }

        @Override
        public final Builder childPolicy(String childPolicy) {
            this.childPolicy = childPolicy;
            return this;
        }

        @Override
        public final Builder childPolicy(ChildPolicy childPolicy) {
            this.childPolicy(childPolicy == null ? null : childPolicy.toString());
            return this;
        }

        @Override
        public WorkflowExecutionTimedOutEventAttributes build() {
            return new WorkflowExecutionTimedOutEventAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
