/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about a workflow type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeWorkflowTypeResponse extends SwfResponse implements
        ToCopyableBuilder<DescribeWorkflowTypeResponse.Builder, DescribeWorkflowTypeResponse> {
    private static final SdkField<WorkflowTypeInfo> TYPE_INFO_FIELD = SdkField
            .<WorkflowTypeInfo> builder(MarshallingType.SDK_POJO).memberName("typeInfo")
            .getter(getter(DescribeWorkflowTypeResponse::typeInfo)).setter(setter(Builder::typeInfo))
            .constructor(WorkflowTypeInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeInfo").build()).build();

    private static final SdkField<WorkflowTypeConfiguration> CONFIGURATION_FIELD = SdkField
            .<WorkflowTypeConfiguration> builder(MarshallingType.SDK_POJO).memberName("configuration")
            .getter(getter(DescribeWorkflowTypeResponse::configuration)).setter(setter(Builder::configuration))
            .constructor(WorkflowTypeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_INFO_FIELD,
            CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("typeInfo", TYPE_INFO_FIELD);
                    put("configuration", CONFIGURATION_FIELD);
                }
            });

    private final WorkflowTypeInfo typeInfo;

    private final WorkflowTypeConfiguration configuration;

    private DescribeWorkflowTypeResponse(BuilderImpl builder) {
        super(builder);
        this.typeInfo = builder.typeInfo;
        this.configuration = builder.configuration;
    }

    /**
     * <p>
     * General information about the workflow type.
     * </p>
     * <p>
     * The status of the workflow type (returned in the WorkflowTypeInfo structure) can be one of the following.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>REGISTERED</code> – The type is registered and available. Workers supporting this type should be running.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DEPRECATED</code> – The type was deprecated using <a>DeprecateWorkflowType</a>, but is still in use. You
     * should keep workers supporting this type running. You cannot create new workflow executions of this type.
     * </p>
     * </li>
     * </ul>
     * 
     * @return General information about the workflow type.</p>
     *         <p>
     *         The status of the workflow type (returned in the WorkflowTypeInfo structure) can be one of the following.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>REGISTERED</code> – The type is registered and available. Workers supporting this type should be
     *         running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DEPRECATED</code> – The type was deprecated using <a>DeprecateWorkflowType</a>, but is still in
     *         use. You should keep workers supporting this type running. You cannot create new workflow executions of
     *         this type.
     *         </p>
     *         </li>
     */
    public final WorkflowTypeInfo typeInfo() {
        return typeInfo;
    }

    /**
     * <p>
     * Configuration settings of the workflow type registered through <a>RegisterWorkflowType</a>
     * </p>
     * 
     * @return Configuration settings of the workflow type registered through <a>RegisterWorkflowType</a>
     */
    public final WorkflowTypeConfiguration configuration() {
        return configuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(typeInfo());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkflowTypeResponse)) {
            return false;
        }
        DescribeWorkflowTypeResponse other = (DescribeWorkflowTypeResponse) obj;
        return Objects.equals(typeInfo(), other.typeInfo()) && Objects.equals(configuration(), other.configuration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeWorkflowTypeResponse").add("TypeInfo", typeInfo()).add("Configuration", configuration())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "typeInfo":
            return Optional.ofNullable(clazz.cast(typeInfo()));
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeWorkflowTypeResponse, T> g) {
        return obj -> g.apply((DescribeWorkflowTypeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SwfResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeWorkflowTypeResponse> {
        /**
         * <p>
         * General information about the workflow type.
         * </p>
         * <p>
         * The status of the workflow type (returned in the WorkflowTypeInfo structure) can be one of the following.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>REGISTERED</code> – The type is registered and available. Workers supporting this type should be
         * running.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DEPRECATED</code> – The type was deprecated using <a>DeprecateWorkflowType</a>, but is still in use.
         * You should keep workers supporting this type running. You cannot create new workflow executions of this type.
         * </p>
         * </li>
         * </ul>
         * 
         * @param typeInfo
         *        General information about the workflow type.</p>
         *        <p>
         *        The status of the workflow type (returned in the WorkflowTypeInfo structure) can be one of the
         *        following.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>REGISTERED</code> – The type is registered and available. Workers supporting this type should be
         *        running.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DEPRECATED</code> – The type was deprecated using <a>DeprecateWorkflowType</a>, but is still in
         *        use. You should keep workers supporting this type running. You cannot create new workflow executions
         *        of this type.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeInfo(WorkflowTypeInfo typeInfo);

        /**
         * <p>
         * General information about the workflow type.
         * </p>
         * <p>
         * The status of the workflow type (returned in the WorkflowTypeInfo structure) can be one of the following.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>REGISTERED</code> – The type is registered and available. Workers supporting this type should be
         * running.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DEPRECATED</code> – The type was deprecated using <a>DeprecateWorkflowType</a>, but is still in use.
         * You should keep workers supporting this type running. You cannot create new workflow executions of this type.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link WorkflowTypeInfo.Builder} avoiding the
         * need to create one manually via {@link WorkflowTypeInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkflowTypeInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #typeInfo(WorkflowTypeInfo)}.
         * 
         * @param typeInfo
         *        a consumer that will call methods on {@link WorkflowTypeInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #typeInfo(WorkflowTypeInfo)
         */
        default Builder typeInfo(Consumer<WorkflowTypeInfo.Builder> typeInfo) {
            return typeInfo(WorkflowTypeInfo.builder().applyMutation(typeInfo).build());
        }

        /**
         * <p>
         * Configuration settings of the workflow type registered through <a>RegisterWorkflowType</a>
         * </p>
         * 
         * @param configuration
         *        Configuration settings of the workflow type registered through <a>RegisterWorkflowType</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(WorkflowTypeConfiguration configuration);

        /**
         * <p>
         * Configuration settings of the workflow type registered through <a>RegisterWorkflowType</a>
         * </p>
         * This is a convenience method that creates an instance of the {@link WorkflowTypeConfiguration.Builder}
         * avoiding the need to create one manually via {@link WorkflowTypeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkflowTypeConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #configuration(WorkflowTypeConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link WorkflowTypeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(WorkflowTypeConfiguration)
         */
        default Builder configuration(Consumer<WorkflowTypeConfiguration.Builder> configuration) {
            return configuration(WorkflowTypeConfiguration.builder().applyMutation(configuration).build());
        }
    }

    static final class BuilderImpl extends SwfResponse.BuilderImpl implements Builder {
        private WorkflowTypeInfo typeInfo;

        private WorkflowTypeConfiguration configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorkflowTypeResponse model) {
            super(model);
            typeInfo(model.typeInfo);
            configuration(model.configuration);
        }

        public final WorkflowTypeInfo.Builder getTypeInfo() {
            return typeInfo != null ? typeInfo.toBuilder() : null;
        }

        public final void setTypeInfo(WorkflowTypeInfo.BuilderImpl typeInfo) {
            this.typeInfo = typeInfo != null ? typeInfo.build() : null;
        }

        @Override
        public final Builder typeInfo(WorkflowTypeInfo typeInfo) {
            this.typeInfo = typeInfo;
            return this;
        }

        public final WorkflowTypeConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(WorkflowTypeConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(WorkflowTypeConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        @Override
        public DescribeWorkflowTypeResponse build() {
            return new DescribeWorkflowTypeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
