/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the details of the <code>LambdaFunctionStarted</code> event. It isn't set for other event types.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LambdaFunctionStartedEventAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<LambdaFunctionStartedEventAttributes.Builder, LambdaFunctionStartedEventAttributes> {
    private static final SdkField<Long> SCHEDULED_EVENT_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("scheduledEventId").getter(getter(LambdaFunctionStartedEventAttributes::scheduledEventId))
            .setter(setter(Builder::scheduledEventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduledEventId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULED_EVENT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("scheduledEventId", SCHEDULED_EVENT_ID_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Long scheduledEventId;

    private LambdaFunctionStartedEventAttributes(BuilderImpl builder) {
        this.scheduledEventId = builder.scheduledEventId;
    }

    /**
     * <p>
     * The ID of the <code>LambdaFunctionScheduled</code> event that was recorded when this activity task was scheduled.
     * To help diagnose issues, use this information to trace back the chain of events leading up to this event.
     * </p>
     * 
     * @return The ID of the <code>LambdaFunctionScheduled</code> event that was recorded when this activity task was
     *         scheduled. To help diagnose issues, use this information to trace back the chain of events leading up to
     *         this event.
     */
    public final Long scheduledEventId() {
        return scheduledEventId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scheduledEventId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaFunctionStartedEventAttributes)) {
            return false;
        }
        LambdaFunctionStartedEventAttributes other = (LambdaFunctionStartedEventAttributes) obj;
        return Objects.equals(scheduledEventId(), other.scheduledEventId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LambdaFunctionStartedEventAttributes").add("ScheduledEventId", scheduledEventId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scheduledEventId":
            return Optional.ofNullable(clazz.cast(scheduledEventId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LambdaFunctionStartedEventAttributes, T> g) {
        return obj -> g.apply((LambdaFunctionStartedEventAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LambdaFunctionStartedEventAttributes> {
        /**
         * <p>
         * The ID of the <code>LambdaFunctionScheduled</code> event that was recorded when this activity task was
         * scheduled. To help diagnose issues, use this information to trace back the chain of events leading up to this
         * event.
         * </p>
         * 
         * @param scheduledEventId
         *        The ID of the <code>LambdaFunctionScheduled</code> event that was recorded when this activity task was
         *        scheduled. To help diagnose issues, use this information to trace back the chain of events leading up
         *        to this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledEventId(Long scheduledEventId);
    }

    static final class BuilderImpl implements Builder {
        private Long scheduledEventId;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaFunctionStartedEventAttributes model) {
            scheduledEventId(model.scheduledEventId);
        }

        public final Long getScheduledEventId() {
            return scheduledEventId;
        }

        public final void setScheduledEventId(Long scheduledEventId) {
            this.scheduledEventId = scheduledEventId;
        }

        @Override
        public final Builder scheduledEventId(Long scheduledEventId) {
            this.scheduledEventId = scheduledEventId;
            return this;
        }

        @Override
        public LambdaFunctionStartedEventAttributes build() {
            return new LambdaFunctionStartedEventAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
