/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the details of the <code>ScheduleLambdaFunctionFailed</code> event. It isn't set for other event types.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScheduleLambdaFunctionFailedEventAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<ScheduleLambdaFunctionFailedEventAttributes.Builder, ScheduleLambdaFunctionFailedEventAttributes> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(ScheduleLambdaFunctionFailedEventAttributes::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ScheduleLambdaFunctionFailedEventAttributes::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> CAUSE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("cause")
            .getter(getter(ScheduleLambdaFunctionFailedEventAttributes::causeAsString)).setter(setter(Builder::cause))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cause").build()).build();

    private static final SdkField<Long> DECISION_TASK_COMPLETED_EVENT_ID_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("decisionTaskCompletedEventId")
            .getter(getter(ScheduleLambdaFunctionFailedEventAttributes::decisionTaskCompletedEventId))
            .setter(setter(Builder::decisionTaskCompletedEventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decisionTaskCompletedEventId")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            CAUSE_FIELD, DECISION_TASK_COMPLETED_EVENT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("id", ID_FIELD);
                    put("name", NAME_FIELD);
                    put("cause", CAUSE_FIELD);
                    put("decisionTaskCompletedEventId", DECISION_TASK_COMPLETED_EVENT_ID_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final String causeValue;

    private final Long decisionTaskCompletedEventId;

    private ScheduleLambdaFunctionFailedEventAttributes(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.causeValue = builder.causeValue;
        this.decisionTaskCompletedEventId = builder.decisionTaskCompletedEventId;
    }

    /**
     * <p>
     * The ID provided in the <code>ScheduleLambdaFunction</code> decision that failed.
     * </p>
     * 
     * @return The ID provided in the <code>ScheduleLambdaFunction</code> decision that failed.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the Lambda function.
     * </p>
     * 
     * @return The name of the Lambda function.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The cause of the failure. To help diagnose issues, use this information to trace back the chain of events leading
     * up to this event.
     * </p>
     * <note>
     * <p>
     * If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed because it lacked
     * sufficient permissions. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #cause} will return
     * {@link ScheduleLambdaFunctionFailedCause#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #causeAsString}.
     * </p>
     * 
     * @return The cause of the failure. To help diagnose issues, use this information to trace back the chain of events
     *         leading up to this event.</p> <note>
     *         <p>
     *         If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed because it
     *         lacked sufficient permissions. For details and example IAM policies, see <a
     *         href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage
     *         Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     *         </p>
     * @see ScheduleLambdaFunctionFailedCause
     */
    public final ScheduleLambdaFunctionFailedCause cause() {
        return ScheduleLambdaFunctionFailedCause.fromValue(causeValue);
    }

    /**
     * <p>
     * The cause of the failure. To help diagnose issues, use this information to trace back the chain of events leading
     * up to this event.
     * </p>
     * <note>
     * <p>
     * If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed because it lacked
     * sufficient permissions. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #cause} will return
     * {@link ScheduleLambdaFunctionFailedCause#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #causeAsString}.
     * </p>
     * 
     * @return The cause of the failure. To help diagnose issues, use this information to trace back the chain of events
     *         leading up to this event.</p> <note>
     *         <p>
     *         If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed because it
     *         lacked sufficient permissions. For details and example IAM policies, see <a
     *         href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage
     *         Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     *         </p>
     * @see ScheduleLambdaFunctionFailedCause
     */
    public final String causeAsString() {
        return causeValue;
    }

    /**
     * <p>
     * The ID of the <code>LambdaFunctionCompleted</code> event corresponding to the decision that resulted in
     * scheduling this Lambda task. To help diagnose issues, use this information to trace back the chain of events
     * leading up to this event.
     * </p>
     * 
     * @return The ID of the <code>LambdaFunctionCompleted</code> event corresponding to the decision that resulted in
     *         scheduling this Lambda task. To help diagnose issues, use this information to trace back the chain of
     *         events leading up to this event.
     */
    public final Long decisionTaskCompletedEventId() {
        return decisionTaskCompletedEventId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(causeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(decisionTaskCompletedEventId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduleLambdaFunctionFailedEventAttributes)) {
            return false;
        }
        ScheduleLambdaFunctionFailedEventAttributes other = (ScheduleLambdaFunctionFailedEventAttributes) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(causeAsString(), other.causeAsString())
                && Objects.equals(decisionTaskCompletedEventId(), other.decisionTaskCompletedEventId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScheduleLambdaFunctionFailedEventAttributes").add("Id", id()).add("Name", name())
                .add("Cause", causeAsString()).add("DecisionTaskCompletedEventId", decisionTaskCompletedEventId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "cause":
            return Optional.ofNullable(clazz.cast(causeAsString()));
        case "decisionTaskCompletedEventId":
            return Optional.ofNullable(clazz.cast(decisionTaskCompletedEventId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ScheduleLambdaFunctionFailedEventAttributes, T> g) {
        return obj -> g.apply((ScheduleLambdaFunctionFailedEventAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScheduleLambdaFunctionFailedEventAttributes> {
        /**
         * <p>
         * The ID provided in the <code>ScheduleLambdaFunction</code> decision that failed.
         * </p>
         * 
         * @param id
         *        The ID provided in the <code>ScheduleLambdaFunction</code> decision that failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the Lambda function.
         * </p>
         * 
         * @param name
         *        The name of the Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The cause of the failure. To help diagnose issues, use this information to trace back the chain of events
         * leading up to this event.
         * </p>
         * <note>
         * <p>
         * If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed because it lacked
         * sufficient permissions. For details and example IAM policies, see <a
         * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage
         * Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
         * </p>
         * </note>
         * 
         * @param causeValue
         *        The cause of the failure. To help diagnose issues, use this information to trace back the chain of
         *        events leading up to this event.</p> <note>
         *        <p>
         *        If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed because it
         *        lacked sufficient permissions. For details and example IAM policies, see <a
         *        href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to
         *        Manage Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
         *        </p>
         * @see ScheduleLambdaFunctionFailedCause
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduleLambdaFunctionFailedCause
         */
        Builder cause(String causeValue);

        /**
         * <p>
         * The cause of the failure. To help diagnose issues, use this information to trace back the chain of events
         * leading up to this event.
         * </p>
         * <note>
         * <p>
         * If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed because it lacked
         * sufficient permissions. For details and example IAM policies, see <a
         * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage
         * Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
         * </p>
         * </note>
         * 
         * @param causeValue
         *        The cause of the failure. To help diagnose issues, use this information to trace back the chain of
         *        events leading up to this event.</p> <note>
         *        <p>
         *        If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed because it
         *        lacked sufficient permissions. For details and example IAM policies, see <a
         *        href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to
         *        Manage Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
         *        </p>
         * @see ScheduleLambdaFunctionFailedCause
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduleLambdaFunctionFailedCause
         */
        Builder cause(ScheduleLambdaFunctionFailedCause causeValue);

        /**
         * <p>
         * The ID of the <code>LambdaFunctionCompleted</code> event corresponding to the decision that resulted in
         * scheduling this Lambda task. To help diagnose issues, use this information to trace back the chain of events
         * leading up to this event.
         * </p>
         * 
         * @param decisionTaskCompletedEventId
         *        The ID of the <code>LambdaFunctionCompleted</code> event corresponding to the decision that resulted
         *        in scheduling this Lambda task. To help diagnose issues, use this information to trace back the chain
         *        of events leading up to this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decisionTaskCompletedEventId(Long decisionTaskCompletedEventId);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private String causeValue;

        private Long decisionTaskCompletedEventId;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduleLambdaFunctionFailedEventAttributes model) {
            id(model.id);
            name(model.name);
            cause(model.causeValue);
            decisionTaskCompletedEventId(model.decisionTaskCompletedEventId);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getCause() {
            return causeValue;
        }

        public final void setCause(String causeValue) {
            this.causeValue = causeValue;
        }

        @Override
        public final Builder cause(String causeValue) {
            this.causeValue = causeValue;
            return this;
        }

        @Override
        public final Builder cause(ScheduleLambdaFunctionFailedCause causeValue) {
            this.cause(causeValue == null ? null : causeValue.toString());
            return this;
        }

        public final Long getDecisionTaskCompletedEventId() {
            return decisionTaskCompletedEventId;
        }

        public final void setDecisionTaskCompletedEventId(Long decisionTaskCompletedEventId) {
            this.decisionTaskCompletedEventId = decisionTaskCompletedEventId;
        }

        @Override
        public final Builder decisionTaskCompletedEventId(Long decisionTaskCompletedEventId) {
            this.decisionTaskCompletedEventId = decisionTaskCompletedEventId;
            return this;
        }

        @Override
        public ScheduleLambdaFunctionFailedEventAttributes build() {
            return new ScheduleLambdaFunctionFailedEventAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
