/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.swf.model.CloseStatusFilter;
import software.amazon.awssdk.services.swf.model.ExecutionTimeFilter;
import software.amazon.awssdk.services.swf.model.SwfRequest;
import software.amazon.awssdk.services.swf.model.TagFilter;
import software.amazon.awssdk.services.swf.model.WorkflowExecutionFilter;
import software.amazon.awssdk.services.swf.model.WorkflowTypeFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListClosedWorkflowExecutionsRequest
extends SwfRequest
implements ToCopyableBuilder<Builder, ListClosedWorkflowExecutionsRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListClosedWorkflowExecutionsRequest.getter(ListClosedWorkflowExecutionsRequest::domain)).setter(ListClosedWorkflowExecutionsRequest.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domain").build()}).build();
    private static final SdkField<ExecutionTimeFilter> START_TIME_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ListClosedWorkflowExecutionsRequest.getter(ListClosedWorkflowExecutionsRequest::startTimeFilter)).setter(ListClosedWorkflowExecutionsRequest.setter(Builder::startTimeFilter)).constructor(ExecutionTimeFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTimeFilter").build()}).build();
    private static final SdkField<ExecutionTimeFilter> CLOSE_TIME_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ListClosedWorkflowExecutionsRequest.getter(ListClosedWorkflowExecutionsRequest::closeTimeFilter)).setter(ListClosedWorkflowExecutionsRequest.setter(Builder::closeTimeFilter)).constructor(ExecutionTimeFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("closeTimeFilter").build()}).build();
    private static final SdkField<WorkflowExecutionFilter> EXECUTION_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ListClosedWorkflowExecutionsRequest.getter(ListClosedWorkflowExecutionsRequest::executionFilter)).setter(ListClosedWorkflowExecutionsRequest.setter(Builder::executionFilter)).constructor(WorkflowExecutionFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionFilter").build()}).build();
    private static final SdkField<CloseStatusFilter> CLOSE_STATUS_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ListClosedWorkflowExecutionsRequest.getter(ListClosedWorkflowExecutionsRequest::closeStatusFilter)).setter(ListClosedWorkflowExecutionsRequest.setter(Builder::closeStatusFilter)).constructor(CloseStatusFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("closeStatusFilter").build()}).build();
    private static final SdkField<WorkflowTypeFilter> TYPE_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ListClosedWorkflowExecutionsRequest.getter(ListClosedWorkflowExecutionsRequest::typeFilter)).setter(ListClosedWorkflowExecutionsRequest.setter(Builder::typeFilter)).constructor(WorkflowTypeFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeFilter").build()}).build();
    private static final SdkField<TagFilter> TAG_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ListClosedWorkflowExecutionsRequest.getter(ListClosedWorkflowExecutionsRequest::tagFilter)).setter(ListClosedWorkflowExecutionsRequest.setter(Builder::tagFilter)).constructor(TagFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagFilter").build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListClosedWorkflowExecutionsRequest.getter(ListClosedWorkflowExecutionsRequest::nextPageToken)).setter(ListClosedWorkflowExecutionsRequest.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageToken").build()}).build();
    private static final SdkField<Integer> MAXIMUM_PAGE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ListClosedWorkflowExecutionsRequest.getter(ListClosedWorkflowExecutionsRequest::maximumPageSize)).setter(ListClosedWorkflowExecutionsRequest.setter(Builder::maximumPageSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumPageSize").build()}).build();
    private static final SdkField<Boolean> REVERSE_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ListClosedWorkflowExecutionsRequest.getter(ListClosedWorkflowExecutionsRequest::reverseOrder)).setter(ListClosedWorkflowExecutionsRequest.setter(Builder::reverseOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reverseOrder").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD, START_TIME_FILTER_FIELD, CLOSE_TIME_FILTER_FIELD, EXECUTION_FILTER_FIELD, CLOSE_STATUS_FILTER_FIELD, TYPE_FILTER_FIELD, TAG_FILTER_FIELD, NEXT_PAGE_TOKEN_FIELD, MAXIMUM_PAGE_SIZE_FIELD, REVERSE_ORDER_FIELD));
    private final String domain;
    private final ExecutionTimeFilter startTimeFilter;
    private final ExecutionTimeFilter closeTimeFilter;
    private final WorkflowExecutionFilter executionFilter;
    private final CloseStatusFilter closeStatusFilter;
    private final WorkflowTypeFilter typeFilter;
    private final TagFilter tagFilter;
    private final String nextPageToken;
    private final Integer maximumPageSize;
    private final Boolean reverseOrder;

    private ListClosedWorkflowExecutionsRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.startTimeFilter = builder.startTimeFilter;
        this.closeTimeFilter = builder.closeTimeFilter;
        this.executionFilter = builder.executionFilter;
        this.closeStatusFilter = builder.closeStatusFilter;
        this.typeFilter = builder.typeFilter;
        this.tagFilter = builder.tagFilter;
        this.nextPageToken = builder.nextPageToken;
        this.maximumPageSize = builder.maximumPageSize;
        this.reverseOrder = builder.reverseOrder;
    }

    public String domain() {
        return this.domain;
    }

    public ExecutionTimeFilter startTimeFilter() {
        return this.startTimeFilter;
    }

    public ExecutionTimeFilter closeTimeFilter() {
        return this.closeTimeFilter;
    }

    public WorkflowExecutionFilter executionFilter() {
        return this.executionFilter;
    }

    public CloseStatusFilter closeStatusFilter() {
        return this.closeStatusFilter;
    }

    public WorkflowTypeFilter typeFilter() {
        return this.typeFilter;
    }

    public TagFilter tagFilter() {
        return this.tagFilter;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Integer maximumPageSize() {
        return this.maximumPageSize;
    }

    public Boolean reverseOrder() {
        return this.reverseOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTimeFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.closeTimeFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.closeStatusFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumPageSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.reverseOrder());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClosedWorkflowExecutionsRequest)) {
            return false;
        }
        ListClosedWorkflowExecutionsRequest other = (ListClosedWorkflowExecutionsRequest)((Object)obj);
        return Objects.equals(this.domain(), other.domain()) && Objects.equals(this.startTimeFilter(), other.startTimeFilter()) && Objects.equals(this.closeTimeFilter(), other.closeTimeFilter()) && Objects.equals(this.executionFilter(), other.executionFilter()) && Objects.equals(this.closeStatusFilter(), other.closeStatusFilter()) && Objects.equals(this.typeFilter(), other.typeFilter()) && Objects.equals(this.tagFilter(), other.tagFilter()) && Objects.equals(this.nextPageToken(), other.nextPageToken()) && Objects.equals(this.maximumPageSize(), other.maximumPageSize()) && Objects.equals(this.reverseOrder(), other.reverseOrder());
    }

    public String toString() {
        return ToString.builder((String)"ListClosedWorkflowExecutionsRequest").add("Domain", (Object)this.domain()).add("StartTimeFilter", (Object)this.startTimeFilter()).add("CloseTimeFilter", (Object)this.closeTimeFilter()).add("ExecutionFilter", (Object)this.executionFilter()).add("CloseStatusFilter", (Object)this.closeStatusFilter()).add("TypeFilter", (Object)this.typeFilter()).add("TagFilter", (Object)this.tagFilter()).add("NextPageToken", (Object)this.nextPageToken()).add("MaximumPageSize", (Object)this.maximumPageSize()).add("ReverseOrder", (Object)this.reverseOrder()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "startTimeFilter": {
                return Optional.ofNullable(clazz.cast(this.startTimeFilter()));
            }
            case "closeTimeFilter": {
                return Optional.ofNullable(clazz.cast(this.closeTimeFilter()));
            }
            case "executionFilter": {
                return Optional.ofNullable(clazz.cast(this.executionFilter()));
            }
            case "closeStatusFilter": {
                return Optional.ofNullable(clazz.cast(this.closeStatusFilter()));
            }
            case "typeFilter": {
                return Optional.ofNullable(clazz.cast(this.typeFilter()));
            }
            case "tagFilter": {
                return Optional.ofNullable(clazz.cast(this.tagFilter()));
            }
            case "nextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
            case "maximumPageSize": {
                return Optional.ofNullable(clazz.cast(this.maximumPageSize()));
            }
            case "reverseOrder": {
                return Optional.ofNullable(clazz.cast(this.reverseOrder()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListClosedWorkflowExecutionsRequest, T> g) {
        return obj -> g.apply((ListClosedWorkflowExecutionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SwfRequest.BuilderImpl
    implements Builder {
        private String domain;
        private ExecutionTimeFilter startTimeFilter;
        private ExecutionTimeFilter closeTimeFilter;
        private WorkflowExecutionFilter executionFilter;
        private CloseStatusFilter closeStatusFilter;
        private WorkflowTypeFilter typeFilter;
        private TagFilter tagFilter;
        private String nextPageToken;
        private Integer maximumPageSize;
        private Boolean reverseOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(ListClosedWorkflowExecutionsRequest model) {
            super(model);
            this.domain(model.domain);
            this.startTimeFilter(model.startTimeFilter);
            this.closeTimeFilter(model.closeTimeFilter);
            this.executionFilter(model.executionFilter);
            this.closeStatusFilter(model.closeStatusFilter);
            this.typeFilter(model.typeFilter);
            this.tagFilter(model.tagFilter);
            this.nextPageToken(model.nextPageToken);
            this.maximumPageSize(model.maximumPageSize);
            this.reverseOrder(model.reverseOrder);
        }

        public final String getDomain() {
            return this.domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final ExecutionTimeFilter.Builder getStartTimeFilter() {
            return this.startTimeFilter != null ? this.startTimeFilter.toBuilder() : null;
        }

        @Override
        public final Builder startTimeFilter(ExecutionTimeFilter startTimeFilter) {
            this.startTimeFilter = startTimeFilter;
            return this;
        }

        public final void setStartTimeFilter(ExecutionTimeFilter.BuilderImpl startTimeFilter) {
            this.startTimeFilter = startTimeFilter != null ? startTimeFilter.build() : null;
        }

        public final ExecutionTimeFilter.Builder getCloseTimeFilter() {
            return this.closeTimeFilter != null ? this.closeTimeFilter.toBuilder() : null;
        }

        @Override
        public final Builder closeTimeFilter(ExecutionTimeFilter closeTimeFilter) {
            this.closeTimeFilter = closeTimeFilter;
            return this;
        }

        public final void setCloseTimeFilter(ExecutionTimeFilter.BuilderImpl closeTimeFilter) {
            this.closeTimeFilter = closeTimeFilter != null ? closeTimeFilter.build() : null;
        }

        public final WorkflowExecutionFilter.Builder getExecutionFilter() {
            return this.executionFilter != null ? this.executionFilter.toBuilder() : null;
        }

        @Override
        public final Builder executionFilter(WorkflowExecutionFilter executionFilter) {
            this.executionFilter = executionFilter;
            return this;
        }

        public final void setExecutionFilter(WorkflowExecutionFilter.BuilderImpl executionFilter) {
            this.executionFilter = executionFilter != null ? executionFilter.build() : null;
        }

        public final CloseStatusFilter.Builder getCloseStatusFilter() {
            return this.closeStatusFilter != null ? this.closeStatusFilter.toBuilder() : null;
        }

        @Override
        public final Builder closeStatusFilter(CloseStatusFilter closeStatusFilter) {
            this.closeStatusFilter = closeStatusFilter;
            return this;
        }

        public final void setCloseStatusFilter(CloseStatusFilter.BuilderImpl closeStatusFilter) {
            this.closeStatusFilter = closeStatusFilter != null ? closeStatusFilter.build() : null;
        }

        public final WorkflowTypeFilter.Builder getTypeFilter() {
            return this.typeFilter != null ? this.typeFilter.toBuilder() : null;
        }

        @Override
        public final Builder typeFilter(WorkflowTypeFilter typeFilter) {
            this.typeFilter = typeFilter;
            return this;
        }

        public final void setTypeFilter(WorkflowTypeFilter.BuilderImpl typeFilter) {
            this.typeFilter = typeFilter != null ? typeFilter.build() : null;
        }

        public final TagFilter.Builder getTagFilter() {
            return this.tagFilter != null ? this.tagFilter.toBuilder() : null;
        }

        @Override
        public final Builder tagFilter(TagFilter tagFilter) {
            this.tagFilter = tagFilter;
            return this;
        }

        public final void setTagFilter(TagFilter.BuilderImpl tagFilter) {
            this.tagFilter = tagFilter != null ? tagFilter.build() : null;
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        public final Integer getMaximumPageSize() {
            return this.maximumPageSize;
        }

        @Override
        public final Builder maximumPageSize(Integer maximumPageSize) {
            this.maximumPageSize = maximumPageSize;
            return this;
        }

        public final void setMaximumPageSize(Integer maximumPageSize) {
            this.maximumPageSize = maximumPageSize;
        }

        public final Boolean getReverseOrder() {
            return this.reverseOrder;
        }

        @Override
        public final Builder reverseOrder(Boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
            return this;
        }

        public final void setReverseOrder(Boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListClosedWorkflowExecutionsRequest build() {
            return new ListClosedWorkflowExecutionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SwfRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListClosedWorkflowExecutionsRequest> {
        public Builder domain(String var1);

        public Builder startTimeFilter(ExecutionTimeFilter var1);

        default public Builder startTimeFilter(Consumer<ExecutionTimeFilter.Builder> startTimeFilter) {
            return this.startTimeFilter((ExecutionTimeFilter)((ExecutionTimeFilter.Builder)ExecutionTimeFilter.builder().applyMutation(startTimeFilter)).build());
        }

        public Builder closeTimeFilter(ExecutionTimeFilter var1);

        default public Builder closeTimeFilter(Consumer<ExecutionTimeFilter.Builder> closeTimeFilter) {
            return this.closeTimeFilter((ExecutionTimeFilter)((ExecutionTimeFilter.Builder)ExecutionTimeFilter.builder().applyMutation(closeTimeFilter)).build());
        }

        public Builder executionFilter(WorkflowExecutionFilter var1);

        default public Builder executionFilter(Consumer<WorkflowExecutionFilter.Builder> executionFilter) {
            return this.executionFilter((WorkflowExecutionFilter)((WorkflowExecutionFilter.Builder)WorkflowExecutionFilter.builder().applyMutation(executionFilter)).build());
        }

        public Builder closeStatusFilter(CloseStatusFilter var1);

        default public Builder closeStatusFilter(Consumer<CloseStatusFilter.Builder> closeStatusFilter) {
            return this.closeStatusFilter((CloseStatusFilter)((CloseStatusFilter.Builder)CloseStatusFilter.builder().applyMutation(closeStatusFilter)).build());
        }

        public Builder typeFilter(WorkflowTypeFilter var1);

        default public Builder typeFilter(Consumer<WorkflowTypeFilter.Builder> typeFilter) {
            return this.typeFilter((WorkflowTypeFilter)((WorkflowTypeFilter.Builder)WorkflowTypeFilter.builder().applyMutation(typeFilter)).build());
        }

        public Builder tagFilter(TagFilter var1);

        default public Builder tagFilter(Consumer<TagFilter.Builder> tagFilter) {
            return this.tagFilter((TagFilter)((TagFilter.Builder)TagFilter.builder().applyMutation(tagFilter)).build());
        }

        public Builder nextPageToken(String var1);

        public Builder maximumPageSize(Integer var1);

        public Builder reverseOrder(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

