/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.swf.model.SwfRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterDomainRequest
extends SwfRequest
implements ToCopyableBuilder<Builder, RegisterDomainRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RegisterDomainRequest.getter(RegisterDomainRequest::name)).setter(RegisterDomainRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RegisterDomainRequest.getter(RegisterDomainRequest::description)).setter(RegisterDomainRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> WORKFLOW_EXECUTION_RETENTION_PERIOD_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RegisterDomainRequest.getter(RegisterDomainRequest::workflowExecutionRetentionPeriodInDays)).setter(RegisterDomainRequest.setter(Builder::workflowExecutionRetentionPeriodInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowExecutionRetentionPeriodInDays").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, WORKFLOW_EXECUTION_RETENTION_PERIOD_IN_DAYS_FIELD));
    private final String name;
    private final String description;
    private final String workflowExecutionRetentionPeriodInDays;

    private RegisterDomainRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.workflowExecutionRetentionPeriodInDays = builder.workflowExecutionRetentionPeriodInDays;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String workflowExecutionRetentionPeriodInDays() {
        return this.workflowExecutionRetentionPeriodInDays;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowExecutionRetentionPeriodInDays());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterDomainRequest)) {
            return false;
        }
        RegisterDomainRequest other = (RegisterDomainRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.workflowExecutionRetentionPeriodInDays(), other.workflowExecutionRetentionPeriodInDays());
    }

    public String toString() {
        return ToString.builder((String)"RegisterDomainRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("WorkflowExecutionRetentionPeriodInDays", (Object)this.workflowExecutionRetentionPeriodInDays()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "workflowExecutionRetentionPeriodInDays": {
                return Optional.ofNullable(clazz.cast(this.workflowExecutionRetentionPeriodInDays()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterDomainRequest, T> g) {
        return obj -> g.apply((RegisterDomainRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SwfRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String workflowExecutionRetentionPeriodInDays;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterDomainRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.workflowExecutionRetentionPeriodInDays(model.workflowExecutionRetentionPeriodInDays);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getWorkflowExecutionRetentionPeriodInDays() {
            return this.workflowExecutionRetentionPeriodInDays;
        }

        @Override
        public final Builder workflowExecutionRetentionPeriodInDays(String workflowExecutionRetentionPeriodInDays) {
            this.workflowExecutionRetentionPeriodInDays = workflowExecutionRetentionPeriodInDays;
            return this;
        }

        public final void setWorkflowExecutionRetentionPeriodInDays(String workflowExecutionRetentionPeriodInDays) {
            this.workflowExecutionRetentionPeriodInDays = workflowExecutionRetentionPeriodInDays;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterDomainRequest build() {
            return new RegisterDomainRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SwfRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RegisterDomainRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder workflowExecutionRetentionPeriodInDays(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

