/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the details of the <code>RequestCancelExternalWorkflowExecutionInitiated</code> event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RequestCancelExternalWorkflowExecutionInitiatedEventAttributes
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<RequestCancelExternalWorkflowExecutionInitiatedEventAttributes.Builder, RequestCancelExternalWorkflowExecutionInitiatedEventAttributes> {
    private static final SdkField<String> WORKFLOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RequestCancelExternalWorkflowExecutionInitiatedEventAttributes::workflowId))
            .setter(setter(Builder::workflowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowId").build()).build();

    private static final SdkField<String> RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RequestCancelExternalWorkflowExecutionInitiatedEventAttributes::runId)).setter(setter(Builder::runId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runId").build()).build();

    private static final SdkField<Long> DECISION_TASK_COMPLETED_EVENT_ID_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .getter(getter(RequestCancelExternalWorkflowExecutionInitiatedEventAttributes::decisionTaskCompletedEventId))
            .setter(setter(Builder::decisionTaskCompletedEventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decisionTaskCompletedEventId")
                    .build()).build();

    private static final SdkField<String> CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RequestCancelExternalWorkflowExecutionInitiatedEventAttributes::control))
            .setter(setter(Builder::control))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("control").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_ID_FIELD,
            RUN_ID_FIELD, DECISION_TASK_COMPLETED_EVENT_ID_FIELD, CONTROL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String workflowId;

    private final String runId;

    private final Long decisionTaskCompletedEventId;

    private final String control;

    private RequestCancelExternalWorkflowExecutionInitiatedEventAttributes(BuilderImpl builder) {
        this.workflowId = builder.workflowId;
        this.runId = builder.runId;
        this.decisionTaskCompletedEventId = builder.decisionTaskCompletedEventId;
        this.control = builder.control;
    }

    /**
     * <p>
     * The <code>workflowId</code> of the external workflow execution to be canceled.
     * </p>
     * 
     * @return The <code>workflowId</code> of the external workflow execution to be canceled.
     */
    public String workflowId() {
        return workflowId;
    }

    /**
     * <p>
     * The <code>runId</code> of the external workflow execution to be canceled.
     * </p>
     * 
     * @return The <code>runId</code> of the external workflow execution to be canceled.
     */
    public String runId() {
        return runId;
    }

    /**
     * <p>
     * The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
     * <code>RequestCancelExternalWorkflowExecution</code> decision for this cancellation request. This information can
     * be useful for diagnosing problems by tracing back the chain of events leading up to this event.
     * </p>
     * 
     * @return The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted
     *         in the <code>RequestCancelExternalWorkflowExecution</code> decision for this cancellation request. This
     *         information can be useful for diagnosing problems by tracing back the chain of events leading up to this
     *         event.
     */
    public Long decisionTaskCompletedEventId() {
        return decisionTaskCompletedEventId;
    }

    /**
     * <p>
     * Data attached to the event that can be used by the decider in subsequent workflow tasks.
     * </p>
     * 
     * @return Data attached to the event that can be used by the decider in subsequent workflow tasks.
     */
    public String control() {
        return control;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(workflowId());
        hashCode = 31 * hashCode + Objects.hashCode(runId());
        hashCode = 31 * hashCode + Objects.hashCode(decisionTaskCompletedEventId());
        hashCode = 31 * hashCode + Objects.hashCode(control());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestCancelExternalWorkflowExecutionInitiatedEventAttributes)) {
            return false;
        }
        RequestCancelExternalWorkflowExecutionInitiatedEventAttributes other = (RequestCancelExternalWorkflowExecutionInitiatedEventAttributes) obj;
        return Objects.equals(workflowId(), other.workflowId()) && Objects.equals(runId(), other.runId())
                && Objects.equals(decisionTaskCompletedEventId(), other.decisionTaskCompletedEventId())
                && Objects.equals(control(), other.control());
    }

    @Override
    public String toString() {
        return ToString.builder("RequestCancelExternalWorkflowExecutionInitiatedEventAttributes").add("WorkflowId", workflowId())
                .add("RunId", runId()).add("DecisionTaskCompletedEventId", decisionTaskCompletedEventId())
                .add("Control", control()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "workflowId":
            return Optional.ofNullable(clazz.cast(workflowId()));
        case "runId":
            return Optional.ofNullable(clazz.cast(runId()));
        case "decisionTaskCompletedEventId":
            return Optional.ofNullable(clazz.cast(decisionTaskCompletedEventId()));
        case "control":
            return Optional.ofNullable(clazz.cast(control()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RequestCancelExternalWorkflowExecutionInitiatedEventAttributes, T> g) {
        return obj -> g.apply((RequestCancelExternalWorkflowExecutionInitiatedEventAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo,
            CopyableBuilder<Builder, RequestCancelExternalWorkflowExecutionInitiatedEventAttributes> {
        /**
         * <p>
         * The <code>workflowId</code> of the external workflow execution to be canceled.
         * </p>
         * 
         * @param workflowId
         *        The <code>workflowId</code> of the external workflow execution to be canceled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowId(String workflowId);

        /**
         * <p>
         * The <code>runId</code> of the external workflow execution to be canceled.
         * </p>
         * 
         * @param runId
         *        The <code>runId</code> of the external workflow execution to be canceled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runId(String runId);

        /**
         * <p>
         * The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in
         * the <code>RequestCancelExternalWorkflowExecution</code> decision for this cancellation request. This
         * information can be useful for diagnosing problems by tracing back the chain of events leading up to this
         * event.
         * </p>
         * 
         * @param decisionTaskCompletedEventId
         *        The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that
         *        resulted in the <code>RequestCancelExternalWorkflowExecution</code> decision for this cancellation
         *        request. This information can be useful for diagnosing problems by tracing back the chain of events
         *        leading up to this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decisionTaskCompletedEventId(Long decisionTaskCompletedEventId);

        /**
         * <p>
         * Data attached to the event that can be used by the decider in subsequent workflow tasks.
         * </p>
         * 
         * @param control
         *        Data attached to the event that can be used by the decider in subsequent workflow tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder control(String control);
    }

    static final class BuilderImpl implements Builder {
        private String workflowId;

        private String runId;

        private Long decisionTaskCompletedEventId;

        private String control;

        private BuilderImpl() {
        }

        private BuilderImpl(RequestCancelExternalWorkflowExecutionInitiatedEventAttributes model) {
            workflowId(model.workflowId);
            runId(model.runId);
            decisionTaskCompletedEventId(model.decisionTaskCompletedEventId);
            control(model.control);
        }

        public final String getWorkflowId() {
            return workflowId;
        }

        @Override
        public final Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public final void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        public final String getRunId() {
            return runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        public final Long getDecisionTaskCompletedEventId() {
            return decisionTaskCompletedEventId;
        }

        @Override
        public final Builder decisionTaskCompletedEventId(Long decisionTaskCompletedEventId) {
            this.decisionTaskCompletedEventId = decisionTaskCompletedEventId;
            return this;
        }

        public final void setDecisionTaskCompletedEventId(Long decisionTaskCompletedEventId) {
            this.decisionTaskCompletedEventId = decisionTaskCompletedEventId;
        }

        public final String getControl() {
            return control;
        }

        @Override
        public final Builder control(String control) {
            this.control = control;
            return this;
        }

        public final void setControl(String control) {
            this.control = control;
        }

        @Override
        public RequestCancelExternalWorkflowExecutionInitiatedEventAttributes build() {
            return new RequestCancelExternalWorkflowExecutionInitiatedEventAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
