/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.swf.SwfClient;
import software.amazon.awssdk.services.swf.model.HistoryEvent;
import software.amazon.awssdk.services.swf.model.PollForDecisionTaskRequest;
import software.amazon.awssdk.services.swf.model.PollForDecisionTaskResponse;

public class PollForDecisionTaskIterable
implements SdkIterable<PollForDecisionTaskResponse> {
    private final SwfClient client;
    private final PollForDecisionTaskRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public PollForDecisionTaskIterable(SwfClient client, PollForDecisionTaskRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new PollForDecisionTaskResponseFetcher();
    }

    public Iterator<PollForDecisionTaskResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<HistoryEvent> events() {
        Function<PollForDecisionTaskResponse, Iterator> getIterator = response -> {
            if (response != null && response.events() != null) {
                return response.events().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final PollForDecisionTaskIterable resume(PollForDecisionTaskResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new PollForDecisionTaskIterable(this.client, (PollForDecisionTaskRequest)((Object)this.firstRequest.toBuilder().nextPageToken(lastSuccessfulPage.nextPageToken()).build()));
        }
        return new PollForDecisionTaskIterable(this.client, this.firstRequest){

            @Override
            public Iterator<PollForDecisionTaskResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class PollForDecisionTaskResponseFetcher
    implements SyncPageFetcher<PollForDecisionTaskResponse> {
        private PollForDecisionTaskResponseFetcher() {
        }

        public boolean hasNextPage(PollForDecisionTaskResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public PollForDecisionTaskResponse nextPage(PollForDecisionTaskResponse previousPage) {
            if (previousPage == null) {
                return PollForDecisionTaskIterable.this.client.pollForDecisionTask(PollForDecisionTaskIterable.this.firstRequest);
            }
            return PollForDecisionTaskIterable.this.client.pollForDecisionTask((PollForDecisionTaskRequest)((Object)PollForDecisionTaskIterable.this.firstRequest.toBuilder().nextPageToken(previousPage.nextPageToken()).build()));
        }
    }
}

