/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Unit of work sent to an activity worker.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PollForActivityTaskResponse extends SwfResponse implements
        ToCopyableBuilder<PollForActivityTaskResponse.Builder, PollForActivityTaskResponse> {
    private static final SdkField<String> TASK_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("taskToken").getter(getter(PollForActivityTaskResponse::taskToken)).setter(setter(Builder::taskToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskToken").build()).build();

    private static final SdkField<String> ACTIVITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("activityId").getter(getter(PollForActivityTaskResponse::activityId)).setter(setter(Builder::activityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activityId").build()).build();

    private static final SdkField<Long> STARTED_EVENT_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("startedEventId").getter(getter(PollForActivityTaskResponse::startedEventId))
            .setter(setter(Builder::startedEventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedEventId").build()).build();

    private static final SdkField<WorkflowExecution> WORKFLOW_EXECUTION_FIELD = SdkField
            .<WorkflowExecution> builder(MarshallingType.SDK_POJO).memberName("workflowExecution")
            .getter(getter(PollForActivityTaskResponse::workflowExecution)).setter(setter(Builder::workflowExecution))
            .constructor(WorkflowExecution::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowExecution").build()).build();

    private static final SdkField<ActivityType> ACTIVITY_TYPE_FIELD = SdkField.<ActivityType> builder(MarshallingType.SDK_POJO)
            .memberName("activityType").getter(getter(PollForActivityTaskResponse::activityType))
            .setter(setter(Builder::activityType)).constructor(ActivityType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activityType").build()).build();

    private static final SdkField<String> INPUT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("input")
            .getter(getter(PollForActivityTaskResponse::input)).setter(setter(Builder::input))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_TOKEN_FIELD,
            ACTIVITY_ID_FIELD, STARTED_EVENT_ID_FIELD, WORKFLOW_EXECUTION_FIELD, ACTIVITY_TYPE_FIELD, INPUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String taskToken;

    private final String activityId;

    private final Long startedEventId;

    private final WorkflowExecution workflowExecution;

    private final ActivityType activityType;

    private final String input;

    private PollForActivityTaskResponse(BuilderImpl builder) {
        super(builder);
        this.taskToken = builder.taskToken;
        this.activityId = builder.activityId;
        this.startedEventId = builder.startedEventId;
        this.workflowExecution = builder.workflowExecution;
        this.activityType = builder.activityType;
        this.input = builder.input;
    }

    /**
     * <p>
     * The opaque string used as a handle on the task. This token is used by workers to communicate progress and
     * response information back to the system about the task.
     * </p>
     * 
     * @return The opaque string used as a handle on the task. This token is used by workers to communicate progress and
     *         response information back to the system about the task.
     */
    public final String taskToken() {
        return taskToken;
    }

    /**
     * <p>
     * The unique ID of the task.
     * </p>
     * 
     * @return The unique ID of the task.
     */
    public final String activityId() {
        return activityId;
    }

    /**
     * <p>
     * The ID of the <code>ActivityTaskStarted</code> event recorded in the history.
     * </p>
     * 
     * @return The ID of the <code>ActivityTaskStarted</code> event recorded in the history.
     */
    public final Long startedEventId() {
        return startedEventId;
    }

    /**
     * <p>
     * The workflow execution that started this activity task.
     * </p>
     * 
     * @return The workflow execution that started this activity task.
     */
    public final WorkflowExecution workflowExecution() {
        return workflowExecution;
    }

    /**
     * <p>
     * The type of this activity task.
     * </p>
     * 
     * @return The type of this activity task.
     */
    public final ActivityType activityType() {
        return activityType;
    }

    /**
     * <p>
     * The inputs provided when the activity task was scheduled. The form of the input is user defined and should be
     * meaningful to the activity implementation.
     * </p>
     * 
     * @return The inputs provided when the activity task was scheduled. The form of the input is user defined and
     *         should be meaningful to the activity implementation.
     */
    public final String input() {
        return input;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(taskToken());
        hashCode = 31 * hashCode + Objects.hashCode(activityId());
        hashCode = 31 * hashCode + Objects.hashCode(startedEventId());
        hashCode = 31 * hashCode + Objects.hashCode(workflowExecution());
        hashCode = 31 * hashCode + Objects.hashCode(activityType());
        hashCode = 31 * hashCode + Objects.hashCode(input());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PollForActivityTaskResponse)) {
            return false;
        }
        PollForActivityTaskResponse other = (PollForActivityTaskResponse) obj;
        return Objects.equals(taskToken(), other.taskToken()) && Objects.equals(activityId(), other.activityId())
                && Objects.equals(startedEventId(), other.startedEventId())
                && Objects.equals(workflowExecution(), other.workflowExecution())
                && Objects.equals(activityType(), other.activityType()) && Objects.equals(input(), other.input());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PollForActivityTaskResponse").add("TaskToken", taskToken()).add("ActivityId", activityId())
                .add("StartedEventId", startedEventId()).add("WorkflowExecution", workflowExecution())
                .add("ActivityType", activityType()).add("Input", input()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "taskToken":
            return Optional.ofNullable(clazz.cast(taskToken()));
        case "activityId":
            return Optional.ofNullable(clazz.cast(activityId()));
        case "startedEventId":
            return Optional.ofNullable(clazz.cast(startedEventId()));
        case "workflowExecution":
            return Optional.ofNullable(clazz.cast(workflowExecution()));
        case "activityType":
            return Optional.ofNullable(clazz.cast(activityType()));
        case "input":
            return Optional.ofNullable(clazz.cast(input()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("taskToken", TASK_TOKEN_FIELD);
        map.put("activityId", ACTIVITY_ID_FIELD);
        map.put("startedEventId", STARTED_EVENT_ID_FIELD);
        map.put("workflowExecution", WORKFLOW_EXECUTION_FIELD);
        map.put("activityType", ACTIVITY_TYPE_FIELD);
        map.put("input", INPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PollForActivityTaskResponse, T> g) {
        return obj -> g.apply((PollForActivityTaskResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SwfResponse.Builder, SdkPojo, CopyableBuilder<Builder, PollForActivityTaskResponse> {
        /**
         * <p>
         * The opaque string used as a handle on the task. This token is used by workers to communicate progress and
         * response information back to the system about the task.
         * </p>
         * 
         * @param taskToken
         *        The opaque string used as a handle on the task. This token is used by workers to communicate progress
         *        and response information back to the system about the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskToken(String taskToken);

        /**
         * <p>
         * The unique ID of the task.
         * </p>
         * 
         * @param activityId
         *        The unique ID of the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activityId(String activityId);

        /**
         * <p>
         * The ID of the <code>ActivityTaskStarted</code> event recorded in the history.
         * </p>
         * 
         * @param startedEventId
         *        The ID of the <code>ActivityTaskStarted</code> event recorded in the history.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedEventId(Long startedEventId);

        /**
         * <p>
         * The workflow execution that started this activity task.
         * </p>
         * 
         * @param workflowExecution
         *        The workflow execution that started this activity task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowExecution(WorkflowExecution workflowExecution);

        /**
         * <p>
         * The workflow execution that started this activity task.
         * </p>
         * This is a convenience method that creates an instance of the {@link WorkflowExecution.Builder} avoiding the
         * need to create one manually via {@link WorkflowExecution#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkflowExecution.Builder#build()} is called immediately and its
         * result is passed to {@link #workflowExecution(WorkflowExecution)}.
         * 
         * @param workflowExecution
         *        a consumer that will call methods on {@link WorkflowExecution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workflowExecution(WorkflowExecution)
         */
        default Builder workflowExecution(Consumer<WorkflowExecution.Builder> workflowExecution) {
            return workflowExecution(WorkflowExecution.builder().applyMutation(workflowExecution).build());
        }

        /**
         * <p>
         * The type of this activity task.
         * </p>
         * 
         * @param activityType
         *        The type of this activity task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activityType(ActivityType activityType);

        /**
         * <p>
         * The type of this activity task.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActivityType.Builder} avoiding the need
         * to create one manually via {@link ActivityType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActivityType.Builder#build()} is called immediately and its
         * result is passed to {@link #activityType(ActivityType)}.
         * 
         * @param activityType
         *        a consumer that will call methods on {@link ActivityType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activityType(ActivityType)
         */
        default Builder activityType(Consumer<ActivityType.Builder> activityType) {
            return activityType(ActivityType.builder().applyMutation(activityType).build());
        }

        /**
         * <p>
         * The inputs provided when the activity task was scheduled. The form of the input is user defined and should be
         * meaningful to the activity implementation.
         * </p>
         * 
         * @param input
         *        The inputs provided when the activity task was scheduled. The form of the input is user defined and
         *        should be meaningful to the activity implementation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(String input);
    }

    static final class BuilderImpl extends SwfResponse.BuilderImpl implements Builder {
        private String taskToken;

        private String activityId;

        private Long startedEventId;

        private WorkflowExecution workflowExecution;

        private ActivityType activityType;

        private String input;

        private BuilderImpl() {
        }

        private BuilderImpl(PollForActivityTaskResponse model) {
            super(model);
            taskToken(model.taskToken);
            activityId(model.activityId);
            startedEventId(model.startedEventId);
            workflowExecution(model.workflowExecution);
            activityType(model.activityType);
            input(model.input);
        }

        public final String getTaskToken() {
            return taskToken;
        }

        public final void setTaskToken(String taskToken) {
            this.taskToken = taskToken;
        }

        @Override
        public final Builder taskToken(String taskToken) {
            this.taskToken = taskToken;
            return this;
        }

        public final String getActivityId() {
            return activityId;
        }

        public final void setActivityId(String activityId) {
            this.activityId = activityId;
        }

        @Override
        public final Builder activityId(String activityId) {
            this.activityId = activityId;
            return this;
        }

        public final Long getStartedEventId() {
            return startedEventId;
        }

        public final void setStartedEventId(Long startedEventId) {
            this.startedEventId = startedEventId;
        }

        @Override
        public final Builder startedEventId(Long startedEventId) {
            this.startedEventId = startedEventId;
            return this;
        }

        public final WorkflowExecution.Builder getWorkflowExecution() {
            return workflowExecution != null ? workflowExecution.toBuilder() : null;
        }

        public final void setWorkflowExecution(WorkflowExecution.BuilderImpl workflowExecution) {
            this.workflowExecution = workflowExecution != null ? workflowExecution.build() : null;
        }

        @Override
        public final Builder workflowExecution(WorkflowExecution workflowExecution) {
            this.workflowExecution = workflowExecution;
            return this;
        }

        public final ActivityType.Builder getActivityType() {
            return activityType != null ? activityType.toBuilder() : null;
        }

        public final void setActivityType(ActivityType.BuilderImpl activityType) {
            this.activityType = activityType != null ? activityType.build() : null;
        }

        @Override
        public final Builder activityType(ActivityType activityType) {
            this.activityType = activityType;
            return this;
        }

        public final String getInput() {
            return input;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        @Override
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        @Override
        public PollForActivityTaskResponse build() {
            return new PollForActivityTaskResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
