/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterActivityTypeRequest extends SwfRequest implements
        ToCopyableBuilder<RegisterActivityTypeRequest.Builder, RegisterActivityTypeRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("domain")
            .getter(getter(RegisterActivityTypeRequest::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domain").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(RegisterActivityTypeRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(RegisterActivityTypeRequest::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(RegisterActivityTypeRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DEFAULT_TASK_START_TO_CLOSE_TIMEOUT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("defaultTaskStartToCloseTimeout")
            .getter(getter(RegisterActivityTypeRequest::defaultTaskStartToCloseTimeout))
            .setter(setter(Builder::defaultTaskStartToCloseTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultTaskStartToCloseTimeout")
                    .build()).build();

    private static final SdkField<String> DEFAULT_TASK_HEARTBEAT_TIMEOUT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("defaultTaskHeartbeatTimeout")
            .getter(getter(RegisterActivityTypeRequest::defaultTaskHeartbeatTimeout))
            .setter(setter(Builder::defaultTaskHeartbeatTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultTaskHeartbeatTimeout")
                    .build()).build();

    private static final SdkField<TaskList> DEFAULT_TASK_LIST_FIELD = SdkField.<TaskList> builder(MarshallingType.SDK_POJO)
            .memberName("defaultTaskList").getter(getter(RegisterActivityTypeRequest::defaultTaskList))
            .setter(setter(Builder::defaultTaskList)).constructor(TaskList::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultTaskList").build()).build();

    private static final SdkField<String> DEFAULT_TASK_PRIORITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("defaultTaskPriority").getter(getter(RegisterActivityTypeRequest::defaultTaskPriority))
            .setter(setter(Builder::defaultTaskPriority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultTaskPriority").build())
            .build();

    private static final SdkField<String> DEFAULT_TASK_SCHEDULE_TO_START_TIMEOUT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("defaultTaskScheduleToStartTimeout")
            .getter(getter(RegisterActivityTypeRequest::defaultTaskScheduleToStartTimeout))
            .setter(setter(Builder::defaultTaskScheduleToStartTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultTaskScheduleToStartTimeout")
                    .build()).build();

    private static final SdkField<String> DEFAULT_TASK_SCHEDULE_TO_CLOSE_TIMEOUT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("defaultTaskScheduleToCloseTimeout")
            .getter(getter(RegisterActivityTypeRequest::defaultTaskScheduleToCloseTimeout))
            .setter(setter(Builder::defaultTaskScheduleToCloseTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultTaskScheduleToCloseTimeout")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD, NAME_FIELD,
            VERSION_FIELD, DESCRIPTION_FIELD, DEFAULT_TASK_START_TO_CLOSE_TIMEOUT_FIELD, DEFAULT_TASK_HEARTBEAT_TIMEOUT_FIELD,
            DEFAULT_TASK_LIST_FIELD, DEFAULT_TASK_PRIORITY_FIELD, DEFAULT_TASK_SCHEDULE_TO_START_TIMEOUT_FIELD,
            DEFAULT_TASK_SCHEDULE_TO_CLOSE_TIMEOUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String domain;

    private final String name;

    private final String version;

    private final String description;

    private final String defaultTaskStartToCloseTimeout;

    private final String defaultTaskHeartbeatTimeout;

    private final TaskList defaultTaskList;

    private final String defaultTaskPriority;

    private final String defaultTaskScheduleToStartTimeout;

    private final String defaultTaskScheduleToCloseTimeout;

    private RegisterActivityTypeRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.name = builder.name;
        this.version = builder.version;
        this.description = builder.description;
        this.defaultTaskStartToCloseTimeout = builder.defaultTaskStartToCloseTimeout;
        this.defaultTaskHeartbeatTimeout = builder.defaultTaskHeartbeatTimeout;
        this.defaultTaskList = builder.defaultTaskList;
        this.defaultTaskPriority = builder.defaultTaskPriority;
        this.defaultTaskScheduleToStartTimeout = builder.defaultTaskScheduleToStartTimeout;
        this.defaultTaskScheduleToCloseTimeout = builder.defaultTaskScheduleToCloseTimeout;
    }

    /**
     * <p>
     * The name of the domain in which this activity is to be registered.
     * </p>
     * 
     * @return The name of the domain in which this activity is to be registered.
     */
    public final String domain() {
        return domain;
    }

    /**
     * <p>
     * The name of the activity type within the domain.
     * </p>
     * <p>
     * The specified string must not contain a <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical
     * bar), or any control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must
     * <i>not</i> be the literal string <code>arn</code>.
     * </p>
     * 
     * @return The name of the activity type within the domain.</p>
     *         <p>
     *         The specified string must not contain a <code>:</code> (colon), <code>/</code> (slash), <code>|</code>
     *         (vertical bar), or any control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>).
     *         Also, it must <i>not</i> be the literal string <code>arn</code>.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The version of the activity type.
     * </p>
     * <note>
     * <p>
     * The activity type consists of the name and version, the combination of which must be unique within the domain.
     * </p>
     * </note>
     * <p>
     * The specified string must not contain a <code>:</code> (colon), <code>/</code> (slash), <code>|</code> (vertical
     * bar), or any control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must
     * <i>not</i> be the literal string <code>arn</code>.
     * </p>
     * 
     * @return The version of the activity type.</p> <note>
     *         <p>
     *         The activity type consists of the name and version, the combination of which must be unique within the
     *         domain.
     *         </p>
     *         </note>
     *         <p>
     *         The specified string must not contain a <code>:</code> (colon), <code>/</code> (slash), <code>|</code>
     *         (vertical bar), or any control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>).
     *         Also, it must <i>not</i> be the literal string <code>arn</code>.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * A textual description of the activity type.
     * </p>
     * 
     * @return A textual description of the activity type.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * If set, specifies the default maximum duration that a worker can take to process tasks of this activity type.
     * This default can be overridden when scheduling an activity task using the <code>ScheduleActivityTask</code>
     * <a>Decision</a>.
     * </p>
     * <p>
     * The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
     * <code>NONE</code> to specify unlimited duration.
     * </p>
     * 
     * @return If set, specifies the default maximum duration that a worker can take to process tasks of this activity
     *         type. This default can be overridden when scheduling an activity task using the
     *         <code>ScheduleActivityTask</code> <a>Decision</a>.</p>
     *         <p>
     *         The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
     *         <code>NONE</code> to specify unlimited duration.
     */
    public final String defaultTaskStartToCloseTimeout() {
        return defaultTaskStartToCloseTimeout;
    }

    /**
     * <p>
     * If set, specifies the default maximum time before which a worker processing a task of this type must report
     * progress by calling <a>RecordActivityTaskHeartbeat</a>. If the timeout is exceeded, the activity task is
     * automatically timed out. This default can be overridden when scheduling an activity task using the
     * <code>ScheduleActivityTask</code> <a>Decision</a>. If the activity worker subsequently attempts to record a
     * heartbeat or returns a result, the activity worker receives an <code>UnknownResource</code> fault. In this case,
     * Amazon SWF no longer considers the activity task to be valid; the activity worker should clean up the activity
     * task.
     * </p>
     * <p>
     * The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
     * <code>NONE</code> to specify unlimited duration.
     * </p>
     * 
     * @return If set, specifies the default maximum time before which a worker processing a task of this type must
     *         report progress by calling <a>RecordActivityTaskHeartbeat</a>. If the timeout is exceeded, the activity
     *         task is automatically timed out. This default can be overridden when scheduling an activity task using
     *         the <code>ScheduleActivityTask</code> <a>Decision</a>. If the activity worker subsequently attempts to
     *         record a heartbeat or returns a result, the activity worker receives an <code>UnknownResource</code>
     *         fault. In this case, Amazon SWF no longer considers the activity task to be valid; the activity worker
     *         should clean up the activity task.</p>
     *         <p>
     *         The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
     *         <code>NONE</code> to specify unlimited duration.
     */
    public final String defaultTaskHeartbeatTimeout() {
        return defaultTaskHeartbeatTimeout;
    }

    /**
     * <p>
     * If set, specifies the default task list to use for scheduling tasks of this activity type. This default task list
     * is used if a task list isn't provided when a task is scheduled through the <code>ScheduleActivityTask</code>
     * <a>Decision</a>.
     * </p>
     * 
     * @return If set, specifies the default task list to use for scheduling tasks of this activity type. This default
     *         task list is used if a task list isn't provided when a task is scheduled through the
     *         <code>ScheduleActivityTask</code> <a>Decision</a>.
     */
    public final TaskList defaultTaskList() {
        return defaultTaskList;
    }

    /**
     * <p>
     * The default task priority to assign to the activity type. If not assigned, then <code>0</code> is used. Valid
     * values are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to
     * <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.
     * </p>
     * <p>
     * For more information about setting task priority, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
     * Priority</a> in the <i>in the <i>Amazon SWF Developer Guide</i>.</i>.
     * </p>
     * 
     * @return The default task priority to assign to the activity type. If not assigned, then <code>0</code> is used.
     *         Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to
     *         <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.</p>
     *         <p>
     *         For more information about setting task priority, see <a
     *         href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
     *         Priority</a> in the <i>in the <i>Amazon SWF Developer Guide</i>.</i>.
     */
    public final String defaultTaskPriority() {
        return defaultTaskPriority;
    }

    /**
     * <p>
     * If set, specifies the default maximum duration that a task of this activity type can wait before being assigned
     * to a worker. This default can be overridden when scheduling an activity task using the
     * <code>ScheduleActivityTask</code> <a>Decision</a>.
     * </p>
     * <p>
     * The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
     * <code>NONE</code> to specify unlimited duration.
     * </p>
     * 
     * @return If set, specifies the default maximum duration that a task of this activity type can wait before being
     *         assigned to a worker. This default can be overridden when scheduling an activity task using the
     *         <code>ScheduleActivityTask</code> <a>Decision</a>.</p>
     *         <p>
     *         The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
     *         <code>NONE</code> to specify unlimited duration.
     */
    public final String defaultTaskScheduleToStartTimeout() {
        return defaultTaskScheduleToStartTimeout;
    }

    /**
     * <p>
     * If set, specifies the default maximum duration for a task of this activity type. This default can be overridden
     * when scheduling an activity task using the <code>ScheduleActivityTask</code> <a>Decision</a>.
     * </p>
     * <p>
     * The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
     * <code>NONE</code> to specify unlimited duration.
     * </p>
     * 
     * @return If set, specifies the default maximum duration for a task of this activity type. This default can be
     *         overridden when scheduling an activity task using the <code>ScheduleActivityTask</code>
     *         <a>Decision</a>.</p>
     *         <p>
     *         The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
     *         <code>NONE</code> to specify unlimited duration.
     */
    public final String defaultTaskScheduleToCloseTimeout() {
        return defaultTaskScheduleToCloseTimeout;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(defaultTaskStartToCloseTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(defaultTaskHeartbeatTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(defaultTaskList());
        hashCode = 31 * hashCode + Objects.hashCode(defaultTaskPriority());
        hashCode = 31 * hashCode + Objects.hashCode(defaultTaskScheduleToStartTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(defaultTaskScheduleToCloseTimeout());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterActivityTypeRequest)) {
            return false;
        }
        RegisterActivityTypeRequest other = (RegisterActivityTypeRequest) obj;
        return Objects.equals(domain(), other.domain()) && Objects.equals(name(), other.name())
                && Objects.equals(version(), other.version()) && Objects.equals(description(), other.description())
                && Objects.equals(defaultTaskStartToCloseTimeout(), other.defaultTaskStartToCloseTimeout())
                && Objects.equals(defaultTaskHeartbeatTimeout(), other.defaultTaskHeartbeatTimeout())
                && Objects.equals(defaultTaskList(), other.defaultTaskList())
                && Objects.equals(defaultTaskPriority(), other.defaultTaskPriority())
                && Objects.equals(defaultTaskScheduleToStartTimeout(), other.defaultTaskScheduleToStartTimeout())
                && Objects.equals(defaultTaskScheduleToCloseTimeout(), other.defaultTaskScheduleToCloseTimeout());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterActivityTypeRequest").add("Domain", domain()).add("Name", name())
                .add("Version", version()).add("Description", description())
                .add("DefaultTaskStartToCloseTimeout", defaultTaskStartToCloseTimeout())
                .add("DefaultTaskHeartbeatTimeout", defaultTaskHeartbeatTimeout()).add("DefaultTaskList", defaultTaskList())
                .add("DefaultTaskPriority", defaultTaskPriority())
                .add("DefaultTaskScheduleToStartTimeout", defaultTaskScheduleToStartTimeout())
                .add("DefaultTaskScheduleToCloseTimeout", defaultTaskScheduleToCloseTimeout()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "defaultTaskStartToCloseTimeout":
            return Optional.ofNullable(clazz.cast(defaultTaskStartToCloseTimeout()));
        case "defaultTaskHeartbeatTimeout":
            return Optional.ofNullable(clazz.cast(defaultTaskHeartbeatTimeout()));
        case "defaultTaskList":
            return Optional.ofNullable(clazz.cast(defaultTaskList()));
        case "defaultTaskPriority":
            return Optional.ofNullable(clazz.cast(defaultTaskPriority()));
        case "defaultTaskScheduleToStartTimeout":
            return Optional.ofNullable(clazz.cast(defaultTaskScheduleToStartTimeout()));
        case "defaultTaskScheduleToCloseTimeout":
            return Optional.ofNullable(clazz.cast(defaultTaskScheduleToCloseTimeout()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("domain", DOMAIN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("version", VERSION_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("defaultTaskStartToCloseTimeout", DEFAULT_TASK_START_TO_CLOSE_TIMEOUT_FIELD);
        map.put("defaultTaskHeartbeatTimeout", DEFAULT_TASK_HEARTBEAT_TIMEOUT_FIELD);
        map.put("defaultTaskList", DEFAULT_TASK_LIST_FIELD);
        map.put("defaultTaskPriority", DEFAULT_TASK_PRIORITY_FIELD);
        map.put("defaultTaskScheduleToStartTimeout", DEFAULT_TASK_SCHEDULE_TO_START_TIMEOUT_FIELD);
        map.put("defaultTaskScheduleToCloseTimeout", DEFAULT_TASK_SCHEDULE_TO_CLOSE_TIMEOUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegisterActivityTypeRequest, T> g) {
        return obj -> g.apply((RegisterActivityTypeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SwfRequest.Builder, SdkPojo, CopyableBuilder<Builder, RegisterActivityTypeRequest> {
        /**
         * <p>
         * The name of the domain in which this activity is to be registered.
         * </p>
         * 
         * @param domain
         *        The name of the domain in which this activity is to be registered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The name of the activity type within the domain.
         * </p>
         * <p>
         * The specified string must not contain a <code>:</code> (colon), <code>/</code> (slash), <code>|</code>
         * (vertical bar), or any control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it
         * must <i>not</i> be the literal string <code>arn</code>.
         * </p>
         * 
         * @param name
         *        The name of the activity type within the domain.</p>
         *        <p>
         *        The specified string must not contain a <code>:</code> (colon), <code>/</code> (slash), <code>|</code>
         *        (vertical bar), or any control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>).
         *        Also, it must <i>not</i> be the literal string <code>arn</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The version of the activity type.
         * </p>
         * <note>
         * <p>
         * The activity type consists of the name and version, the combination of which must be unique within the
         * domain.
         * </p>
         * </note>
         * <p>
         * The specified string must not contain a <code>:</code> (colon), <code>/</code> (slash), <code>|</code>
         * (vertical bar), or any control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it
         * must <i>not</i> be the literal string <code>arn</code>.
         * </p>
         * 
         * @param version
         *        The version of the activity type.</p> <note>
         *        <p>
         *        The activity type consists of the name and version, the combination of which must be unique within the
         *        domain.
         *        </p>
         *        </note>
         *        <p>
         *        The specified string must not contain a <code>:</code> (colon), <code>/</code> (slash), <code>|</code>
         *        (vertical bar), or any control characters (<code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>).
         *        Also, it must <i>not</i> be the literal string <code>arn</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * A textual description of the activity type.
         * </p>
         * 
         * @param description
         *        A textual description of the activity type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * If set, specifies the default maximum duration that a worker can take to process tasks of this activity type.
         * This default can be overridden when scheduling an activity task using the <code>ScheduleActivityTask</code>
         * <a>Decision</a>.
         * </p>
         * <p>
         * The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
         * <code>NONE</code> to specify unlimited duration.
         * </p>
         * 
         * @param defaultTaskStartToCloseTimeout
         *        If set, specifies the default maximum duration that a worker can take to process tasks of this
         *        activity type. This default can be overridden when scheduling an activity task using the
         *        <code>ScheduleActivityTask</code> <a>Decision</a>.</p>
         *        <p>
         *        The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
         *        <code>NONE</code> to specify unlimited duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultTaskStartToCloseTimeout(String defaultTaskStartToCloseTimeout);

        /**
         * <p>
         * If set, specifies the default maximum time before which a worker processing a task of this type must report
         * progress by calling <a>RecordActivityTaskHeartbeat</a>. If the timeout is exceeded, the activity task is
         * automatically timed out. This default can be overridden when scheduling an activity task using the
         * <code>ScheduleActivityTask</code> <a>Decision</a>. If the activity worker subsequently attempts to record a
         * heartbeat or returns a result, the activity worker receives an <code>UnknownResource</code> fault. In this
         * case, Amazon SWF no longer considers the activity task to be valid; the activity worker should clean up the
         * activity task.
         * </p>
         * <p>
         * The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
         * <code>NONE</code> to specify unlimited duration.
         * </p>
         * 
         * @param defaultTaskHeartbeatTimeout
         *        If set, specifies the default maximum time before which a worker processing a task of this type must
         *        report progress by calling <a>RecordActivityTaskHeartbeat</a>. If the timeout is exceeded, the
         *        activity task is automatically timed out. This default can be overridden when scheduling an activity
         *        task using the <code>ScheduleActivityTask</code> <a>Decision</a>. If the activity worker subsequently
         *        attempts to record a heartbeat or returns a result, the activity worker receives an
         *        <code>UnknownResource</code> fault. In this case, Amazon SWF no longer considers the activity task to
         *        be valid; the activity worker should clean up the activity task.</p>
         *        <p>
         *        The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
         *        <code>NONE</code> to specify unlimited duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultTaskHeartbeatTimeout(String defaultTaskHeartbeatTimeout);

        /**
         * <p>
         * If set, specifies the default task list to use for scheduling tasks of this activity type. This default task
         * list is used if a task list isn't provided when a task is scheduled through the
         * <code>ScheduleActivityTask</code> <a>Decision</a>.
         * </p>
         * 
         * @param defaultTaskList
         *        If set, specifies the default task list to use for scheduling tasks of this activity type. This
         *        default task list is used if a task list isn't provided when a task is scheduled through the
         *        <code>ScheduleActivityTask</code> <a>Decision</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultTaskList(TaskList defaultTaskList);

        /**
         * <p>
         * If set, specifies the default task list to use for scheduling tasks of this activity type. This default task
         * list is used if a task list isn't provided when a task is scheduled through the
         * <code>ScheduleActivityTask</code> <a>Decision</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link TaskList.Builder} avoiding the need to
         * create one manually via {@link TaskList#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TaskList.Builder#build()} is called immediately and its result is
         * passed to {@link #defaultTaskList(TaskList)}.
         * 
         * @param defaultTaskList
         *        a consumer that will call methods on {@link TaskList.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultTaskList(TaskList)
         */
        default Builder defaultTaskList(Consumer<TaskList.Builder> defaultTaskList) {
            return defaultTaskList(TaskList.builder().applyMutation(defaultTaskList).build());
        }

        /**
         * <p>
         * The default task priority to assign to the activity type. If not assigned, then <code>0</code> is used. Valid
         * values are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to
         * <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.
         * </p>
         * <p>
         * For more information about setting task priority, see <a
         * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
         * Priority</a> in the <i>in the <i>Amazon SWF Developer Guide</i>.</i>.
         * </p>
         * 
         * @param defaultTaskPriority
         *        The default task priority to assign to the activity type. If not assigned, then <code>0</code> is
         *        used. Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to
         *        <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.</p>
         *        <p>
         *        For more information about setting task priority, see <a
         *        href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting
         *        Task Priority</a> in the <i>in the <i>Amazon SWF Developer Guide</i>.</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultTaskPriority(String defaultTaskPriority);

        /**
         * <p>
         * If set, specifies the default maximum duration that a task of this activity type can wait before being
         * assigned to a worker. This default can be overridden when scheduling an activity task using the
         * <code>ScheduleActivityTask</code> <a>Decision</a>.
         * </p>
         * <p>
         * The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
         * <code>NONE</code> to specify unlimited duration.
         * </p>
         * 
         * @param defaultTaskScheduleToStartTimeout
         *        If set, specifies the default maximum duration that a task of this activity type can wait before being
         *        assigned to a worker. This default can be overridden when scheduling an activity task using the
         *        <code>ScheduleActivityTask</code> <a>Decision</a>.</p>
         *        <p>
         *        The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
         *        <code>NONE</code> to specify unlimited duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultTaskScheduleToStartTimeout(String defaultTaskScheduleToStartTimeout);

        /**
         * <p>
         * If set, specifies the default maximum duration for a task of this activity type. This default can be
         * overridden when scheduling an activity task using the <code>ScheduleActivityTask</code> <a>Decision</a>.
         * </p>
         * <p>
         * The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
         * <code>NONE</code> to specify unlimited duration.
         * </p>
         * 
         * @param defaultTaskScheduleToCloseTimeout
         *        If set, specifies the default maximum duration for a task of this activity type. This default can be
         *        overridden when scheduling an activity task using the <code>ScheduleActivityTask</code>
         *        <a>Decision</a>.</p>
         *        <p>
         *        The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
         *        <code>NONE</code> to specify unlimited duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultTaskScheduleToCloseTimeout(String defaultTaskScheduleToCloseTimeout);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SwfRequest.BuilderImpl implements Builder {
        private String domain;

        private String name;

        private String version;

        private String description;

        private String defaultTaskStartToCloseTimeout;

        private String defaultTaskHeartbeatTimeout;

        private TaskList defaultTaskList;

        private String defaultTaskPriority;

        private String defaultTaskScheduleToStartTimeout;

        private String defaultTaskScheduleToCloseTimeout;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterActivityTypeRequest model) {
            super(model);
            domain(model.domain);
            name(model.name);
            version(model.version);
            description(model.description);
            defaultTaskStartToCloseTimeout(model.defaultTaskStartToCloseTimeout);
            defaultTaskHeartbeatTimeout(model.defaultTaskHeartbeatTimeout);
            defaultTaskList(model.defaultTaskList);
            defaultTaskPriority(model.defaultTaskPriority);
            defaultTaskScheduleToStartTimeout(model.defaultTaskScheduleToStartTimeout);
            defaultTaskScheduleToCloseTimeout(model.defaultTaskScheduleToCloseTimeout);
        }

        public final String getDomain() {
            return domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDefaultTaskStartToCloseTimeout() {
            return defaultTaskStartToCloseTimeout;
        }

        public final void setDefaultTaskStartToCloseTimeout(String defaultTaskStartToCloseTimeout) {
            this.defaultTaskStartToCloseTimeout = defaultTaskStartToCloseTimeout;
        }

        @Override
        public final Builder defaultTaskStartToCloseTimeout(String defaultTaskStartToCloseTimeout) {
            this.defaultTaskStartToCloseTimeout = defaultTaskStartToCloseTimeout;
            return this;
        }

        public final String getDefaultTaskHeartbeatTimeout() {
            return defaultTaskHeartbeatTimeout;
        }

        public final void setDefaultTaskHeartbeatTimeout(String defaultTaskHeartbeatTimeout) {
            this.defaultTaskHeartbeatTimeout = defaultTaskHeartbeatTimeout;
        }

        @Override
        public final Builder defaultTaskHeartbeatTimeout(String defaultTaskHeartbeatTimeout) {
            this.defaultTaskHeartbeatTimeout = defaultTaskHeartbeatTimeout;
            return this;
        }

        public final TaskList.Builder getDefaultTaskList() {
            return defaultTaskList != null ? defaultTaskList.toBuilder() : null;
        }

        public final void setDefaultTaskList(TaskList.BuilderImpl defaultTaskList) {
            this.defaultTaskList = defaultTaskList != null ? defaultTaskList.build() : null;
        }

        @Override
        public final Builder defaultTaskList(TaskList defaultTaskList) {
            this.defaultTaskList = defaultTaskList;
            return this;
        }

        public final String getDefaultTaskPriority() {
            return defaultTaskPriority;
        }

        public final void setDefaultTaskPriority(String defaultTaskPriority) {
            this.defaultTaskPriority = defaultTaskPriority;
        }

        @Override
        public final Builder defaultTaskPriority(String defaultTaskPriority) {
            this.defaultTaskPriority = defaultTaskPriority;
            return this;
        }

        public final String getDefaultTaskScheduleToStartTimeout() {
            return defaultTaskScheduleToStartTimeout;
        }

        public final void setDefaultTaskScheduleToStartTimeout(String defaultTaskScheduleToStartTimeout) {
            this.defaultTaskScheduleToStartTimeout = defaultTaskScheduleToStartTimeout;
        }

        @Override
        public final Builder defaultTaskScheduleToStartTimeout(String defaultTaskScheduleToStartTimeout) {
            this.defaultTaskScheduleToStartTimeout = defaultTaskScheduleToStartTimeout;
            return this;
        }

        public final String getDefaultTaskScheduleToCloseTimeout() {
            return defaultTaskScheduleToCloseTimeout;
        }

        public final void setDefaultTaskScheduleToCloseTimeout(String defaultTaskScheduleToCloseTimeout) {
            this.defaultTaskScheduleToCloseTimeout = defaultTaskScheduleToCloseTimeout;
        }

        @Override
        public final Builder defaultTaskScheduleToCloseTimeout(String defaultTaskScheduleToCloseTimeout) {
            this.defaultTaskScheduleToCloseTimeout = defaultTaskScheduleToCloseTimeout;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterActivityTypeRequest build() {
            return new RegisterActivityTypeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
