/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RespondActivityTaskFailedRequest extends SwfRequest implements
        ToCopyableBuilder<RespondActivityTaskFailedRequest.Builder, RespondActivityTaskFailedRequest> {
    private static final SdkField<String> TASK_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("taskToken").getter(getter(RespondActivityTaskFailedRequest::taskToken))
            .setter(setter(Builder::taskToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskToken").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("reason")
            .getter(getter(RespondActivityTaskFailedRequest::reason)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()).build();

    private static final SdkField<String> DETAILS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("details")
            .getter(getter(RespondActivityTaskFailedRequest::details)).setter(setter(Builder::details))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("details").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_TOKEN_FIELD,
            REASON_FIELD, DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String taskToken;

    private final String reason;

    private final String details;

    private RespondActivityTaskFailedRequest(BuilderImpl builder) {
        super(builder);
        this.taskToken = builder.taskToken;
        this.reason = builder.reason;
        this.details = builder.details;
    }

    /**
     * <p>
     * The <code>taskToken</code> of the <a>ActivityTask</a>.
     * </p>
     * <important>
     * <p>
     * <code>taskToken</code> is generated by the service and should be treated as an opaque value. If the task is
     * passed to another process, its <code>taskToken</code> must also be passed. This enables it to provide its
     * progress and respond with results.
     * </p>
     * </important>
     * 
     * @return The <code>taskToken</code> of the <a>ActivityTask</a>.</p> <important>
     *         <p>
     *         <code>taskToken</code> is generated by the service and should be treated as an opaque value. If the task
     *         is passed to another process, its <code>taskToken</code> must also be passed. This enables it to provide
     *         its progress and respond with results.
     *         </p>
     */
    public final String taskToken() {
        return taskToken;
    }

    /**
     * <p>
     * Description of the error that may assist in diagnostics.
     * </p>
     * 
     * @return Description of the error that may assist in diagnostics.
     */
    public final String reason() {
        return reason;
    }

    /**
     * <p>
     * Detailed information about the failure.
     * </p>
     * 
     * @return Detailed information about the failure.
     */
    public final String details() {
        return details;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(taskToken());
        hashCode = 31 * hashCode + Objects.hashCode(reason());
        hashCode = 31 * hashCode + Objects.hashCode(details());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RespondActivityTaskFailedRequest)) {
            return false;
        }
        RespondActivityTaskFailedRequest other = (RespondActivityTaskFailedRequest) obj;
        return Objects.equals(taskToken(), other.taskToken()) && Objects.equals(reason(), other.reason())
                && Objects.equals(details(), other.details());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RespondActivityTaskFailedRequest").add("TaskToken", taskToken()).add("Reason", reason())
                .add("Details", details()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "taskToken":
            return Optional.ofNullable(clazz.cast(taskToken()));
        case "reason":
            return Optional.ofNullable(clazz.cast(reason()));
        case "details":
            return Optional.ofNullable(clazz.cast(details()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("taskToken", TASK_TOKEN_FIELD);
        map.put("reason", REASON_FIELD);
        map.put("details", DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RespondActivityTaskFailedRequest, T> g) {
        return obj -> g.apply((RespondActivityTaskFailedRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SwfRequest.Builder, SdkPojo, CopyableBuilder<Builder, RespondActivityTaskFailedRequest> {
        /**
         * <p>
         * The <code>taskToken</code> of the <a>ActivityTask</a>.
         * </p>
         * <important>
         * <p>
         * <code>taskToken</code> is generated by the service and should be treated as an opaque value. If the task is
         * passed to another process, its <code>taskToken</code> must also be passed. This enables it to provide its
         * progress and respond with results.
         * </p>
         * </important>
         * 
         * @param taskToken
         *        The <code>taskToken</code> of the <a>ActivityTask</a>.</p> <important>
         *        <p>
         *        <code>taskToken</code> is generated by the service and should be treated as an opaque value. If the
         *        task is passed to another process, its <code>taskToken</code> must also be passed. This enables it to
         *        provide its progress and respond with results.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskToken(String taskToken);

        /**
         * <p>
         * Description of the error that may assist in diagnostics.
         * </p>
         * 
         * @param reason
         *        Description of the error that may assist in diagnostics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);

        /**
         * <p>
         * Detailed information about the failure.
         * </p>
         * 
         * @param details
         *        Detailed information about the failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(String details);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SwfRequest.BuilderImpl implements Builder {
        private String taskToken;

        private String reason;

        private String details;

        private BuilderImpl() {
        }

        private BuilderImpl(RespondActivityTaskFailedRequest model) {
            super(model);
            taskToken(model.taskToken);
            reason(model.reason);
            details(model.details);
        }

        public final String getTaskToken() {
            return taskToken;
        }

        public final void setTaskToken(String taskToken) {
            this.taskToken = taskToken;
        }

        @Override
        public final Builder taskToken(String taskToken) {
            this.taskToken = taskToken;
            return this;
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final String getDetails() {
            return details;
        }

        public final void setDetails(String details) {
            this.details = details;
        }

        @Override
        public final Builder details(String details) {
            this.details = details;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RespondActivityTaskFailedRequest build() {
            return new RespondActivityTaskFailedRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
